<?php
/***
*
*@package binzcms
*@version $id:FrontClassClass.php, v 1.0
*@author 斌子
*@Tue Apr 14 22:09:19 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * FrontClassClass
 * 分类控制类
 * 
 */
include(MOD_PATH."/ModFrontClassClass.php");
class FrontClassClass extends ModFrontClassClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "base_back_index";
		}
		/*合法action*/
		$this->allow_action	= array(
		'base_back_index',			//返回首页
		'front_class'				//分类列表
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "base_back_index";
		}
		/*载入语言包*/
		$this->import_language('FrontArticle,FrontImage,FrontCommon');
		
		$this->$act();
	}
	/**
	 * front_class
	 *
	 * 分类列表页面
	 * @access  private（权限）
	 * 
	 */
	private function front_class() {
		$class_info	= $this->mod_front_class_one_info($_GET['class_id']);
		if($class_info == '') {
			$this->base_back_index();
		}
		if($class_info['class_url'] != '') {
			@header("Location: ".$class_info['class_url']);
		}
		
		switch ($class_info['class_type_tag']) {
			case 'image':
				$this->front_image_class();
				break;
			case 'article':	//文章列表
				$this->front_article_class();
				break;
		}

	}
	/**
	 * front_article_class
	 *
	 * 文章分类列表页面
	 * @access  private（权限）
	 * 
	 */
	private function front_article_class() {
		$article_list_array		= array();
		$perpage				= 10;			//每页记录数
		$article_new_list		= array();
		$article_hot_list		= array();

		$article_class		= $this->import_class("ModAdminClass",ADMIN_MOD_PATH,'mod');

		/*最新文章列表（本分类及分类子集）*/
		$article_new_list	= $this->mod_front_article_type('article_id',6,$article_class);
		$this->binz_tpl->set_var('article_new_list',$article_new_list);
		/*最热文章列表（本分类及分子子集）*/
		$article_hot_list	= $this->mod_front_article_type('article_click',6,$article_class);
		$this->binz_tpl->set_var('article_hot_list',$article_hot_list);

		/*文章列表*/
		$article_list_array		= $this->mod_front_article_list($_GET['binz_page'],$perpage,$article_class);
		/*如果该分类不存在的话那么返回首页*/
		if($article_list_array == false) {
			$this->base_back_index();
		}
		$this->binz_tpl->set_var('article_array',$article_list_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->front_rwrite_type = 'article';
		$page_class->set_page(array('total'=>$article_list_array['count']['article_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		/*分类列表*/
		$class_array	= array();
		$class_array	= $this->mod_front_class_list();
		$this->binz_tpl->set_var('class_array',$class_array);

		$this->binz_tpl->set_tag('article_list');
	}
	/**
	 * front_image_class
	 *
	 * 图片分类列表页面
	 * @access  private（权限）
	 * 
	 */
	private function front_image_class() {
		$article_list_array		= array();
		$perpage				= 9;			//每页记录数
		$article_new_list		= array();
		$article_hot_list		= array();

		$article_class		= $this->import_class("ModAdminClass",ADMIN_MOD_PATH,'mod');

		/*最新文章列表（本分类及分类子集）*/
		$article_new_list	= $this->mod_front_article_type('article_id',6,$article_class);
		$this->binz_tpl->set_var('article_new_list',$article_new_list);
		/*最热文章列表（本分类及分子子集）*/
		$article_hot_list	= $this->mod_front_article_type('article_click',6,$article_class);
		$this->binz_tpl->set_var('article_hot_list',$article_hot_list);

		/*文章列表*/
		$article_list_array		= $this->mod_front_article_list($_GET['binz_page'],$perpage,$article_class);
		/*如果该分类不存在的话那么返回首页*/
		if($article_list_array == false) {
			$this->base_back_index();
		}
		$this->binz_tpl->set_var('article_array',$article_list_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->front_rwrite_type = 'image';
		$page_class->set_page(array('total'=>$article_list_array['count']['article_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		/*分类列表*/
		$class_array	= array();
		$class_array	= $this->mod_front_class_list();
		$this->binz_tpl->set_var('class_array',$class_array);

		$this->binz_tpl->set_tag('pic_list');		
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>