<?php
/***
*
*@package binzcms
*@version $id:ModAdminLeaveClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:07:19 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModAdminMessageClass
 * 留言管理类
 * 
 */
class ModAdminLeaveClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_leave_save
	 *
	 * 留言保存操作
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_leave_save() {
		$insert_state					= false;
		$leave_array					= array();

		$leave_array['leave_id']		= 'NULL';														//留言id
		$leave_array['leave_writer']	= trim($_POST['leave_writer']);									//留言作者
		$leave_array['leave_body']		= htmlspecialchars(trim($_POST['leave_body']),ENT_QUOTES);		//留言内容
		$leave_array['leave_time']		= time();														//留言时间

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#leave',$leave_array);
		if($insert_state) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * mod_leave_edit
	 *
	 * 留言编辑操作
	 * @access  public（权限）
	 * @param   integer $leave_id		留言id
	 * @return  bool
	 */
	public function mod_leave_edit($leave_id) {
		$edit_state					= false;
		$leave_array				= array();

		$leave_array['leave_body']	= htmlspecialchars(trim($_POST['leave_body']),ENT_QUOTES);		//留言内容

		$edit_state	= $this->binz_db->set_update_sql('#binz#leave',$leave_array,array('field'=>'leave_id','value'=>intval($leave_id)));

		return $edit_state;
	}
	/**
	 * mod_leave_list
	 *
	 * 留言列表
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_leave_list($binz_page,$page_num) {
		$leave_array			= array();
		$leave_sql				= '';
		$limit_sql				=  "LIMIT ".(intval($binz_page)-(intval($binz_page)>=1 ? 1 : 0))*$page_num.",$page_num";

		$leave_sql				= "SELECT * FROM #binz#leave
									ORDER BY leave_id DESC ".$limit_sql;
		$leave_array['list']	= $this->binz_db->set_select_sql($leave_sql);
		$leave_array['count']	= $this->binz_db->set_select_sql("SELECT COUNT(leave_id) AS leave_num FROM #binz#leave",0);

		return $leave_array;
	}
	/**
	 * mod_leave_info
	 *
	 * 留言信息
	 * @access  public（权限）
	 * @param   integer $leave_id		留言id
	 * @return  array	留言信息
	 */
	public function mod_leave_info($leave_id) {
		$leave_info		= array();
		$leave_sql		= '';

		$leave_sql		= "SELECT * FROM #binz#leave
							WHERE leave_id=".intval($leave_id);
		$leave_info		= $this->binz_db->set_select_sql($leave_sql,0);

		return $leave_info;
	}
	/**
	 * mod_leave_del
	 *
	 * 函数简介
	 * @access  public（权限）
	 * @param   integer/array $leave_id		留言id
	 * @return  bool
	 */
	public function mod_leave_del($leave_id) {
		$leave_del		= false;
		$del_sql		= '';
		$where_str		= ' WHERE leave_id ';

		if(is_array($leave_id) and count($leave_id) > 0) {
			$where_str	.= 'IN ('.implode(',',$leave_id).')';
		} else {
			$where_str	.= 'IN ('.intval($leave_id).')';
		}

		$del_sql		= "DELETE FROM #binz#leave".$where_str;
		$leave_del		= $this->binz_db->one_query($del_sql);

		return $leave_del;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>