<?php
/***
*
*@package binzcms
*@version $id:ModAdminFlinkClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:09:58 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModAdminFlinkClass
 * 友情链接管理类
 * 
 */
class ModAdminFlinkClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_flink_save
	 *
	 * 友情链接保存
	 * @access  public（权限）
	 * @param   string	$flink_logo		友情链接logo
	 * @return  bool
	 */
	public function mod_flink_save($flink_logo='') {
		$insert_state					= false;
		$flink_array					= array();

		$flink_array['flink_id']		= 'NULL';							//友情链接id
		$flink_array['flink_name']		= trim($_POST['flink_name']);		//友情链接名称
		$flink_array['flink_url']		= trim($_POST['flink_url']);		//友情链接地址
		$flink_array['flink_sort']		= intval($_POST['flink_sort']);		//友情链接排序
		$flink_array['flink_logo']		= $flink_logo;						//友情链接logo

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#flink',$flink_array);
		if($insert_state) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * mod_flink_edit
	 *
	 * 友情链接信息修改
	 * @access  public（权限）
	 * @param   integer	$flink_id		友情链接id 
	 * @param   string	flink_logo		友情链接logo
	 * @return  bool
	 */
	public function mod_flink_edit($flink_id,$flink_logo='') {
		$edit_state					= false;
		$flink_array				= array();

		$flink_array['flink_name']		= trim($_POST['flink_name']);		//友情链接名称
		$flink_array['flink_url']		= trim($_POST['flink_url']);		//友情链接地址
		$flink_array['flink_sort']		= intval($_POST['flink_sort']);		//友情链接排序
		$flink_array['flink_logo']		= $flink_logo;						//友情链接logo

		$edit_state	= $this->binz_db->set_update_sql('#binz#flink',$flink_array,array('field'=>'flink_id','value'=>intval($flink_id)));

		return $edit_state;
	}
	/**
	 * mod_flink_list
	 *
	 * 友情链接列表数组
	 * @access  public（权限）
	 * 
	 * return  array
	 */
	public function mod_flink_list() {
		$flink_array			= array();
		$flink_sql				= '';

		$flink_sql				= "SELECT * FROM #binz#flink AS flink
									ORDER BY flink.flink_sort,flink.flink_id";
		$flink_array			= $this->binz_db->set_select_sql($flink_sql);

		return $flink_array;
	}
	/**
	 * mod_flink_info
	 *
	 * 获得指定友情链接信息
	 * @access  public（权限）
	 * @param   integer $flink_id		友情链接id
	 * @return  array
	 */
	public function mod_flink_info($flink_id) {
		$flink_info		= array();
		$flink_sql		= '';

		$flink_sql		= "SELECT * FROM #binz#flink AS flink
							WHERE flink.flink_id=".intval($flink_id);
		$flink_info		= $this->binz_db->set_select_sql($flink_sql,0);

		return $flink_info;
	}
	/**
	 * mod_flink_del
	 *
	 * 友情链接删除操作
	 * @access  public（权限）
	 * @param   string	$flink_id		友情链接id
	 * @return  bool
	 */
	public function mod_flink_del($flink_id) {
		$flink_del		= false;
		$flink_info		= array();
		$del_sql		= '';

		/*如果有logo图片，删除图片*/
		$flink_info		= $this->mod_flink_info($flink_id);
		if($flink_info['flink_logo'] != '') {
			if(strpos("http",$flink_info['flink_logo']) === false) {
				@unlink(ROOT_PATH.$flink_info['flink_logo']);
			}
		}
		unset($flink_info);

		/*删除友情链接记录*/
		$del_sql		= "DELETE FROM #binz#flink WHERE flink_id=".intval($flink_id);
		$flink_del		= $this->binz_db->one_query($del_sql);

		return $flink_del;

	}
	/**
	 * mod_logo_upload
	 *
	 * 友情链接logo上传
	 * @access  public（权限）
	 * @param   string	$path		logo上传路径
	 * @return  string	上传后的路径
	 */
	public function mod_logo_upload($path) {

		$logo_path					= '';

		/*上传logo操作*/
		if($_FILES['flink_logo']['name'] != '') {
			$upload_image				= $this->import_class('Image',ROOT_PATH.'/include');
			$upload_image->upload_dir	= $path;
			$logo_path					= $upload_image->upload_image($_FILES['flink_logo'],'n');

			if($_POST['image_logo'] != '' and strpos("http",$_POST['image_logo']) === false) @unlink(ROOT_PATH.trim($_POST['image_logo']));
			return $logo_path;
		}
		/*远程logo*/
		if (trim($_POST['url_logo']) != '' and $_FILES['flink_logo']['name'] == '') {
			$logo_path					= trim($_POST['url_logo']);

			if($_POST['image_logo'] != '' and strpos("http",$_POST['image_logo']) === false and trim($_POST['image_logo']) != trim($_POST['url_logo'])) {
				@unlink(ROOT_PATH.trim($_POST['image_logo']));
			}

			return $logo_path;
		}
		/*已有logo*/
		if (trim($_POST['image_logo']) != '' and trim($_POST['ulr_logo']) == '' and $_FILES['flink_logo']['name'] == '') {
			$logo_path					= trim($_POST['image_logo']);
			return $logo_path;
		}

		return $logo_path;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>