<?php
/***
*
*@package binzcms
*@version $id:ModAdminClassClass.php, v 1.0
*@author 斌子
*@Tue Jan 13 23:49:49 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModAdminClassClass
 * 频道应用类
 * 
 */
class ModAdminClassClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_class_save
	 *
	 * 保存分类
	 * @access  public（权限）
	 * 
	 * @return  bool	保存状态
	 */
	public function mod_class_save() {

		$insert_state						= false;
		$class_array						= array();

		$class_array['class_id']			= 'NULL';								//文章分类id
		$class_array['class_top_id']		= intval($_POST['class_top_id']);		//顶级分类id
		$class_array['class_url']			= trim($_POST['class_url']);			//跳转链接
		$class_array['class_name']			= trim($_POST['class_name']);			//分类名称
		$class_array['class_type_id']		= intval($_POST['class_type_id']);		//分类类型
		$class_array['class_type_tag']		= trim($_POST['class_type_tag']);		//分类类型标识
		$class_array['class_state']			= intval($_POST['class_state']);		//分类状态
		$class_array['class_sort']			= intval($_POST['class_sort']);			//分类排序
		$class_array['top_menu']			= intval($_POST['class_top']);			//头部导航
		$class_array['index_class']			= intval($_POST['class_index']);		//首页显示，必须顶级分类
		$class_array['class_keywords']		= trim($_POST['class_keywords']);		//分类关键字
		$class_array['class_description']	= trim($_POST['class_description']);	//分类描述

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#article_class',$class_array);

		return $insert_state;
	}
	/**
	 * mod_class_edit
	 *
	 * 函数简介
	 * @access  public（权限）
	 * @param   integer	$class_id		分类id
	 * @return  bool
	 */
	public function mod_class_edit($class_id) {
		$edit_state							= false;
		$class_array						= array();

		/*检查是新的上级分类是否为，当前分类的子分类，如果是返回2（错误）*/
		$sub_array	= $this->get_sun_class_id(intval($class_id));
		if(in_array(intval($_POST['class_top_id']),$sub_array)) return 2;

		$class_array['class_top_id']		= intval($_POST['class_top_id']);		//顶级分类id
		$class_array['class_name']			= trim($_POST['class_name']);			//分类名称
		$class_array['class_url']			= trim($_POST['class_url']);			//跳转链接
		$class_array['class_type_id']		= intval($_POST['class_type_id']);		//分类类型
		$class_array['class_type_tag']		= trim($_POST['class_type_tag']);		//分类类型标识
		$class_array['class_state']			= intval($_POST['class_state']);		//分类状态
		$class_array['class_sort']			= intval($_POST['class_sort']);			//分类排序
		$class_array['top_menu']			= intval($_POST['class_top']);			//头部导航
		$class_array['index_class']			= intval($_POST['class_index']);		//首页显示，必须顶级分类
		$class_array['class_keywords']		= trim($_POST['class_keywords']);		//分类关键字
		$class_array['class_description']	= trim($_POST['class_description']);	//分类描述

		$edit_state	= $this->binz_db->set_update_sql('#binz#article_class',$class_array,array('field'=>'class_id','value'=>intval($class_id)));

		/*修改下级频道类型*/
		if(intval($_POST['modify_type']) == 1) {
			if(count($sub_array) > 0) {
				$this->binz_db->set_update_sql('#binz#article_class',array('class_type_id'=>$class_array['class_type_id']),array(),' AND class_id IN ('.implode(',',$sub_array).')');
			}
		}

		return $edit_state;
	}
	/**
	 * mod_class_info
	 *
	 * 单一分类信息数据
	 * @access  public（权限）
	 * @param   integer $class_id		分类id
	 * @return  array	分类信息数组
	 */
	public function mod_class_info($class_id) {
		$class_info		= array();
		$class_sql		= '';

		$class_sql		= "SELECT * FROM #binz#article_class
							 WHERE class_id=".intval($class_id);
		$class_info		= $this->binz_db->set_select_sql($class_sql,0);
		return $class_info;
	}
	/**
	 * mod_class_del
	 *
	 * 删除分类
	 * @access  public（权限）
	 * @param   integer	$class_id		分类id
	 * @return  bool
	 */
	public function mod_class_del($class_id) {
		$del_state		= false;
		$sub_array		= $this->get_sun_class_id(intval($class_id));//得到子集

		/*删除文章*/
		$arc_sql		= "SELECT article_id FROM #binz#article
							WHERE class_id IN (".implode(',',$sub_array).")";
		$arc_id_array	= $this->binz_db->set_select_sql($arc_sql);
		if(count($arc_id_array) > 0) {
			$arc_class	= $this->import_class('ModAdminContent',ADMIN_MOD_PATH,'mod');
			foreach ($arc_id_array as $v) {
				$arc_class->mod_article_del($v['article_id']);
			}
		}
		/*删除分类*/
		$sub_array		= count($sub_array) == 1 ? array('class_id'=>$sub_array[0]) : $sub_array;
		$del_state		= $this->binz_db->set_del_sql('#binz#article_class',$sub_array,'or','class_id');
		return $del_state;
	}
	/**
	 * mod_class_move
	 *
	 * 移动操作，移动分类或是记录
	 * @access  public（权限）
	 * @param   integer $class_id	分类id（非父级分类）
	 * @param   integer $move_type	移动类型，1移动频道和记录，2只移动记录 
	 * @return  bool
	 */
	public function mod_class_move($class_id,$move_type) {
		$move_state		= false;
		$sub_array		= $this->get_sun_class_id(intval($class_id));
		$move_class_id	= intval($_POST['move_class_id']);

		if($move_type == 1) {
			/*检查是新的上级分类是否为，当前分类的子分类，如果是返回2（错误）*/
			if(in_array($move_class_id,$sub_array)) return 2;
			$move_state	= $this->binz_db->set_update_sql('#binz#article_class',array('class_top_id'=>$move_class_id),array('field'=>'class_id','value'=>intval($class_id)));
		} else {
			$sql		= "UPDATE #binz#article AS a,#binz#article_body AS b SET a.class_id=$move_class_id,b.class_id=$move_class_id WHERE a.article_id=b.body_id AND a.class_id IN (".implode(',',$sub_array).")";
			$move_state	= $this->binz_db->sql_query($sql);
		}
		return $move_state;
	}
	/**
	 * mod_class_array
	 *
	 * 分类数组信息
	 * @access  public（权限）
	 * @return  array	数组信息
	 */
	public function mod_class_array($top_id=0,$front_class=false,$class_type_tag='') {
		$class_array	= array();
		$class_sql		= '';
		switch ($class_type_tag) {
			case 'image':
				$sql = "WHERE a.class_type_tag='image'";
				break;
			case 'article';
				$sql = "WHERE a.class_type_tag='article'";
				break;
			default:
				$sql = '';
		}
			$where_sql		= $sql;

		/*当前台调用时，需要过滤掉状态为关闭的分类*/
		if($front_class) {
			//$where_sql	= "WHERE a.class_state=1";
		}

		$class_sql		= "SELECT a.*,(SELECT COUNT(art.article_id) FROM #binz#article AS art WHERE art.class_id=a.class_id) AS article_num,COUNT(c.class_id) AS has_children
							FROM #binz#article_class AS a
							LEFT JOIN #binz#article_class AS c ON c.class_top_id=a.class_id
							$where_sql
							GROUP BY a.class_id ORDER BY class_top_id,class_sort ASC";
		$class_array	= $this->binz_db->set_select_sql($class_sql);

		return $this->class_options($top_id,$class_array);
	}
	/**
	 * mod_class_select
	 *
	 * 文章分类下拉菜单
	 * @access  public（权限）
	 * @param   string	$class_type		分类类型，为了区分在后台添加图片类型和文章类型的分类
	 * @return  string	下拉菜单
	 */
	public function mod_class_select($class_type='') {
		$class_select	= array();
		$class_array	= array();

		$class_array	= $this->mod_class_array(0,false,$class_type);
		if(count($class_array)>0) {
			foreach ($class_array as $v) {
					$class_select[$v['class_id']] = str_repeat('&nbsp;', $v['class_level'] * 2).$v['class_name'];
			}
		}
		return $class_select;
	}
	/**
	 * class_options
	 *
	 * 过滤和排序所有分类，返回一个带有缩进级别的数组
	 * @access  public（权限）
	 * @param   integer $spec_class_id	上级id
	 * @param   array 	$arr			分类数组
	 * @return  array	过滤排序好的数组
	 */
	public function class_options($spec_class_id,$arr) {
		static $class_options = array();

		if (isset($class_options[$spec_class_id])) {
			return $class_options[$spec_class_id];
		}

		if (!isset($class_options[0])) {
			$level = $last_class_id = 0;
			$options = $class_id_array = $level_array = array();
			while (!empty($arr)) {
				foreach ($arr AS $key => $value) {
					$class_id = $value['class_id'];
					if ($level == 0 && $last_class_id == 0) {
						if ($value['class_top_id'] > 0) {
							break;
						}

						$options[$class_id]					= $value;
						$options[$class_id]['class_level']	= $level;
						unset($arr[$key]);

						if ($value['has_children'] == 0) {
							continue;
						}
						$last_class_id  					= $class_id;
						$class_id_array 					= array($class_id);
						$level_array[$last_class_id] 		= ++$level;
						$options[$class_id]['class_leaf']	= 1;
						continue;
					}
					if ($value['class_top_id'] == $last_class_id)	{
						$options[$class_id]					= $value;
						$options[$class_id]['class_level']	= $level;
						unset($arr[$key]);

						if ($value['has_children'] > 0)	{
							if (end($class_id_array) != $last_class_id)	{
								$class_id_array[] = $last_class_id;
							}
							$last_class_id    					= $class_id;
							$class_id_array[] 					= $class_id;
							$level_array[$last_class_id]		= ++$level;
							$options[$class_id]['class_leaf']	= 1;
						}
					} elseif ($value['class_top_id'] > $last_class_id) {
						break;
					}
				}
				$count = count($class_id_array);
				if ($count > 1) {
					$last_class_id = array_pop($class_id_array);
				}
				elseif ($count == 1) {
					if ($last_class_id != end($class_id_array)) {
						$last_class_id = end($class_id_array);
					} else {
						$level = 0;
						$last_class_id = 0;
						$class_id_array = array();
						continue;
					}
				}
				if ($last_class_id && isset($level_array[$last_class_id])) {
					$level = $level_array[$last_class_id];
				} else {
					$level = 0;
				}
			}
			$class_options[0] = $options;
		} else {
			$options = $class_options[0];
		}

		if (!$spec_class_id) {
			return $options;
		} else {
			if (empty($options[$spec_class_id])) {
				return array();
			}

			$spec_class_id_level = $options[$spec_class_id]['class_level'];

			foreach ($options AS $key => $value) {
				if ($key != $spec_class_id) {
					unset($options[$key]);
				} else {
					break;
				}
			}

			$spec_class_id_array = array();
			foreach ($options AS $key => $value) {
				if (($spec_class_id_level == $value['class_level'] && $value['class_id'] != $spec_class_id) ||
				($spec_class_id_level > $value['class_level'])) {
					break;
				} else {
					$spec_class_id_array[$key] = $value;
				}
			}
			$class_options[$spec_class_id] = $spec_class_id_array;
			return $spec_class_id_array;
		}
	}
	/**
	 * get_sun_class_id
	 *
	 * 获得分类id下（包括当前id）的所有子分类
	 * @access  public（权限）
	 * @param   integer $class_id		分类id	
	 * @param   bool 	$front_class	是否前台调用的判断	
	 * @return  array	子集分类数组
	 */
	public function get_sun_class_id($class_id=0,$front_class=false) {
		$sub_class		= array();
		$class_array	= $this->mod_class_array($class_id,$front_class);

		if(is_array($class_array) and count($class_array)>0) {
			foreach ($class_array as $v) {
				$sub_class[] = $v['class_id'];
			}
		}

		return $sub_class;
	}
	/**
	 * mod_class_type_save
	 *
	 * 频道类型添加
	 * @access  public（权限）
	 * 
	 */
	public function mod_class_type_save() {
		$insert_state							= false;
		$class_type_array						= array();

		$class_type_array['class_type_id']		= 'NULL';								//频道类型id
		$class_type_array['class_type_name']	= trim($_POST['class_type_name']);		//频道类型名称
		$class_type_array['class_type_tpl']		= trim($_POST['class_type_tpl']);		//频道类型模板
		$class_type_array['class_type_tag']		= trim($_POST['class_type_tag']);		//频道类型标识

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#class_type',$class_type_array);

		return $insert_state;
	}
	/**
	 * mod_class_type_edit
	 *
	 * 保存编辑后的频道类型
	 * @access  public（权限）
	 * @param   integer $class_type_id		频道类型id
	 * @return  bool
	 */	
	public function mod_class_type_edit($class_type_id) {
		$edit_state								= false;
		$class_type_array						= array();

		$class_type_array['class_type_name']	= trim($_POST['class_type_name']);		//频道类型名称
		$class_type_array['class_type_tpl']		= trim($_POST['class_type_tpl']);		//频道类型模板
		$class_type_array['class_type_tag']		= trim($_POST['class_type_tag']);		//频道类型标识

		$edit_state	= $this->binz_db->set_update_sql('#binz#class_type',$class_type_array,array('field'=>'class_type_id','value'=>intval($class_type_id)));

		return $edit_state;
	}
	/**
	 * mod_class_type_list
	 *
	 * 频道类型列表
	 * @access  public（权限）
	 * 
	 */
	public function mod_class_type_list() {
		$class_type_array	= array();
		$class_type_sql		= '';

		$class_type_sql		= "SELECT * FROM #binz#class_type
								ORDER BY class_type_id";
		$class_type_array	= $this->binz_db->set_select_sql($class_type_sql);

		return $class_type_array;
	}
	/**
	 * mod_class_type_info
	 *
	 * 获取频道类型信息
	 * @access  public（权限）
	 * @param   integer $class_type_id		频道类型id
	 * @return  array	频道类型数组信息
	 */
	public function mod_class_type_info($class_type_id) {
		$class_type_info	= array();
		$class_type_sql		= '';

		$class_type_sql		= "SELECT * FROM #binz#class_type
								WHERE class_type_id=".intval($class_type_id);
		$class_type_info	= $this->binz_db->set_select_sql($class_type_sql,0);

		return $class_type_info;
	}
	/**
	 * mod_class_type_del
	 *
	 * 删除频道类型
	 * @access  public（权限）
	 * @param   integer $class_type_id		频道类型id
	 * @return  bool
	 */
	public function mod_class_type_del($class_type_id) {
		$del_state	= false;
		$del_state	= $this->binz_db->set_del_sql('#binz#class_type',array('class_type_id'=>intval($class_type_id)));
		return $del_state;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>