<?php
/***
*
*@package binzcms
*@version $id:AdminVoteClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:24:46 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminVoteClass
 * 投票管理
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminVoteClass.php");
class AdminVoteClass extends ModAdminVoteClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "vote_manage";
		}
		/*合法action*/
		$this->allow_action	= array(
		'vote_manage',				//投票列表页面
		'vote_add',					//添加投票
		'vote_save',				//保存投票
		'vote_del'					//删除投票
		);
		
		parent::__construct($act);
		
		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "vote_manage";
		}
		
		/*载入语言包*/
		/*
		*AdminVote		对应
		*/
		$this->import_language('AdminVote,AdminCommon');

		$this->$act();
	}
	/**
	 * vote_manage
	 *
	 * 投票列表页面
	 * @access  private（权限）
	 * 
	 */
	private function vote_manage() {
		$this->binz_admin_common->check_admin_power('vote_manage');
		
		$vote_array		= array();

		/*投票列表*/
		$vote_array		= $this->mod_vote_list();
		$this->binz_tpl->set_var('vote_array',$vote_array);

		/*载入模板*/
		$this->binz_tpl->set_tag('vote_list');
	}
	/**
	 * vote_add
	 *
	 * 添加投票页面
	 * @access  private（权限）
	 * 
	 */
	private function vote_add() {
		$this->binz_admin_common->check_admin_power('vote_manage');
		
		$vote_type_select	= array(0);

		/*编辑投票页面*/
		if(intval($_GET['vote_id']) != '') {
			$vote_info		= array();
			$vote_info		= $this->mod_vote_info($_GET['vote_id']);
			$vote_type_select = array($vote_info['vote_type']);

			$this->binz_tpl->set_var('vote_option_count',count($vote_info['vote_body']));
			$this->binz_tpl->set_var('vote_info',$vote_info);
		}

		/*投票类型*/
		$this->binz_tpl->set_var('vote_type',$this->binz_common->html_input('vote_type','radio',array(0=>$this->binz_tpl->var_all['vote_add_type_1'],1=>$this->binz_tpl->var_all['vote_add_type_2']),$vote_type_select));
		
		/*时间js*/
		$this->binz_tpl->set_var('time_calendar',$this->binz_common->out_calendar());
		
		/*载入模板*/
		$this->binz_tpl->set_tag('vote_add');
	}
	/**
	 * vote_save
	 *
	 * 保存投票内容
	 * @access  private（权限）
	 * 
	 */
	private function vote_save() {
		$this->binz_admin_common->check_admin_power('vote_manage');
		
		$save_state 	= false;
		$message		= '';
		$message_false	= '';

		if(intval($_POST['vote_id']) != 0) {
			$save_state		= $this->mod_vote_edit($_POST['vote_id']);
			$message		= $this->binz_tpl->var_all['vote_add_save_ok'];//'投票编辑成功';
			$message_false	= $this->binz_tpl->var_all['vote_add_save_no'];//'投票编辑失败';
		} else {
			$save_state		= $this->mod_vote_save();
			$message		= $this->binz_tpl->var_all['vote_add_edit_ok'];//'投票添加成功';
			$message_false	= $this->binz_tpl->var_all['vote_add_edit_no'];//'投票添加成功';
		}

		if($save_state) {
			$message			= $message;
			$link[0]['text']	= $this->binz_tpl->var_all['vote_add_click_url'];//'点击此链接到投票列表页面';
			$link[0]['href']	= 'index.php?ctl=vote&act=vote_manage';
		} else {
			$message			= $message_false;
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * vote_del
	 *
	 * 投票删除
	 * @access  private（权限）
	 * 
	 */
	private function vote_del() {
		$this->binz_admin_common->check_admin_power('vote_manage');
		
		$del_state	= false;
		$message	= '';

		$del_state	= $this->mod_vote_del($_GET['vote_id']);

		if($del_state) {
			$message	= $this->binz_tpl->var_all['vote_list_del_ok'];//'投票删除成功';
		} else {
			$message	= $this->binz_tpl->var_all['vote_list_del_no'];//'投票删除失败';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>