<?php
/***
*
*@package binzcms
*@version $id:AdminSystemClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:23:57 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminSystemClass
 * 系统管理
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminSystemClass.php");
class AdminSystemClass extends ModAdminSystemClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "system_log";
		}
		/*合法action*/
		$this->allow_action	= array(
		'system_set',				//系统设置
		'system_set_save',			//系统设置保存
		'watermark_set',			//水印图片设置
		'watermark_set_save',		//水印设置保存
		'upload_set',				//附件设置
		'upload_set_save',			//附件设置保存
		'system_log',				//系统日志
		'system_admin',				//管理员列表
		'system_admin_add',			//添加管理员
		'system_admin_save',		//保存管理员
		'system_admin_del',			//删除管理员
		'system_admin_power',		//设置权限
		'system_admin_power_save',	//保存权限
		'system_article',			//系统文章
		'system_article_add',		//系统文章添加
		'system_article_save',		//系统文章保存
		'system_article_del',		//系统文章删除
		'change_action'
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "system_log";
		}

		/*载入语言包*/
		/*
		*AdminSystem	对应
		*/
		$this->import_language('AdminSystem,AdminCommon');

		$this->$act();
	}
	/**
	 * system_set
	 *
	 * 系统设置
	 * @access  private（权限）
	 * 
	 */
	private function system_set() {
		$this->binz_admin_common->check_admin_power('system_set');
		
		$system_info		= array();

		/*系统设置相关信息*/
		$system_info	= $this->mod_system_info('system');
		$this->binz_tpl->set_var('system_info',$system_info);
		/*基本设置*/
		$this->binz_tpl->set_var('web_state_radio',		$this->binz_common->html_input('web_state',		'radio',array(1=>$this->binz_tpl->var_all['web_open'],0=>$this->binz_tpl->var_all['web_close']),				array(intval($system_info['web_state']['system_value']))));
		/*会员设置*/
		$this->binz_tpl->set_var('open_member_radio',	$this->binz_common->html_input('open_member',	'radio',array(1=>$this->binz_tpl->var_all['web_open'],0=>$this->binz_tpl->var_all['web_close']),				array(intval($system_info['open_member']['system_value']))));
		$this->binz_tpl->set_var('reg_code_radio',		$this->binz_common->html_input('reg_code',		'radio',array(1=>$this->binz_tpl->var_all['web_open'],0=>$this->binz_tpl->var_all['web_close']),				array(intval($system_info['reg_code']['system_value']))));
		$this->binz_tpl->set_var('login_code_radio',	$this->binz_common->html_input('login_code',	'radio',array(1=>$this->binz_tpl->var_all['web_open'],0=>$this->binz_tpl->var_all['web_close']),				array(intval($system_info['login_code']['system_value']))));
		$this->binz_tpl->set_var('open_comment_radio',	$this->binz_common->html_input('open_comment',	'radio',array(1=>$this->binz_tpl->var_all['open_comment_reg'],0=>$this->binz_tpl->var_all['open_comment_all']),	array(intval($system_info['open_comment']['system_value']))));
		$this->binz_tpl->set_var('comment_code_radio',	$this->binz_common->html_input('comment_code',	'radio',array(1=>$this->binz_tpl->var_all['web_open'],0=>$this->binz_tpl->var_all['web_close']),				array(intval($system_info['comment_code']['system_value']))));
		$this->binz_tpl->set_var('leave_login_radio',	$this->binz_common->html_input('leave_login',	'radio',array(1=>$this->binz_tpl->var_all['open_comment_reg'],0=>$this->binz_tpl->var_all['open_comment_all']),	array(intval($system_info['leave_login']['system_value']))));
		$this->binz_tpl->set_var('leave_code_radio',	$this->binz_common->html_input('leave_code',	'radio',array(1=>$this->binz_tpl->var_all['web_open'],0=>$this->binz_tpl->var_all['web_close']),				array(intval($system_info['leave_code']['system_value']))));
		/*优化设置*/
		$this->binz_tpl->set_var('rwrite_radio',		$this->binz_common->html_input('rwrite',		'radio',array(1=>$this->binz_tpl->var_all['web_open'],0=>$this->binz_tpl->var_all['web_close']),				array(intval($system_info['rwrite']['system_value']))));
		$this->binz_tpl->set_var('gzip_radio',			$this->binz_common->html_input('web_gzip',		'radio',array(1=>$this->binz_tpl->var_all['web_open'],0=>$this->binz_tpl->var_all['web_close']),				array(intval($system_info['web_gzip']['system_value']))));
		
		/*载入模板*/
		$this->binz_tpl->set_tag('system_config');
	}
	/**
	 * system_set_save
	 *
	 * 系统设置保存
	 * @access  private（权限）
	 * 
	 */
	private function system_set_save() {
		$this->binz_admin_common->check_admin_power('system_set');
		
		$system_save		= false;

		/*保存系统设置*/
		$system_save		= $this->mod_system_save();
		if($system_save) {
			$message		= $this->binz_tpl->var_all['system_save_ok'];//'系统设置配置完毕';
		} else {
			$message		= $this->binz_tpl->var_all['system_save_no'];//'系统设置配置失败，请检查相关目录权限';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * watermark_set
	 *
	 * 设置水印图片
	 * @access  private（权限）
	 * 
	 */
	private function watermark_set() {
		$this->binz_admin_common->check_admin_power('system_watermark');
		
		$watermark_info	= array();

		/*水印图片信息*/
		$watermark_info	= $this->mod_system_info('watermark');
		$this->binz_tpl->set_var('watermark_info',$watermark_info);

		/*水印状态*/
		$this->binz_tpl->set_var('open_watermark_radio',$this->binz_common->html_input('open_watermark','radio',array(1=>$this->binz_tpl->var_all['system_watermark_open'],0=>$this->binz_tpl->var_all['system_watermark_close']),array(intval($watermark_info['open_watermark']['system_value']))));
		/*水印类型*/
		$this->binz_tpl->set_var('water_type_radio',	$this->binz_common->html_input('water_type','radio',array('image'=>$this->binz_tpl->var_all['system_watermark_img'],'text'=>$this->binz_tpl->var_all['system_watermark_text']),array($watermark_info['water_type']['system_value'])));
		/*水印位置*/
		$this->binz_tpl->set_var('position_radio',		$this->binz_common->html_input('position','radio',array(0=>$this->binz_tpl->var_all['system_watermark_position0'],1=>$this->binz_tpl->var_all['system_watermark_position1'],2=>$this->binz_tpl->var_all['system_watermark_position2'],3=>$this->binz_tpl->var_all['system_watermark_position3'],4=>$this->binz_tpl->var_all['system_watermark_position4'],5=>$this->binz_tpl->var_all['system_watermark_position5'],6=>$this->binz_tpl->var_all['system_watermark_position6']),array(intval($watermark_info['position']['system_value']))));

		/*载入模板*/
		$this->binz_tpl->set_tag('system_watermark');
	}
	/**
	 * watermark_set_save
	 *
	 * 水印图片设置保存
	 * @access  public（权限）
	 * 
	 */
	private function watermark_set_save() {
		$this->binz_admin_common->check_admin_power('system_watermark');
		
		$watermark_save		= false;

		/*水印图片设置保存*/
		$watermark_save		= $this->mod_system_watermark_save();
		if($watermark_save) {
			$message		= $this->binz_tpl->var_all['system_watermark_save_ok'];//'水印图片设置配置完毕';
		} else {
			$message		= $this->binz_tpl->var_all['system_watermark_save_no'];//'水印图片设置配置失败，请检查相关目录权限';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * upload_set
	 *
	 * 附件上传设置
	 * @access  private（权限）
	 * 
	 */
	private function upload_set() {
		$this->binz_admin_common->check_admin_power('system_upload');
		
		$upload_info	= array();

		/*上传设置信息*/
		$upload_info	= $this->mod_system_info('file_upload');
		$this->binz_tpl->set_var('upload_info',$upload_info);

		/*载入模板*/
		$this->binz_tpl->set_tag('system_upload');
	}
	/**
	 * upload_set_save
	 *
	 * 附件上传设置保存
	 * @access  private（权限）
	 * 
	 */
	private function upload_set_save() {
		$this->binz_admin_common->check_admin_power('system_upload');
		
		$upload_save		= false;

		/*保存上传设置信息*/
		$upload_save		= $this->mod_system_upload_save();
		if($upload_save) {
			$message		= $this->binz_tpl->var_all['system_upload_save_ok'];//'上传附件设置配置完毕';
		} else {
			$message		= $this->binz_tpl->var_all['system_upload_save_no'];//'上传设置配置失败，请检查相关目录权限';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * system_log
	 *
	 * 系统日志页面
	 * @access  private（权限）
	 * 
	 */
	private function system_log() {
		/*载入模板*/
		$this->binz_tpl->set_tag('system_logs');
	}
	/**
	 * system_admin
	 *
	 * 管理员列表页面
	 * @access  private（权限）
	 * 
	 */
	private function system_admin() {
		$this->binz_admin_common->check_admin_power('system_admin');
		
		$admin_array	= array();

		/*管理员列表信息*/
		$admin_array	= $this->mod_system_admin_list();
		$this->binz_tpl->set_var('admin_array',$admin_array);

		/*载入模板*/
		$this->binz_tpl->set_tag('admin_list');
	}
	/**
	 * system_admin_add
	 *
	 * 添加管理员页面
	 * @access  private（权限）
	 * 
	 */
	private function system_admin_add() {
		$this->binz_admin_common->check_admin_power('system_admin');
		
		$admin_info		= array();

		/*编辑管理员信息*/
		if(intval($_GET['admin_id']) != 0) {
			$admin_info		= $this->mod_system_admin_info($_GET['admin_id']);
			$this->binz_tpl->set_var('admin_info',$admin_info);
		}
		/*载入模板*/
		$this->binz_tpl->set_tag('admin_add');
	}
	/**
	 * system_admin_save
	 *
	 * 管理员保存
	 * @access  private（权限）
	 * 
	 */
	private function system_admin_save() {
		$this->binz_admin_common->check_admin_power('system_admin');
		
		$save_state		= false;
		$message		= '';
		$message_false	= '';

		if(intval($_POST['admin_id']) != '') {	//管理员修改
			$save_state		= $this->mod_system_admin_edit($_POST['admin_id']);
			$message		= $this->binz_tpl->var_all['system_admin_add_edit_ok'];//'管理员编辑成功！';
			$message_false	= $this->binz_tpl->var_all['system_admin_add_edit_no'];//'管理员编辑失败';
		} else {								//管理员添加
			$save_state		= $this->mod_system_admin_save();
			$message		= $this->binz_tpl->var_all['system_admin_add_save_ok'];//'管理员添加成功！';
			$message_false	= $this->binz_tpl->var_all['system_admin_add_save_no'];//'管理员添加失败';
		}

		if(intval($save_state) == 3) {//原密码输入有误
			/*跳转页面*/
			$this->binz_common->admin_msg($this->binz_tpl->var_all['system_admin_add_passwd_error'],0,$link,$this->binz_tpl,true,2);
			exit();
		}
		if(intval($save_state) == 2) {//密码为空，或是两次输入的密码不同
			/*跳转页面*/
			$this->binz_common->admin_msg($this->binz_tpl->var_all['system_admin_add_passwd_null'],0,$link,$this->binz_tpl,true,2);
			exit();
		}

		if($save_state) {
			$message			= $message;
			$link[0]['text']	= $this->binz_tpl->var_all['system_admin_add_click_url'];//'点击此链接到管理员列表页面';
			$link[0]['href']	= 'index.php?ctl=system&act=system_admin';
		} else {
			$message			= $message_false;
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * system_admin_del
	 *
	 * 管理员删除
	 * @access  private（权限）
	 * 
	 */
	private function system_admin_del() {
		$this->binz_admin_common->check_admin_power('system_admin');
		
		$del_state		= false;
		$message		= '';

		/*管理员删除*/
		$del_state		= $this->mod_system_admin_del($_GET['admin_id']);
		if(intval($del_state) == 2) {
			/*跳转页面*/
			$this->binz_common->admin_msg($this->binz_tpl->var_all['system_admin_list_no_del'],0,$link,$this->binz_tpl,true,2);
		}

		if($del_state) {
			$message	= $this->binz_tpl->var_all['system_admin_list_del_ok'];//'管理员删除成功';
		} else {
			$message	= $this->binz_tpl->var_all['system_admin_list_del_no'];//'管理员删除失败';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * system_admin_power
	 *
	 * 添加管理员权限页面
	 * @access  public（权限）
	 * @param   integer 参数
	 * @return  void	返回类型
	 */
	private function system_admin_power() {
		$this->binz_admin_common->check_admin_power('system_admin');
		
		/*权限数组*/
		if(intval($_GET['admin_id']) != 0 and intval($_GET['admin_id']) != 1) {
			$admin_info		= $this->mod_system_admin_info($_GET['admin_id']);
			$power_array	= explode(',',$admin_info['admin_power']);

			$this->binz_tpl->set_var('admin_info',$admin_info);
			$this->binz_tpl->set_var('power_array',$power_array);
		}

		/*权限信息*/
		include_once(ROOT_PATH.'/data/admin_power.php');
		$this->binz_tpl->set_var('admin_power',$admin_power);

		/*载入模板*/
		$this->binz_tpl->set_tag('admin_power');
	}
	/**
	 * system_admin_power_save
	 *
	 * 保存管理员权限
	 * @access  private（权限）
	 * 
	 */
	private function system_admin_power_save() {
		$this->binz_admin_common->check_admin_power('system_admin');
		
		$edit_state		= false;
		$message		= '';

		/*权限保存*/
		$edit_state		= $this->mod_system_admin_power_save();
		if($edit_state) {
			$message	= $this->binz_tpl->var_all['system_admin_power_save_ok'];//'权限编辑成功';
		} else {
			$message	= $this->binz_tpl->var_all['system_admin_power_save_no'];//'权限编辑失败';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * system_article
	 *
	 * 系统文章列表
	 * @access  private（权限）
	 * 
	 */
	private function system_article() {
		$this->binz_admin_common->check_admin_power('system_article');
		
		$article_array		= array();
		$perpage			= 10;			//每页记录数

		$article_array		= $this->mod_system_article_list($_GET['binz_page'],$perpage);
		$this->binz_tpl->set_var('article_array',$article_array);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->set_page(array('total'=>$article_array['count']['article_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		$this->binz_tpl->set_tag('system_article_list');
	}
	/**
	 * system_article_add
	 *
	 * 系统文章添加页面
	 * @access  private（权限）
	 * 
	 */
	private function system_article_add() {
		$this->binz_admin_common->check_admin_power('system_article');
		
		$article_state			= array(1);
		$article_info			= array();

		if(intval($_GET['article_id']) != 0) {
			$article_info	= $this->mod_sys_article_info($_GET['article_id']);
			$article_state	= array($article_info['sys_article_state']);
			$this->binz_tpl->set_var('article_info',$article_info);
		}
		$this->binz_tpl->set_var('system_article_state',			//文章状态
		$this->binz_common->html_input('system_article_state','radio',array(1=>$this->binz_tpl->var_all['system_admin_article_state_on'],0=>$this->binz_tpl->var_all['system_admin_article_state_off']),$article_state));

		/*在线编辑器*/
		$body	= $article_info['sys_article_content']=='' ? '<!--binzcms-->' : $article_info['sys_article_content'];
		$this->binz_tpl->set_var('content_fck',$this->binz_editor->create_editor('body_content',$body));

		$this->binz_tpl->set_tag('system_article_add');
	}
	/**
	 * system_article_save
	 *
	 * 系统文章保存
	 * @access  private（权限）
	 * 
	 */
	private function system_article_save() {
		$this->binz_admin_common->check_admin_power('system_article');
		
		$message		= '';
		$false_message	= '';

		if(intval($_POST['sys_article_id']) == 0) {
			/*内容保存*/
			$save_state		= $this->mod_system_article_save();
			$article_id		= $save_state;

			$message		= $this->binz_tpl->var_all['system_admin_article_save_ok'];//"系统文章保存成功";
			$false_message	= $this->binz_tpl->var_all['system_admin_article_save_no'];//"系统文章保存失败";
		} else {
			/*内容修改*/
			$save_state		= $this->mod_sys_article_edit($_POST['sys_article_id']);
			$message		= $this->binz_tpl->var_all['system_admin_article_edit_ok'];//"系统文章修改成功";
			$false_message	= $this->binz_tpl->var_all['system_admin_article_edit_ok'];//"系统文章修改失败";
		}
		if($save_state) {
			/*添加链接*/
			$link[1]['text']	= $this->binz_tpl->var_all['link_article_add'];		//'继续添加内容';
			$link[1]['href']	= 'index.php?ctl=system&act=system_article_add';

			$link[0]['text']	= $this->binz_tpl->var_all['link_article_list'];	//'查看内容列表';
			$link[0]['href']	= 'index.php?ctl=system&act=system_article';

			$link[2]['text']	= $this->binz_tpl->var_all['link_article_edit'];	//'编辑当前内容';
			$link[2]['href']	= 'index.php?ctl=system&act=system_article_add&aritlce_id='.$article_id;

			$redirect			= false;
		} else {
			$redirect			= true;
			$message			= $false_message;
		}
		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,$redirect);
	}
	/**
	 * change_action
	 *
	 * 执行列表的相关操作
	 * @access  private（权限）
	 * 
	 */
	private function change_action() {
		$this->binz_admin_common->check_admin_power('system_article');
		
		$change_state	= false;
		$message		= '';

		$change_state	= $this->mod_system_change_action();
		if($change_state) {
			$message	= $this->binz_tpl->var_all['article_list_modify_yes'];//'修改完成！';
		} else {
			$message	= $this->binz_tpl->var_all['article_list_modify_no'];//'修改失败！';
		}
		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,3);
	}
	/**
	 * system_article_del
	 *
	 * 系统文章删除
	 * @access  private（权限）
	 * 
	 */
	private function system_article_del() {
		$this->binz_admin_common->check_admin_power('system_article');
		
		$del_state		= false;
		$message		= '';

		$del_state		= $this->mod_system_article_del($_GET['article_id']);
		if($del_state) {
			$message		= $this->binz_tpl->var_all['article_list_del_ok'];//"删除成功";
		} else {
			$message		= $this->binz_tpl->var_all['article_list_del_no'];//"删除失败";
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>