<?php
/***
*
*@package binzcms
*@version $id:AdminLeaveClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:22:56 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminMessageClass
 * 留言管理
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminLeaveClass.php");
class AdminLeaveClass extends ModAdminLeaveClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "leave_manage";
		}
		/*合法action*/
		$this->allow_action	= array(
		'leave_manage',				//留言列表
		'leave_edit',				//编辑留言
		'leave_save',				//留言保存
		'leave_del'					//留言删除
		);
		
		parent::__construct($act);
		
		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "leave_manage";
		}
		
		/*载入语言包*/
		/*
		*AdminMessage	对应
		*/
		$this->import_language('AdminLeave,AdminCommon');

		$this->$act();
	}
	/**
	 * leave_manage
	 *
	 * 留言列表
	 * @access  private（权限）
	 * 
	 */
	private function leave_manage() {
		$this->binz_admin_common->check_admin_power('leave_manage');
		
		$leave_array	= array();
		$perpage		= 10;			//每页记录数

		/*留言列表*/
		$leave_array	= $this->mod_leave_list($_GET['binz_page'],$perpage);
		$this->binz_tpl->set_var('leave_array',$leave_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->set_page(array('total'=>$leave_array['count']['leave_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		/*载入模板*/
		$this->binz_tpl->set_tag('leave');
	}
	/**
	 * leave_edit
	 *
	 * 留言编辑页面
	 * @access  private（权限）
	 * 
	 */
	private function leave_edit() {
		$this->binz_admin_common->check_admin_power('leave_manage');
		
		$leave_info		= array();

		$leave_info		= $this->mod_leave_info($_GET['leave_id']);
		$this->binz_tpl->set_var('leave_info',$leave_info);

		/*载入模板*/
		$this->binz_tpl->set_tag('leave_edit');
	}
	/**
	 * leave_save
	 *
	 * 留言回复
	 * @access  private（权限）
	 * 
	 */
	private function leave_save() {
		$this->binz_admin_common->check_admin_power('leave_manage');
		
		$save_state		= false;
		$message		= '';
		$message_false	= '';

		if(intval($_POST['leave_id']) != 0) {
			$save_state		= $this->mod_leave_edit($_POST['leave_id']);
			$message		= $this->binz_tpl->var_all['leave_edit_save_ok'];//'留言编辑成功！';
			$message_false	= $this->binz_tpl->var_all['leave_edit_save_no'];//'留言编辑失败！';
		} else {
			$save_state		= $this->mod_leave_save();
			$message		= $this->binz_tpl->var_all['leave_list_save_ok'];//'留言回复成功！';
			$message_false	= $this->binz_tpl->var_all['leave_list_save_no'];//'留言回复失败！';
		}

		if($save_state) {
			$message			= $message;
			$link[0]['text']	= $this->binz_tpl->var_all['leave_click_url'];//'点击此链接到留言列表页面';
			$link[0]['href']	= 'index.php?ctl=leave&act=leave_manage&binz_page='.intval($_POST['binz_page']);
		} else {
			$message			= $message_false;
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * leave_del
	 *
	 * 函数简介
	 * @access  private（权限）
	 * 
	 */
	private function leave_del() {
		$this->binz_admin_common->check_admin_power('leave_manage');
		
		$del_state		= false;
		$message		= '';

		if((!is_array($_POST['id']) and count($_POST['id']) <= 0) and intval($_GET['leave_id']) == 0) {
			return '';
		}
		$leave_id		= is_array($_POST['id']) ? $_POST['id'] : intval($_GET['leave_id']);
		$del_state		= $this->mod_leave_del($leave_id);

		if($del_state) {
			$message			= $this->binz_tpl->var_all['leave_list_del_ok'];//'留言删除成功！';
			$link[0]['text']	= $this->binz_tpl->var_all['leave_click_url'];//'点击此链接到留言列表页面';
			$link[0]['href']	= 'index.php?ctl=leave&act=leave_manage&binz_page='.intval($_GET['binz_page']);
		} else {
			$message			= $this->binz_tpl->var_all['leave_list_del_no'];//'留言删除失败！';
		}
		
		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>