<?php
/***
*
*@package binzcms
*@version $id:AdminContentClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 00:58:32 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminContentClass
 * 内容管理
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminContentClass.php");
class AdminContentClass extends ModAdminContentClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "content_list";
		}
		/*合法action*/
		$this->allow_action	= array(
		'content_list',				//内容列表
		'change_action',			//执行列表的相关操作
		'content_add',				//内容添加
		'content_save',				//内容保存
		'content_del',				//内容删除
		'image_list',				//图片列表
		'image_add',				//图片添加
		'image_del',				//相册删除
		'ajax_drop_image',			//ajax删除图片
		'image_save',				//图片保存
		'content_comment',			//评论列表
		'content_comment_reply',	//回复评论
		'comment_reply_save',		//回复评论操作
		'comment_del'				//删除评论操作
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "content_list";
		}

		/*载入语言包*/
		/*
		*AdminContent	对应
		*/
		$this->import_language('AdminContent,AdminCommon');

		$this->$act();
	}
	/**
	 * content_list
	 *
	 * 内容列表
	 * @access  private（权限）
	 *
	 */
	private function content_list() {
		$this->binz_admin_common->check_admin_power('content_list');
		
		$article_class		= $this->import_class('ModAdminClass',ADMIN_MOD_PATH,'mod');	//分类对象
		
		/*频道下拉菜单*/
		$article_class_select	= $article_class->mod_class_select('article');
		$this->binz_tpl->set_var('class_select',		//搜索的频道下拉
		$this->binz_common->html_select('class_id',$article_class_select,array($this->binz_tpl->var_all['article_list_class_all']),intval($_GET['class_id'])));
		
		$article_array		= array();
		$perpage			= 10;			//每页记录数

		$article_array		= $this->mod_content_list($_GET['binz_page'],$perpage,$article_class);
		$this->binz_tpl->set_var('article_array',$article_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->set_page(array('total'=>$article_array['count']['article_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		$this->binz_tpl->set_var('class_move_select',	//移动的的频道下拉
		$this->binz_common->html_select('move_class_id',$article_class_select,array($this->binz_tpl->var_all['article_move_class_select']),$class_select,'style="display:none"'));

		/*载入模板*/
		$this->binz_tpl->set_tag('article_list');
	}
	/**
	 * change_action
	 *
	 * 执行列表的相关操作
	 * @access  private（权限）
	 * 
	 */
	private function change_action() {
		$this->binz_admin_common->check_admin_power('content_add');
		
		$change_state	= false;
		$message		= '';

		$change_state	= $this->mod_change_action();
		if($change_state) {
			$message	= $this->binz_tpl->var_all['article_list_modify_yes'];//'修改完成！';
		} else {
			$message	= $this->binz_tpl->var_all['article_list_modify_no'];//'修改失败！';
		}
		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,3);
	}
	/**
	 * content_add
	 *
	 * 内容添加页面
	 * @access  private（权限）
	 *
	 */
	private function content_add() {
		$this->binz_admin_common->check_admin_power('content_add');
		
		$class_select			= intval($_GET['class_id']) != 0 ? intval($_GET['class_id']) : '';
		$index_type				= '';
		$article_state			= array(1);

		$article_class			= $this->import_class('ModAdminClass',ADMIN_MOD_PATH,'mod');
		$article_class_select	= $article_class->mod_class_select('article');

		if(intval($_GET['content_id']) != 0) {				//编辑内容
			$article_info	= $this->mod_content_info(intval($_GET['content_id']));
			$class_select	= $article_info['class_id'];
			$index_type		= $article_info['article_index_show'];
			$article_state	= array($article_info['article_state']);
			$this->binz_tpl->set_var('article_info',$article_info);
		}

		$this->binz_tpl->set_var('class_select',			//频道选择
		$this->binz_common->html_select('class_id',$article_class_select,array($this->binz_tpl->var_all['article_add_class_select']),$class_select));

		$this->binz_tpl->set_var('index_type',				//首页类型
		$this->binz_common->html_select('index_type',array('1'=>$this->binz_tpl->var_all['article_add_art'],'2'=>$this->binz_tpl->var_all['article_add_first'],'3'=>$this->binz_tpl->var_all['article_add_slide']),array(),$index_type));

		$this->binz_tpl->set_var('article_state',			//文章状态
		$this->binz_common->html_input('article_state','radio',array(1=>$this->binz_tpl->var_all['article_add_state_open'],0=>$this->binz_tpl->var_all['article_add_state_close']),$article_state));

		/*在线编辑器*/
		$body	= $article_info['body_content']=='' ? '<!--binzcms-->' : $article_info['body_content'];
		$this->binz_tpl->set_var('content_fck',$this->binz_editor->create_editor('body_content',$body));

		/*载入模板*/
		$this->binz_tpl->set_tag('article_add');
	}
	/**
	 * content_save
	 *
	 * 内容保存
	 * @access  private（权限）
	 * 
	 */
	private function content_save() {
		$this->binz_admin_common->check_admin_power('content_add');
		
		$message		= '';
		$false_message	= '';

		/*图片保存*/
		$_POST['article_img']	= $this->mod_upload_image();

		if(intval($_POST['article_id']) == 0) {
			/*内容保存操作*/
			$save_state		= $this->mod_content_save();
			$article_id		= $save_state;

			$message		= $this->binz_tpl->var_all['article_add_save_ok'];
			$false_message	= $this->binz_tpl->var_all['article_add_save_no'];
		} else {
			/*内容编辑操作*/
			$save_state		= $this->mod_content_edit($_POST['article_id']);
			$article_id		= intval($_POST['article_id']);

			$message		= $this->binz_tpl->var_all['article_add_edit_ok'];
			$false_message	= $this->binz_tpl->var_all['article_add_edit_no'];
		}
		if($save_state) {
			/*添加链接*/
			$link[1]['text']	= $this->binz_tpl->var_all['link_article_add'];		//'继续添加内容';
			$link[1]['href']	= 'index.php?ctl=content&act=content_add';

			$link[0]['text']	= $this->binz_tpl->var_all['link_article_list'];	//'查看内容列表';
			$link[0]['href']	= 'index.php?ctl=content&act=content_list';

			$link[2]['text']	= $this->binz_tpl->var_all['link_article_edit'];	//'编辑当前内容';
			$link[2]['href']	= 'index.php?ctl=content&act=content_add&content_id='.$article_id;

			$redirect			= false;
		} else {
			$redirect			= true;
			$message			= $false_message;
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,$redirect);
	}
	/**
	 * content_del
	 *
	 * 内容删除
	 * @access  private（权限）
	 * 
	 */
	private function content_del() {
		$this->binz_admin_common->check_admin_power('content_add');
		
		$del_state		= false;
		$message		= '';

		$del_state		= $this->mod_article_del($_GET['content_id']);
		if($del_state) {
			$message		= $this->binz_tpl->var_all['article_list_del_ok'];
		} else {
			$message		= $this->binz_tpl->var_all['article_list_del_no'];
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true);
	}
	/**
	 * image_list
	 *
	 * 图片列表
	 * @access  private（权限）
	 *
	 */
	private function image_list() {
		$this->binz_admin_common->check_admin_power('image_list');
		
		$article_class		= $this->import_class('ModAdminClass',ADMIN_MOD_PATH,'mod');	//分类对象
		
		/*频道下拉菜单*/
		$article_class_select	= $article_class->mod_class_select('image');
		$this->binz_tpl->set_var('class_select',		//搜索的频道下拉
		$this->binz_common->html_select('class_id',$article_class_select,array($this->binz_tpl->var_all['article_list_class_all']),intval($_GET['class_id'])));
		
		$article_array		= array();
		$perpage			= 10;			//每页记录数

		$article_array		= $this->mod_image_list($_GET['binz_page'],$perpage,$article_class);
		$this->binz_tpl->set_var('article_array',$article_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->set_page(array('total'=>$article_array['count']['article_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		$this->binz_tpl->set_var('class_move_select',	//移动的的频道下拉
		$this->binz_common->html_select('move_class_id',$article_class_select,array($this->binz_tpl->var_all['article_move_class_select']),$class_select,'style="display:none"'));

		/*载入模板*/
		$this->binz_tpl->set_tag('image_list');
	}
	/**
	 * image_add
	 *
	 * 图片添加
	 * @access  private（权限）
	 * 
	 */
	private function image_add() {
		$this->binz_admin_common->check_admin_power('image_add');
		
		$class_select			= intval($_GET['class_id']) != 0 ? intval($_GET['class_id']) : '';
		$index_type				= array();
		$article_state			= array(1);
		$image_array			= array();

		$image_class			= $this->import_class('ModAdminClass',ADMIN_MOD_PATH,'mod');
		$article_class_select	= $image_class->mod_class_select('image');

		if(intval($_GET['content_id']) != 0) {				//编辑内容
			$article_info	= $this->mod_content_info(intval($_GET['content_id']));
			$class_select	= $article_info['class_id'];
			$index_type		= $article_info['article_index_show'];
			$article_state	= array($article_info['article_state']);
			$image_array	= $this->mod_image_more_info($_GET['content_id']);
			$this->binz_tpl->set_var('article_info',$article_info);
			$this->binz_tpl->set_var('image_more',$image_array);
		}

		$this->binz_tpl->set_var('class_select',			//频道选择
		$this->binz_common->html_select('class_id',$article_class_select,array($this->binz_tpl->var_all['article_add_class_select']),$class_select));

		$this->binz_tpl->set_var('index_type',				//首页类型
		$this->binz_common->html_select('index_type',array(1=>$this->binz_tpl->var_all['article_add_art'],2=>$this->binz_tpl->var_all['article_add_first'],3=>$this->binz_tpl->var_all['article_add_slide']),array(),$index_type));

		$this->binz_tpl->set_var('article_state',			//文章类型
		$this->binz_common->html_input('article_state','radio',array(1=>$this->binz_tpl->var_all['article_add_state_open'],0=>$this->binz_tpl->var_all['article_add_state_close']),$article_state));

		/*载入模板*/
		$this->binz_tpl->set_tag('image_add');
	}
	/**
	 * image_save
	 *
	 * 图片保存操作
	 * @access  private（权限）
	 * 
	 */
	private function image_save() {
		$this->binz_admin_common->check_admin_power('image_add');
		
		$message		= '';
		$false_message	= '';
		$add_state		= false;

		/*图片保存*/
		$_POST['article_img']	= $this->mod_upload_image();

		if(intval($_POST['article_id']) == 0) {
			$add_state 	= $this->mod_image_save();
			$article_id	= $add_state;
			$message		= $this->binz_tpl->var_all['image_add_save_ok'];//'图片内容添加成功';
			$false_message	= $this->binz_tpl->var_all['image_add_save_no'];//'图片内容添加失败';
		} else {
			$add_state	= $this->mod_image_edit();
			$article_id	= $add_state;
			$message		= $this->binz_tpl->var_all['image_add_edit_ok'];//'图片内容修改成功';
			$false_message	= $this->binz_tpl->var_all['image_add_edit_no'];//'图片内容修改失败';
		}
		if($add_state) {
			/*添加链接*/
			$link[1]['text']	= $this->binz_tpl->var_all['link_image_add'];//'继续添加图片';
			$link[1]['href']	= 'index.php?ctl=content&act=image_add';

			$link[0]['text']	= $this->binz_tpl->var_all['link_image_list'];//'查看图片列表';
			$link[0]['href']	= 'index.php?ctl=content&act=image_list';

			$link[2]['text']	= $this->binz_tpl->var_all['link_image_edit'];//'编辑当前图片内容';
			$link[2]['href']	= 'index.php?ctl=content&act=image_add&content_id='.$article_id;

			$redirect			= false;
		} else {
			$redirect			= true;
			$message			= $false_message;
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,$redirect);
	}
	/**
	 * image_del
	 *
	 * 相册删除
	 * @access  private（权限）
	 * 
	 */
	private function image_del() {
		$this->binz_admin_common->check_admin_power('image_add');
		
		$del_state		= false;
		$message		= '';

		$del_state		= $this->mod_article_del($_GET['content_id']);
		$del_more_image	= $this->mod_image_more_del($_GET['content_id']);

		if($del_state and $del_more_image) {
			$message		= $this->binz_tpl->var_all['image_add_del_ok'];
		} else {
			$message		= $this->binz_tpl->var_all['image_add_del_no'];
		}
		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true);
	}
	/**
	 * ajax_drop_image
	 *
	 * ajax删除图片
	 * @access  private（权限）
	 * 
	 */
	private function ajax_drop_image() {
		$this->binz_admin_common->check_admin_power('image_add');
		
		$image_id	= intval($_REQUEST['img_id']);
		$drop_state	= false;
		$drop_state	= $this->mod_drop_image_more($image_id);
		$this->binz_common->make_json_response($image_id);
	}
	/**
	 * content_comment
	 *
	 * 内容评论列表页面
	 * @access  private（权限）
	 * 
	 */
	private function content_comment() {
		$this->binz_admin_common->check_admin_power('content_comment');
		
		$comment_array	= array();
		$perpage		= 10;			//每页记录数

		/*文章评论列表*/
		$comment_array	= $this->mod_comment_list($_GET['binz_page'],$perpage);
		$this->binz_tpl->set_var('comment_array',$comment_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->set_page(array('total'=>$comment_array['count']['comment_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		/*载入模板*/
		$this->binz_tpl->set_tag('content_comment_list');
	}
	/**
	 * content_comment_reply
	 *
	 * 评论回复页面
	 * @access  private（权限）
	 * 
	 */
	private function content_comment_reply() {
		$this->binz_admin_common->check_admin_power('content_comment');
		
		$comment_info		= array();

		$comment_info		= $this->mod_comment_info($_GET['comment_id']);
		$comment_info['comment_ip']	= $comment_info['comment_ip'] == '' ? $this->binz_tpl->var_all['comment_list_ip_null'] : $comment_info['comment_ip'];
		$this->binz_tpl->set_var('comment_info',$comment_info);

		/*载入模板*/
		$this->binz_tpl->set_tag('content_comment_reply');
	}
	/**
	 * comment_reply_save
	 *
	 * 评论回复操作
	 * @access  private（权限）
	 * @param   integer 参数
	 * @return  void	返回类型
	 */
	private function comment_reply_save() {
		$this->binz_admin_common->check_admin_power('content_comment');
		
		$save_state		= false;
		$message		= '';

		$save_state		= $this->mod_comment_reply_save($_POST['comment_id']);
		if($save_state) {
			$message	= $this->binz_tpl->var_all['comment_reply_save_ok'];//'评论回复成功！';
		} else {
			$message	= $this->binz_tpl->var_all['comment_reply_save_no'];//'评论回复失败！';
		}

		$link[0]['text']	= $this->binz_tpl->var_all['comment_reply_click_url'];//'点此返回评论内容页面';
		$link[0]['href']	= 'index.php?ctl=content&act=content_comment_reply&comment_id='.intval($_POST['comment_id']);

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,1);
	}
	/**
	 * comment_del
	 *
	 * 评论删除
	 * @access  public（权限）
	 * @param   integer 参数
	 * @return  void	返回类型
	 */
	private function comment_del() {
		$this->binz_admin_common->check_admin_power('content_comment');
		
		$del_state		= false;
		$message		= '';

		$del_state		= $this->mod_comment_del($_REQUEST['comment_id']);
		if($del_state) {
			$message	= $this->binz_tpl->var_all['comment_list_del_ok'];//'评论删除成功！';
		} else {
			$message	= $this->binz_tpl->var_all['comment_list_del_no'];//'评论删除失败！';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,1);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>