<?php
/***
*
*@package binzcms
*@version $id:AdminAdClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:14:24 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminAdClass
 * 广告
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminAdClass.php");
class AdminAdClass extends ModAdminAdClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "ad_manage";
		}
		/*合法action*/
		$this->allow_action	= array(
		'ad_manage',				//广告列表
		'ad_add',					//广告添加
		'ad_save',					//广告保存
		'ad_del',					//广告删除
		'ad_js'						//广告调用
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "ad_manage";
		}

		/*载入语言包*/
		/*
		*AdminAd		对应
		*/
		$this->import_language('AdminAd,AdminCommon');

		$this->$act();
	}
	/**
	 * ad_manage
	 *
	 * 广告列表
	 * @access  private（权限）
	 * 
	 */
	private function ad_manage() {
		$this->binz_admin_common->check_admin_power('ad_manage');
		
		$ad_array	= array();

		/*广告列表*/
		$ad_type_lg	= array('ad_text'=>$this->binz_tpl->var_all['ad_add_type_text'],'ad_code'=>$this->binz_tpl->var_all['ad_add_type_code'],'ad_image'=>$this->binz_tpl->var_all['ad_add_type_image'],'ad_flash'=>$this->binz_tpl->var_all['ad_add_type_flash']);

		/*广告类型的文字描述数组*/
		$this->binz_tpl->set_var('ad_type_lg',$ad_type_lg);
		$ad_array	= $this->mod_ad_list();
		$this->binz_tpl->set_var('ad_array',$ad_array);

		/*载入模板*/
		$this->binz_tpl->set_tag('ad_list');
	}
	/**
	 * ad_add
	 *
	 * 广告添加页面
	 * @access  private（权限）
	 * 
	 */
	private function ad_add() {
		$this->binz_admin_common->check_admin_power('ad_manage');
		
		$ad_state	= array(1);

		/*编辑广告，输出广告信息*/
		if(intval($_GET['ad_id']) != 0) {
			$ad_info	= $this->mod_ad_info($_GET['ad_id']);
			$ad_state	= array($ad_info['ad_state']);
			$this->binz_tpl->set_var('ad_info',$ad_info);
		}

		/*广告状态*/
		$this->binz_tpl->set_var('ad_state',$this->binz_common->html_input('ad_state','radio',array(1=>$this->binz_tpl->var_all['ad_add_state_open'],0=>$this->binz_tpl->var_all['ad_add_state_close']),$ad_state));

		/*时间js*/
		$this->binz_tpl->set_var('time_calendar',$this->binz_common->out_calendar());

		/*载入模板*/
		$this->binz_tpl->set_tag('ad_add');
	}
	/**
	 * ad_save
	 *
	 * 广告保存
	 * @access  private（权限）
	 * 
	 */
	private function ad_save() {
		$this->binz_admin_common->check_admin_power('ad_manage');
		
		$upload_path			= 'upload/ad';			//广告文件上传地址
		$insert_state			= false;
		$message				= '';
		$message_false			= '';

		/*处理上传文件*/
		$_POST['body']	= $this->mod_body($upload_path);

		if(intval($_POST['ad_id']) != 0) {	//广告编辑
			$save_state		= $this->mod_ad_edit($_POST['ad_id']);
			$message		= $this->binz_tpl->var_all['ad_add_edit_ok'];	//'广告编辑成功';
			$message_false	= $this->binz_tpl->var_all['ad_add_edit_no'];	//'广告编辑失败';
		} else {							//广告保存
			$save_state		= $this->mod_ad_save();
			$message		= $this->binz_tpl->var_all['ad_add_save_ok'];	//'广告保存成功';
			$message_false	= $this->binz_tpl->var_all['ad_add_save_no'];	//'广告保存失败';
		}

		if($save_state) {
			$message			= $message;
			$link[0]['text']	= $this->binz_tpl->var_all['ad_add_click_url'];//'点击此链接到广告列表页面';
			$link[0]['href']	= 'index.php?ctl=ad&act=ad_manage';
		} else {
			$message			= $message_false;
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * ad_del
	 *
	 * 广告删除
	 * @access  private（权限）
	 * 
	 */
	private function ad_del() {
		$this->binz_admin_common->check_admin_power('ad_manage');
		
		$del_state		= false;
		$message		= '';

		$del_state		= $this->mod_ad_del($_GET['ad_id']);
		if($del_state) {
			$message	= $this->binz_tpl->var_all['ad_list_del_ok'];//'广告删除成功';
		} else {
			$message	= $this->binz_tpl->var_all['ad_list_del_no'];//'广告删除失败';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * ad_js
	 *
	 * js广告调用
	 * @access  private（权限）
	 * 
	 */
	private function ad_js() {
		/*载入模板*/
		$this->binz_tpl->set_tag('ad_js');
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>