<?php
/***
*
*@package binzcms
*@version $id:ModFrontSearchClass.php, v 1.0
*@author 斌子
*@Sat Sep 11 14:11:29 GMT 2010
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModFrontSearchClass
 * 前台搜索
 * 
 */
class ModFrontSearchClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_front_search_article_list
	 *
	 * 文章搜索列表
	 * @access  public（权限）
	 *  @param   integer $binz_page		当前页数
	 *  @param   integer $page_num		每页记录数
	 * @param 	string	$type_tag	文章类型，图片的还是内容的
	 * @return  array	内容列表数组
	 */
	public function mod_front_search_article_list($binz_page,$page_num,$type_tag='article') {
		$article_array		= array();
		$article_sql		= "";
		$limit_sql			=  "LIMIT ".(intval($binz_page)-(intval($binz_page)>=1 ? 1 : 0))*$page_num.",$page_num";

		$where					= "WHERE a.article_title LIKE '%".trim($_GET['keywords'])."%' AND a.article_state=1";
		if($type_tag == 'image') {
			$where				.= " AND c.class_type_tag='image'";
		} elseif($type_tag == 'article') {
			$where				.=" AND c.class_type_tag='article'";
		}
		
		$article_sql			= "SELECT a.*,c.class_name FROM #binz#article AS a
									INNER JOIN #binz#article_class AS c ON a.class_id=c.class_id
									$where AND c.class_state=1
									ORDER BY a.article_sort,a.article_id DESC ".$limit_sql;
		$article_array['list']	= $this->binz_db->set_select_sql($article_sql);
		$article_array['count']	= $this->binz_db->set_select_sql("SELECT COUNT(a.article_id) AS article_num FROM #binz#article AS a $where",0);

		return $article_array;
	}
	/**
	 * mod_front_article_type
	 *
	 * 特定组分类列表
	 * @access  public（权限）
	 * @param   array	$type		列表类型
	 * @param   int		$num		文章数目
	 * @param 	string	$type_tag	文章类型，图片的还是内容的
	 * @return  array
	 */
	public function mod_front_article_type($type,$num,$type_tag='article') {
		$article_array	= array();
		$article_sql	= '';

		$where					= "WHERE a.article_state=1";
		if($type_tag == 'image') {
			$where				.= " AND c.class_type_tag='image'";
		} elseif($type_tag == 'article') {
			$where				.=" AND c.class_type_tag='article'";
		}
		
		$article_sql			= "SELECT a.*,c.class_name FROM #binz#article AS a
									INNER JOIN #binz#article_class AS c ON a.class_id=c.class_id
									$where  AND c.class_state=1
									ORDER BY a.".$type." DESC LIMIT 0,".$num;
		$article_array	= $this->binz_db->set_select_sql($article_sql);
		
		return $article_array;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>