<?php
/***
*
*@package binzcms
*@version $id:ModFrontOtherClass.php, v 1.0
*@author 斌子
*@Thu Mar 05 00:06:12 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModFrontOtherClass
 * 前台其他非主要显示
 * 
 */
class ModFrontOtherClass extends  BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_front_vote_add
	 *
	 * 投票操作
	 * @access  public（权限）
	 * 
	 * @param   int		$vote_option	投票选项
	 * @return  void	返回类型
	 */
	public function mod_front_vote_add($vote_option) {
		$vote_sql	= '';
		$vote_info	= array();

		if($vote_option != 0) {
			$vote_sql	= "SELECT * FROM #binz#vote
							WHERE vote_id=".intval($_GET['vote_id']);
			$vote_info	= $this->binz_db->set_select_sql($vote_sql,0);

			$vote_body	= unserialize($vote_info['vote_body']);
			foreach ($vote_body as $key => $val) {
				if($val['vote_key'] == $vote_option) {
					$vote_body[$key]['vote_num']	= intval($val['vote_num'])+1;
					$vote_info['vote_count']		= intval($vote_info['vote_count'])+1;
				}
			}
			$update_array['vote_body']	= serialize($vote_body);
			$update_array['vote_count']	= $vote_info['vote_count'];
			$this->binz_db->set_update_sql('#binz#vote',$update_array,array('field'=>'vote_id','value'=>intval($_GET['vote_id'])));
		}

		return true;
	}
	/**
	 * mod_front_vote_view
	 *
	 * 投票显示操作
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_front_vote_view() {
		$vote_sql	= '';
		$vote_array	= array();

		$vote_sql	= "SELECT * FROM #binz#vote
						WHERE vote_id=".intval($_GET['vote_id']);
		$vote_array	= $this->binz_db->set_select_sql($vote_sql,0);

		return $vote_array;
	}
	/**
	 * mod_front_system_article_view
	 *
	 * 系统文章显示，包括公告和底部导航显示
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_front_system_article_view($type) {
		$article_sql	= '';
		$article_array	= array();

		$article_sql	= "SELECT * FROM #binz#sys_article
						WHERE sys_article_class=".$type." AND sys_article_state=1 AND sys_article_id=".intval($_GET['article_id']);
		$article_array	= $this->binz_db->set_select_sql($article_sql,0);

		return $article_array;
	}
	/**
	 * mod_front_article_type
	 *
	 * 特定组分类列表
	 * @access  public（权限）
	 * @param   array	$type		列表类型
	 * @param   int		$num		文章数目
	 * @return  array
	 */
	public function mod_front_article_type($type,$num) {
		$article_array	= array();
		$article_sql	= '';

		$where					= "WHERE a.article_state=1";
		$article_sql			= "SELECT a.* FROM #binz#article AS a
									$where
									ORDER BY a.".$type." DESC LIMIT 0,".$num;
		$article_array	= $this->binz_db->set_select_sql($article_sql);
		
		return $article_array;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>