<?php
/***
*
*@package binzcms
*@version $id:ModFrontIndexClass.php, v 1.0
*@author 斌子
*@Sat Jan 03 23:56:31 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModFrontIndexClass
 * 首页应用类
 * 
 */
class ModFrontIndexClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_front_commend_article
	 *
	 * 首页推荐资讯
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_front_commend_article($num=6) {
		$commend_array	= array();
		$commend_sql	= '';

		$commend_sql	= "SELECT * FROM #binz#article AS article
							INNER JOIN #binz#article_class AS class
							ON article.class_id=class.class_id
							WHERE article.article_state=1 AND article.article_commend=1 AND class.class_state=1
							ORDER BY article.article_sort LIMIT 0,$num";
		$commend_array	= $this->binz_db->set_select_sql($commend_sql);

		return $commend_array;
	}
	/**
	 * mod_front_new_article
	 *
	 * 最新资讯
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_front_new_article($num=6) {
		$new_array	= array();
		$new_sql	= '';

		$new_sql	= "SELECT * FROM #binz#article AS article
							INNER JOIN #binz#article_class AS class
							ON article.class_id=class.class_id
							WHERE article.article_state=1 AND class.class_state=1
							ORDER BY article.article_id DESC LIMIT 0,$num";
		$new_array	= $this->binz_db->set_select_sql($new_sql);

		return $new_array;
	}
	/**
	 * mod_front_hot_article
	 *
	 * 焦点资讯（热门）
	 * @access  public（权限）
	 * @param   integer 参数
	 * @return  array
	 */
	public function mod_front_hot_article($num=6) {
		$hot_array	= array();
		$hot_sql	= '';

		$hot_sql	= "SELECT * FROM #binz#article AS article
							INNER JOIN #binz#article_class AS class
							ON article.class_id=class.class_id
							WHERE article.article_state=1 AND class.class_state=1
							ORDER BY article.article_click DESC LIMIT 0,$num";
		$hot_array	= $this->binz_db->set_select_sql($hot_sql);

		return $hot_array;
	}
	/**
	 * mod_front_index_flink
	 *
	 * 友情链接，分出图片链接和文字链接
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_front_index_flink() {
		$flink_array	= array();
		$flink_sql		= '';

		$flink_sql		= "SELECT * FROM #binz#flink AS flink
							ORDER BY flink.flink_sort,flink.flink_id";
		$array			= $this->binz_db->set_select_sql($flink_sql);

		/*划分友情链接类型，图片类型，文字类型*/
		foreach ($array as $v) {
			if($v['flink_logo'] != '') {
				$v['flink_logo']		= (strpos("http",$v['flink_logo']) === false ? substr($v['flink_logo'],1,strlen($v['flink_logo'])) : $v['flink_logo']);
				$flink_array['image'][]	= $v;
			} else {
				$flink_array['text'][]	= $v;
			}
		}

		return $flink_array;
	}
	/**
	 * mod_front_index_vote
	 *
	 * 投票信息
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_front_index_vote() {
		$vote_array		= array();
		$vote_sql		= '';

		$vote_sql	= "SELECT * FROM #binz#vote AS vote
						WHERE vote.vote_start_time<'".date("Y-m-d")."' and vote.vote_end_time>='".date("Y-m-d")."'";
		$vote_info	= $this->binz_db->set_select_sql($vote_sql,0);
		$vote_info['vote_body']	= $vote_info['vote_body'] != '' ? unserialize($vote_info['vote_body']) : '';

		return $vote_info;
	}
	/**
	 * mod_front_class_list
	 *
	 * 首页分类列表
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_front_class_list() {
		$class_array	= array();
		$class_sql		= '';

		$class_sql		= "SELECT * FROM #binz#article_class AS class
							WHERE class.class_state=1 AND class_top_id=0 AND index_class=1
							ORDER BY class.class_sort";
		$class_array	= $this->binz_db->set_select_sql($class_sql);
		$class_array	= $this->self_class_article($class_array);

		return $class_array;
	}
	/**
	 * self_class_article
	 *
	 * 分类内的文章
	 * @access  private（权限）
	 * 
	 * @return  array	包含分类，分类文章，分类图片文章
	 */
	private function self_class_article($class_array) {
		$class_array		= $class_array;
		$class_txt_article	= array();
		$class_img_article	= array();
		$txt_article_sql	= '';
		$img_article_sql	= '';

		$article_class		= $this->import_class("ModAdminClass",ADMIN_MOD_PATH,'mod');
		if(is_array($class_array) and count($class_array)>0) {
			foreach ($class_array as $key => $val) {
				$class_sub_array	= $article_class->get_sun_class_id($val['class_id'],true);
				$where_str			= "WHERE a.class_id IN (".implode(",",$class_sub_array).")";
				/*文本新闻*/
				$txt_article_sql	= "SELECT * FROM #binz#article AS a
				
										$where_str and a.article_state=1
										ORDER BY a.article_id desc LIMIT 0,10";
				$class_txt_article	= $this->binz_db->set_select_sql($txt_article_sql);
				/*图片信息*/
				$img_article_sql	= "SELECT * FROM #binz#article AS a
										$where_str and a.article_state=1 and a.article_img!=''
										ORDER BY a.article_id desc LIMIT 0,6";
				$class_img_article	= $this->binz_db->set_select_sql($img_article_sql);

				$class_array[$key]['txt']	= $class_txt_article;
				$class_array[$key]['img']	= $class_img_article;
			}
			return $class_array;
		}
	}
	/**
	 * mod_front_class_list
	 *
	 * 首页分类列表
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_front_notice_list($num) {
		$notice_array	= array();
		$notice_sql	= '';

		$notice_sql	= "SELECT * FROM #binz#sys_article AS article
							WHERE article.sys_article_state=1 and article.sys_article_class=1
							ORDER BY article.sys_article_sort LIMIT 0,$num";
		$notice_array= $this->binz_db->set_select_sql($notice_sql);

		return $notice_array;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>