<?php
/***
*
*@package binzcms
*@version $id:ModFrontClassClass.php, v 1.0
*@author 斌子
*@Tue Apr 14 22:08:02 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModFrontClassClass
 * 文章分类应用类
 * 
 */
class ModFrontClassClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_front_article_list
	 *
	 * 文章列表
	 * @access  public（权限）
	 *  @param   integer $binz_page		当前页数
	 *  @param   integer $page_num		每页记录数
	 * @return  array	内容列表数组
	 */
	public function mod_front_article_list($binz_page,$page_num,$article_class) {
		$article_array		= array();
		$article_sql		= "";
		$limit_sql			=  "LIMIT ".(intval($binz_page)-(intval($binz_page)>=1 ? 1 : 0))*$page_num.",$page_num";

		$class_sub_array	= $article_class->get_sun_class_id(intval($_GET['class_id']),true);
		if(count($class_sub_array)== 0 or intval($_GET['class_id']) == 0) {
			return false;
		}
		$where					= "WHERE a.class_id IN (".implode(',',$class_sub_array).") AND a.article_state=1";
		$article_sql			= "SELECT a.*,c.class_name FROM #binz#article AS a
									INNER JOIN #binz#article_class AS c ON a.class_id=c.class_id
									$where
									ORDER BY a.article_index_show,a.article_class_show,a.article_sort,a.article_id DESC ".$limit_sql;
		$article_array['list']	= $this->binz_db->set_select_sql($article_sql);
		$article_array['count']	= $this->binz_db->set_select_sql("SELECT COUNT(a.article_id) AS article_num FROM #binz#article AS a $where",0);

		return $article_array;
	}
	/**
	 * mod_front_article_type
	 *
	 * 特定组分类列表
	 * @access  public（权限）
	 * @param   array	$type		列表类型
	 * @param   int		$num		文章数目
	 * @return  array
	 */
	public function mod_front_article_type($type,$num,$article_class) {
		$article_array	= array();
		$article_sql	= '';

		$class_sub_array	= $article_class->get_sun_class_id(intval($_GET['class_id']),true);
		
		if(count($class_sub_array)== 0) {
			return '';
		}
		$where					= "WHERE a.class_id IN (".implode(',',$class_sub_array).") AND a.article_state=1";
		$article_sql			= "SELECT a.*,c.class_name FROM #binz#article AS a
									INNER JOIN #binz#article_class AS c ON a.class_id=c.class_id
									$where
									ORDER BY a.".$type." DESC LIMIT 0,".$num;
		$article_array	= $this->binz_db->set_select_sql($article_sql);
		
		return $article_array;
	}
	/**
	 * mod_front_class_list
	 *
	 * 分类导航
	 * @access  public（权限）
	 * 
	 * @return  array	包括当前分类，同级分类，和下级分类
	 */
	public function mod_front_class_list() {
		$class_id		= intval($_GET['class_id']);
		$class_sql		= "SELECT * FROM #binz#article_class as c
							WHERE c.class_id=".$class_id." and c.class_state=1";
		$class_array	= $this->binz_db->set_select_sql($class_sql,0);

		if(count($class_array) == 0) {
			return '';
		}
		/*同级分类*/
		$class_top_sql	= "SELECT * FROM #binz#article_class AS c
							WHERE c.class_top_id=".$class_array['class_top_id']." and c.class_id!=".$class_id." and c.class_state=1";
		$class_top_array= $this->binz_db->set_select_sql($class_top_sql);
		
		/*下级分类*/
		$class_sun_sql	= "SELECT * FROM #binz#article_class as c
							WHERE c.class_top_id=".$class_array['class_id']." and c.class_state=1";
		$class_sun_array= $this->binz_db->set_select_sql($class_sun_sql);
		
		return array('top_class'=>$class_top_array,'class'=>$class_array,'sun_class'=>$class_sun_array);
	}
	/**
	 * mod_front_class_one_info
	 *
	 * 单条分类内容
	 * @access  public（权限）
	 * 
	 * @return  array	分类内容
	 */
	public function mod_front_class_one_info($class_id) {
		$class_id	= intval($class_id);
		$class_sql	= "SELECT * FROM #binz#article_class AS c
						WHERE c.class_id=".$class_id;
		$class_info	= $this->binz_db->set_select_sql($class_sql,0);
		return $class_info;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>