DROP TABLE IF EXISTS binz_ad;
CREATE TABLE binz_ad (
  ad_id int(10) NOT NULL AUTO_INCREMENT,
  ad_name varchar(50) NOT NULL,
  ad_type varchar(10) NOT NULL,
  ad_place varchar(100) NOT NULL,
  ad_time_start varchar(10) DEFAULT NULL,
  ad_time_end varchar(10) DEFAULT NULL,
  ad_url varchar(200) DEFAULT NULL,
  ad_body text NOT NULL,
  ad_state tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (ad_id),
  KEY ad_name (ad_name),
  KEY ad_type (ad_type)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_admin;
CREATE TABLE binz_admin (
  admin_id int(8) NOT NULL AUTO_INCREMENT,
  admin_name varchar(100) NOT NULL,
  admin_passwd varchar(16) NOT NULL,
  admin_email varchar(100) NOT NULL,
  admin_power text,
  admin_time varchar(10) NOT NULL,
  admin_login_time varchar(10) DEFAULT NULL,
  PRIMARY KEY (admin_id),
  KEY admin_name (admin_name),
  KEY admin_time (admin_time)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_article;
CREATE TABLE binz_article (
  article_id int(10) NOT NULL AUTO_INCREMENT,
  class_id int(10) NOT NULL,
  article_title varchar(100) NOT NULL,
  article_url_jump varchar(255) DEFAULT NULL,
  article_title_color varchar(7) DEFAULT NULL,
  article_source varchar(200) DEFAULT NULL,
  article_author varchar(100) NOT NULL,
  article_time varchar(10) NOT NULL,
  article_update varchar(10) DEFAULT NULL,
  article_click int(10) NOT NULL DEFAULT '0',
  article_state tinyint(1) NOT NULL,
  article_sort int(8) NOT NULL,
  article_commend tinyint(1) DEFAULT '0',
  article_img varchar(200) DEFAULT NULL,
  article_index_show tinyint(1) DEFAULT NULL,
  article_class_show tinyint(1) DEFAULT NULL,
  article_keywords varchar(200) DEFAULT NULL,
  article_description varchar(255) DEFAULT NULL,
  PRIMARY KEY (article_id),
  KEY class_id (class_id),
  KEY article_title (article_title),
  KEY article_sort (article_sort)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_article_body;
CREATE TABLE binz_article_body (
  body_id int(10) NOT NULL,
  class_id int(10) NOT NULL,
  body_content longtext,
  PRIMARY KEY (body_id),
  KEY class_id (class_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_article_class;
CREATE TABLE binz_article_class (
  class_id int(10) NOT NULL AUTO_INCREMENT,
  class_top_id int(10) NOT NULL,
  class_name varchar(50) NOT NULL,
  class_url varchar(200) DEFAULT NULL,
  top_menu tinyint(1) NOT NULL DEFAULT '0',
  index_class tinyint(1) NOT NULL DEFAULT '0',
  class_type_id int(10) NOT NULL,
  class_type_tag varchar(10) NOT NULL,
  class_state tinyint(1) NOT NULL DEFAULT '0',
  class_sort int(8) NOT NULL DEFAULT '0',
  class_keywords varchar(100) DEFAULT NULL,
  class_description varchar(255) DEFAULT NULL,
  PRIMARY KEY (class_id),
  KEY class_top_id (class_top_id),
  KEY class_name (class_name),
  KEY class_type_id (class_type_id),
  KEY class_state (class_state),
  KEY class_sort (class_sort)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_article_comment;
CREATE TABLE binz_article_comment (
  comment_id int(10) NOT NULL AUTO_INCREMENT,
  article_id int(10) NOT NULL,
  comment_author varchar(100) NOT NULL,
  member_id int(11) DEFAULT NULL,
  comment_time varchar(10) NOT NULL DEFAULT '0',
  comment_body varchar(255) DEFAULT NULL,
  comment_repost varchar(255) DEFAULT NULL,
  comment_repost_author varchar(50) DEFAULT NULL,
  comment_ip varchar(20) NOT NULL,
  comment_repost_time varchar(10) NOT NULL,
  PRIMARY KEY (comment_id),
  KEY article_id (article_id),
  KEY member_id (member_id),
  KEY comment_repost_author (comment_repost_author)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_class_type;
CREATE TABLE binz_class_type (
  class_type_id int(10) NOT NULL AUTO_INCREMENT,
  class_type_name varchar(50) NOT NULL,
  class_type_tpl varchar(100) NOT NULL,
  class_type_tag varchar(10) NOT NULL,
  PRIMARY KEY (class_type_id),
  KEY class_type_tag (class_type_tag),
  KEY class_type_name (class_type_name)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_flink;
CREATE TABLE binz_flink (
  flink_id int(10) NOT NULL AUTO_INCREMENT,
  flink_name varchar(100) NOT NULL,
  flink_url varchar(200) NOT NULL,
  flink_sort int(8) DEFAULT NULL,
  flink_logo varchar(200) DEFAULT NULL,
  PRIMARY KEY (flink_id),
  KEY flink_sort (flink_sort),
  KEY flink_name (flink_name)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_image;
CREATE TABLE binz_image (
  image_id int(11) NOT NULL AUTO_INCREMENT,
  article_id int(11) NOT NULL DEFAULT '0',
  image_source varchar(255) NOT NULL,
  image_art varchar(255) NOT NULL,
  image_thumb varchar(255) NOT NULL,
  image_info varchar(255) DEFAULT NULL,
  PRIMARY KEY (image_id),
  KEY article_id (article_id)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_leave;
CREATE TABLE binz_leave (
  leave_id int(10) NOT NULL AUTO_INCREMENT,
  leave_writer varchar(50) NOT NULL,
  leave_body varchar(255) NOT NULL,
  leave_time varchar(10) NOT NULL,
  leave_ip varchar(20) DEFAULT NULL,
  PRIMARY KEY (leave_id),
  KEY leave_writer (leave_writer),
  KEY leave_time (leave_time),
  KEY leave_ip (leave_ip)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_member;
CREATE TABLE binz_member (
  member_id int(10) NOT NULL AUTO_INCREMENT,
  member_name varchar(100) NOT NULL,
  member_passwd varchar(16) NOT NULL,
  member_birthday varchar(10) DEFAULT NULL,
  member_sex tinyint(1) NOT NULL,
  member_email varchar(50) DEFAULT NULL,
  member_msn varchar(50) DEFAULT NULL,
  member_qq varchar(50) DEFAULT NULL,
  member_img varchar(200) DEFAULT NULL,
  member_time varchar(10) NOT NULL,
  login_time varchar(10) NOT NULL,
  login_old_time VARCHAR( 10 ) NOT NULL,
  PRIMARY KEY (member_id),
  KEY member_name (member_name),
  KEY login_time (login_time)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_system;
CREATE TABLE binz_system (
  system_name varchar(50) NOT NULL,
  system_value varchar(255) NOT NULL,
  system_sort int(8) NOT NULL DEFAULT '0',
  system_type varchar(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_sys_article;
CREATE TABLE binz_sys_article (
  sys_article_id int(11) NOT NULL AUTO_INCREMENT,
  sys_article_title varchar(100) NOT NULL,
  sys_url_jump varchar(255) DEFAULT NULL,
  sys_article_sort int(11) NOT NULL DEFAULT '0',
  sys_article_state tinyint(4) NOT NULL,
  sys_article_class int(11) NOT NULL,
  sys_article_author varchar(50) NOT NULL,
  sys_article_content text NOT NULL,
  sys_article_time varchar(10) NOT NULL,
  PRIMARY KEY (sys_article_id),
  KEY sys_article_title (sys_article_title),
  KEY sys_article_sort (sys_article_sort),
  KEY sys_article_class (sys_article_class)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS binz_vote;
CREATE TABLE binz_vote (
  vote_id int(10) NOT NULL AUTO_INCREMENT,
  vote_title varchar(100) NOT NULL,
  vote_start_time varchar(10) DEFAULT NULL,
  vote_end_time varchar(10) DEFAULT NULL,
  vote_type tinyint(1) NOT NULL,
  vote_body text NOT NULL,
  vote_count int(10) NOT NULL,
  PRIMARY KEY (vote_id),
  KEY vote_title (vote_title),
  KEY vote_start_time (vote_start_time),
  KEY vote_type (vote_type)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


INSERT INTO binz_system VALUES('open_watermark', '1', 0, 'watermark');
INSERT INTO binz_system VALUES('water_type', 'image', 0, 'watermark');
INSERT INTO binz_system VALUES('water_image_upload', 'watermark.jpg', 0, 'watermark');
INSERT INTO binz_system VALUES('text_string', 'binzcms', 0, 'watermark');
INSERT INTO binz_system VALUES('text_size', '12', 0, 'watermark');
INSERT INTO binz_system VALUES('text_color', '#66CC33', 0, 'watermark');
INSERT INTO binz_system VALUES('position', '6', 0, 'watermark');
INSERT INTO binz_system VALUES('diaphaneity', '100', 0, 'watermark');
INSERT INTO binz_system VALUES('web_host', 'http://127.0.0.1/shiyan/binzcms', 0, 'system');
INSERT INTO binz_system VALUES('thump_image_width', '285', 0, 'file_upload');
INSERT INTO binz_system VALUES('thump_image_height', '285', 0, 'file_upload');
INSERT INTO binz_system VALUES('image_type', 'jpg|gif|png', 0, 'file_upload');
INSERT INTO binz_system VALUES('soft_type', 'zip|rar', 0, 'file_upload');
INSERT INTO binz_system VALUES('media_type', 'mp3|rm', 0, 'file_upload');
INSERT INTO binz_system VALUES('web_name', 'binzcms內容管理系統', 0, 'system');
INSERT INTO binz_system VALUES('web_time', '', 0, 'system');
INSERT INTO binz_system VALUES('web_ipc', '冀ICP備0000000號', 0, 'system');
INSERT INTO binz_system VALUES('web_keywords', 'binzcms,內容管理系統', 0, 'system');
INSERT INTO binz_system VALUES('web_description', '好用的內容管理系統', 0, 'system');
INSERT INTO binz_system VALUES('web_state', '1', 0, 'system');
INSERT INTO binz_system VALUES('web_close_info', '網站建設狀態中……', 0, 'system');
INSERT INTO binz_system VALUES('web_copyright', 'Power by <a href="http://www.binzcms.com/" target="_blank">binzcms v1.0 beta</a> © 2009-2010 binzcms.com All Rights Reserved.', 0, 'system');
INSERT INTO binz_system VALUES('web_stat_code', '', 0, 'system');
INSERT INTO binz_system VALUES('open_member', '1', 0, 'system');
INSERT INTO binz_system VALUES('reg_code', '0', 0, 'system');
INSERT INTO binz_system VALUES('login_code', '1', 0, 'system');
INSERT INTO binz_system VALUES('open_comment', '0', 0, 'system');
INSERT INTO binz_system VALUES('comment_code', '1', 0, 'system');
INSERT INTO binz_system VALUES('not_allow_word', '', 0, 'system');
INSERT INTO binz_system VALUES('admin_language', 'zh', 0, 'system');
INSERT INTO binz_system VALUES('front_language', 'zh', 0, 'system');
INSERT INTO binz_system VALUES('leave_login', '0', 0, 'system');
INSERT INTO binz_system VALUES('leave_code', '0', 0, 'system');
INSERT INTO binz_system VALUES ('rwrite', '0', 0, 'system');
INSERT INTO binz_system VALUES ('web_gzip', '0', '0', 'system');

INSERT INTO binz_class_type VALUES(1, '文章', 'article_add.html', 'article');
INSERT INTO binz_class_type VALUES(2, '圖片', 'image_add.html', 'image');

INSERT INTO binz_sys_article VALUES(3, 'Binzcms內容管理系統發布！', '', 0, 1, 1, 'admin', '<p><!--binzcms-->Binzcms內容管理髮布了，讓使用者簡單、方便、快捷的架設自己的網站。我們的進步離不開您的支持。</p>\r\n<p>我們的網站：<a href="http://www.binzcms.com /">http://www.binzcms.com/</a></p>\r\n<p>&nbsp;</p>', '1285153739');
INSERT INTO binz_sys_article VALUES(5, '網站首頁', 'index.php', 0, 1, 2, 'admin', '<!--binzcms--><!--binzcms-->', '1284821500' );
INSERT INTO binz_sys_article VALUES(6, '關於我們', '', 0, 1, 2, 'admin', '<!--binzcms-->', '1283958595');
INSERT INTO binz_sys_article VALUES(7, '服務條款', '', 0, 1, 2, 'admin', '<!--binzcms-->', '1283958604');
INSERT INTO binz_sys_article VALUES(8, '聯繫我們', '', 0, 1, 2, 'admin', '<!--binzcms-->', '1283958619');
INSERT INTO binz_sys_article VALUES(9, '免責聲明', '', 0, 1, 2, 'admin', '<!--binzcms-->', '1283958628');
INSERT INTO binz_sys_article VALUES(10, '網站地圖', '', 0, 1, 2, 'admin', '<!--binzcms-->', '1283958637');
INSERT INTO binz_sys_article VALUES(11, 'Binzcms論壇開放註冊', '', 0, 1, 1, 'admin', '<p><!--binzcms-->在Binzcms內容管理系統發布之際，Binzcms論壇也將對外開放註冊提供Binzcms系統的後續支持工作。歡迎大家多多提出寶貴意見。</p>\r\n<p>Binzcms論壇：<a href="http://www.binzcms.com/bbs /">http://www.binzcms.com/bbs/</a></p>\r\n<p>&nbsp;</p>', '1285154019');
INSERT INTO binz_sys_article VALUES(12, 'Binzcms功能介紹', '', 0, 1, 1, 'admin', '<!--binzcms-->\r\n<p>\r\n<table cellspacing= "0" cellpadding="0">\r\n <tbody>\r\n <tr>\r\n <td id="postmessage_2" class="t_msgfont">Binzcms V1.0 功能列表<br /> \r\n <br />\r\n 1、頻道管理<br />\r\n <br />\r\n 添加頻道<br />\r\n 頻道列表<br />\r \n 頻道類型<br />\r\n <br />\r\n 2、內容管理<br />\r\n <br />\r\n 添加內容<br />\r\n內容列表<br />\r\n 內容評論<br />\r\n <br />\r\n 3、會員管理<br />\r\n <br />\r\n 會員添加<br />\r\n 會員列表<br />\r\n <br />\r\n 4、系統管理<br />\r\n <br />\r\n 系統設置<br />\r\n 水印設置<br />\r\n 上傳設置<br />\r\n 系統日誌（臨時去掉）<br />\r\n 管理員設置<br />\ r\n <br />\r\n 5、輔助模塊<br />\r\n <br />\r\n 投票管理<br />\r\n 留言管理<br />\r\ n 廣告管理<br />\r\n 友情鏈接<br />\r\n <br />\r\n 6、數據庫管理<br />\r\n <br />\r\n 數據庫備份<br />\r\n 數據庫還原<br />\r\n 數據庫優化</td>\r\n </tr>\r\n </tbody>\r\n</table>\ r\n<table cellspacing="0" cellpadding="0">\r\n <tbody>\r\n <tr>\r\n <td id="postmessage_2" class="t_msgfont">Binzcms V1. 0 功能列表<br />\r\n <br />\r\n 1、頻道管理<br />\r\n <br />\r\n 添加頻道<br />\r\n 頻道列表<br />\r\n 頻道類型<br />\r\n <br />\r\n 2、內容管理<br />\r\n <br />\r\n 添加內容< br />\r\n 內容列表<br />\r\n 內容評論<br />\r\n <br />\r\n 3、會員管理<br />\r\n <br / >\r\n 會員添加<br />\r\n 會員列表<br />\r\n <br />\r\n 4、系統管理<br />\r\n <br />\ r\n 系統設置<br />\r\n 水印設置<br />\r\n 上傳設置<br />\r\n 系統日誌（臨時去掉）<br />\r\n 管理員設置<br />\r\n <br />\r\n 5、輔助模塊<br />\r\n <br />\r\n 投票管理<br />\r\n 留言管理<br />\r\n 廣告管理<br />\r\n 友情鏈接<br />\r\n <br />\r\n 6、數據庫管理<br />\r\n <br />\r\n 數據庫備份<br />\r\n 數據庫還原<br />\r\n 數據庫優化</td>\r\n </tr>\r\n </tbody>\r \n</table>\r\nBinzcms V1.0 功能列表</p>\r\n<p>1、頻道管理</p>\r\n<p>添加頻道<br />\r\ n頻道列表<br />\r\n頻道類型</p>\r\n<p>2、內容管理</p>\r\n<p>添加文章<br />\r\n文章列表<br />\r\n添加圖片<br />\r\n圖片類別<br />\r\n內容評論</p>\r\n<p>3、會員管理</p> \r\n<p>會員添加<br />\r\n會員列表</p>\r\n<p>4、系統管理</p>\r\n<p>系統設置<br / >\r\n水印設置<br />\r\n上傳設置<br />\r\n管理員設置<br />\r\n系統文章</p>\r\n<p> 5、輔助模塊</p>\r\n<p>投票管理<br />\r\n留言管理<br />\r\n廣告管理<br />\r\n友情鏈接</p >\r\n<p>6、數據庫管理</p>\r\n<p>數據庫備份<br />\r\n數據庫還原<br />\r\n數據庫優化</p>' , '1285158135');
INSERT INTO binz_flink VALUES(1, 'Binzcms', 'http://www.binzcms.com', 0, '');