<?php
/***
*
*@package binzcms
*@version $id:ImageClass.php, v 1.0
*@author 斌子
*@Tue Jan 06 22:03:02 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ImageClass
 * 图片处理类
 * 
 */
class ImageClass {

	public $upload_dir			= 'upload/uppic';		//图片上传路径

	public $watermark_type		= WATER_TYPE;
	public $watermark_file		= '';					//水印图片
	public $watermark_trans		= DIAPHANEITY;			//水印透明度

	public $watermark_font		= TEXT_STRING;			//水印文字
	public $watermark_fontsize	= TEXT_SIZE;			//文字大小
	public $watermark_fontcolor	= TEXT_COLOR;			//文字颜色

	public $watermark_pos		= POSITION;  			//水印位置

	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct() {
		$this->watermark_file	= ROOT_PATH.'/data/'.WATER_IMAGE_UPLOAD;
	}
	/**
	 * upload_image
	 *
	 * 上传图片
	 * @access  public（权限）
	 * @param   string	$files			上传图片的数组信息，$_FILES
	 * @param   string	$dir_type		上传目录命名类型，Y（年），m（年月），d（年月日），其他为自定义名称
	 * @param   string	$image_name		新图片名称，如果为空，在程序中自动生成
	 * @param   string	$wartermark		是否添加水印
	 * @return  string	上传图片路径
	 */
	public function upload_image($files,$dir_type='m',$image_name='',$create_thumb=false,$wartermark='0') {

		/*上传目录*/
		$true_path	= $this->dir_name_type($dir_type);
		if(!is_dir($true_path)) {
			if(!@mkdir($true_path,0777)) {
				die("create dir ".$dir_name[$dir_type]." error!");
				exit();
			}
		}
		/*文件命名*/
		$image_array	= explode('.',$files['name']);
		if($image_name == '') {
			$image_name		= $true_path."/".time().mt_rand().".".$image_array[count($image_array)-1];
		} else {
			$image_name		= $true_path."/".$image_name.".".$image_array[count($image_array)-1];
		}
		/*判断类型*/
		//if(!in_array($files['type'],array('image/pjpeg','image/x-png','image/png','image/gif','image/jpeg'))) {
		if(!$this->check_image_type($files['type'])){
			die('image type error!');
			exit();
		}
		/*文件上传*/
		if(!move_uploaded_file($files['tmp_name'],$image_name)) {
			die('upload error!');
			exit();
		}
		/*是否添加水印*/
		if($wartermark == '1') {
			$this->create_watermark($image_name);
		}
		/*是否生成缩微图*/
		if($create_thumb) {
			$this->create_thump($image_name,$true_path,'',THUMP_IMAGE_WIDTH,THUMP_IMAGE_HEIGHT);
		}
		return str_replace(ROOT_PATH,'',$image_name);
	}
	/**
     * create_thump
     *
     * 创建缩微图
     * @access  public （权限）
     * @param   string      $img    		原始图片的路径
     * @param   string      $path         	指定生成图片的目录名
     * @param   int         $thumb_width  	缩略图宽度
     * @param   int         $thumb_height 	缩略图高度
     * @return  mix         如果成功返回缩略图的路径，失败则返回false
     */
	public function create_thump($img, $path = '',$thumb_name='', $thumb_width = 100, $thumb_height = 100, $bgcolor='#FFFFFF') {
		$gd = $this->gd_version(); //获取 GD 版本。0 表示没有 GD 库，1 表示 GD 1.x，2 表示 GD 2.x
		if ($gd == 0) {
			die('no gd!');
			return false;
		}

		/* 检查缩略图宽度和高度是否合法 */
		if ($thumb_width == 0 && $thumb_height == 0) {
			return str_replace(ROOT_PATH, '', str_replace('\\', '/', realpath($img)));
		}

		/* 检查原始文件是否存在及获得原始文件的信息 */
		$org_info = @getimagesize($img);
		if (!$org_info) {
			return false;
		}
		$img_org = $this->img_resource($img, $org_info[2]);

		/* 原始图片以及缩略图的尺寸比例 */
		$scale_org      = $org_info[0] / $org_info[1];

		/* 处理只有缩略图宽和高有一个为0的情况，这时背景和缩略图一样大 */
		if ($thumb_width == 0) {
			$thumb_width = $thumb_height * $scale_org;
		}
		if ($thumb_height == 0) {
			$thumb_height = $thumb_width / $scale_org;
		}

		/* 创建缩略图的标志符 */
		if ($gd == 2) {
			$img_thumb  = imagecreatetruecolor($thumb_width, $thumb_height);
		} else {
			$img_thumb  = imagecreate($thumb_width, $thumb_height);
		}

		/* 背景颜色 */
		$bgcolor = trim($bgcolor,"#");
		sscanf($bgcolor, "%2x%2x%2x", $red, $green, $blue);
		$clr = imagecolorallocate($img_thumb, $red, $green, $blue);
		imagefilledrectangle($img_thumb, 0, 0, $thumb_width, $thumb_height, $clr);

		if ($org_info[0] / $thumb_width > $org_info[1] / $thumb_height) {
			$lessen_width  = $thumb_width;
			$lessen_height  = $thumb_width / $scale_org;
		} else {
			/* 原始图片比较高，则以高度为准 */
			$lessen_width  = $thumb_height * $scale_org;
			$lessen_height = $thumb_height;
		}

		$dst_x = ($thumb_width  - $lessen_width)  / 2;
		$dst_y = ($thumb_height - $lessen_height) / 2;

		/* 将原始图片进行缩放处理 */
		if ($gd == 2) {
			imagecopyresampled($img_thumb, $img_org, $dst_x, $dst_y, 0, 0, $lessen_width, $lessen_height, $org_info[0], $org_info[1]);
		}
		else {
			imagecopyresized($img_thumb, $img_org, $dst_x, $dst_y, 0, 0, $lessen_width, $lessen_height, $org_info[0], $org_info[1]);
		}

		/* 缩微图目录 */
		$dir = $path.'/';

		/* 如果目标目录不存在，则创建它 */
		if (!is_dir($dir)) {
			if (!mkdir($dir)) {
				/* 创建目录失败 */
				die('create dir error!');
				return false;
			}
		}

		if($thumb_name == '') {
			$img_array	= explode('/',$img);
			$filename	= $img_array[count($img_array)-1];
		} else {
			$filename	= $thumb_name;
		}

		/* 生成文件 */
		if (function_exists('imagejpeg')) {
			imagejpeg($img_thumb, $dir . $filename);
		} elseif (function_exists('imagegif')) {
			imagegif($img_thumb, $dir . $filename);
		} elseif (function_exists('imagepng')) {
			imagepng($img_thumb, $dir . $filename);
		} else {
			die('create thumb false!');

			return false;
		}

		imagedestroy($img_thumb);
		imagedestroy($img_org);

		/*确认文件是否生成*/
		if (is_file($dir . $filename)) {
			return str_replace(ROOT_PATH, '', $dir) . $filename;
		} else {
			die('no thumb!');

			return false;
		}
	}
	/**
 	 * create_watermark
 	 *
 	 * 添加水印图片
 	 * @access  public（权限）
 	 * @param   string	$file		图片地址
 	 */
	public function create_watermark ($file) {
		/*文件不存在则返回*/
		if (!file_exists($this->watermark_file) || !file_exists($file)) return;
		if (!function_exists('getImageSize')) return;

		/*检查GD支持的文件类型*/
		$gd_allow_types = array();
		if (function_exists('ImageCreateFromGIF')) $gd_allow_types['image/gif'] = 'ImageCreateFromGIF';
		if (function_exists('ImageCreateFromPNG')) $gd_allow_types['image/png'] = 'ImageCreateFromPNG';
		if (function_exists('ImageCreateFromJPEG')) $gd_allow_types['image/jpeg'] = 'ImageCreateFromJPEG';

		/*获取文件信息*/
		$fileinfo = getImageSize($file);

		if($this->watermark_type == 'image') {
			$wminfo   = getImageSize($this->watermark_file);

			if ($fileinfo[0] < $wminfo[0] || $fileinfo[1] < $wminfo[1]) return;

			if (array_key_exists($fileinfo['mime'],$gd_allow_types)) {
				if (array_key_exists($wminfo['mime'],$gd_allow_types)) {

					/*从文件创建图像*/
					$temp = $gd_allow_types[$fileinfo['mime']]($file);
					$temp_wm = $gd_allow_types[$wminfo['mime']]($this->watermark_file);
				}
			}
		} else {
			$temp			= $gd_allow_types[$fileinfo['mime']]($file);
			$temp_wm		= $gd_allow_types[$fileinfo['mime']]($file);
			@$image_temp 	= imagettfbbox($this->watermark_fontsize,0,ROOT_PATH.'/data/verdana.ttf',$this->watermark_font);
			$wminfo[0] 		= $image_temp[2] - $image_temp[6];
			$wminfo[1] 		= $image_temp[3] - $image_temp[7];
			unset($image_temp);
			if(empty($wminfo[0]) and empty($wminfo[1])){
				$wminfo[0] = strlen($this->watermark_font) * 10;
				$wminfo[1] = 20;
			}
		}
		/*水印位置*/
		switch ($this->watermark_pos) {
			case 1 :  //顶部居左
			$dst_x = 0; $dst_y = 0; break;
			case 2 :  //顶部居中
			$dst_x = ($fileinfo[0] - $wminfo[0]) / 2; $dst_y = 0; break;
			case 3 :  //顶部居右
			$dst_x = $fileinfo[0] - $wminfo[0]; $dst_y = 0; break;
			case 4 :  //底部居左
			$dst_x = 0; $dst_y = $fileinfo[1]-$wminfo[1]; break;
			case 5 :  //底部居中
			$dst_x = ($fileinfo[0] - $wminfo[0]) / 2; $dst_y = $fileinfo[1]-$wminfo[1]; break;
			case 6 :  //底部居右
			$dst_x = $fileinfo[0]-$wminfo[0]; $dst_y = $fileinfo[1]-$wminfo[1]; break;
			default : //随机
			$dst_x = mt_rand(0,$fileinfo[0]-$wminfo[0]); $dst_y = mt_rand(0,$fileinfo[1]-$wminfo[1]);
		}

		if (function_exists('ImageAlphaBlending')) ImageAlphaBlending($temp_wm,True);	//设定图像的混色模式
		if (function_exists('ImageSaveAlpha')) ImageSaveAlpha($temp_wm,True); 			//保存完整的 alpha 通道信息

		/*为图像添加水印*/
		if($this->watermark_type == 'image') {
			if (function_exists('imageCopyMerge')) {
				ImageCopyMerge($temp,$temp_wm,$dst_x,$dst_y,0,0,$wminfo[0],$wminfo[1],$this->watermark_trans);
			} else {
				ImageCopyMerge($temp,$temp_wm,$dst_x,$dst_y,0,0,$wminfo[0],$wminfo[1]);
			}
		} else {
			if(!empty($this->watermark_fontcolor) && (strlen($this->watermark_fontcolor)==7)){
				$R = hexdec(substr($this->watermark_fontcolor,1,2));
				$G = hexdec(substr($this->watermark_fontcolor,3,2));
				$B = hexdec(substr($this->watermark_fontcolor,5));
			}else{
				return;
			}
			if(empty($wminfo[0]) and empty($wminfo[1])) {
				imagettftext($temp, $this->watermark_fontsize, 0, $dst_x, $dst_y, imagecolorallocate($temp,$R,$G,$B), ROOT_PATH.'/data/verdana.ttf', $this->watermark_font);
			} else {
				imagestring($temp,$this->watermark_fontsize,$dst_x,$dst_y,$this->watermark_font,imagecolorallocate($temp,$R,$G,$B));
			}
		}
		/*保存图片*/
		switch ($fileinfo['mime']) {
			case 'image/jpeg' :
				@imagejpeg($temp,$file);
				break;
			case 'image/png' :
				@imagePNG($temp,$file);
				break;
			case 'image/gif' :
				@imageGIF($temp,$file);
				break;
		}
		/*销毁零时图像*/
		@imageDestroy($temp);
		@imageDestroy($temp_wm);
	}
	/**
 	 * gd_version
 	 *
	 * 获得gd库版本
 	 * @access  public（权限）
 	 * @return  int
 	 */
	public function gd_version() {
		static $version = -1;

		if ($version >= 0) {
			return $version;
		}

		if (!extension_loaded('gd')) {
			$version = 0;
		} else {
			/*尝试使用gd_info函数*/
			if (PHP_VERSION >= '4.3') {
				if (function_exists('gd_info')) {
					$ver_info = gd_info();
					preg_match('/\d/', $ver_info['GD Version'], $match);
					$version = $match[0];
				} else {
					if (function_exists('imagecreatetruecolor')) {
						$version = 2;
					} elseif (function_exists('imagecreate')) {
						$version = 1;
					}
				}
			} else {
				if (preg_match('/phpinfo/', ini_get('disable_functions'))) {
					/* 如果phpinfo被禁用，无法确定gd版本 */
					$version = 1;
				} else {
					/*使用phpinfo函数*/
					ob_start();
					phpinfo(8);
					$info = ob_get_contents();
					ob_end_clean();
					$info = stristr($info, 'gd version');
					preg_match('/\d/', $info, $match);
					$version = $match[0];
				}
			}
		}

		return $version;
	}
	/**
     * img_resource
     *
     * 根据来源文件的文件类型创建一个图像操作的标识符
     * @access  public (权限)
     * @param   string      $img_file   图片文件的路径
     * @param   string      $mime_type  图片文件的文件类型
     * @return  resource    如果成功则返回图像操作标志符，反之则返回错误代码
     */
	function img_resource($img_file, $mime_type)
	{
		switch ($mime_type) {
			case 1:
			case 'image/gif':
				$res = imagecreatefromgif($img_file);
				break;

			case 2:
			case 'image/pjpeg':
			case 'image/jpeg':
				$res = imagecreatefromjpeg($img_file);
				break;

			case 3:
			case 'image/x-png':
			case 'image/png':
				$res = imagecreatefrompng($img_file);
				break;

			default:
				return false;
		}

		return $res;
	}
	/**
	 * dir_name_type
	 *
	 * 目录命名类型
	 * @access  public（权限）
	 * @param   string	$type	目录类型
	 * @return  string	类型名称
	 */
	public function dir_name_type($type) {
		$dir_name	= array();
		if($type != '' and in_array($type,array('y','m','d'))) {
			$dir_name	= array('y'=>date("Y"),'m'=>date("Ym"),'d'=>date("Ymd"),'n'=>'');
		}
		$true_path	= ROOT_PATH."/".$this->upload_dir.($dir_name[$type] != '' ? "/".$dir_name[$type] : '');
		return $true_path;
	}
	/**
	 * check_image_type
	 *
	 * 检查图片类型
	 * @access  public（权限）
	 * @param   string	$image_type	图片类型
	 * @return  bool
	 */
	public function check_image_type($image_type) {
		$image_type_array	= explode('|',IMAGE_TYPE);
		include(ROOT_PATH.'/data/filetype.php');
		if($image_type_array == '') {
			if(in_array($image_type,array('image/pjpeg','image/x-png','image/png','image/gif','image/jpeg'))) {
				return true;
			} else {
				return false;
			}
		} else {
			foreach ($image_type_array as $val) {
				if(is_array($filetype[$val])) {
					if(in_array($image_type,$filetype[$val])) {
						return true;
					}
				} else {
					if($image_type == $filetype[$val]) {
						return true;
					}
				}
			}
			return false;
		}
	}
}
?>
