<?php
/***
*
*@package binzcms
*@version $id:BaseClass.php, v 1.0
*@author 斌子
*@Mon Jan 05 01:39:34 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * BaseClass
 * 框架基类
 * 
 */

class BaseClass {

	public $binz_db;			//数据库
	public $binz_editor;		//编辑器
	public $binz_tpl;			//模板引擎
	public $binz_common;		//公用函数
	public $binz_front_common;	//前台公用显示
	public $binz_admin_common;	//后台公用方法

	public $allow_action 	= array();
	public $action			= '';
	public $action_state	= true;
	public $refer_url		= '';
	
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		$this->action	= $act;
		$this->base_set();
	}
	/**
	 * base_set
	 *
	 * 初始化
	 * @access  private（权限）
	 * 
	 */
	private function base_set() {

		include_once(ROOT_PATH."/include/CommonClass.php");			//公用函数类文件
		include_once(ROOT_PATH."/include/SqlExtClass.php");			//数据库操作类
		include_once(ROOT_PATH."/include/TplClass.php");			//模板引擎类
		include_once(ROOT_PATH."/include/EditorClass.php");			//在线编辑器类
		include_once(ROOT_PATH."/include/common/F_CommonClass.php");//前台公用显示类
		include_once(ROOT_PATH."/include/common/A_CommonClass.php");//后台公用类
		/*设置数据库*/
		$this->binz_db					= new SqlExtClass($GLOBALS['db_name'],$GLOBALS['db_user'],$GLOBALS['db_passwd'],$GLOBALS['db_prefix'],$GLOBALS['db_host']);
		/*设置在线编辑器*/
		$this->binz_editor				= new EditorClass();
		/*设置公用类*/
		$this->binz_common				= new CommonClass();

		/*设置模板引擎*/
		$this->binz_tpl					= new TplClass();
		$this->binz_tpl->temp_dir		= TPL_PATH;							//模板文件目录
		$this->binz_tpl->temp_cache		= ROOT_PATH."/cache/";				//缓存文件目录
		$this->binz_tpl->cache_state	= false;							//是否开启缓存
		$this->binz_tpl->cache_time		= 3600;								//只有在开启缓存的情况下，这里才有效
		$this->binz_tpl->left_tag		= "<tpl>";							//模板标签开始标记
		$this->binz_tpl->right_tag		= "</tpl>";							//模板标签结束标记

		/*对变量进行过滤*/
		if(!empty($_POST) or !empty($_GET) or !empty($_COOKIE)) {
			$this->filtrate_variable();
		}

		/*公用变量抛出模板*/
		$this->base_tpl_val();

		/*过滤非法action*/
		$this->base_check_action($this->action);

		/*设置前台公用显示类*/
		$this->binz_front_common	= new F_CommonClass($this->binz_db,$this->binz_tpl,$this->binz_common);

		/*设置后台公用类*/
		$this->binz_admin_common	= new A_CommonClass($this->binz_db,$this->binz_tpl,$this->binz_common);

		/*获得上一页网址*/
		if (array_key_exists('HTTP_REFERER',$_SERVER)){
			$this->refer_url = strrpos($_SERVER['HTTP_REFERER'],WEB_HOST)===false ? '' :$_SERVER['HTTP_REFERER'];
		}else{
			$this->refer_url = "";
		}
	}
	/**
	 * import_class
	 *
	 * 引入类文件并声明
	 * @access  protected（权限）
	 * @param   string	$name		类文件名称，省略掉Class.php
	 * @param   string	$dir		所在目录
	 * @return  object
	 */
	protected function import_class($class_file,$dir='',$type='')	{
		$binz_class_name	= $class_file."Class";
		@include($dir."/".$binz_class_name.".php");
		if($type == '') {
			return new $binz_class_name();
		} elseif($type == 'mod') {
			return new $binz_class_name('');
		}
	}
	/**
	 * import_language
	 *
	 * 引入语言包文件
	 * @access  protected（权限）
	 * @param   string	$language_file 语言包文件名，省略掉Language.php
	 * @param   string	$dir		语言包目录
	 * 
	 */
	protected function import_language($language_file,$dir='languages') {
		$file_array	= @explode(',',$language_file);
		$dir		= (ADMIN_LG == true ? $dir.'/'.ADMIN_LANGUAGE : $dir.'/'.FRONT_LANGUAGE);

		foreach ($file_array as $v) {
			$binz_language_name	= $v."Language";
			@include(ROOT_PATH."/".$dir."/".$binz_language_name.".php");
			unset($binz_language_name);
		}
		$this->binz_tpl->set_var($language);
	}
	/**
	 * filtrate_variable
	 *
	 * 过滤变量
	 * @access  private（权限）
	 */
	private function filtrate_variable() {
		/*对传入变量转义*/
		if(!get_magic_quotes_gpc()) {
			$_POST		= (isset($_POST) 	and !empty($_POST)) 	? $this->binz_common->addslashes_value($_POST) : array();
			$_GET		= (isset($_GET) 	and !empty($_GET)) 		? $this->binz_common->addslashes_value($_GET) : array();
			$_COOKIE	= (isset($_COOKIE) 	and !empty($_COOKIE)) 	? $this->binz_common->addslashes_value($_COOKIE) : array();
		}
	}
	/**
	 * base_tpl_val
	 *
	 * 公用信息抛出模板
	 * @access  public（权限）
	 * 
	 */
	private function base_tpl_val() {

		$this->binz_tpl->set_var('web_host',$GLOBALS['web_host']);			//网站地址
	}
	/**
	 * base_check_action
	 *
	 * 过滤action值
	 * @access  protected（权限）
	 * @param   string	$action		变量值
	 * 
	 */
	protected function base_check_action($action) {
		if(!empty($action) and !in_array($action,$this->allow_action)) {
			return $this->action_state = false;
		}
	}
	/**
	 * base_back_index
	 *
	 * 返回前台首页
	 * @access  protected（权限）
	 * 
	 */
	protected function base_back_index() {
		header("Location: ".WEB_HOST);
		exit();
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>