<?php
/***
*
*@package binzcms
*@version $id:FrontPicClass.php, v 1.0
*@author 斌子
*@Tue Aug 31 04:48:15 GMT 2010
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * FrontOtherClass
 * 前台其他非重要显示控制类
 * 
 */
include(MOD_PATH."/ModFrontPicClass.php");
class FrontPicClass extends ModFrontPicClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "base_back_index";
		}
		/*合法action*/
		$this->allow_action	= array(
		'base_back_index',			//返回首页
		'front_pic_content',		//图片内容
		'front_image_comment'		//评论保存
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "base_back_index";
		}
		/*载入语言包*/
		$this->import_language('FrontImage,FrontCommon');

		$this->$act();
	}
	/**
	 * front_pic_view
	 *
	 * 图片显示页面
	 * @access  private（权限）
	 * 
	 * @return  array
	 */
	private function front_pic_content() {
		$image_array = array();
		$image_array = $this->mod_front_img_content();
		/*如果返回空值则，返回首页*/
		if($image_array == false) {
			$this->base_back_index();
		}
		/*跳转链接*/
		if($image_array['article_url_jump'] != '') {
			@header("Location: ".$image_array['article_url_jump']);
			exit();
		}
		/*图片总数*/
		$image_count	= count($image_array);
		/*当前是第一张图片*/
		$image_num		= intval($_GET['image_num']);
		/*上一页下一页初始值*/
		$image_next		= 0;
		$image_pre		= 0;
		/*当前图片内容*/
		if($image_num ==0 or $image_num == 1) {
			$image_num =1;
			if($image_count>1) {
				$image_next = 2;
			}
			$image_one_array = $image_array[0];
		} elseif ($image_count >= $image_num) {
			if($image_num<$image_count) {
				$image_next = $image_num+1;
			}
			$image_pre	= $image_num-1;

			$image_one_array = $image_array[$image_num-1];
		}
		$this->binz_tpl->set_var('image_count',$image_count);
		$this->binz_tpl->set_var('image_num',$image_num);
		$this->binz_tpl->set_var('image_pre',$image_pre);
		$this->binz_tpl->set_var('image_next',$image_next);
		$this->binz_tpl->set_var('image_one_array',$image_one_array);

		/*更新浏览次数*/
		if($image_num == 1) {
			$click_num	= intval($image_one_array['article_click']) + 1;
			$this->mod_update_front_image_content(array('article_click'=>$click_num));
		}

		/*内容评论*/
		$comment_list_array		= array();
		$perpage				= 10;			//每页记录数
		$comment_list_array		= $this->mod_front_image_comment_list($_GET['binz_page'],$perpage);
		$this->binz_tpl->set_var('comment_array',$comment_list_array['list']);
		$this->binz_tpl->set_var('comment_num',$comment_list_array['count']['comment_num']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->front_rwrite_type = 'pic_comment';
		$page_class->set_page(array('total'=>$comment_list_array['count']['comment_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		$front_class		= $this->import_class("ModFrontClass",MOD_PATH,'mod');
		$article_class		= $this->import_class("ModAdminClass",ADMIN_MOD_PATH,'mod');
		$_GET['class_id']	= $image_array[0]['class_id'];
		/*最新图片列表（本分类及分类子集）*/
		$image_new_list	= $front_class->mod_front_article_type('article_id',6,$article_class);
		$this->binz_tpl->set_var('image_new_list',$image_new_list);
		/*最热图片列表（本分类及分子子集）*/
		$image_hot_list	= $front_class->mod_front_article_type('article_click',6,$article_class);
		$this->binz_tpl->set_var('image_hot_list',$image_hot_list);

		$this->binz_front_common->f_menu_url('class');

		$this->binz_tpl->set_tag('pic_view');
	}
	/**
	 * front_image_comment
	 *
	 * 评论提交操作
	 * @access  private（权限）
	 * 
	 */
	private function front_image_comment() {
		$save_state		= false;
		$save_state		= $this->mod_front_image_comment_save();
		/*验证码和登录状态的判断*/
		if(intval($save_state) == 2) {
			/*跳转页面，未登录状态，只有在后台设置登录可发布评论的时候才可用*/

			$this->binz_common->front_msg($this->binz_tpl->var_all['cont_comment_login'],0,$link,$this->binz_tpl,true,2);
		} elseif (intval($save_state) == 4) {
			/*跳转页面，验证码错误，开启评论验证码功能才可用*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['cont_comment_code'],0,$link,$this->binz_tpl,true,2);
		}
		/*评论插入状态判断*/
		if($save_state) {
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['cont_comment_ok'],0,$link,$this->binz_tpl,true,2);
		} else {
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['cont_comment_no'],0,$link,$this->binz_tpl,true,2);
		}
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>