<?php
/***
*
*@package binzcms
*@version $id:FrontMemberClass.php, v 1.0
*@author 斌子
*@Tue Mar 03 20:41:10 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModFrontMemberClass
 * 会员控制类
 * 
 */
include(MOD_PATH."/ModFrontMemberClass.php");
class FrontMemberClass extends ModFrontMemberClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "base_back_index";
		}
		/*合法action*/
		$this->allow_action	= array(
		'base_back_index',			//返回首页
		'front_member_register',	//会员注册
		'front_member_save',		//会员保存
		'front_member_login',		//会员登录
		'front_member_out'			//会员退出
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "base_back_index";
		}

		/*载入语言包*/
		$this->import_language('FrontMember,FrontCommon');

		$this->$act();
	}
	/**
	 * font_member_register
	 *
	 * 前台会员注册页面
	 * @access  private（权限）
	 * 
	 */
	private function front_member_register() {
		/*会员登录的校验*/
		if($_SESSION['member_id'] != '') {
			header("Location: ./index.php");
			exit();
		}
		/*判读是否关闭会员功能，禁止注册*/
		if(OPEN_MEMBER != '1') {
			$this->binz_common->front_msg($this->binz_tpl->var_all['register_close'],0,$link,$this->binz_tpl,true,2);
		}
		if(REG_CODE == '1') {
			$this->binz_tpl->set_var('reg_code',$this->binz_common->create_binz_code($this->binz_tpl->var_all['register_code_text']));
		}
		$this->binz_tpl->set_var('refer_url',$this->refer_url);
		/*载入模板*/
		$this->binz_tpl->set_tag('member_register');
	}
	/**
	 * front_member_save
	 *
	 * 会员保存
	 * @access  private（权限）
	 * 
	 */
	private function front_member_save() {
		/*判读是否关闭会员功能，禁止注册*/
		if(OPEN_MEMBER != '1') {
			$this->binz_common->front_msg($this->binz_tpl->var_all['register_close'],0,$link,$this->binz_tpl,true,2);
		}

		$save_state		= false;
		$save_state		= $this->mod_front_member_save();

		if(intval($save_state) == 4) {//用户名不能为空
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['register_name_false'],0,$link,$this->binz_tpl,true,2);
		}
		if(intval($save_state) == 5) {//电子邮件不能为空
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['register_email_empty'],0,$link,$this->binz_tpl,true,2);
		}
		if(intval($save_state) == 6) {//电子邮件重复
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['register_email_repeat'],0,$link,$this->binz_tpl,true,2);
		}
		if(intval($save_state) == 2) {//密码为空，或是两次输入的密码不同
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['register_passwd_false'],0,$link,$this->binz_tpl,true,2);
		}
		if(intval($save_state) == 3) {//验证码输入错误
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['register_code_false'],0,$link,$this->binz_tpl,true,2);
		}

		if($save_state) {
			$message			= $this->binz_tpl->var_all['register_ok'];			//'会员注册成功';
			$link[0]['text']	= $this->binz_tpl->var_all['register_click_url'];	//'点击此链接进入会员中心页面';
			$link[0]['href']	= trim($_POST['refer_url'])!= '' ? trim($_POST['refer_url']) : 'index.php?ctl=home&act=front_home';
		} else {
			$message			= $this->binz_tpl->var_all['register_false'];		//'会员注册失败';
		}

		/*跳转页面*/
		$this->binz_common->front_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * front_member_login
	 *
	 * 会员登录
	 * @access  private（权限）
	 * 
	 */
	private function front_member_login() {
		/*判断登录信息是否存在*/
		if(!empty($_POST['username']) and !empty($_POST['password'])) {
			$login_state	= $this->mod_front_member_login();

			if($login_state	== 1) {			//登录成功
				header("Location: ".$this->refer_url);
				exit();
			} elseif ($login_state == 2) {	//用户名错误
				$message			= $this->binz_tpl->var_all['login_name_false'];		//'您输入的用户名错误，请从新输入';
			} elseif ($login_state == 3) {	//密码错误
				$message			= $this->binz_tpl->var_all['login_passwd_false'];		//'您输入的密码错误，请从新输入';
			} elseif ($login_state == 4) {	//验证码错误
				$message			= $this->binz_tpl->var_all['login_code_false'];		//'您输入的验证码错误，请从新输入';
			}
			/*上一页面*/
			$link[0]['text']		= $this->binz_tpl->var_all['register_click_url'];
			$link[0]['url']			= $this->refer_url;
			/*跳转页面*/
			$this->binz_common->front_msg($message,0,$link,$this->binz_tpl,true,2);

		} else {
			header("Location: ./index.php");
		}
	}
	/**
	 * front_member_out
	 *
	 * 会员退出
	 * @access  private（权限）
	 * 
	 */
	private function front_member_out() {
		$this->mod_front_member_out();

		$message			= $this->binz_tpl->var_all['member_out_ok'];		//'退出成功';
		$link[0]['text']	= $this->binz_tpl->var_all['member_out_click'];		//'点此返回登录页面';
		$link[0]['href']	= 'index.php';
		/*跳转页面*/
		$this->binz_common->front_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>