<?php
/***
*
*@package binzcms
*@version $id:FrontGuestbookClass.php, v 1.0
*@author 斌子
*@Tue Sep 07 16:13:43 GMT 2010
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * FrontGuestbookClass
 * 留言板
 * 
 */
include(MOD_PATH."/ModFrontGuestbookClass.php");
class FrontGuestbookClass extends ModFrontGuestbookClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "front_guestbook";
		}
		/*合法action*/
		$this->allow_action	= array(
		'base_back_index',			//返回首页
		'front_guestbook_save',		//留言保存
		'front_guestbook'			//留言板页面
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "base_back_index";
		}
		/*载入语言包*/
		$this->import_language('FrontGuestbook,FrontCommon');
		
		$this->$act();
	}
	/**
	 * front_guestbook
	 *
	 * 留言板页面
	 * @access  private（权限）
	 * 
	 */
	private function front_guestbook() {
		$leave_array	= array();
		$perpage		= 10;			//每页记录数

		/*留言列表*/
		$leave_array	= $this->mod_front_leave_list($_GET['binz_page'],$perpage);
		$this->binz_tpl->set_var('leave_array',$leave_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->front_rwrite_type = 'guestbook';
		$page_class->set_page(array('total'=>$leave_array['count']['leave_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		$this->binz_tpl->set_var('show_menu','guestbook');
		$this->binz_tpl->set_tag('guestbook');
	}
	/**
	 * front_guestbook_save
	 *
	 * 留言操作
	 * @access  private（权限）
	 * 
	 */
	private function front_guestbook_save() {
		$save_state		= false;
		$save_state		= $this->mod_front_gusetbook_save();
		/*验证码和登录状态的判断*/
		if(intval($save_state) == 2) {
			/*跳转页面，未登录状态，只有在后台设置登录可发布留言的时候才可用*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['guestbook_comment_login'],0,$link,$this->binz_tpl,true,2);
		} elseif (intval($save_state) == 4) {
			/*跳转页面，验证码错误，开启留言验证码功能才可用*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['guestbook_comment_code'],0,$link,$this->binz_tpl,true,2);
		}
		
		if($save_state) {
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['guestbook_add_ok'],0,$link,$this->binz_tpl,true,2);
		} else {
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['guestbook_add_no'],0,$link,$this->binz_tpl,true,2);
		}
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>