<?php
/***
*
*@package binzcms
*@version $id:FrontArticleClass.php, v 1.0
*@author 斌子
*@Mon Apr 13 00:58:19 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * FrontArticleClass
 * 文章控制类
 * 
 */
include(MOD_PATH."/ModFrontArticleClass.php");
class FrontArticleClass extends ModFrontArticleClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "base_back_index";
		}
		/*合法action*/
		$this->allow_action	= array(
		'base_back_index',			//返回首页
		'front_article_content',	//文章内容
		'front_article_comment'		//评论处理
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "base_back_index";
		}
		/*载入语言包*/
		$this->import_language('FrontArticle,FrontCommon');

		$this->$act();
	}
	/**
	 * front_article_content
	 *
	 * 文章内容页面
	 * @access  private（权限）
	 * 
	 */
	private function front_article_content() {
		$article_array		= array();

		/*文章内容*/
		$article_array		= $this->mod_front_article_content();
		/*如果返回空值则，返回首页*/
		if($article_array == false) {
			$this->base_back_index();
		}
		/*跳转链接*/
		if($article_array['article_url_jump'] != '') {
			@header("Location: ".$article_array['article_url_jump']);
			exit();
		}
		/*如果是图片类型则跳转*/
		if($article_array['class_type_tag'] == 'image') {
			if(RWRITE == '1') {
				@header("Location: pic-".$article_array['article_id'].".html");
			} else {
				@header("Location: index.php?ctl=pic&act=front_pic_content&article_id=".$article_array['article_id']);
			}
			exit();
		}

		$this->binz_tpl->set_var('article_array',$article_array);
		
		/*更新浏览次数*/
		$click_num	= intval($article_array['article_click']) + 1;
		$this->mod_update_front_article_content(array('article_click'=>$click_num));
		
		/*内容评论*/
		$comment_list_array		= array();
		$perpage				= 10;			//每页记录数
		$comment_list_array		= $this->mod_front_article_comment_list($_GET['binz_page'],$perpage);
		$this->binz_tpl->set_var('comment_array',$comment_list_array['list']);
		$this->binz_tpl->set_var('comment_num',$comment_list_array['count']['comment_num']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->front_rwrite_type = 'article_comment';
		$page_class->set_page(array('total'=>$comment_list_array['count']['comment_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));
		
		$front_class		= $this->import_class("ModFrontClass",MOD_PATH,'mod');
		$article_class		= $this->import_class("ModAdminClass",ADMIN_MOD_PATH,'mod');
		$_GET['class_id']	= $article_array['class_id'];
		/*最新文章列表（本分类及分类子集）*/
		$article_new_list	= $front_class->mod_front_article_type('article_id',6,$article_class);
		$this->binz_tpl->set_var('article_new_list',$article_new_list);
		/*最热文章列表（本分类及分子子集）*/
		$article_hot_list	= $front_class->mod_front_article_type('article_click',6,$article_class);
		$this->binz_tpl->set_var('article_hot_list',$article_hot_list);
		
		$this->binz_front_common->f_menu_url('class');

		$this->binz_tpl->set_tag('article');
	}
	/**
	 * front_article_comment
	 *
	 * 评论提交操作
	 * @access  private（权限）
	 * 
	 */
	private function front_article_comment() {
		$save_state		= false;

		$save_state		= $this->mod_front_article_comment_save();

		/*验证码和登录状态的判断*/
		if(intval($save_state) == 2) {
			/*跳转页面，未登录状态，只有在后台设置登录可发布评论的时候才可用*/
			
			$this->binz_common->front_msg($this->binz_tpl->var_all['cont_comment_login'],0,$link,$this->binz_tpl,true,2);
		} elseif (intval($save_state) == 4) {
			/*跳转页面，验证码错误，开启评论验证码功能才可用*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['cont_comment_code'],0,$link,$this->binz_tpl,true,2);
		}
		/*评论插入状态判断*/
		if($save_state) {
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['cont_comment_ok'],0,$link,$this->binz_tpl,true,2);
		} else {
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['cont_comment_no'],0,$link,$this->binz_tpl,true,2);
		}
	}
	/**
		 * __destruct
		 *
		 * 析构函数
		 * @access  public（权限）
		 */
	public function __destruct() {

	}
}
?>