<?php
/***
*
*@package binzcms
*@version $id:ModAdminVoteClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:05:52 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModAdminVoteClass
 * 投票应用类
 * 
 */
class ModAdminVoteClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_vote_save
	 *
	 * 投票内容保存操作
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_vote_save() {
		$insert_state	= false;
		$vote_array		= array();
		$vote_count		= 0;
		
		/*对投票内容进行处理*/
		if(is_array($_POST['vote_body']) and count($_POST['vote_body'])>0) {
			$array		= array();
			$vote_body	= '';
			$vote_key	= 1;
			foreach ($_POST['vote_body'] as $k => $v) {
				$array[]	= array('vote_key'=>$vote_key,'vote_option'=>trim($v),'vote_num'=>intval($_POST['vote_num'][$k]));
				$vote_count = $vote_count + intval($_POST['vote_num'][$k]);
				$vote_key++;
			}
			$vote_body	= serialize($array);
		} else {
			$vote_body	= '';
		}

		$vote_array['vote_id']			= 'NULL';							//投票id
		$vote_array['vote_title']		= trim($_POST['vote_title']);		//投票标题
		$vote_array['vote_start_time']	= trim($_POST['vote_start_time']);	//投票开始时间
		$vote_array['vote_end_time']	= trim($_POST['vote_end_time']);	//投票结束时间
		$vote_array['vote_type']		= trim($_POST['vote_type']);		//投票类型，0单选，1多选
		$vote_array['vote_body']		= $vote_body;						//投票内容
		$vote_array['vote_count']		= $vote_count;						//投票总数

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#vote',$vote_array);
		if($insert_state) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * mod_vote_edit
	 *
	 * 编辑投票
	 * @access  public（权限）
	 * @param   integer $vote_id		投票id
	 * @return  bool
	 */
	public function mod_vote_edit($vote_id) {
		$edit_state				= false;
		$vote_array				= array();
		
		/*对投票内容进行处理*/
		if(is_array($_POST['vote_body']) and count($_POST['vote_body'])>0) {
			$array		= array();
			$vote_body	= '';
			$vote_key	= 1;
			foreach ($_POST['vote_body'] as $k => $v) {
				$array[]	= array('vote_key'=>$vote_key,'vote_option'=>trim($v),'vote_num'=>intval($_POST['vote_num'][$k]));
				$vote_count = $vote_count + intval($_POST['vote_num'][$k]);
				$vote_key++;
			}
			$vote_body	= serialize($array);
		} else {
			$vote_body	= '';
		}
		
		$vote_array['vote_title']		= trim($_POST['vote_title']);		//投票标题
		$vote_array['vote_start_time']	= trim($_POST['vote_start_time']);	//投票开始时间
		$vote_array['vote_end_time']	= trim($_POST['vote_end_time']);	//投票结束时间
		$vote_array['vote_type']		= trim($_POST['vote_type']);		//投票类型，0单选，1多选
		$vote_array['vote_body']		= $vote_body;						//投票内容
		$vote_array['vote_count']		= $vote_count;						//投票总数
		
		$edit_state	= $this->binz_db->set_update_sql('#binz#vote',$vote_array,array('field'=>'vote_id','value'=>intval($vote_id)));

		return $edit_state;
	}
	/**
	 * mod_vote_list
	 *
	 * 投票列表
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_vote_list() {
		$vote_array			= array();
		$vote_sql				= '';

		$vote_sql				= "SELECT * FROM #binz#vote AS vote
									ORDER BY vote.vote_id DESC";
		$vote_array			= $this->binz_db->set_select_sql($vote_sql);

		return $vote_array;
	}
	/**
	 * mod_vote_info
	 *
	 * 得到投票内容
	 * @access  public（权限）
	 * @param   integer 参数
	 * @return  void	返回类型
	 */
	public function mod_vote_info($vote_id) {
		$vote_info	= array();
		$vote_sql	= '';

		$vote_sql	= "SELECT * FROM #binz#vote AS vote
						WHERE vote.vote_id=".intval($vote_id);
		$vote_info	= $this->binz_db->set_select_sql($vote_sql,0);
		$vote_info['vote_body']	= $vote_info['vote_body'] != '' ? unserialize($vote_info['vote_body']) : '';

		return $vote_info;
	}
	/**
	 * mod_vote_del
	 *
	 * 投票删除
	 * @access  public（权限）
	 * @param   integer $vote_id		投票id
	 * @return  bool
	 */
	public function mod_vote_del($vote_id) {
		$vote_del		= false;
		$vote_sql		= '';

		/*删除广告信息记录*/
		$vote_sql		= "DELETE FROM #binz#vote WHERE vote_id=".intval($vote_id);
		$vote_del		= $this->binz_db->one_query($vote_sql);

		return $vote_del;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}

?>