<?php
/***
*
*@package binzcms
*@version $id:ModAdminSystemClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:04:26 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModAdminSystemClass
 * 系统设置应用类
 * 
 */
class ModAdminSystemClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_system_info
	 *
	 * 系统设置信息
	 * @access  public（权限）
	 * @param   string $system_type		系统信息类型
	 * @return  array
	 */
	public function mod_system_info($system_type) {
		$system_array	= array();
		$array			= array();
		$system_sql		= '';

		$system_sql		= "SELECT * FROM #binz#system AS system
							WHERE system.system_type='$system_type'
							ORDER BY system.system_sort";
		$system_array	= $this->binz_db->set_select_sql($system_sql);

		foreach ($system_array as $v) {
			$array[$v['system_name']]	= $v;
		}

		return $array;
	}
	/**
	 * mod_system_save
	 *
	 * 系统配置信息保存
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_system_save() {
		/*更新数据库中系统配置信息*/
		foreach ($_POST['system_info'] as $v) {
			$this->binz_db->set_update_sql('#binz#system',array('system_value'=>trim($_POST[$v])),array('field'=>'system_name','value'=>$v));
		}
		/*将信息写入配置文件*/
		$write_state	= $this->system_file_write();
		return $write_state;
	}
	/**
	 * mod_system_watermark_save
	 *
	 * 修改图片水印配置信息
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_system_watermark_save() {
		/*更新数据库中水印图片的配置信息*/
		foreach ($_POST['warter_mark'] as $v) {
			$this->binz_db->set_update_sql('#binz#system',array('system_value'=>trim($_POST[$v])),array('field'=>'system_name','value'=>$v));
		}

		/*水印图片处理*/
		if($_FILES['water_image']['name'] != '') {
			$upload_image				= $this->import_class('Image',ROOT_PATH.'/include');
			$upload_image->upload_dir	= '/data';
			$upload_image->upload_image($_FILES['water_image'],'n','watermark');
			$this->binz_db->set_update_sql('#binz#system',array('system_value'=>'watermark.jpg'),array('field'=>'system_name','value'=>'water_image_upload'));
		}

		/*将信息写入配置文件*/
		$write_state	= $this->system_file_write();
		return $write_state;
	}
	/**
	 * mod_system_upload_save
	 *
	 * 修改上传配置信息
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_system_upload_save() {
		/*更新数据库中上传附件的配置信息*/
		foreach ($_POST['upload_info'] as $v) {
			$this->binz_db->set_update_sql('#binz#system',array('system_value'=>trim($_POST[$v])),array('field'=>'system_name','value'=>$v));
		}
		/*将信息写入配置文件*/
		$write_state	= $this->system_file_write();
		return $write_state;
	}
	/**
	 * system_file_write
	 *
	 * 将配置信息写入配置文件
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function system_file_write() {
		$system_sql			= '';
		$system_array		= array();
		$watermark_config	= "<?php\n";
		$system_file_path	= ROOT_PATH.'/config/';

		/*提取配置信息，拼接成字符串*/
		$system_sql			= "SELECT * FROM #binz#system AS system
								ORDER BY system.system_type";
		$system_array		= $this->binz_db->set_select_sql($system_sql);
		if(is_array($system_array) and count($system_array)>0) {
			foreach ($system_array as $val) {
				if(in_array($val['system_name'],array('web_stat_code','web_copyright'))) {
					$val['system_value'] = htmlentities($val['system_value'],ENT_QUOTES);
				}
				$watermark_config	.= "//".$this->binz_tpl->var_all[$val['system_name']]."\ndefine('".strtoupper($val['system_name'])."','".$val['system_value']."');\n";
			}
		}
		$watermark_config	.= "?>";

		if(!$this->binz_common->write_file($system_file_path)) {
			return false;		//config目录没有写入权限
		}
		return @file_put_contents($system_file_path.'config.ini.php',$watermark_config);
	}
	/**
	 * mod_system_admin_save
	 *
	 * 管理员保存操作
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_system_admin_save() {
		$insert_state					= false;
		$admin_array					= array();


		if((trim($_POST['admin_password']) != trim($_POST['pwd_confirm'])) or trim($_POST['pwd_confirm']) == '' or trim($_POST['admin_password']) == '') {
			return 2;	//密码为空，或是两次输入的密码不同
		}

		$admin_array['admin_id']		= 'NULL';							//管理员id
		$admin_array['admin_name']		= trim($_POST['admin_name']);		//管理员名称
		$admin_array['admin_passwd']	= substr(md5(trim($_POST['admin_password'])),0,16);	//管理员密码
		$admin_array['admin_email']		= trim($_POST['admin_email']);		//管理员邮箱
		$admin_array['admin_time']		= time();

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#admin',$admin_array);
		if($insert_state) {
			return true;
		} else {
			return false;
		}
	}
	public function mod_system_admin_edit($admin_id) {
		$edit_state					= false;
		$admin_array				= array();

		if(trim($_POST['new_password']) != '') {
			if(trim($_POST['admin_passwd']) != substr(md5(trim($_POST['old_password'])),0,16)) {
				return 3;		//旧密码输入不正确
			}

			if(trim($_POST['new_password']) != trim($_POST['pwd_confirm'])) {
				return 2; 			//密码为空，或确认密码和新密码不相同
			}
			$admin_array['admin_passwd']	= substr(md5(trim($_POST['new_password'])),0,16);	//管理员密码
		}

		$admin_array['admin_name']		= trim($_POST['admin_name']);		//友情链接名称
		$admin_array['admin_email']		= trim($_POST['admin_email']);		//友情链接地址

		$edit_state	= $this->binz_db->set_update_sql('#binz#admin',$admin_array,array('field'=>'admin_id','value'=>intval($admin_id)));

		return $edit_state;
	}
	/**
	 * mod_system_admin_list
	 *
	 * 管理员列表
	 * @access  public（权限）
	 * 
	 * @return  array	
	 */
	public function mod_system_admin_list() {
		$admin_array			= array();
		$admin_sql				= '';

		$admin_sql				= "SELECT * FROM #binz#admin AS admin
									ORDER BY admin.admin_id";
		$admin_array			= $this->binz_db->set_select_sql($admin_sql);

		return $admin_array;
	}
	/**
	 * mod_system_admin_info
	 *
	 * 得到管理员信息
	 * @access  public（权限）
	 * @param   integer $admin_id		管理员id
	 * @return  array	管理员信息
	 */
	public function mod_system_admin_info($admin_id) {
		$admin_info		= array();
		$admin_sql		= '';

		$admin_sql		= "SELECT * FROM #binz#admin AS admin
							WHERE admin.admin_id=".intval($admin_id);
		$admin_info		= $this->binz_db->set_select_sql($admin_sql,0);

		return $admin_info;
	}
	/**
	 * mod_system_admin_del
	 *
	 * 删除管理员
	 * @access  public（权限）
	 * @param   integer $admin_id		管理员id
	 * @return  bool
	 */
	public function mod_system_admin_del($admin_id) {
		$admin_del		= false;
		$del_sql		= '';

		if(intval($admin_id) == 1) {
			return 2;	//不能删除创始人
		}
		/*删除管理员记录*/
		$del_sql		= "DELETE FROM #binz#admin WHERE admin_id=".intval($admin_id);
		$admin_del		= $this->binz_db->one_query($del_sql);

		return $admin_del;
	}
	/**
	 * mod_system_admin_power_save
	 *
	 * 管理员权限保存
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_system_admin_power_save() {

		if(is_array($_POST['power_code']) and count($_POST['power_code'])>0 and intval($_POST['admin_id']) != 1) {
			$this->binz_db->set_update_sql('#binz#admin',array('admin_power'=>implode(',',$_POST['power_code'])),array('field'=>'admin_id','value'=>intval($_POST['admin_id'])));
		}
		return true;
	}
	/**
	 * mod_system_article_save
	 *
	 * 内容保存
	 * @access  public（权限）
	 * 
	 */
	public function mod_system_article_save() {
		$insert_state							= false;
		$article_id								= '';
		$article_array							= array();

		$article_array['sys_article_id']		= 'NULL';									//文章id
		$article_array['sys_article_class']		= intval($_POST['system_article_type']);	//文章类型
		$article_array['sys_article_title']		= trim($_POST['article_title']);			//文章标题
		$article_array['sys_article_author']	= $_SESSION['admin_name'];				//文章作者
		$article_array['sys_url_jump']			= trim($_POST['article_url_jump']);			//跳转地址
		$article_array['sys_article_state']		= intval($_POST['system_article_state']);	//文章状态
		$article_array['sys_article_content']	= trim($_POST['body_content']);				//文章内容
		$article_array['sys_article_time']		= time();									//文章时间
		$article_array['sys_article_sort']		= intval($_POST['article_sort']);			//文章排序

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#sys_article',$article_array);
		if($insert_state) {
			$article_id			= $this->binz_db->last_insert_id();
			return $article_id;
		} else {
			return false;
		}
	}
	/**
	 * mod_sys_article_edit
	 *
	 * 系统文章修改
	 * @access  public（权限）
	 * @param   integer $article_id		内容id
	 * @return  bool
	 */
	public function mod_sys_article_edit($article_id) {
		$edit_state								= false;
		$article_array							= array();

		$article_array['sys_article_class']		= intval($_POST['system_article_type']);	//文章类型
		$article_array['sys_article_title']		= trim($_POST['article_title']);			//文章标题
		$article_array['sys_article_author']	= $_SESSION['admin_name'];					//文章作者
		$article_array['sys_url_jump']			= trim($_POST['article_url_jump']);			//跳转地址
		$article_array['sys_article_state']		= intval($_POST['system_article_state']);	//文章状态
		$article_array['sys_article_content']	= trim($_POST['body_content']);				//文章内容
		$article_array['sys_article_time']		= time();									//文章时间
		$article_array['sys_article_sort']		= intval($_POST['article_sort']);			//文章排序

		$edit_state	= $this->binz_db->set_update_sql('#binz#sys_article',$article_array,array('field'=>'sys_article_id','value'=>intval($article_id)));
		if($edit_state) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * mod_sys_article_info
	 *
	 * 单个内容信息
	 * @access  public（权限）
	 * @param   integer $article_id		内容id
	 * @return  array	内容
	 */
	public function mod_sys_article_info($article_id) {
		$article_info			= array();
		$article_sql			= '';

		$article_sql			= "SELECT * FROM #binz#sys_article AS a
							 		WHERE a.sys_article_id=".intval($article_id);
		$article_info			= $this->binz_db->set_select_sql($article_sql,0);

		return $article_info;
	}
	/**
	 * mod_system_article_list
	 *
	 * 系统文章列表数组
	 * @access  public（权限）
	 *  @param   integer $binz_page		当前页数
	 *  @param   integer $page_num		每页记录数
	 * return  array
	 */
	public function mod_system_article_list($binz_page,$page_num) {
		$article_array			= array();
		$article_sql			= '';
		$limit_sql				=  "LIMIT ".(intval($binz_page)-(intval($binz_page)>=1 ? 1 : 0))*$page_num.",$page_num";
		$where					= "WHERE a.sys_article_title LIKE '%".trim($_GET['keyword'])."%'";
		if(intval($_GET['system_article_type']) != 0) {
			$where				.= " AND sys_article_class=".intval($_GET['system_article_type']);
		}

		$article_sql			= "SELECT * FROM #binz#sys_article AS a
									$where
									ORDER BY a.sys_article_sort,a.sys_article_id DESC ".$limit_sql;
		$article_array			= $this->binz_db->set_select_sql($article_sql);

		return $article_array;
	}
	/**
	 * mod_system_article_del
	 *
	 * 文章删除
	 * @access  public（权限）
	 * @param   integer $article_id		文章id
	 * @return  bool	执行状态
	 */
	public function mod_system_article_del($article_id) {
		$del_state		= false;
		$sql			= " a.* FROM #binz#sys_article AS a
							WHERE a.sys_article_id=".intval($article_id);
		/*删除记录*/
		$del_state		= $this->binz_db->one_query('DELETE'.$sql);
		return $del_state;
	}
	/**
	 * mod_system_change_action
	 *
	 * 执行列表的相关操作
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_system_change_action() {
		$state		= false;
		$sql		= '';

		/*文章删除操作*/
		if(trim($_POST['type']) == 'delete' and (is_array($_POST['art_id']) and count($_POST['art_id'])>0)) {
			foreach ($_POST['art_id'] as $v) {
				$this->mod_system_article_del($v);
			}
			return true;
		}
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>