<?php
/***
*
*@package binzcms
*@version $id:ModAdminMemberClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:03:03 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModAdminMemberClass
 * 会员应用类
 * 
 */
class ModAdminMemberClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_member_save
	 *
	 * 会员保存
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_member_save() {
		$insert_state					= false;
		$member_array					= array();


		if((trim($_POST['member_passwd']) != trim($_POST['confirm_password'])) or trim($_POST['member_passwd']) == '' or trim($_POST['confirm_password']) == '') {
			return 2;	//密码为空，或是两次输入的密码不同
		}
		
		$member_array['member_id']		= 'NULL';							//会员id
		$member_array['member_name']	= trim($_POST['member_name']);		//会员名称
		$member_array['member_passwd']	= substr(md5(trim($_POST['member_passwd'])),0,16);	//会员密码
		$member_array['member_sex']		= intval($_POST['member_sex']);		//会员性别
		$member_array['member_birthday']= intval($_POST['year']).'|'.intval($_POST['month']).'|'.intval($_POST['day']);
		$member_array['member_email']	= trim($_POST['member_email']);		//会员email
		$member_array['member_msn']		= trim($_POST['member_msn']);		//会员msn
		$member_array['member_qq']		= trim($_POST['member_qq']);		//会员qq
		$member_array['member_time']	= time();

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#member',$member_array);
		if($insert_state) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * mod_member_edit
	 *
	 * 会员修改
	 * @access  public（权限）
	 * @param   integer $member_id		会员id
	 * @return  bool
	 */
	public function mod_member_edit($member_id) {
		$edit_state					= false;
		$member_array				= array();

		$member_array['member_sex']		= intval($_POST['member_sex']);					//会员性别
		$member_array['member_email']	= trim($_POST['member_email']);					//会员email
		$member_array['member_birthday']= intval($_POST['year']).'|'.intval($_POST['month']).'|'.intval($_POST['day']);
		$member_array['member_msn']		= trim($_POST['member_msn']);					//会员msn
		$member_array['member_qq']		= trim($_POST['member_qq']);					//会员qq

		$edit_state	= $this->binz_db->set_update_sql('#binz#member',$member_array,array('field'=>'member_id','value'=>intval($member_id)));

		return $edit_state;
	}
	/**
	 * mod_member_list
	 *
	 * 会员列表
	 * @access  public（权限）
	 * @param   integer $binz_page			当前页数
	 * @param   integer $page_num			每页记录数
	 * @param   string	$key_words			每页记录数
	 * @return  void	返回类型
	 */
	public function mod_member_list($binz_page,$page_num,$key_words='') {
		$member_array			= array();
		$member_sql				= '';
		$where_str				= $key_words != '' ? " WHERE member_name like '%$key_words%'" : '';

		$limit_sql				=  "LIMIT ".(intval($binz_page)-(intval($binz_page)>=1 ? 1 : 0))*$page_num.",$page_num";

		$member_sql				= "SELECT * FROM #binz#member
									$where_str
									ORDER BY member_id DESC ".$limit_sql;
		$member_array['list']	= $this->binz_db->set_select_sql($member_sql);
		$member_array['count']	= $this->binz_db->set_select_sql("SELECT COUNT(member_id) AS member_num FROM #binz#member".$where_str,0);

		return $member_array;
	}
	/**
	 * mod_member_info
	 *
	 * 得到会员信息
	 * @access  public（权限）
	 * @param   integer $member_id		会员id
	 * @return  array
	 */
	public function mod_member_info($member_id) {
		$member_info	= array();
		$member_sql		= '';

		$member_sql		= "SELECT * FROM #binz#member AS member
							WHERE member.member_id=".intval($member_id);
		$member_info	= $this->binz_db->set_select_sql($member_sql,0);

		return $member_info;
	}
	/**
	 * mod_member_del
	 *
	 * 会员删除
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_member_del($member_id) {
		$member_del		= false;
		$del_sql		= '';
		$where_str		= ' WHERE member_id ';

		if(is_array($member_id) and count($member_id) > 0) {
			$where_str	.= 'IN ('.implode(',',$member_id).')';
		} else {
			$where_str	.= 'IN ('.intval($member_id).')';
		}

		$del_sql		= "DELETE FROM #binz#member".$where_str;
		$member_del		= $this->binz_db->one_query($del_sql);

		return $del_sql;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>