<?php
/***
*
*@package binzcms
*@version $id:ModAdminContentClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 00:59:27 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModAdminContentClass
 * 内容应用类
 * 
 */
class ModAdminContentClass extends BaseClass {

	private $upload_image;

	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {

		$this->upload_image		= $this->import_class('Image',ROOT_PATH.'/include');

		parent::__construct($act);
	}
	/**
	 * content_save
	 *
	 * 内容保存
	 * @access  public（权限）
	 * 
	 */
	public function mod_content_save() {
		$insert_state							= false;
		$end_insert_state						= false;
		$article_id								= '';
		$article_array							= array();

		$article_array['article_id']			= 'NULL';									//文章id
		$article_array['class_id']				= intval($_POST['class_id']);				//分类id
		$article_array['article_title']			= trim($_POST['article_title']);			//文章标题
		$article_array['article_time']			= time();									//文章发布时间
		$article_array['article_author']		= trim($_POST['article_author']);			//文章作者
		$article_array['article_source']		= trim($_POST['article_source']);			//文章来源
		$article_array['article_state']			= intval($_POST['article_state']);			//文章状态
		$article_array['article_sort']			= intval($_POST['article_sort']);			//文章排序
		$article_array['article_commend']		= intval($_POST['article_commend']);		//文章是否整站推荐
		$article_array['article_img']			= trim($_POST['article_img']);				//文章缩微图
		$article_array['article_title_color']	= trim($_POST['article_title_color']);		//文章标题颜色
		$article_array['article_index_show']	= intval($_POST['index_type']);				//首页显示类型
		$article_array['article_keywords']		= trim($_POST['article_keywords']);			//文章关键字
		$article_array['article_description']	= trim($_POST['article_description']);		//文章描述
		$article_array['article_class_show']	= intval($_POST['article_class_show']);		//文章频道显示类型
		$article_array['article_url_jump']		= trim($_POST['article_url_jump']);			//文章跳转地址

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#article',$article_array);
		if($insert_state) {
			$article_id			= $this->binz_db->last_insert_id();
			$end_insert_state	= $this->binz_db->set_insert_sql_value('#binz#article_body',array('body_id'=>$article_id,'class_id'=>$article_array['class_id'],'body_content'=>trim($_POST['body_content'])));
			if($article_array['article_index_show'] == 3) {
				self::mod_index_flash_edit();
			}
		}
		if(!$end_insert_state) {
			return false;
		}
		return $article_id;
	}
	/**
	 * mod_content_list
	 *
	 * 内容列表
	 * @access  public（权限）
	 *  @param   integer $binz_page		当前页数
	 *  @param   integer $page_num		每页记录数
	 *  @param   integer $art_class		分类对象
	 * @return  array	内容列表数组
	 */
	public function mod_content_list($binz_page,$page_num,$art_class) {
		$article_array			= array();
		$article_sql			= '';
		$limit_sql				=  "LIMIT ".(intval($binz_page)-(intval($binz_page)>=1 ? 1 : 0))*$page_num.",$page_num";
		$where					= "WHERE a.class_id!=0 AND c.class_type_tag!='image'";
		/*分类子级*/
		if(intval($_GET['class_id']) != 0) {
			$sub_class			= $art_class->get_sun_class_id(intval($_GET['class_id']));
			$where				.= count($sub_class)>0 ? ' AND a.class_id IN ('.implode(',',$sub_class).') ' : '' ;
		}

		$article_sql			= "SELECT a.*,c.class_name FROM #binz#article AS a
									INNER JOIN #binz#article_class AS c ON a.class_id=c.class_id
									$where
									ORDER BY a.article_sort,a.article_id DESC ".$limit_sql;

		$article_array['list']	= $this->binz_db->set_select_sql($article_sql);
		$article_array['count']	= $this->binz_db->set_select_sql("SELECT COUNT(a.article_id) AS article_num FROM #binz#article AS a INNER JOIN #binz#article_class AS c ON a.class_id=c.class_id $where",0);
		return $article_array;
	}
	/**
	 * mod_change_action
	 *
	 * 执行列表的相关操作
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_change_action() {
		$state		= false;
		$sql		= '';

		/*文章删除操作*/
		if(trim($_POST['type']) == 'delete' and (is_array($_POST['art_id']) and count($_POST['art_id'])>0)) {
			foreach ($_POST['art_id'] as $v) {
				$this->mod_article_del($v);
			}
			return true;
		}
		/*图片内容删除操作*/
		if(trim($_POST['type']) == 'delete_img' and (is_array($_POST['art_id']) and count($_POST['art_id'])>0)) {
			foreach ($_POST['art_id'] as $v) {
				$this->mod_article_del($v);
				$this->mod_image_more_del($v);
			}
			return true;
		}
		/*内容排序更新操作*/
		if(trim($_POST['type']) == 'update' and (is_array($_POST['art_id']) and count($_POST['art_id'])>0)) {
			$this->mod_article_update();
			return true;
		}
		/*其他操作*/
		switch (trim($_POST['type'])) {
			case 'commend':		//推荐
			$sql	= "UPDATE #binz#article SET article_commend=1 WHERE article_id ";
			break;
			case 'cancel':		//取消推荐
			$sql	= "UPDATE #binz#article SET article_commend=0 WHERE article_id ";
			break;
			case 'move_to':		//移动
			$sql	= "UPDATE #binz#article AS a,#binz#article_body AS b SET b.class_id=".$_POST['move_class_id'].",a.class_id=".$_POST['move_class_id']." WHERE a.article_id=b.body_id AND a.article_id ";
			break;
		}

		if(is_array($_POST['art_id']) and count($_POST['art_id'])>0) {
			$sql	.= " IN (".implode(',',$_POST['art_id']).")";
		} else {
			$sql	= '';
		}


		$state	= $this->binz_db->sql_query($sql);
		return $state;
	}
	/**
	 * mod_content_info
	 *
	 * 单个内容信息
	 * @access  public（权限）
	 * @param   integer $article_id		内容id
	 * @return  array	内容
	 */
	public function mod_content_info($article_id) {
		$article_info			= array();
		$article_sql			= '';

		$article_sql			= "SELECT * FROM #binz#article AS a
									INNER JOIN #binz#article_body AS b ON a.article_id=b.body_id
							 		WHERE a.article_id=".intval($article_id);
		$article_info			= $this->binz_db->set_select_sql($article_sql,0);

		return $article_info;
	}
	/**
	 * mod_content_edit
	 *
	 * 内容编辑操作
	 * @access  public（权限）
	 * @param   integer $article_id		内容id
	 * 
	 */
	public function mod_content_edit($article_id) {
		$edit_state								= false;
		$body_edit_state						= false;
		$article_array							= array();

		$article_array['class_id']				= intval($_POST['class_id']);				//分类id
		$article_array['article_title']			= trim($_POST['article_title']);			//文章标题
		$article_array['article_time']			= time();									//文章发布时间
		$article_array['article_author']		= trim($_POST['article_author']);			//文章作者
		$article_array['article_source']		= trim($_POST['article_source']);			//文章来源
		$article_array['article_state']			= intval($_POST['article_state']);			//文章状态
		$article_array['article_sort']			= intval($_POST['article_sort']);			//文章排序
		$article_array['article_commend']		= intval($_POST['article_commend']);		//文章是否推荐
		if($_POST['article_img'] != '') {
			$article_array['article_img']		= trim($_POST['article_img']);				//文章缩微图
		}
		$article_array['article_title_color']	= trim($_POST['article_title_color']);		//文章标题颜色
		$article_array['article_index_show']	= intval($_POST['index_type']);				//首页显示类型
		$article_array['article_keywords']		= trim($_POST['article_keywords']);			//文章关键字
		$article_array['article_description']	= trim($_POST['article_description']);		//文章描述
		$article_array['article_class_show']	= intval($_POST['article_class_show']);		//文章频道显示类型
		$article_array['article_url_jump']		= trim($_POST['article_url_jump']);			//文章跳转地址

		$edit_state	= $this->binz_db->set_update_sql('#binz#article',$article_array,array('field'=>'article_id','value'=>intval($article_id)));
		if($edit_state) {
			$body_edit_state = $this->binz_db->set_update_sql('#binz#article_body',array('class_id'=>$article_array['class_id'],'body_content'=>trim($_POST['body_content'])),array('field'=>'body_id','value'=>intval($article_id)));
			if($article_array['article_index_show'] == 3) {
				self::mod_index_flash_edit();
			}
		}
		if($body_edit_state) {
			return true;
		}
		return false;
	}
	/**
	 * mod_article_del
	 *
	 * 文章删除
	 * @access  public（权限）
	 * @param   integer $article_id		文章id
	 * @return  bool	执行状态
	 */
	public function mod_article_del($article_id) {
		$del_state		= false;
		$sql			= " a.*,b.* FROM #binz#article AS a
							INNER JOIN #binz#article_body AS b ON a.article_id=b.body_id
							WHERE a.article_id=".intval($article_id);
		/*删除文章内的图片*/
		$article_info	= $this->binz_db->set_select_sql('SELECT '.$sql,0);
		@unlink(ROOT_PATH.$article_info['article_img']);
		/*删除内容中站内图片*/
		$img_array 	= array();
		$serch_host	= str_replace('/','\/',str_replace('.','\.',WEB_HOST));
		preg_match_all("/(src|SRC)=[\"|'| ]{0,}($serch_host(.*)\.(gif|jpg|jpeg|bmp|png))/isU",$article_info['body_content'],$img_array);
		if(is_array($img_array[3]) and count($img_array[3])>0) {
			$img_num	= count($img_array[3]);
			for($i=0;$i<$img_num;$i++) {
				@unlink('..'.$img_array[3][$i].'.'.$img_array[4][$i]);
			}
		}
		/*删除记录*/
		$del_state		= $this->binz_db->one_query('DELETE'.$sql);
		/*删除评论*/
		$this->binz_db->set_del_sql('#binz#article_comment ',array('article_id'=>intval($article_id)));

		return $del_state;
	}
	/**
	 * mod_article_update
	 *
	 * 更新排序
	 * @access  private（权限）
	 * 
	 * @return  bool
	 */
	private function mod_article_update() {
		if(is_array($_POST['art_id']) and count($_POST['art_id'])>0) {
			foreach ($_POST['art_id'] as $key => $val) {
				$update_array	= array();
				$update_array['article_sort']	= intval($_POST['sort'][$key]);
				$edit_state	= $this->binz_db->set_update_sql('#binz#article',$update_array,array('field'=>'article_id','value'=>intval($val)));
			}
		}
	}
	/**
	 * mod_image_save
	 *
	 * 图片保存
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_image_save() {
		/*内容保存*/
		$article_id		= '';
		$article_id		= $this->mod_content_save();

		/*相册保存*/
		$state=$this->mod_image_more_save($article_id);
		if($state) {
			return $article_id;
		} else {
			return false;
		}
	}
	public function mod_image_edit() {
		/*内容修改*/
		$this->mod_content_edit(intval($_POST['article_id']));
		/*相册原有内容修改*/
		$this->mod_image_finish_edit();
		/*相册保存*/
		$state=$this->mod_image_more_save(intval($_POST['article_id']));
		if($state) {
			return intval($_POST['article_id']);
		} else {
			return false;
		}
	}
	/**
	 * mod_image_more_save
	 *
	 * 相册图片保存
	 * @access  public（权限）
	 * @param   integer $article_id		文章id
	 * @return  bool
	 */
	public function mod_image_more_save($article_id) {
		$upload_path	= array();
		$image_array	= array();
		$this->upload_image->upload_dir	= 'upload/more_img';
		$image_name		= '';
		if(is_array($_FILES['img_url']['name']) and count($_FILES['img_url']['name'])>0) {
			foreach ($_FILES['img_url']['name'] as $key => $value) {
				if($value != '') {
					$image_name		= time().mt_rand();
					$file_name		= array('name'=>$_FILES['img_url']['name'][$key],'type'=>$_FILES['img_url']['type'][$key],'tmp_name'=>$_FILES['img_url']['tmp_name'][$key]);
					$upload_path['image_source']	= $this->upload_image->upload_image($file_name,'m',$image_name.'_source');
					$image_extend	= explode('.',$upload_path['image_source']);
					$image_s		= $image_extend[count($image_extend)-1];
					$image_spath	= $this->upload_image->dir_name_type('m');
					/*复制图片*/
					if(file_exists(ROOT_PATH.$upload_path['image_source'])) {
						$image_art		= $image_spath.'/'.$image_name.'.'.$image_s;
						@copy(ROOT_PATH.$upload_path['image_source'],$image_art);
					}
					/*水印图片*/
					if(OPEN_WATERMARK == '1' and file_exists($image_art)) {
						$this->upload_image->create_watermark($image_art);
					}
					/*缩微图*/
					$this->upload_image->create_thump($image_art,$image_spath,$image_name.'_thumb.'.$image_s);

					$upload_path['image_art']	= $image_spath.'/'.$image_name.'.'.$image_s;
					$upload_path['image_thumb']	= $image_spath.'/'.$image_name.'_thumb.'.$image_s;

					$image_info_array['image_id']		= 'NULL';
					$image_info_array['article_id']		= $article_id;
					$image_info_array['image_source']	= str_replace(ROOT_PATH,'',$upload_path['image_source']);
					$image_info_array['image_art']		= str_replace(ROOT_PATH,'',$upload_path['image_art']);
					$image_info_array['image_thumb']	= str_replace(ROOT_PATH,'',$upload_path['image_thumb']);
					$image_info_array['image_info']		= trim($_POST['img_desc'][$key]);

					$this->binz_db->set_insert_sql_value('#binz#image',$image_info_array);
				}
			}
		}
		return true;
	}
	/**
	 * mod_image_finish_edit
	 *
	 * 对相册已有图片进行处理
	 * @access  public（权限）
	 * 
	 * @return  
	 */
	public function mod_image_finish_edit() {
		if(is_array($_POST['old_img_desc']) and count($_POST['old_img_desc'])>0) {
			foreach ($_POST['old_img_desc'] as $k => $v) {
				$image_sql			= "SELECT * FROM #binz#image AS i
							 		WHERE i.image_id=".$k;
				$image_info			= $this->binz_db->set_select_sql($image_sql,0);
				if($image_info['image_id'] != '') {
					$this->binz_db->set_update_sql('#binz#image',array('image_info'=>$v),array('field'=>'image_id','value'=>intval($k)));
				}
			}
		}
	}
	/**
	 * mod_comment_list
	 *
	 * 文章评论列表
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_comment_list($binz_page,$page_num) {
		$comment_array			= array();
		$comment_sql			= '';
		$limit_sql				=  "LIMIT ".(intval($binz_page)-(intval($binz_page)>=1 ? 1 : 0))*$page_num.",$page_num";
		$where_sql				= '';

		if($_GET['search_type'] != '' and trim($_GET['keywords']) != '') {
			$where_sql			= " WHERE ".($_GET['search_type'] == 'comment_body' ? "c.comment_body LINK '%".$_GET['keywords']."%'" : "c.".$_GET['search_type']."='".$_GET['keywords']."'");
		}

		$comment_sql			= "SELECT c.*,a.article_id,a.article_title FROM #binz#article_comment AS c
									INNER JOIN #binz#article AS a ON c.article_id=a.article_id
									$where_sql
									ORDER BY c.comment_id DESC ".$limit_sql;
		$comment_array['list']	= $this->binz_db->set_select_sql($comment_sql);
		$comment_array['count']	= $this->binz_db->set_select_sql("SELECT COUNT(c.comment_id) AS comment_num FROM #binz#article_comment AS c ".$where_sql,0);

		return $comment_array;
	}
	/**
	 * mod_comment_info
	 *
	 * 得到评论内容
	 * @access  public（权限）
	 * @param   integer $comment_id		评论id
	 * @return  array
	 */
	public function mod_comment_info($comment_id) {
		$comment_info			= array();
		$comment_sql			= '';

		$comment_sql			= "SELECT c.*,a.article_id,a.article_title FROM #binz#article_comment AS c
									INNER JOIN #binz#article AS a ON c.article_id=a.article_id
									WHERE c.comment_id=".intval($comment_id);		
		$comment_info			= $this->binz_db->set_select_sql($comment_sql,0);
		return $comment_info;
	}
	/**
	 * mod_comment_reply
	 *
	 * 回复评论
	 * @access  public（权限）
	 * @param   integer $comment_id		评论id
	 * @return  bool
	 */
	public function mod_comment_reply_save($comment_id) {
		$save_state		= false;
		$save_state		= $this->binz_db->set_update_sql('#binz#article_comment',array('comment_repost'=>htmlspecialchars(trim($_POST['comment_repost']),ENT_QUOTES),'comment_repost_author'=>$_SESSION['admin_name'],'comment_repost_time'=>time()),array('field'=>'comment_id','value'=>intval($comment_id)));
		return $save_state;
	}
	/**
	 * mod_comment_del
	 *
	 * 删除评论
	 * @access  public（权限）
	 * @param   integer/array $comment_id		评论id
	 * @return  bool
	 */
	public function mod_comment_del($comment_id) {
		$del_state		= false;
		$del_sql		= "DELETE FROM #binz#article_comment ";

		if(is_array($comment_id) and count($comment_id)>0) {
			$del_state	= $this->binz_db->sql_query($del_sql."WHERE comment_id IN(".implode(',',$comment_id).")");
		} else {
			if(intval($comment_id) != 0) {
				$del_state	= $this->binz_db->sql_query($del_sql."WHERE comment_id=".intval($comment_id));
			}
		}
		return $del_state;
	}
	/**
	 * mod_upload_image
	 *
	 * 文章上传图片处理
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_upload_image() {
		$upload_path			= '';
		//$upload_image			= $this->import_class('Image',ROOT_PATH.'/include');
		$img_array 				= array();

		/*得到内容里的站内图片*/
		$serch_host	= str_replace('/','\/',str_replace('.','\.',WEB_HOST));
		preg_match_all("/(src|SRC)=[\"|'| ]{0,}($serch_host(.*)\.(gif|jpg|jpeg|bmp|png))/isU",trim($_POST['body_content']),$img_array);
		/*是否添加水印*/
		if(OPEN_WATERMARK == '1') {
			if(is_array($img_array[3]) and count($img_array[3])>0) {
				$image_num	= count($img_array[3]);
				for($i=0;$i<$image_num;$i++) {
					$this->upload_image->create_watermark(ROOT_PATH.$img_array[3][$i].'.'.$img_array[4][$i]);
				}
			}
		}

		//上传缩微图
		if($_FILES['article_img']['name'] != '') {
			$upload_path		= $this->upload_image->upload_image($_FILES['article_img'],'m','',true,OPEN_WATERMARK);
			if($_POST['old_article_img'] != '') {
				@unlink(ROOT_PATH.'/'.trim($_POST['old_article_img']));
			}
			//当没有缩微上传的时候，对内容中的第一张图片进行缩微处理
		} elseif (trim($_POST['old_article_img']) == '') {
			/*生成缩微图*/
			if($img_array[3][0] != '') {
				$this->upload_image->create_thump(ROOT_PATH.$img_array[3][0].'.'.$img_array[4][0],$this->upload_image->dir_name_type('m'));
				$upload_path	= str_replace(ROOT_PATH,'',$this->upload_image->dir_name_type('m')).'/'.basename($img_array[2][0]);
			}
		} else {
			$upload_path		= '';
		}

		return $upload_path;
	}
	/**
	 * mod_image_list
	 *
	 * 图片列表
	 * @access  public（权限）
	 *  @param   integer $binz_page		当前页数
	 *  @param   integer $page_num		每页记录数
	 *  @param   integer $art_class		分类对象
	 * @return  array	内容列表数组
	 */
	public function mod_image_list($binz_page,$page_num,$art_class) {
		$article_array			= array();
		$article_sql			= '';
		$limit_sql				=  "LIMIT ".(intval($binz_page)-(intval($binz_page)>=1 ? 1 : 0))*$page_num.",$page_num";
		$where					= "WHERE a.class_id!=0 AND c.class_type_tag!='article' AND a.article_title LIKE '%".trim($_GET['keyword'])."%'";
		/*分类子级*/
		if(intval($_GET['class_id']) != 0) {
			$sub_class			= $art_class->get_sun_class_id(intval($_GET['class_id']));
			$where				.= count($sub_class)>0 ? ' AND a.class_id IN ('.implode(',',$sub_class).') ' : '' ;
		}

		$article_sql			= "SELECT a.*,c.class_name FROM #binz#article AS a
									INNER JOIN #binz#article_class AS c ON a.class_id=c.class_id
									$where
									ORDER BY a.article_sort,a.article_id DESC ".$limit_sql;

		$article_array['list']	= $this->binz_db->set_select_sql($article_sql);
		$article_array['count']	= $this->binz_db->set_select_sql("SELECT COUNT(a.article_id) AS article_num FROM #binz#article AS a INNER JOIN #binz#article_class AS c ON a.class_id=c.class_id $where",0);
		return $article_array;
	}
	/**
	 * mod_image_more_info
	 *
	 * 指定相册图片
	 * @access  public（权限）
	 *  @param   integer $image_id		相册id
	 * @return  array	内容数组
	 */
	public function mod_image_more_info($article_id) {
		$image_info			= array();
		$image_sql			= '';

		$image_sql			= "SELECT * FROM #binz#image AS i
							 		WHERE i.article_id=".intval($article_id);
		$image_info			= $this->binz_db->set_select_sql($image_sql);

		return $image_info;
	}
	/**
	 * mod_image_more_del
	 *
	 * 删除相册
	 * @access  public（权限）
	 *  @param  integer $article_id		内容id
	 * @return  
	 */
	public function mod_image_more_del($article_id) {
		$image_info			= array();
		$image_sql			= '';

		$image_sql			= "SELECT * FROM #binz#image AS i
							 		WHERE i.article_id=".intval($article_id);
		$image_info			= $this->binz_db->set_select_sql($image_sql);
		if(is_array($image_info) and count($image_info)>0) {
			foreach ($image_info as $v) {
				$this->mod_drop_image_more($v['image_id']);
			}
		}
		return true;
	}
	/**
	 * mod_drop_image_more
	 *
	 * 删除指定相册中图片
	 * @access  public（权限）
	 *  @param   integer $image_id		相册id
	 * @return  bool
	 */
	public function mod_drop_image_more($image_id) {
		$image_sql			= "SELECT * FROM #binz#image AS i
							 		WHERE i.image_id=".$image_id;
		$image_info			= $this->binz_db->set_select_sql($image_sql,0);
		@unlink('..'.$image_info['image_source']);
		@unlink('..'.$image_info['image_art']);
		@unlink('..'.$image_info['image_thumb']);
		/*删除记录*/
		$del_state		= $this->binz_db->set_del_sql('#binz#image ',array('image_id'=>$image_id));
		if($del_state) {
			return true;
		} else {
			return false;
		}
	}
	public function mod_index_flash_edit() {
		$index_flash_image	= array();
		$index_image_sql	= '';

		$index_image_sql	= "SELECT a.article_id,a.article_url_jump,a.article_img,c.class_type_tag FROM #binz#article AS a
									INNER JOIN #binz#article_class AS c ON a.class_id=c.class_id
									WHERE a.article_state=1 AND a.article_index_show=3
									ORDER BY a.article_sort,a.article_id DESC ";
		$index_flash_image	= $this->binz_db->set_select_sql($index_image_sql);
		
		$data_xml			= "<?xml version=\"1.0\" encoding=\"utf-8\"?><bcaster>";
		if($index_flash_image != '') {
			foreach ($index_flash_image AS $val) {
				$url = '';
				switch ($val['class_type_tag']) {
					case 'article':
						$url		= $val['article_url_jump'] != '' ? $val['article_url_jump'] : 'index.php?ctl=article&act=front_article_content&article_id='.$val['article_id'];
						$data_xml 	.= '<item item_url="'.WEB_HOST.$val['article_img'].'" link="'.$url.'" />';
						break;
					case 'image':
						$url		= $val['article_url_jump'] != '' ? $val['article_url_jump'] : 'index.php?ctl=pic&act=front_pic_content&article_id='.$val['article_id'];
						$data_xml 	.= '<item item_url="'.WEB_HOST.$val['article_img'].'" link="'.$url.'" />';
						break;
				}
			}
		}
		$data_xml			.= "</bcaster>";
		file_put_contents(ROOT_PATH."/data/flashdata/data.xml",$data_xml);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>