<?php
/***
*
*@package binzcms
*@version $id:ModAdminAdClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:08:49 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModAdminAdClass
 * 广告管理类
 * 
 */
class ModAdminAdClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_ad_save
	 *
	 * 保存广告
	 * @access  public（权限）
	 * 
	 */
	public function mod_ad_save() {
		$insert_state				= false;
		$ad_array					= array();

		$ad_array['ad_id']			= 'NULL';							//广告id
		$ad_array['ad_name']		= trim($_POST['ad_name']);			//广告名称
		$ad_array['ad_type']		= trim($_POST['ad_type']);			//广告类型
		$ad_array['ad_place']		= trim($_POST['ad_place']);			//广告位置
		$ad_array['ad_time_start']	= trim($_POST['ad_time_start']);	//广告开始时间
		$ad_array['ad_time_end']	= trim($_POST['ad_time_end']);		//广告结束时间
		$ad_array['ad_url']			= trim($_POST['ad_url']);			//广告链接地址
		$ad_array['ad_body']		= trim($_POST['body']);				//广告内容
		$ad_array['ad_state']		= intval($_POST['ad_state']);		//广告状态

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#ad',$ad_array);
		if($insert_state) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * mod_ad_edit
	 *
	 * 函数简介
	 * @access  public（权限）
	 * @param   integer $ad_id		广告id
	 * @return  bool
	 */
	public function mod_ad_edit($ad_id) {
		$edit_state					= false;
		$ad_array					= array();

		$ad_array['ad_name']		= trim($_POST['ad_name']);			//广告名称
		$ad_array['ad_type']		= trim($_POST['ad_type']);			//广告类型
		$ad_array['ad_place']		= trim($_POST['ad_place']);			//广告位置
		$ad_array['ad_time_start']	= trim($_POST['ad_time_start']);	//广告开始时间
		$ad_array['ad_time_end']	= trim($_POST['ad_time_end']);		//广告结束时间
		$ad_array['ad_url']			= trim($_POST['ad_url']);			//广告链接地址
		$ad_array['ad_body']		= trim($_POST['body']);				//广告内容
		$ad_array['ad_state']		= intval($_POST['ad_state']);		//广告状态

		$edit_state	= $this->binz_db->set_update_sql('#binz#ad',$ad_array,array('field'=>'ad_id','value'=>intval($ad_id)));

		return $edit_state;
	}
	/**
	 * mod_ad_info
	 *
	 * 取得广告信息
	 * @access  public（权限）
	 * @param   string	$ad_id		广告id
	 * @return  array
	 */
	public function mod_ad_info($ad_id) {
		$ad_info		= array();
		$ad_sql		= '';

		$ad_sql		= "SELECT * FROM #binz#ad AS ad
							WHERE ad.ad_id=".intval($ad_id);
		$ad_info		= $this->binz_db->set_select_sql($ad_sql,0);

		return $ad_info;
	}
	/**
	 * mod_ad_list
	 *
	 * 广告列表
	 * @access  public（权限）
	 * 
	 */
	public function mod_ad_list() {
		$ad_array			= array();
		$ad_sql				= '';

		$ad_sql				= "SELECT * FROM #binz#ad AS ad
									ORDER BY ad.ad_id";
		$ad_array			= $this->binz_db->set_select_sql($ad_sql);

		return $ad_array;
	}
	/**
	 * mod_ad_del
	 *
	 * 广告删除
	 * @access  public（权限）
	 * @param   string	$ad_id		广告id
	 * @return  bool
	 */
	public function mod_ad_del($ad_id) {
		$ad_del		= false;
		$ad_info	= array();
		$ad_sql		= '';

		/*如果有广告文件，删除文件*/
		$ad_info		= $this->mod_ad_info($ad_id);
		if($ad_info['ad_type'] == 'ad_image' or $ad_info['ad_type'] == 'ad_flash') {
			if(strpos("http",$ad_info['ad_body']) === false) {
				@unlink(ROOT_PATH.$ad_info['ad_body']);
			}
		}
		unset($ad_info);

		/*删除广告信息记录*/
		$del_sql		= "DELETE FROM #binz#ad WHERE ad_id=".$ad_id;
		$ad_del		= $this->binz_db->one_query($del_sql);

		return $ad_del;
	}
	/**
	 * mod_body
	 *
	 * 广告文件上传
	 * @access  public（权限）
	 * @param   string	$path		ad上传路径
	 * @return  string
	 */
	public function mod_body($path) {
		$ad_body	= '';

		if(trim($_POST['ad_type']) == 'ad_image') {
			/*上传image操作*/
			$ad_body	= $this->mod_file_upload('ad_img','old_ad_img','ad_img_url',$path);

		} elseif(trim($_POST['ad_type'] == 'ad_flash')) {
			/*上传flash操作*/
			$ad_body	= $this->mod_file_upload('ad_flash','old_ad_flash','flash_url',$path);

		} elseif (trim($_POST['ad_type']) == 'ad_text') {
			/*文字内容*/
			$ad_body	= trim($_POST['text_body']);
		} elseif (trim($_POST['ad_type']) == 'ad_code') {
			/*代码内容*/
			$ad_body	= trim($_POST['code_body']);
		}
		return $ad_body;
	}
	/**
	 * mod_file_upload
	 *
	 * 对上传文件的处理
	 * @access  public（权限）
	 * @param   string	$file_name			上传文件名称
	 * @param   string	$old_file_name		以上传文件名称
	 * @param   string	$file_url			远程文件地址
	 * @param   string	$path				上传路径
	 * @return  string
	 */
	public function mod_file_upload($file_name,$old_file_name,$file_url,$path) {
		$file_path					= '';

		$upload_image				= $this->import_class('Image',ROOT_PATH.'/include');
		$upload_image->upload_dir	= $path;

		/*上传文件操作*/
		if($_FILES[$file_name]['name'] != '') {
			$file_path					= $upload_image->upload_image($_FILES[$file_name],'n');

			if($_POST[$old_file_name] != '' and strpos("http",$_POST[$old_file_name]) === false) @unlink(ROOT_PATH.trim($_POST[$old_file_name]));
			return $file_path;
		}
		/*远程文件*/
		if (trim($_POST[$file_url]) != '' and $_FILES[$file_name]['name'] == '') {
			$file_path					= trim($_POST[$file_url]);

			if($_POST[$old_file_name] != '' and strpos("http",$_POST[$old_file_name]) === false and trim($_POST[$old_file_name]) != trim($_POST[$file_url])) {
				@unlink(ROOT_PATH.trim($old_file_name));
			}

			return $file_path;
		}
		/*已有文件*/
		if (trim($_POST[$old_file_name]) != '' and trim($_POST[$file_url]) == '' and $_FILES[$file_name]['name'] == '') {
			$file_path					= trim($_POST[$old_file_name]);
			return $file_path;
		}
		return $file_path;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>