<?php
/***
*
*@package binzcms
*@version $id:AdminMemberClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:22:03 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminMemberClass
 * 会员管理
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminMemberClass.php");
class AdminMemberClass extends ModAdminMemberClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "member_list";
		}
		/*合法action*/
		$this->allow_action	= array(
		'member_list',				//会员列表
		'member_add',				//会员添加
		'member_save',				//会员保存
		'member_del'				//会员删除
		);
		
		parent::__construct($act);
		
		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "member_list";
		}
		
		/*载入语言包*/
		/*
		*AdminMember	对应
		*/
		$this->import_language('AdminMember,AdminCommon');

		$this->$act();
	}
	/**
	 * member_list
	 *
	 * 会员列表
	 * @access  private（权限）
	 * 
	 */
	private function member_list() {
		$this->binz_admin_common->check_admin_power('member_list');
		
		$member_array	= array();
		$perpage		= 10;			//每页记录数

		/*会员列表*/
		$key_words		= trim($_GET['keyword']) != '' ? trim($_GET['keyword']) : '';
		$member_array	= $this->mod_member_list($_GET['binz_page'],$perpage,$key_words);
		$this->binz_tpl->set_var('member_array',$member_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->set_page(array('total'=>$member_array['count']['member_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		/*载入模板*/
		$this->binz_tpl->set_tag('member_list');
	}
	/**
	 * member_add
	 *
	 * 会员添加
	 * @access  private（权限）
	 * 
	 */
	private function member_add() {
		$this->binz_admin_common->check_admin_power('member_add');
		
		$member_info	= array();
		$sex_array		= array(1);
		$year_select	= '';
		$month_select	= '';
		$day_select		= '';

		if(intval($_GET['member_id']) != 0) {
			$member_info	= $this->mod_member_info($_GET['member_id']);
			$sex_array		= array($member_info['member_sex']);
			$birthday		= explode('|',$member_info['member_birthday']);
			$year_select	= $birthday[0];
			$month_select	= $birthday[1];
			$day_select		= $birthday[2];

			$this->binz_tpl->set_var('member_info',$member_info);
		}
		/*广告状态*/
		$this->binz_tpl->set_var('member_sex',$this->binz_common->html_input('member_sex','radio',array(1=>'男',0=>'女'),$sex_array));

		/*出生日期*/
		$this->binz_tpl->set_var('select_year',$this->binz_common->html_select('year',	array_combine(range(1949,2006),range(1949,2006)),'',$year_select));
		$this->binz_tpl->set_var('select_month',$this->binz_common->html_select('month',array_combine(range(1,12),range(1,12)),'',			$month_select));
		$this->binz_tpl->set_var('select_day',$this->binz_common->html_select('day',	array_combine(range(1,31),range(1,31)),'',			$day_select));

		/*载入模板*/
		$this->binz_tpl->set_tag('member_add');
	}
	/**
	 * member_save
	 *
	 * 添加会员/修改会员
	 * @access  private（权限）
	 * 
	 */
	private function member_save() {
		$this->binz_admin_common->check_admin_power('member_add');
		
		$save_state		= false;
		$message		= '';
		$message_false	= '';

		if(intval($_POST['member_id']) != 0) {
			$save_state		= $this->mod_member_edit($_POST['member_id']);
			$message		= $this->binz_tpl->var_all['member_add_edit_ok'];//'会员编辑成功';
			$message_false	= $this->binz_tpl->var_all['member_add_edit_no'];//'会员编辑失败';
		} else {
			$save_state	= $this->mod_member_save();
			$message		= $this->binz_tpl->var_all['member_add_save_ok'];//'会员添加成功';
			$message_false	= $this->binz_tpl->var_all['member_add_save_no'];//'会员添加失败';
		}

		if(intval($save_state) == 2) {//密码为空，或是两次输入的密码不同
			/*跳转页面*/
			$this->binz_common->admin_msg($this->binz_tpl->var_all['member_add_passwd_error'],0,$link,$this->binz_tpl,true,2);
			exit();
		}

		if($save_state) {
			$message			= $message;
			$link[0]['text']	= $this->binz_tpl->var_all['member_click_url'];//'点击此链接到会员列表页面';
			$link[0]['href']	= 'index.php?ctl=member&act=member_list';
		} else {
			$message			= $message_false;
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * member_del
	 *
	 * 会员删除
	 * @access  private（权限）
	 * 
	 */
	private function member_del() {
		$this->binz_admin_common->check_admin_power('member_add');
		
		$del_state		= false;
		$message		= '';

		if((!is_array($_POST['member_id']) and count($_POST['member_id']) <= 0) and intval($_GET['member_id']) == 0) {
			return '';
		}
		$member_id		= is_array($_POST['member_id']) ? $_POST['member_id'] : intval($_GET['member_id']);
		$del_state		= $this->mod_member_del($member_id);

		if($del_state) {
			$message			= $this->binz_tpl->var_all['member_list_del_ok'];//'会员删除成功！';
			$link[0]['text']	= $this->binz_tpl->var_all['member_click_url'];//'点击此链接到会员列表页面';
			$link[0]['href']	= 'index.php?ctl=member&act=member_list&binz_page='.intval($_GET['binz_page']);
		} else {
			$message			= $this->binz_tpl->var_all['member_list_del_no'];//'会员删除失败！';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>