<?php
/***
*
*@package binzcms
*@version $id:AdminIndexClass.php, v 1.0
*@author 斌子
*@Sat Jan 10 00:30:25 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminIndexClass
 * 后台管理首页
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminIndexClass.php");
class AdminIndexClass extends ModAdminIndexClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "admin_index";
		}
		/*合法action*/
		$this->allow_action	= array(
		'admin_index',				//手头首页
		'admin_top',				//头部导航
		'admin_left',				//左侧菜单
		'admin_main',				//右侧住内容区
		'admin_drag',				//关闭、展开
		'about_us',					//关于我们
		'admin_login',				//登录
		'admin_out'					//退出
		);
		
		parent::__construct($act);
		
		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "admin_index";
		}
		
		/*载入语言包*/
		/*
		*AdminIndex	对应 admin_index(),admin_top(),admin_left(),admin_main()
		*AdminAboutUs	对应 about_us()
		*/
		$this->import_language('AdminIndex,AdminAboutUs,AdminCommon');

		$this->$act();
	}
	/**
	 * admin_index
	 *
	 * 后台首页
	 * @access  private（权限）
	 * 
	 */
	private function admin_index() {
		$this->binz_tpl->set_tag('index');
	}
	/**
	 * admin_top
	 *
	 * 首页头部
	 * @access  private（权限）
	 * 
	 */	
	private function admin_top() {

		/*载入模板*/
		$this->binz_tpl->set_tag('top');
	}
	/**
	 * admin_left
	 *
	 * 左下菜单栏
	 * @access  private（权限）
	 * 
	 */
	private function admin_left() {

		/*载入模板*/
		$this->binz_tpl->set_tag('left');
	}
	/**
	 * admin_main
	 *
	 * 右下首页面
	 * @access  private（权限）
	 * 
	 */
	private function admin_main() {

		$cms_sys_info	= $this->mod_index_sys_info();	//得到系统信息

		$this->binz_tpl->set_var($cms_sys_info);		//系统信息
		/*载入模板*/
		$this->binz_tpl->set_tag('main');
	}
	/**
	 * admin_drag
	 *
	 * 下方拖动条
	 * @access  private（权限）
	 * 
	 */
	private function admin_drag() {
		$this->binz_tpl->set_tag('drag');
	}
	/**
	 * about_us
	 *
	 * 关于BINZCMS
	 * @access  private（权限）
	 * 
	 */
	private function about_us() {
		/*载入模板*/
		$this->binz_tpl->set_tag('about_us');
	}
	/**
	 * admin_login
	 *
	 * 管理员登录页面
	 * @access  private（权限）
	 * @param   integer 参数
	 * @return  void	返回类型
	 */
	private function admin_login() {

		/*判断登录信息是否存在*/
		if(!empty($_POST['username']) and !empty($_POST['password']) and !empty($_POST['login_code'])) {
			$login_state	= $this->mod_admin_login();

			if($login_state	== 1) {			//登录成功
				header("Location: ./index.php");
				exit();
			} elseif ($login_state == 2) {	//用户名错误
				$message			= $this->binz_tpl->var_all['admin_login_name_error'];		//'您输入的用户名错误，请从新输入';
			} elseif ($login_state == 3) {	//密码错误
				$message			= $this->binz_tpl->var_all['admin_login_pwd_error'];		//'您输入的密码错误，请从新输入';
			} elseif ($login_state == 4) {	//验证码错误
				$message			= $this->binz_tpl->var_all['admin_login_code_error'];		//'您输入的验证码错误，请从新输入';
			}

			/*跳转页面*/
			$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);

		} else {
			$this->binz_tpl->set_var('binz_code',$this->binz_common->create_binz_code($this->binz_tpl->var_all['admin_login_code_info']));
			/*载入模板*/
			$this->binz_tpl->set_tag('admin_login');
		}
	}
	/**
	 * admin_out
	 *
	 * 管理员退出
	 * @access  private（权限）
	 * 
	 */
	private function admin_out() {

		$this->mod_admin_out();
		$message			= $this->binz_tpl->var_all['admin_out_ok'];			//'管理员退出成功';
		$link[0]['text']	= $this->binz_tpl->var_all['admin_out_click'];		//'点此返回登录页面';
		$link[0]['href']	= 'index.php?ctl=index&act=admin_login';
		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>