<?php
/***
*
*@package binzcms
*@version $id:AdminHtmlClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:21:03 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminHtmlClass
 * html生成管理
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminHtmlClass.php");
class AdminHtmlClass extends ModAdminHtmlClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "create_index";
		}
		/*合法action*/
		$this->allow_action	= array(
		'create_index',				//生成主页页面
		'create_index_html',		//生成首页操作
		'create_class',				//生成频道
		'create_content',			//生成内容
		'create_map'				//生成地图
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "create_index";
		}

		/*载入语言包*/
		/*
		*AdminHtml		对应
		*/
		$this->import_language('AdminHtml,AdminCommon');

		$this->$act();
	}
	/**
	 * create_index
	 *
	 * 生成首页页面
	 * @access  private（权限）
	 * 
	 */
	private function create_index() {
		/*载入模板*/
		$this->binz_tpl->set_tag('html_create_index');
	}
	/**
	 * create_index_html
	 *
	 * 生成首页
	 * @access  public（权限）
	 * 
	 */
	private function create_index_html() {
		$create_state	= false;

		$create_state	= $this->mod_create_index_html();
		if($create_state) {
			$message			= '首页生成成功';
			$link[0]['text']	= '查看已生成首页';
			$link[0]['href']	= WEB_HOST.trim($_POST['index_file']).'" target="_blank';
			$link[1]['text']	= '返回生成页面';
			$link[1]['href']	= 'index.php?ctl=html&act=create_index';
			$redirect			= false;
		} else {
			$message			= '首页生成失败，请检查生成目录的权限';
			$redirect			= true;
		}
		
		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,$redirect);
	}
	/**
	 * create_class
	 *
	 * 频道生成页面
	 * @access  private（权限）
	 * 
	 */
	private function create_class() {
		/*载入模板*/
		$this->binz_tpl->set_tag('html_create_class');
	}
	/**
	 * create_content
	 *
	 * 内容生成页面
	 * @access  private（权限）
	 * 
	 */
	private function create_content() {
		/*载入模板*/
		$this->binz_tpl->set_tag('html_create_content');
	}
	/**
	 * create_map
	 *
	 * 地图生成页面
	 * @access  private（权限）
	 * 
	 */
	private function create_map() {
		/*载入模板*/
		$this->binz_tpl->set_tag('html_create_map');
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>