<?php
/***
*
*@package binzcms
*@version $id:AdminFlinkClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:19:34 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminFlinkClass
 * 友情链接管理
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminFlinkClass.php");
class AdminFlinkClass extends ModAdminFlinkClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "flink_manage";
		}
		/*合法action*/
		$this->allow_action	= array(
		'flink_manage',				//友情链接列表
		'flink_add',				//友情链接添加
		'flink_save',				//友情链接保存
		'flink_del'					//友情链接删除
		);
		
		parent::__construct($act);
		
		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "flink_manage";
		}
		
		/*载入语言包*/
		/*
		*AdminFlink		对应
		*/
		$this->import_language('AdminFlink,AdminCommon');

		$this->$act();
	}
	/**
	 * flink_manage
	 *
	 * 友情链接列表
	 * @access  private（权限）
	 *
	 */
	private function flink_manage() {
		$this->binz_admin_common->check_admin_power('flink_manage');
		
		$flink_array		= array();

		$flink_array		= $this->mod_flink_list();
		$this->binz_tpl->set_var('flink_array',$flink_array);

		/*载入模板*/
		$this->binz_tpl->set_tag('friend_link');
	}
	/**
	 * flink_add
	 *
	 * 友情链接添加
	 * @access  private（权限）
	 *
	 */
	private function flink_add() {
		$this->binz_admin_common->check_admin_power('flink_manage');
		
		$flink_info		= array();

		/*编辑友情链接信息*/
		if(intval($_GET['flink_id']) != 0) {
			$flink_info		= $this->mod_flink_info($_GET['flink_id']);
			$this->binz_tpl->set_var('flink_info',$flink_info);
		}
		/*载入模板*/
		$this->binz_tpl->set_tag('friend_link_add');
	}
	/**
	 * flink_save
	 *
	 * 友情链接保存
	 * @access  private（权限）
	 * 
	 */
	private function flink_save() {
		$this->binz_admin_common->check_admin_power('flink_manage');
		
		$upload_path			= 'upload/logo';			//logo上传地址
		$insert_state			= false;
		$message				= '';
		$message_false			= '';
		$image_path				= '';

		/*上传logo图片*/
		$image_path				= $this->mod_logo_upload($upload_path);

		if(intval($_POST['flink_id']) != '') {
			$insert_state		= $this->mod_flink_edit($_POST['flink_id'],$image_path);
			$message			= $this->binz_tpl->var_all['flink_add_edit_ok'];//'友情链接修改成功';
			$message_false		= $this->binz_tpl->var_all['flink_add_edit_no'];//'友情链接修改失败';	
		} else {
			/*保存友情链接信息*/
			$insert_state		= $this->mod_flink_save($image_path);
			$message			= $this->binz_tpl->var_all['flink_add_save_ok'];//'友情链接添加成功';
			$message_false		= $this->binz_tpl->var_all['flink_add_save_no'];//'友情链接添加失败';
		}

		if($insert_state) {
			$message			= $message;
			$link[0]['text']	= $this->binz_tpl->var_all['flink_add_click_url'];//'点击此链接到友情列表页面';
			$link[0]['href']	= 'index.php?ctl=flink&act=flink_manage';
		} else {
			$message			= $message_false;
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * flink_del
	 *
	 * 友情链接删除
	 * @access  private（权限）
	 * 
	 */
	private function flink_del() {
		$this->binz_admin_common->check_admin_power('flink_manage');
		
		$del_state		= false;
		$message		= '';
		
		$del_state		= $this->mod_flink_del($_GET['flink_id']);
		if($del_state) {
			$message	= $this->binz_tpl->var_all['flink_list_del_ok'];//'友情链接删除成功';
		} else {
			$message	= $this->binz_tpl->var_all['flink_list_del_no'];//'友情链接删除失败';
		}
		
		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>