<?php
/***
*
*@package binzcms
*@version $id:AdminDataClass.php, v 1.0
*@author 斌子
*@Thu Jan 15 01:18:38 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminDataClass
 * 数据库管理
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminDataClass.php");
class AdminDataClass extends ModAdminDataClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "data_back";
		}
		/*合法action*/
		$this->allow_action	= array(
		'data_back',				//数据库备份页面
		'run_data_back',			//数据库备份操作
		'data_revert',				//数据库还原页面
		'run_data_import',			//数据库还原操作
		'sql_del',					//sql文件删除
		'data_optimize',			//数据库优化页面
		'run_data_optimize',		//数据库优化操作
		'data_sql',					//数据库语句操作页面
		'query_sql'					//数据库语句执行操作
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "data_back";
		}

		/*载入语言包*/
		/*
		*AdminData		对应
		*/
		$this->import_language('AdminData,AdminCommon');

		$this->$act();
	}
	/**
	 * data_back
	 *
	 * 备份数据库页面
	 * @access  private（权限）
	 * 
	 */
	private function data_back() {
		$this->binz_admin_common->check_admin_power('data_back');

		/*随机备份数据库文件名称*/
		$back_file_rand	= range('a','z');
		$this->binz_tpl->set_var('back_file_name',$back_file_rand[rand(0,25)].$back_file_rand[rand(0,25)].$back_file_rand[rand(0,25)].$back_file_rand[rand(0,25)].date('Ymd').'.sql');

		/*载入模板*/
		$this->binz_tpl->set_tag('data_back');
	}
	/**
	 * run_data_back
	 *
	 * 数据库备份操作
	 * @access  private（权限）
	 * 
	 */
	private function run_data_back() {
		$this->binz_admin_common->check_admin_power('data_back');

		$back_state		= false;
		$back_path		= ROOT_PATH.'/data/databack';
		$message		= '';

		if(!$this->binz_common->write_file($back_path)) {

			/*没有写权限，跳转页面*/
			$this->binz_common->admin_msg($this->binz_tpl->var_all['data_check_sql_dir'],0,$link,$this->binz_tpl,true);
			exit();
		}
		$back_state= $this->mod_run_data_back($back_path);

		/*备份失败*/
		if($back_state[0] == 0) {
			$message	= $back_state[1]['name'].$this->binz_tpl->var_all['data_backup_error'];
		}

		/*备份成功*/
		if($back_state[0] == 1) {
			$message	= $this->binz_tpl->var_all['data_backup_ok'].'<br>'.implode(',<br>',$back_state[1]);
			$link[0]['text']	= $this->binz_tpl->var_all['data_backup_click_url'];
			$link[0]['href']	= 'index.php?ctl=data&act=data_revert';
		}

		/*多卷，继续进行备份*/
		if($back_state[0] == 2) {
			$message			= $back_state[1]['file_name'].$this->binz_tpl->var_all['data_backup_create_ok'];
			$link[0]['text']	= $this->binz_tpl->var_all['data_backup_create_next'];
			$link[0]['href']	= $back_state[1]['name'];
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * data_revert
	 *
	 * 数据库还原页面
	 * @access  private（权限）
	 * 
	 */
	private function data_revert() {
		$this->binz_admin_common->check_admin_power('data_revert');

		$array	= array();
		$path	= ROOT_PATH . '/data/databack/';

		$array	= $this->mod_data_revert_show($path);
		$this->binz_tpl->set_var('array',$array);

		/*载入模板*/
		$this->binz_tpl->set_tag('data_revert');
	}
	/**
	 * run_data_import
	 *
	 * 进行数据库还原
	 * @access  private（权限）
	 * 
	 */
	private function run_data_import() {
		$this->binz_admin_common->check_admin_power('data_revert');

		$import_state	= false;
		$path			= ROOT_PATH . '/data/databack/';

		$import_state	= $this->mod_run_data_import($path);

		if($import_state) {
			$message			= $this->binz_tpl->var_all['data_import_ok'];
			$link[0]['text']	= $this->binz_tpl->var_all['data_import_click_url'];
			$link[0]['href']	= 'index.php?ctl=data&act=data_revert';
		} else {
			$message			= $this->binz_tpl->var_all['data_import_false'];
			$link[0]['text']	= $this->binz_tpl->var_all['data_import_click_url'];
			$link[0]['href']	= 'index.php?ctl=data&act=data_revert';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * sql_del
	 *
	 * 数据文件删除
	 * @access  private（权限）
	 * 
	 */
	private function sql_del() {
		$this->binz_admin_common->check_admin_power('data_revert');

		$del_state		= false;
		$path			= ROOT_PATH . '/data/databack/';

		$del_state		= $this->mod_sql_del($path);

		if($del_state) {
			$message			= $this->binz_tpl->var_all['data_del_ok'];
			$link[0]['text']	= $this->binz_tpl->var_all['data_del_click_url'];
			$link[0]['href']	= 'index.php?ctl=data&act=data_revert';
		} else {
			$message			= $this->binz_tpl->var_all['data_del_false'];
			$link[0]['text']	= $this->binz_tpl->var_all['data_del_click_url'];
			$link[0]['href']	= 'index.php?ctl=data&act=data_revert';
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * data_optimize
	 *
	 * 数据表优化页面
	 * @access  private（权限）
	 * 
	 */
	private function data_optimize() {
		$this->binz_admin_common->check_admin_power('data_optimize');

		/*得到数据表信息*/
		$data_info	= array();
		$data_info	= $this->mod_data_optimize_show();
		$this->binz_tpl->set_var('data_info',$data_info);

		/*载入模板*/
		$this->binz_tpl->set_tag('data_optimize');
	}
	/**
	 * run_data_optimize
	 *
	 * 执行数据表优化操作
	 * @access  private（权限）
	 * 
	 */
	private function run_data_optimize() {
		$this->binz_admin_common->check_admin_power('data_optimize');

		$message	= '';
		$link		= array();

		$this->mod_run_data_optimize();
		$message	= $this->binz_tpl->var_all['data_optimize_ok'].$_POST['all_chip_count'];

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true);
	}
	/**
	 * data_sql
	 *
	 * 执行SQL语句页面
	 * @access  private（权限）
	 * 
	 */
	private function data_sql() {
		$this->binz_tpl->set_tag('data_sql');
	}
	/**
	 * query_sql
	 *
	 * 执行SQL语句
	 * @access  private（权限）
	 * 
	 */
	private function query_sql() {
		if($_SESSION['admin_id'] != 1) {
			$this->binz_common->admin_msg($this->binz_tpl->var_all['data_sql_power'],0,$link,$this->binz_tpl,true);
		}
		/*sql语句执行*/
		$query_info	= $this->mod_query_sql();
		$state		= intval($query_info['state']);
		if($state == 0) {
			$this->binz_tpl->set_var('state',$state);
			$this->binz_tpl->set_var('message',$query_info['message']);
		}
		if($state == 1) {
			$this->binz_tpl->set_var('state',$state);
			$this->binz_tpl->set_var('message',$this->binz_tpl->var_all['data_sql_ok']);			
		}
		if($state == 2) {
			$this->binz_tpl->set_var('state',$state);
			$this->binz_tpl->set_var('message',$query_info['message']);			
		}
		$this->binz_tpl->set_var('sql',$query_info['sql']);
		$this->binz_tpl->set_var('show','yes');
		$this->binz_tpl->set_tag('data_sql');
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>
