<?php
/***
*
*@package binzcms
*@version $id:AdminClassClass.php, v 1.0
*@author 斌子
*@Tue Jan 13 23:48:23 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * AdminClassClass
 * 频道管理
 * 
 */
include(ADMIN_MOD_PATH."/ModAdminClassClass.php");
class AdminClassClass extends ModAdminClassClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "class_list";
		}
		/*合法action*/
		$this->allow_action	= array(
		'class_list',				//频道列表
		'class_add',				//频道添加
		'move_show',				//频道移动页面
		'move_save',				//频道移动操作
		'class_save',				//频道保存
		'class_del',				//频道删除
		'class_type',				//频道类型
		'class_type_add',			//频道类型添加
		'class_type_save',			//频道类型保存
		'class_type_del'			//频道类型删除
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "class_list";
		}

		/*载入语言包*/
		/*
		* AdminClass		对应	class_list(),class_add(),class_save()
		*/
		$this->import_language('AdminClass,AdminCommon');

		$this->$act();
	}
	/**
	 * class_list
	 *
	 * 频道列表
	 * @access  private（权限）
	 * 
	 */
	private function class_list() {
		$this->binz_admin_common->check_admin_power('class_list');

		$class_array	= array();
		$class_array	= $this->mod_class_array();
		$this->binz_tpl->set_var('class_array',$class_array);
		/*载入模板*/
		$this->binz_tpl->set_tag('article_class_list');
	}
	/**
	 * class_add
	 *
	 * 添加频道页面
	 * @access  private（权限）
	 * 
	 */
	private function class_add() {
		$this->binz_admin_common->check_admin_power('class_add');

		$top_array		= $this->mod_class_select();
		$type_array		= $this->mod_class_type_list();
		$state_array	= array(1=>$this->binz_tpl->var_all['class_state_yes'],0=>$this->binz_tpl->var_all['class_state_no']);
		$top_menu_array	= array(1=>$this->binz_tpl->var_all['class_yes'],0=>$this->binz_tpl->var_all['class_no']);
		$index_array	= array(1=>$this->binz_tpl->var_all['class_yes'],0=>$this->binz_tpl->var_all['class_no']);

		$top_select		= '';
		$state_select	= array(1);
		$top_class_select 	= array(1);
		$index_class_select = array(1);
		
		if(intval($_GET['class_id']) != 0) {				//编辑分类
			$class_info		= array();
			$class_info		= $this->mod_class_info(intval($_GET['class_id']));
			$top_select		= $class_info['class_top_id'];
			$state_select	= array($class_info['class_state']);
			$top_class_select 	= array($class_info['top_menu']);
			$index_class_select = array($class_info['index_class']);
			$this->binz_tpl->set_var('class_info',$class_info);

		} elseif (intval($_GET['class_top_id']) !=0) {		//添加子分类
			$top_select			= intval($_GET['class_top_id']);
		}

		$this->binz_tpl->set_var('top_select',				//上级频道选择
		$this->binz_common->html_select('class_top_id',$top_array,array($this->binz_tpl->var_all['class_top_select']),$top_select));

		$this->binz_tpl->set_var('type_select',$type_array);//频道类型选择

		$this->binz_tpl->set_var('state_radio',				//频道状态选择
		$this->binz_common->html_input('class_state','radio',$state_array,$state_select));

		$this->binz_tpl->set_var('top_radio',				//频道状态选择
		$this->binz_common->html_input('class_top','radio',$top_menu_array,$top_class_select));

		$this->binz_tpl->set_var('index_radio',				//频道状态选择
		$this->binz_common->html_input('class_index','radio',$index_array,$index_class_select));

		/*载入模板*/
		$this->binz_tpl->set_tag('article_class_add');
	}
	/**
	 * class_save
	 *
	 * 频道保存
	 * @access  private（权限）
	 * 
	 */
	private function class_save() {
		$this->binz_admin_common->check_admin_power('class_add');

		$message		= '';
		$false_message	= '';

		/*得到模板类型*/
		$class_type_info= $this->mod_class_type_info($_POST['class_type_id']);
		$_POST['class_type_tag']	= $class_type_info['class_type_tag'];

		if(intval($_POST['class_id']) == 0) {
			/*分类保存操作*/
			$save_state		= $this->mod_class_save();
			$class_id		= $this->binz_db->last_insert_id();

			$message		= $this->binz_tpl->var_all['class_add_yes'];
			$false_message	= $this->binz_tpl->var_all['class_add_no'];
		} else {
			/*分类编辑操作*/
			$save_state		= $this->mod_class_edit($_POST['class_id']);
			$class_id		= intval($_POST['class_id']);

			$message		= $this->binz_tpl->var_all['class_edit_yes'];
			$false_message	= $this->binz_tpl->var_all['class_edit_no'];
		}

		/*检查是否为其子级分类*/
		if(intval($save_state) == 2) {
			$message			= $this->binz_tpl->var_all['class_del_error'];//'该分类为当前分类的子级分类，不能正常修改！';
			$redirect			= true;
			$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,$redirect);
		}

		if($save_state) {
			/*添加链接*/
			$link[0]['text']	= $this->binz_tpl->var_all['link_class_view'];	//'查看频道列表';
			$link[0]['href']	= 'index.php?ctl=class&act=class_list';

			$link[1]['text']	= $this->binz_tpl->var_all['link_class_add'];	//'继续添加频道';
			$link[1]['href']	= 'index.php?ctl=class&act=class_add';

			$link[2]['text']	= $this->binz_tpl->var_all['link_class_edit'];	//'编辑当前频道';
			$link[2]['href']	= 'index.php?ctl=class&act=class_add&class_id='.$class_id;

			$redirect			= false;
		} else {
			$message			= $false_message;
			$redirect			= true;
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,$redirect);
	}
	/**
	 * move_show
	 *
	 * 移动分类页面
	 * @access  private（权限）
	 * 
	 */
	private function move_show() {
		$this->binz_admin_common->check_admin_power('class_add');

		$start_class	= array();									//频道数组初始化
		$move_class		= array();									//目标频道数组初始化
		$move_type		= array(1=>$this->binz_tpl->var_all['class_move_class'],2=>$this->binz_tpl->var_all['class_move_content']);

		$start_class	= $this->mod_class_info($_GET['class_id']);	//获取频道信息
		$move_class		= $this->mod_class_select();				//获取分类数组

		$this->binz_tpl->set_var($start_class);						//要进行移动的频道

		$this->binz_tpl->set_var('move_class_select',				//移动到的频道
		$this->binz_common->html_select('move_class_id',$move_class));

		$this->binz_tpl->set_var('move_radio',						//移动类型
		$this->binz_common->html_input('move_type','radio',$move_type,array(1)));
		/*载入模板*/
		$this->binz_tpl->set_tag('article_class_move');
	}
	/**
	 * move_save
	 *
	 * 移动操作，包括移动分类或是移动分类内的记录
	 * @access  public（权限）
	 * @param   integer 参数
	 * @return  void	返回类型
	 */
	private function move_save() {
		$this->binz_admin_common->check_admin_power('class_add');

		$move_state		= false;
		$message		= '';

		$move_state		= $this->mod_class_move($_POST['class_id'],$_POST['move_type']);
		/*检查是否为其子级分类*/
		if(intval($save_state) == 2) {
			$message			= $this->binz_tpl->var_all['class_move_error'];//'该分类为当前分类的子级分类，不能正常修改！';
			$redirect			= true;
			$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,$redirect);
		}
		if($move_state) {
			$message			= $this->binz_tpl->var_all['class_move_yes'];//'移动操作成功！';
			$link[0]['text']	= $this->binz_tpl->var_all['class_move_click_url'];//'点击此链接返回分类列表';
			$link[0]['href']	= 'index.php?ctl=class&act=class_list';
		} else {
			$message			= $this->binz_tpl->var_all['class_move_no'];//'移动操作失败！';
		}
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true);
	}
	/**
	 * class_del
	 *
	 * 频道删除
	 * @access  private（权限）
	 * 
	 */
	private function class_del() {
		$this->binz_admin_common->check_admin_power('class_add');

		$message	= '';

		/*删除分类*/
		$del_state	= $this->mod_class_del($_GET['class_id']);
		if($del_state) {
			$message			= $this->binz_tpl->var_all['class_del_yes'];
		} else {
			$message			= $this->binz_tpl->var_all['class_del_no'];

		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true);
	}
	/**
	 * class_type
	 *
	 * 频道类型
	 * @access  private（权限）
	 *
	 */
	private function class_type() {
		$this->binz_admin_common->check_admin_power('class_type');

		$class_type_array	= array();

		$class_type_array	= $this->mod_class_type_list();
		$this->binz_tpl->set_var('class_type_array',$class_type_array);

		/*载入模板*/
		$this->binz_tpl->set_tag('class_type');
	}
	/**
	 * class_type_add
	 *
	 * 频道类型添加页面
	 * @access  private（权限）
	 *
	 */	
	private function class_type_add() {
		$this->binz_admin_common->check_admin_power('class_type');

		if(!empty($_GET['class_type_id']) and intval($_GET['class_type_id']) != 0) {
			/*禁止修改系统内置频道类型*/
			if($_GET['class_type_id'] == 1 or $_GET['class_type_id'] == 2) {
				$this->binz_common->admin_msg($this->binz_tpl->var_all['class_type_no_edit'],0,$link,$this->binz_tpl,true);
				exit;
			}

			$class_type_info	= array();
			$class_type_info	= $this->mod_class_type_info($_GET['class_type_id']);
			$this->binz_tpl->set_var('class_type_info',$class_type_info);
		}

		/*载入模板*/
		$this->binz_tpl->set_tag('class_type_add');
	}
	/**
	 * class_type_save
	 *
	 * 频道模板类型添加编辑操作
	 * @access  private（权限）
	 * 
	 */
	private function class_type_save() {
		$this->binz_admin_common->check_admin_power('class_type');

		$_POST['class_type_id'] = intval($_POST['class_type_id']);
		if($_POST['class_type_id'] == 1 or $_POST['class_type_id'] == 2) {
			$this->binz_common->admin_msg($this->binz_tpl->var_all['class_type_no_edit'],0,$link,$this->binz_tpl,true);
			exit;
		}

		$message		= '';
		$false_message	= '';
		$save_state		= false;
		if($_POST['class_type_id'] != 0) {		//频道类型编辑
			$save_state		= $this->mod_class_type_edit($_POST['class_type_id']);
			$class_type_id	= intval($_POST['class_type_id']);
			$message		= $this->binz_tpl->var_all['class_type_edit_ok'];
			$false_message	= $this->binz_tpl->var_all['class_type_edit_no'];
		} else {										//频道类型添加
			$save_state		= $this->mod_class_type_save();
			$class_type_id	= $this->binz_db->last_insert_id();
			$message		= $this->binz_tpl->var_all['class_type_add_ok'];
			$false_message	= $this->binz_tpl->var_all['class_type_add_no'];
		}
		if($save_state) {
			$link[0]['text']	= $this->binz_tpl->var_all['class_type_list'];		//'返回频道类型列表';
			$link[0]['href']	= 'index.php?ctl=class&act=class_type';

			$link[1]['text']	= $this->binz_tpl->var_all['class_type_edit_one'];	//'编辑当前频道类型';
			$link[1]['href']	= 'index.php?ctl=class&act=class_type_add&class_type_id='.$class_type_id;

			$link[1]['text']	= $this->binz_tpl->var_all['class_type_add_one'];	//'继续添加频道类型';
			$link[1]['href']	= 'index.php?ctl=class&act=class_type_add&class_type_id';


			$message			= $message;
			$redirect			= false;
		} else {
			$message			= $false_message;
			$redirect			= true;
		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,$redirect);
	}
	/**
	 * class_type_del
	 *
	 * 频道类型删除
	 * @access  private（权限）
	 * 
	 */
	private function class_type_del() {
		$this->binz_admin_common->check_admin_power('class_type');

		$message	= '';
		$del_state	= $this->mod_class_type_del($_GET['class_type_id']);

		if($del_state) {
			$message			= $this->binz_tpl->var_all['class_type_del_ok'];
		} else {
			$message			= $this->binz_tpl->var_all['class_type_del_no'];

		}

		/*跳转页面*/
		$this->binz_common->admin_msg($message,0,$link,$this->binz_tpl,true);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {
		$this->binz_tpl->clear_var();
	}
}
?>