SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
--
-- 数据库: `pubgatewei`
--

-- --------------------------------------------------------

--
-- 表的结构 `g_articlecategory`
--

CREATE TABLE IF NOT EXISTS `g_articlecategory` (
  `acid` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `categorytitle` char(255) NOT NULL,
  `ord` int(11) NOT NULL,
  `articlecount` int(11) NOT NULL,
  `displayway` tinyint(4) NOT NULL,
  `hlightway` tinyint(1) NOT NULL,
  `pagerecords` int(11) NOT NULL,
  `dateformat` char(10) NOT NULL,
  PRIMARY KEY (`acid`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

--
-- 导出表中的数据 `g_articlecategory`
--

INSERT INTO `g_articlecategory` (`acid`, `pid`, `categorytitle`, `ord`, `articlecount`, `displayway`, `hlightway`, `pagerecords`, `dateformat`) VALUES
(1, 0, '新闻中心', 1, 0, 1, 0, 20, 'Y年n月j日'),
(2, 1, '公司新闻', 2, 0, 1, 0, 20, 'Y年n月j日'),
(3, 0, '关于我们', 3, 0, 1, 0, 10, 'Y年n月j日');

-- --------------------------------------------------------

--
-- 表的结构 `g_articles`
--

CREATE TABLE IF NOT EXISTS `g_articles` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `useraccount` char(50) NOT NULL,
  `ip1` tinyint(1) unsigned NOT NULL,
  `ip2` tinyint(1) unsigned NOT NULL,
  `ip3` tinyint(1) unsigned NOT NULL,
  `ip4` tinyint(1) unsigned NOT NULL,
  `status` tinyint(1) NOT NULL,
  `ord` int(11) NOT NULL,
  `tag` tinyint(4) NOT NULL,
  `hlight` tinyint(4) NOT NULL,
  `articletitle` char(240) NOT NULL,
  `pid` int(11) NOT NULL,
  `categoryid` int(11) NOT NULL,
  `top` tinyint(1) NOT NULL,
  `view` int(11) NOT NULL,
  `review` int(11) NOT NULL,
  `subtime` int(11) NOT NULL,
  PRIMARY KEY (`aid`),
  KEY `pid` (`pid`,`categoryid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `g_article_content`
--

CREATE TABLE IF NOT EXISTS `g_article_content` (
  `aid` int(10) unsigned NOT NULL,
  `content` text NOT NULL,
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 表的结构 `g_attachments`
--

CREATE TABLE IF NOT EXISTS `g_attachments` (
  `fid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bid` int(10) unsigned NOT NULL,
  `typeid` int(10) unsigned NOT NULL,
  `name` char(255) NOT NULL,
  `storename` char(255) NOT NULL,
  `size` int(11) NOT NULL,
  `islogo` tinyint(1) NOT NULL,
  `isimage` tinyint(1) NOT NULL,
  `type` char(255) NOT NULL,
  `downtimes` int(11) unsigned NOT NULL,
  `subtime` int(11) NOT NULL,
  PRIMARY KEY (`fid`),
  KEY `bid` (`bid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `g_forgetpassword_mailcode`
--

CREATE TABLE IF NOT EXISTS `g_forgetpassword_mailcode` (
  `uid` int(11) NOT NULL,
  `emailcode` char(50) NOT NULL,
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 表的结构 `g_forumcategory`
--

CREATE TABLE IF NOT EXISTS `g_forumcategory` (
  `forid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL,
  `upstatus` int(10) unsigned NOT NULL,
  `threads` int(10) unsigned NOT NULL,
  `posts` int(10) unsigned NOT NULL,
  `todayposts` int(10) unsigned NOT NULL,
  `forumtitle` char(100) NOT NULL,
  `ord` bigint(11) unsigned NOT NULL,
  `access` tinyint(1) NOT NULL,
  `accesspwd` char(50) NOT NULL,
  `accessgroup` int(10) unsigned NOT NULL,
  `forumurl` char(255) NOT NULL,
  `lastpost` char(255) NOT NULL,
  `pagerecords` int(10) unsigned NOT NULL,
  `dateformat` char(10) NOT NULL,
  `hlightway` tinyint(4) NOT NULL,
  PRIMARY KEY (`forid`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=34 ;

--
-- 导出表中的数据 `g_forumcategory`
--

INSERT INTO `g_forumcategory` (`forid`, `pid`, `upstatus`, `threads`, `posts`, `todayposts`, `forumtitle`, `ord`, `access`, `accesspwd`, `accessgroup`, `forumurl`, `lastpost`, `pagerecords`, `dateformat`, `hlightway`) VALUES
(1, 0, 0, 0, 0, 0, '咨询交流', 0, 0, '', 0, '', '', 20, 'Y-n-j', 0),
(2, 1, 0, 0, 0, 0, '在线交流', 0, 0, '', 0, '', '', 20, 'Y-n-j', 0);

-- --------------------------------------------------------

--
-- 表的结构 `g_friendlylink`
--

CREATE TABLE IF NOT EXISTS `g_friendlylink` (
  `frid` int(11) NOT NULL AUTO_INCREMENT,
  `top` int(11) NOT NULL,
  `sitename` char(255) NOT NULL,
  `siteurl` char(255) NOT NULL,
  `sitelogo` char(255) NOT NULL,
  PRIMARY KEY (`frid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 导出表中的数据 `g_friendlylink`
--

INSERT INTO `g_friendlylink` (`frid`, `top`, `sitename`, `siteurl`, `sitelogo`) VALUES
(1, 1274772916, 'gatewei建站引擎', 'http://www.gatewei.com', '');

-- --------------------------------------------------------

--
-- 表的结构 `g_groups`
--

CREATE TABLE IF NOT EXISTS `g_groups` (
  `gid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupname` char(50) CHARACTER SET utf8 NOT NULL,
  `type` tinyint(1) NOT NULL,
  `isregister` tinyint(1) NOT NULL,
  `checkregister` tinyint(1) NOT NULL,
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- 导出表中的数据 `g_groups`
--

INSERT INTO `g_groups` (`gid`, `groupname`, `type`, `isregister`, `checkregister`) VALUES
(1, '管理员', 1, 0, 2),
(2, '内部员工', 1, 1, 2),
(3, '普通会员', 1, 1, 0),
(4, '游客', 1, 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `g_members`
--

CREATE TABLE IF NOT EXISTS `g_members` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `userid` char(50) NOT NULL,
  `username` char(100) DEFAULT NULL,
  `userface` char(20) NOT NULL,
  `email` char(255) NOT NULL,
  `gid` int(4) unsigned NOT NULL,
  `postcount` int(11) unsigned NOT NULL,
  `userpwd` char(50) NOT NULL,
  `logintimes` int(11) NOT NULL,
  `registerip` char(20) NOT NULL,
  `state` tinyint(1) NOT NULL,
  `registertime` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 导出表中的数据 `g_members`
--

INSERT INTO `g_members` (`uid`, `userid`, `username`, `userface`, `email`, `gid`, `postcount`, `userpwd`, `logintimes`, `registerip`, `state`, `registertime`) VALUES
(1, 'admin', '管理员', '01.png', 'gatewei@126.com', 1, 0, '7fef6171469e80d32c0559f88b377245', 0, '127.0.0.1', 0, 1259564568);

--
-- 表的结构 `g_member_info`
--

CREATE TABLE IF NOT EXISTS `g_member_info` (
  `uid` int(10) unsigned NOT NULL,
  `msgboxcount` tinyint(4) NOT NULL,
  `lastlogintime` int(10) unsigned NOT NULL,
  `logintimes` int(10) unsigned NOT NULL,
  `sex` tinyint(1) NOT NULL,
  `phone` char(20) NOT NULL,
  `mobile` char(20) NOT NULL,
  `qq` char(20) NOT NULL,
  `address` char(200) NOT NULL,
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 导出表中的数据 `g_member_info`
--

INSERT INTO `g_member_info` (`uid`, `msgboxcount`, `lastlogintime`, `logintimes`, `sex`, `phone`, `mobile`, `qq`, `address`) VALUES
(1, 0, 0, 0, 0, '', '', '', '');

-- --------------------------------------------------------

--
-- 表的结构 `g_member_mailcode`
--

CREATE TABLE IF NOT EXISTS `g_member_mailcode` (
  `uid` int(10) unsigned NOT NULL,
  `emailcode` char(50) NOT NULL,
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 表的结构 `g_member_msg`
--

CREATE TABLE IF NOT EXISTS `g_member_msg` (
  `mmid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `userid` char(50) NOT NULL,
  `title` char(100) NOT NULL,
  `content` varchar(600) NOT NULL,
  `sendtime` int(10) unsigned NOT NULL,
  `readed` tinyint(1) NOT NULL,
  `senderid` int(10) unsigned NOT NULL,
  `sender` char(50) NOT NULL,
  `sendergid` int(10) unsigned NOT NULL,
  PRIMARY KEY (`mmid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `g_msgs`
--

CREATE TABLE IF NOT EXISTS `g_msgs` (
  `msgid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` char(100) NOT NULL,
  `content` varchar(600) NOT NULL,
  `ismulticast` tinyint(1) NOT NULL,
  `isbroadcast` tinyint(1) NOT NULL,
  `recgid` int(10) unsigned NOT NULL,
  `senderid` int(10) unsigned NOT NULL,
  `sender` int(11) NOT NULL,
  `sendergid` int(10) unsigned NOT NULL,
  `sendtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`msgid`),
  KEY `gid` (`recgid`,`senderid`,`sendtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `g_permission`
--

CREATE TABLE IF NOT EXISTS `g_permission` (
  `perid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gid` int(10) unsigned NOT NULL,
  `pervalue` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`perid`),
  KEY `gid` (`gid`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- 导出表中的数据 `g_permission`
--

INSERT INTO `g_permission` (`perid`, `gid`, `pervalue`) VALUES
(1, 1, 524287),
(2, 2, 524272),
(3, 3, 184144),
(4, 4, 0);

--
-- 表的结构 `g_productcategory`
--

CREATE TABLE IF NOT EXISTS `g_productcategory` (
  `pcid` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `categorytitle` char(255) NOT NULL,
  `ord` int(11) NOT NULL,
  `productcount` int(11) NOT NULL,
  `displayway` tinyint(4) NOT NULL,
  `hlightway` tinyint(1) NOT NULL,
  `pagerecords` int(11) NOT NULL,
  `dateformat` char(10) NOT NULL,
  PRIMARY KEY (`pcid`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 导出表中的数据 `g_productcategory`
--

INSERT INTO `g_productcategory` (`pcid`, `pid`, `categorytitle`, `ord`, `productcount`, `displayway`, `hlightway`, `pagerecords`, `dateformat`) VALUES
(1, 0, '产品一类', 1, 0, 0, 0, 10, 'Y-n-j'),
(2, 0, '产品二类', 2, 0, 0, 0, 10, 'Y-n-j');

-- --------------------------------------------------------

--
-- 表的结构 `g_products`
--

CREATE TABLE IF NOT EXISTS `g_products` (
  `productid` int(11) NOT NULL AUTO_INCREMENT,
  `ord` int(11) NOT NULL,
  `tag` tinyint(4) NOT NULL,
  `hlight` tinyint(4) NOT NULL,
  `ip1` tinyint(1) NOT NULL,
  `ip2` tinyint(1) NOT NULL,
  `ip3` tinyint(1) NOT NULL,
  `ip4` tinyint(1) NOT NULL,
  `uid` int(11) NOT NULL,
  `useraccount` char(50) NOT NULL,
  `producttitle` char(240) NOT NULL,
  `productintro` char(255) NOT NULL,
  `pid` int(11) NOT NULL,
  `categoryid` int(11) NOT NULL,
  `top` tinyint(1) NOT NULL,
  `view` int(11) unsigned NOT NULL,
  `review` int(11) unsigned NOT NULL,
  `subtime` int(11) unsigned NOT NULL,
  PRIMARY KEY (`productid`),
  KEY `pid` (`pid`,`categoryid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `g_product_content`
--

CREATE TABLE IF NOT EXISTS `g_product_content` (
  `productid` int(11) unsigned NOT NULL,
  `content` text NOT NULL,
  KEY `productid` (`productid`),
  KEY `productid_2` (`productid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 表的结构 `g_replys`
--

CREATE TABLE IF NOT EXISTS `g_replys` (
  `rid` int(11) NOT NULL AUTO_INCREMENT,
  `reply_uid` int(10) unsigned NOT NULL,
  `postname` char(50) NOT NULL,
  `content` text NOT NULL,
  `typeid` int(11) NOT NULL,
  `bid` int(11) NOT NULL,
  `ip1` tinyint(1) unsigned NOT NULL,
  `ip2` tinyint(1) unsigned NOT NULL,
  `ip3` tinyint(1) unsigned NOT NULL,
  `ip4` tinyint(1) unsigned NOT NULL,
  `subtime` int(11) NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `typeid` (`typeid`),
  KEY `bid` (`bid`),
  KEY `uid` (`reply_uid`),
  KEY `uid_2` (`reply_uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `g_reply_attachment`
--

CREATE TABLE IF NOT EXISTS `g_reply_attachment` (
  `fid` int(11) NOT NULL AUTO_INCREMENT,
  `rid` int(11) NOT NULL,
  `name` char(255) NOT NULL,
  `storename` char(255) NOT NULL,
  `size` int(11) NOT NULL,
  `isimage` tinyint(1) NOT NULL,
  `type` char(255) NOT NULL,
  `downtimes` int(11) NOT NULL,
  `subtime` int(11) NOT NULL,
  PRIMARY KEY (`fid`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `g_sessions`
--

CREATE TABLE IF NOT EXISTS `g_sessions` (
  `sid` char(10) NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `userid` char(50) NOT NULL,
  `gid` int(10) unsigned NOT NULL,
  `pervalue` int(10) unsigned NOT NULL,
  `lastloginip` char(20) NOT NULL,
  `lastlogintime` int(10) unsigned NOT NULL,
  `uptime` int(10) unsigned NOT NULL,
  `newmsgcount` tinyint(4) unsigned NOT NULL,
  `adminlogin` tinyint(1) NOT NULL,
  `authcode` char(4) NOT NULL,
  `allowedforum` char(255) NOT NULL,
  UNIQUE KEY `sid` (`sid`),
  KEY `uid` (`uid`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 MAX_ROWS=5000;

--
-- 导出表中的数据 `g_sessions`
--

-- --------------------------------------------------------

--
-- 表的结构 `g_settings`
--

CREATE TABLE IF NOT EXISTS `g_settings` (
  `var` char(50) NOT NULL,
  `val` char(255) NOT NULL,
  UNIQUE KEY `var` (`var`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 导出表中的数据 `g_settings`
--

INSERT INTO `g_settings` (`var`, `val`) VALUES
('sitename', 'gatewei 建站引擎'),
('siteurl', 'www.gatewei.com'),
('sitekeywords', '企业建站 网站建设'),
('sitelogo', 'sitelogo.gif'),
('siteicp', '蜀ICP备09001214号'),
('companyname', 'gatewei开发团队'),
('companyaddress', '中国 四川 成都'),
('companyzip', '610016'),
('companyphone', '028-888888'),
('companyfax', '028-888888'),
('companyemail', 'gatewei@126.com'),
('companyqq', '56642434'),
('companyhremail', 'gatewei@126.com'),
('allowedauthcode', '0'),
('attachmaxsize', '10'),
('attachallowedextname', 'pdf,doc,xls,ppt,rar,zip,jpg,gif'),
('userpermission', '{{1,524287;2,524272;3,184144;4,0}}'),
('groupnames', '{{1,管理员,0,0;2,内部员工,1,2;3,普通会员,1,0;4,游客,0,0}}'),
('hlightways', '{{0,粗体字,font-weight:bold;1,斜体字,font-style:italic;3,下划线字,text-decoration:underline;4,红色字体,color:red;5,橙色字体,color:orange;6,绿色字体,color:green;7,蓝色字体,color:blue;8,粉色字体,color:purple}}'),
('dateformats', '{{1,Y-n-j;2,Y年n月j日;3,M j[]Y;4,n/j/Y}}'),
('productidentification', '{{0,black,推荐新品;1,red,新品上市;2,orange,热销产品;3,green,下市产品;4,blue,主打产品;5,brown,研发产品}}'),
('articleidentification', '{{0,black,信息发布;1,red,通知发文;2,orange,新年寄语;3,green,产品信息;4,blue,统计分析;5,brown,业绩报告;6,purple,标准认证}}'),
('templatedir', './templates/default/'),
('smtpserver', 'smtp.126.com'),
('emailaddress', 'gatewei@126.com'),
('emailid', 'gatewei'),
('emailpwd', '13402899470'),
('allowedregister', '1'),
('registerfilename', 'register.php'),
('registerlinkword', '会员注册'),
('forumname', '服务中心'),
('registerkeyword', '{{gatewei;gate;wei}}'),
('emailtitle', '{name}，您好！欢迎光临{sitename}'),
('emailmsg', '{name}您好!欢迎光临{sitename},请您在发表言论时，遵守国家法律法规。如果您有什么疑问可以联系管理员，Email:{adminemail}。'),
('registerinfomore', '0'),
('soleemail', '1'),
('allowedemailmsg', '0'),
('forumisclosed', '0'),
('forumclosedreason', '系统维护，请各位原谅'),
('articlename', '文章中心'),
('productname', '公司产品'),
('surveyname', '调查专题');

-- --------------------------------------------------------

--
-- 表的结构 `g_subsurveys`
--

CREATE TABLE IF NOT EXISTS `g_subsurveys` (
  `sub_survey_id` int(11) NOT NULL AUTO_INCREMENT,
  `survey_id` int(11) NOT NULL,
  `sub_survey_ord` tinyint(1) NOT NULL,
  `sub_survey_title` char(255) NOT NULL,
  `sub_survey_count` int(11) NOT NULL,
  PRIMARY KEY (`sub_survey_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `g_surveys`
--

CREATE TABLE IF NOT EXISTS `g_surveys` (
  `survey_id` int(11) NOT NULL AUTO_INCREMENT,
  `survey_ord` int(11) NOT NULL,
  `survey_title` char(255) NOT NULL,
  `multichecked` tinyint(1) NOT NULL,
  `showresult` tinyint(1) NOT NULL,
  `survey_total_count` int(11) NOT NULL,
  `subtime` int(11) NOT NULL,
  PRIMARY KEY (`survey_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `g_templates`
--

CREATE TABLE IF NOT EXISTS `g_templates` (
  `template_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template_name` char(255) NOT NULL,
  `template_url` char(255) NOT NULL,
  `template_copyright` char(255) NOT NULL,
  `enable` tinyint(1) NOT NULL,
  `subtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`template_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 导出表中的数据 `g_templates`
--

INSERT INTO `g_templates` (`template_id`, `template_name`, `template_url`, `template_copyright`, `enable`, `subtime`) VALUES
(1, '默认风格', './templates/default/', 'gatewei系统开发团队', 1, 1277447158),
(2, '大冢风格', './templates/sclop/', 'gatewei系统开发团队', 0, 1278999347);

--
-- 表的结构 `g_threads`
--

CREATE TABLE IF NOT EXISTS `g_threads` (
  `tid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `forid` int(10) unsigned NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `useraccount` char(50) NOT NULL,
  `ip1` tinyint(1) unsigned NOT NULL,
  `ip2` tinyint(1) unsigned NOT NULL,
  `ip3` tinyint(1) unsigned NOT NULL,
  `ip4` tinyint(1) unsigned NOT NULL,
  `ord` int(11) NOT NULL,
  `hlight` tinyint(4) NOT NULL,
  `title` char(255) NOT NULL,
  `top` tinyint(1) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `view` int(11) NOT NULL,
  `review` int(11) NOT NULL,
  `subtime` int(11) NOT NULL,
  PRIMARY KEY (`tid`),
  KEY `forid` (`forid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 表的结构 `g_thread_content`
--

CREATE TABLE IF NOT EXISTS `g_thread_content` (
  `tid` int(10) unsigned NOT NULL,
  `content` text NOT NULL,
  KEY `tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
