<?php

if(!defined('IN_GATEWEI')) {
	exit('Access Denied');
}

function uploadattach($varname = 'attach',$attach_dir="article",$thumb=false){

	global $db,$attachallowedextname,$attachmaxsize;
	
	$attachments = $attacharray = $dbattachments = array();
	$allowedext  = $attachallowedextname;
	$allowedmaxsize  = intval($attachmaxsize)*1024*1024;
	$imgext  = array('jpg', 'jpeg', 'gif', 'png', 'bmp');
	

	if(isset($_FILES[$varname]) && is_array($_FILES[$varname])) {
		foreach($_FILES[$varname] as $key => $var) {
			foreach($var as $k => $v) {
				$attachments[$k][$key] = $v;
			}
		}
	}


	if(empty($attachments)) {
		return FALSE;
	}

	foreach($attachments as $key => $attach) {

		$attachdir='./clientdata/attachment/';
		$attach_saved = false;
		$attach_thumb = $thumb;

		if(!gisuploadedfile($attach['tmp_name']) || !($attach['tmp_name'] != 'none' && $attach['tmp_name'] && $attach['name'])) {
			continue;
		}

		$filename = gaddslashes($attach['name']);
		
		$attach['ext'] = strtolower(fileext($attach['name']));
		$allowedexts=explode(',',$allowedext);
		$extension = in_array($attach['ext'], $allowedexts) ? $attach['ext'] : 'attach';

		if(in_array($attach['ext'], $imgext)) {
			$attach['isimage'] = 1;
		}else{
			$attach['isimage'] = 0;
		}

		$attach['name'] = htmlspecialchars($attach['name'], ENT_QUOTES);

		if(!in_array($attach['ext'],$allowedexts)) {
			upload_error('该附件类型不允许上传', $attacharray);
		}

		if(empty($attach['size'])) {
			upload_error('附件上传无效', $attacharray);
		}

		if($allowedmaxsize && $attach['size'] > $allowedmaxsize) {
			upload_error('附件超出最大上传限制', $attacharray);
		}

        $storename = time().random(4,0,0).'.'.$extension;
		$storedir=date('Ym');		
		$attachdir = $attachdir.$attach_dir;

		if(!is_dir($attachdir)) {
				@mkdir($attachdir, 0777);
				@fclose(fopen($attachdir.'/index.html', 'w'));
		}

		$attachdir = $attachdir.'/'.$storedir;

		if(!is_dir($attachdir)) {
				@mkdir($attachdir, 0777);
				@fclose(fopen($attachdir.'/index.html', 'w'));
		}

		$target=$attachdir.'/'.$storename;

		if(@copy($attach['tmp_name'], $target) || (function_exists('move_uploaded_file') && @move_uploaded_file($attach['tmp_name'], $target))) {
			@unlink($attach['tmp_name']);
			$attach_saved = true;
			$attacharray[]=$target;
		}

		if($attach_saved) {
			if($attach_thumb){
					thumbimage($target);
			}
			@chmod($target, 0644);
			if(in_array($attach['ext'], $imgext) && function_exists('getimagesize') && !@getimagesize($target)) {
				@unlink($target);
				upload_error('该图片附件类型不允许上传', $attacharray);
			}
			$dbattachments[$key]=array('name'=>$filename,'storename'=>$storedir.'/'.$storename,'size'=>$attach['size'],'isimage'=>$attach['isimage'],'type'=>$attach['type']);
		}

	}

	return $dbattachments;
}




function upload_error($message, $attacharray = array()) {
	if(!empty($attacharray)) {
		foreach($attacharray as $attach) {
			@unlink($attach);
		}
	}
	if(POSITION=='sitefont'){
		showmsg($message);
	}else{
		gadminmessage($message);
	}
}



function thumbimage($srcimg, $thumb_width=180, $thumb_height=135)
{

	//$srcimg ,$desimg 为文件路径及文件名
	//$img ,$thumbimg为获取到的文件标示符
	   list($width, $height, $type) = getimagesize($srcimg);

	    if($type==1){
			$img =  imagecreatefromgif($srcimg);
       }
       elseif($type==2){
			$img =  imagecreatefromjpeg($srcimg);
       }
       elseif($type==3){
         $img =  imagecreatefrompng($srcimg);
       }

	   $thumbimg = imagecreatetruecolor($thumb_width,$thumb_height);
	   imagecopyresampled($thumbimg, $img, 0, 0, 0, 0, $thumb_width,$thumb_height, $width, $height);
	    if($type==1){
			$desimg=str_replace(".gif", ".thumb.gif", $srcimg);
			$img =  imagegif($thumbimg,$desimg);
       }
       elseif($type==2){
		   $desimg=str_replace(".jpg", ".thumb.jpg", $srcimg);
		   $img =  imagejpeg($thumbimg,$desimg);
       }
       elseif($type==3){
		   $desimg=str_replace(".jpg", ".thumb.png", $srcimg);
         $img =  imagepng($thumbimg,$desimg);
       }
	   
}

?>