<?php
/**
 * The model file of productplan module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2010 QingDao Nature Easy Soft Network Technology Co,LTD (www.cnezsoft.com)
 * @license     LGPL (http://www.gnu.org/licenses/lgpl.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     productplan
 * @version     $Id: model.php 1429 2011-02-21 14:35:26Z wwccss $
 * @link        http://www.zentao.net
 */
?>
<?php
class productplanModel extends model
{
    /**
     * Get plan by id.
     * 
     * @param  int    $planID 
     * @access public
     * @return object
     */
    public function getByID($planID)
    {
        return $this->dao->findByID((int)$planID)->from(TABLE_PRODUCTPLAN)->fetch();
    }

    /**
     * Get list 
     * 
     * @param  int    $product 
     * @access public
     * @return object
     */
    public function getList($product = 0)
    {
        return $this->dao->select('*')->from(TABLE_PRODUCTPLAN)->where('product')->eq($product)
            ->andWhere('deleted')->eq(0)
            ->orderBy('begin')->fetchAll();
    }

    /**
     * Get plan pairs.
     * 
     * @param  int    $product 
     * @param  string $expired 
     * @access public
     * @return array
     */
    public function getPairs($product = 0, $expired = '')
    {
        $date = date('Y-m-d');
        return array('' => '') + $this->dao->select('id,title')->from(TABLE_PRODUCTPLAN)
            ->where('product')->eq((int)$product)
            ->andWhere('deleted')->eq(0)
            ->beginIF($expired = 'unexpired')
            ->andWhere('end')->gt($date)
            ->fi()
            ->orderBy('begin')->fetchPairs();
    }

    /**
     * Create a plan.
     * 
     * @param  int    $product 
     * @access public
     * @return int
     */
    public function create($product)
    {
        $plan = fixer::input('post')->stripTags('title')->get();
        $this->dao->insert(TABLE_PRODUCTPLAN)->data($plan)->autoCheck()->batchCheck($this->config->productplan->create->requiredFields, 'notempty')->exec();
        if(!dao::isError()) return $this->dao->lastInsertID();
    }

    /**
     * Update a plan
     * 
     * @param  int    $planID 
     * @access public
     * @return array
     */
    public function update($planID)
    {
        $oldPlan = $this->getById($planID);
        $plan = fixer::input('post')->stripTags('title')->get();
        $this->dao->update(TABLE_PRODUCTPLAN)->data($plan)->autoCheck()->batchCheck($this->config->productplan->edit->requiredFields, 'notempty')->where('id')->eq((int)$planID)->exec();
        if(!dao::isError()) return common::createChanges($oldPlan, $plan);
    }

    /**
     * Link stories.
     * 
     * @param  int    $planID 
     * @access public
     * @return void
     */
    public function linkStory($planID)
    {
        $this->loadModel('story');
        $this->loadModel('action');
        foreach($this->post->stories as $storyID)
        {
            $this->dao->update(TABLE_STORY)->set('plan')->eq((int)$planID)->where('id')->eq((int)$storyID)->exec();
            $this->action->create('story', $storyID, 'linked2plan', '', $planID);
            $this->story->setStage($storyID);
        }        
    }

    /**
     * Unlink story 
     * 
     * @param  int    $storyID 
     * @access public
     * @return void
     */
    public function unlinkStory($storyID)
    {
        $planID = $this->dao->findByID($storyID)->from(TABLE_STORY)->fields('plan')->fetch('plan');
        $this->dao->update(TABLE_STORY)->set('plan')->eq(0)->where('id')->eq((int)$storyID)->exec();
        $this->loadModel('story')->setStage($storyID);
        $this->loadModel('action')->create('story', $storyID, 'unlinkedfromplan', '', $planID);
    }
}
