<?php
/**
 * The view file of build module's view method of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2010 QingDao Nature Easy Soft Network Technology Co,LTD (www.cnezsoft.com)
 * @license     LGPL (http://www.gnu.org/licenses/lgpl.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     build
 * @version     $Id: view.html.php 1460 2011-02-25 08:50:07Z wwccss $
 * @link        http://www.zentao.net
 */
?>
<?php include '../../common/view/header.html.php';?>
<table class='table-1'> 
  <caption><?php echo $lang->build->view;?></caption>
  <tr>
    <th class='rowhead'><?php echo $lang->build->product;?></th>
    <td><?php echo $build->productName;?></td>
  </tr>  
  <tr>
    <th class='rowhead'><?php echo $lang->build->name;?></th>
    <td class='<?php if($build->deleted) echo 'deleted';?>'><?php echo $build->name;?></td>
  </tr>  
  <tr>
    <th class='rowhead'><?php echo $lang->build->builder;?></th>
    <td><?php echo $users[$build->builder];?></td>
  </tr>  
  <tr>
    <th class='rowhead'><?php echo $lang->build->date;?></th>
    <td><?php echo $build->date;?></td>
  </tr>  
  <tr>
    <th class='rowhead'><?php echo $lang->build->scmPath;?></th>
    <td><?php strpos($build->scmPath,  'http') === 0 ? printf(html::a($build->scmPath))  : printf($build->scmPath);?></td>
  </tr>  
  <tr>
    <th class='rowhead'><?php echo $lang->build->filePath;?></th>
    <td><?php strpos($build->filePath, 'http') === 0 ? printf(html::a($build->filePath)) : printf($build->filePath);?></td>
  </tr>  

  <tr>
    <th class='rowhead'><?php echo $lang->build->desc;?></th>
    <td class='content'><?php echo $build->desc;?></td>
  </tr>  
</table>
<div class='a-center f-16px strong'>
  <?php
  $browseLink = $this->session->buildList ? $this->session->buildList : $this->createLink('project', 'build', "projectID=$build->project");
  if(!$build->deleted)
  {
      common::printLink('build', 'edit',   "buildID=$build->id", $lang->edit);
      common::printLink('build', 'delete', "buildID=$build->id", $lang->delete, 'hiddenwin');
  }
  echo html::a($browseLink, $lang->goback);
  ?>
</div>
<?php include '../../common/view/action.html.php';?>
<?php include '../../common/view/footer.html.php';?>
