-- DROP TABLE IF EXISTS `zt_action`;
CREATE TABLE IF NOT EXISTS `zt_action` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL default '0',
  `objectType` varchar(30) NOT NULL default '',
  `objectID` mediumint(8) unsigned NOT NULL default '0',
  `actor` varchar(30) NOT NULL default '',
  `action` varchar(30) NOT NULL default '',
  `date` datetime NOT NULL,
  `comment` text NOT NULL,
  `extra` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `company` (`company`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_bug`;
CREATE TABLE IF NOT EXISTS `zt_bug` (
  `id` mediumint(8) NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `project` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `task` mediumint(8) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `severity` tinyint(4) NOT NULL default '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `type` varchar(30) NOT NULL default '',
  `os` varchar(30) NOT NULL default '',
  `browser` varchar(30) NOT NULL default '',
  `hardware` varchar(30) NOT NULL,
  `found` varchar(30) NOT NULL default '',
  `steps` text NOT NULL,
  `status` enum('active','resolved','closed') NOT NULL default 'active',
  `mailto` varchar(255) NOT NULL default '',
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `openedBuild` varchar(255) NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `resolvedBy` varchar(30) NOT NULL default '',
  `resolution` varchar(30) NOT NULL default '',
  `resolvedBuild` varchar(30) NOT NULL default '',
  `resolvedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `duplicateBug` mediumint(8) unsigned NOT NULL,
  `linkBug` varchar(255) NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `caseVersion` smallint(6) NOT NULL default '1',
  `result` mediumint(8) unsigned NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_build`;
CREATE TABLE IF NOT EXISTS `zt_build` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `project` mediumint(8) unsigned NOT NULL default '0',
  `name` char(150) NOT NULL,
  `scmPath` char(255) NOT NULL,
  `filePath` char(255) NOT NULL,
  `date` date NOT NULL,
  `builder` char(30) NOT NULL default '',
  `desc` text NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_burn`;
CREATE TABLE IF NOT EXISTS `zt_burn` (
  `company` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `date` date NOT NULL,
  `left` float NOT NULL,
  `consumed` float NOT NULL,
  PRIMARY KEY  (`project`,`date`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_case`;
CREATE TABLE IF NOT EXISTS `zt_case` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `path` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(30) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `type` char(30) NOT NULL default '1',
  `stage` varchar(255) NOT NULL,
  `howRun` varchar(30) NOT NULL,
  `scriptedBy` varchar(30) NOT NULL,
  `scriptedDate` date NOT NULL,
  `scriptStatus` varchar(30) NOT NULL,
  `scriptLocation` varchar(255) NOT NULL,
  `status` char(30) NOT NULL default '1',
  `frequency` enum('1','2','3') NOT NULL default '1',
  `order` tinyint(30) unsigned NOT NULL default '0',
  `openedBy` char(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `lastEditedBy` char(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `version` tinyint(3) unsigned NOT NULL default '0',
  `linkCase` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_caseStep`;
CREATE TABLE IF NOT EXISTS `zt_caseStep` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(3) unsigned NOT NULL default '0',
  `desc` text NOT NULL,
  `expect` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`,`version`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_company`;
CREATE TABLE IF NOT EXISTS `zt_company` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(120) default NULL,
  `phone` char(20) default NULL,
  `fax` char(20) default NULL,
  `address` char(120) default NULL,
  `zipcode` char(10) default NULL,
  `website` char(120) default NULL,
  `backyard` char(120) default NULL,
  `pms` char(120) default NULL,
  `guest` enum('1','0') NOT NULL default '0',
  `admins` char(255) default NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `pms` (`pms`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_config`;
CREATE TABLE IF NOT EXISTS `zt_config` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL default '0',
  `owner` char(30) NOT NULL default '',
  `section` char(30) NOT NULL default '',
  `key` char(30) NOT NULL default '',
  `value` char(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dept`;
CREATE TABLE IF NOT EXISTS `zt_dept` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL default '0',
  `name` char(60) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` tinyint(3) unsigned NOT NULL default '0',
  `position` char(30) NOT NULL default '',
  `function` char(255) NOT NULL default '',
  `manager` char(30) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doc`;
CREATE TABLE IF NOT EXISTS `zt_doc` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` smallint(5) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `lib` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(255) NOT NULL,
  `digest` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL,
  `content` text NOT NULL,
  `url` varchar(255) NOT NULL,
  `views` smallint(5) unsigned NOT NULL,
  `addedBy` varchar(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_docLib`;
CREATE TABLE IF NOT EXISTS `zt_docLib` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `company` smallint(5) unsigned NOT NULL,
  `name` varchar(60) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_effort`;
CREATE TABLE IF NOT EXISTS `zt_effort` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `user` char(30) NOT NULL default '',
  `todo` enum('1','0') NOT NULL default '1',
  `date` date NOT NULL default '0000-00-00',
  `begin` datetime NOT NULL default '0000-00-00 00:00:00',
  `end` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` enum('1','2','3') NOT NULL default '1',
  `idvalue` mediumint(8) unsigned NOT NULL default '0',
  `name` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `status` enum('1','2','3') NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `user` (`user`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_extension`;
CREATE TABLE IF NOT EXISTS `zt_extension` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `name` varchar(150) NOT NULL,
  `code` varchar(30) NOT NULL,
  `version` varchar(50) NOT NULL,
  `author` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `license` text NOT NULL,
  `site` varchar(150) NOT NULL,
  `zentaoVersion` varchar(100) NOT NULL,
  `installedTime` datetime NOT NULL,
  `dirs` text NOT NULL,
  `files` text NOT NULL,
  `status` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `addedTime` (`installedTime`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_file`;
CREATE TABLE IF NOT EXISTS `zt_file` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL default '0',
  `pathname` char(50) NOT NULL,
  `title` char(90) NOT NULL,
  `extension` char(30) NOT NULL,
  `size` mediumint(8) unsigned NOT NULL default '0',
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `addedBy` char(30) NOT NULL default '',
  `addedDate` datetime NOT NULL,
  `downloads` mediumint(8) unsigned NOT NULL default '0',
  `extra` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_group`;
CREATE TABLE IF NOT EXISTS `zt_group` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `name` char(30) NOT NULL,
  `desc` char(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_groupPriv`;
CREATE TABLE IF NOT EXISTS `zt_groupPriv` (
  `company` mediumint(9) NOT NULL,
  `group` mediumint(8) unsigned NOT NULL default '0',
  `module` char(30) NOT NULL default '',
  `method` char(30) NOT NULL default '',
  UNIQUE KEY `group` (`group`,`module`,`method`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_history`;
CREATE TABLE IF NOT EXISTS `zt_history` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `action` mediumint(8) unsigned NOT NULL default '0',
  `field` varchar(30) NOT NULL default '',
  `old` text NOT NULL,
  `new` text NOT NULL,
  `diff` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_module`;
CREATE TABLE IF NOT EXISTS `zt_module` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `name` char(30) NOT NULL default '',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` tinyint(3) unsigned NOT NULL default '0',
  `type` char(30) NOT NULL,
  `owner` varchar(30) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_product`;
CREATE TABLE IF NOT EXISTS `zt_product` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `order` tinyint(3) unsigned NOT NULL default '0',
  `status` varchar(30) NOT NULL default '',
  `desc` text NOT NULL,
  `PO` varchar(30) NOT NULL,
  `QM` varchar(30) NOT NULL,
  `RM` varchar(30) NOT NULL,
  `acl` enum('open','private','custom') NOT NULL default 'open',
  `whitelist` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_productPlan`;
CREATE TABLE IF NOT EXISTS `zt_productPlan` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `title` varchar(90) NOT NULL,
  `desc` varchar(255) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_project`;
CREATE TABLE IF NOT EXISTS `zt_project` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL default '0',
  `isCat` enum('1','0') NOT NULL default '0',
  `catID` mediumint(8) unsigned NOT NULL,
  `type` enum('sprint','project') NOT NULL default 'sprint',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `statge` enum('1','2','3','4','5') NOT NULL default '1',
  `pri` enum('1','2','3','4') NOT NULL default '1',
  `desc` text NOT NULL,
  `goal` text NOT NULL,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` int(10) unsigned NOT NULL default '0',
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` int(10) unsigned NOT NULL default '0',
  `canceledBy` varchar(30) NOT NULL default '',
  `canceledDate` int(10) unsigned NOT NULL default '0',
  `PO` varchar(30) NOT NULL default '',
  `PM` varchar(30) NOT NULL default '',
  `QM` varchar(30) NOT NULL default '',
  `RM` varchar(30) NOT NULL default '',
  `team` varchar(30) NOT NULL,
  `acl` enum('open','private','custom') NOT NULL default 'open',
  `whitelist` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `company` (`company`,`type`,`parent`,`begin`,`end`,`status`,`statge`,`pri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectProduct`;
CREATE TABLE IF NOT EXISTS `zt_projectProduct` (
  `company` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`project`,`product`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectStory`;
CREATE TABLE IF NOT EXISTS `zt_projectStory` (
  `company` mediumint(9) NOT NULL,
  `project` mediumint(8) unsigned NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(6) NOT NULL default '1',
  UNIQUE KEY `project` (`project`,`story`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_release`;
CREATE TABLE IF NOT EXISTS `zt_release` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `build` mediumint(8) unsigned NOT NULL,
  `name` char(30) NOT NULL default '',
  `date` date NOT NULL,
  `desc` text NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_story`;
CREATE TABLE IF NOT EXISTS `zt_story` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `plan` mediumint(8) unsigned NOT NULL default '0',
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL default '',
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `estimate` float unsigned NOT NULL,
  `status` varchar(30) NOT NULL default '',
  `stage` varchar(30) NOT NULL,
  `mailto` varchar(255) NOT NULL default '',
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `reviewedBy` varchar(30) NOT NULL,
  `reviewedDate` date NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `toBug` mediumint(9) NOT NULL,
  `childStories` varchar(255) NOT NULL,
  `linkStories` varchar(255) NOT NULL,
  `duplicateStory` mediumint(8) unsigned NOT NULL,
  `version` smallint(6) NOT NULL default '1',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`,`module`,`plan`,`type`,`pri`),
  KEY `status` (`status`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storySpec`;
CREATE TABLE IF NOT EXISTS `zt_storySpec` (
  `company` mediumint(8) unsigned NOT NULL,
  `story` mediumint(9) NOT NULL,
  `version` smallint(6) NOT NULL,
  `title` varchar(90) NOT NULL,
  `spec` text NOT NULL,
  `verify` text NOT NULL,
  UNIQUE KEY `story` (`story`,`version`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_task`;
CREATE TABLE IF NOT EXISTS `zt_task` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `estimate` float unsigned NOT NULL,
  `consumed` float unsigned NOT NULL,
  `left` float unsigned NOT NULL,
  `deadline` date NOT NULL,
  `status` enum('wait','doing','done','cancel','closed') NOT NULL default 'wait',
  `statusCustom` tinyint(3) unsigned NOT NULL,
  `mailto` varchar(255) NOT NULL default '',
  `desc` text NOT NULL,
  `openedBy` varchar(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `finishedBy` varchar(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `canceledBy` varchar(30) NOT NULL,
  `canceledDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `statusOrder` (`statusCustom`),
  KEY `type` (`type`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskEstimate`;
CREATE TABLE IF NOT EXISTS `zt_taskEstimate` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `date` int(10) unsigned NOT NULL default '0',
  `estimate` tinyint(3) unsigned NOT NULL default '0',
  `estimater` char(30) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `task` (`task`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_team`;
CREATE TABLE IF NOT EXISTS `zt_team` (
  `company` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL default '0',
  `account` char(30) NOT NULL default '',
  `role` char(30) NOT NULL default '',
  `joinDate` date NOT NULL default '0000-00-00',
  `workingHour` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`project`,`account`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testResult`;
CREATE TABLE IF NOT EXISTS `zt_testResult` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `run` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  `caseResult` char(30) NOT NULL,
  `stepResults` text NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `run` (`run`),
  KEY `case` (`case`,`version`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testRun`;
CREATE TABLE IF NOT EXISTS `zt_testRun` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` tinyint(3) unsigned NOT NULL default '0',
  `assignedTo` char(30) NOT NULL default '',
  `lastRun` datetime NOT NULL,
  `lastResult` char(30) NOT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `task` (`task`,`case`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testTask`;
CREATE TABLE IF NOT EXISTS `zt_testTask` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `name` char(90) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL default '0',
  `build` char(30) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `desc` text NOT NULL,
  `status` char(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_todo`;
CREATE TABLE IF NOT EXISTS `zt_todo` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(9) NOT NULL,
  `account` char(30) NOT NULL,
  `date` date NOT NULL default '0000-00-00',
  `begin` smallint(4) unsigned zerofill NOT NULL,
  `end` smallint(4) unsigned zerofill NOT NULL,
  `type` char(10) NOT NULL,
  `idvalue` mediumint(8) unsigned NOT NULL default '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `name` char(150) NOT NULL,
  `desc` text NOT NULL,
  `status` char(20) NOT NULL default '',
  `private` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `user` (`account`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_user`;
CREATE TABLE IF NOT EXISTS `zt_user` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL default '0',
  `dept` mediumint(8) unsigned NOT NULL default '0',
  `account` char(30) NOT NULL default '',
  `password` char(32) NOT NULL default '',
  `realname` char(30) NOT NULL default '',
  `nickname` char(60) NOT NULL default '',
  `avatar` char(30) NOT NULL default '',
  `birthday` date NOT NULL default '0000-00-00',
  `gendar` enum('f','m') NOT NULL default 'f',
  `email` char(90) NOT NULL default '',
  `msn` char(90) NOT NULL default '',
  `qq` char(20) NOT NULL default '',
  `yahoo` char(90) NOT NULL default '',
  `gtalk` char(90) NOT NULL default '',
  `wangwang` char(90) NOT NULL default '',
  `mobile` char(11) NOT NULL default '',
  `phone` char(20) NOT NULL default '',
  `address` char(120) NOT NULL default '',
  `zipcode` char(10) NOT NULL default '',
  `join` date NOT NULL default '0000-00-00',
  `visits` mediumint(8) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  `last` int(10) unsigned NOT NULL default '0',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `account` (`account`),
  KEY `company` (`company`,`dept`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userGroup`;
CREATE TABLE IF NOT EXISTS `zt_userGroup` (
  `company` mediumint(8) unsigned NOT NULL,
  `account` char(30) NOT NULL default '',
  `group` mediumint(8) unsigned NOT NULL default '0',
  UNIQUE KEY `account` (`account`,`group`),
  KEY `company` (`company`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userQuery`;
CREATE TABLE IF NOT EXISTS `zt_userQuery` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL default '0',
  `account` char(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(90) NOT NULL,
  `form` text NOT NULL,
  `sql` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `company` (`company`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userTPL`;
CREATE TABLE IF NOT EXISTS `zt_userTPL` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint(8) unsigned NOT NULL,
  `account` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(150) NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `company` (`company`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `zt_group` (`id`, `company`, `name`, `desc`) VALUES
(1, 1, 'ADMIN', 'for administrator.'),
(2, 1, 'PO', 'for product owners.'),
(3, 1, 'DEV', 'for developers.'),
(4, 1, 'QA', 'for testers.'),
(5, 1, 'PM', 'for project managers.'),
(6, 1, 'guest', 'For guest');

INSERT INTO `zt_groupPriv` (`company`, `group`, `module`, `method`) VALUES
(1, 1, 'tree', 'ajaxGetSonModules'),
(1, 1, 'tree', 'ajaxGetOptionMenu'),
(1, 1, 'tree', 'delete'),
(1, 1, 'tree', 'edit'),
(1, 1, 'tree', 'manageChild'),
(1, 1, 'tree', 'updateOrder'),
(1, 1, 'tree', 'browse'),
(1, 1, 'user', 'profile'),
(1, 1, 'user', 'dynamic'),
(1, 1, 'user', 'project'),
(1, 1, 'user', 'bug'),
(1, 1, 'user', 'task'),
(1, 1, 'user', 'todo'),
(1, 1, 'user', 'delete'),
(1, 1, 'user', 'edit'),
(1, 1, 'user', 'view'),
(1, 1, 'user', 'create'),
(1, 1, 'group', 'manageMember'),
(1, 1, 'group', 'managePriv'),
(1, 1, 'group', 'delete'),
(1, 1, 'group', 'copy'),
(1, 1, 'group', 'edit'),
(1, 1, 'group', 'create'),
(1, 1, 'group', 'browse'),
(1, 1, 'dept', 'delete'),
(1, 1, 'dept', 'manageChild'),
(1, 1, 'dept', 'updateOrder'),
(1, 1, 'dept', 'browse'),
(1, 1, 'company', 'dynamic'),
(1, 1, 'company', 'edit'),
(1, 1, 'company', 'browse'),
(1, 1, 'company', 'index'),
(1, 1, 'doc', 'delete'),
(1, 1, 'doc', 'edit'),
(1, 1, 'doc', 'view'),
(1, 1, 'doc', 'create'),
(1, 1, 'doc', 'deleteLib'),
(1, 1, 'doc', 'editLib'),
(1, 1, 'doc', 'createLib'),
(1, 1, 'doc', 'browse'),
(1, 1, 'doc', 'index'),
(1, 1, 'testtask', 'results'),
(1, 1, 'testtask', 'runcase'),
(1, 1, 'testtask', 'unlinkcase'),
(1, 1, 'testtask', 'linkcase'),
(1, 1, 'testtask', 'batchAssign'),
(1, 1, 'testtask', 'delete'),
(1, 1, 'testtask', 'edit'),
(1, 1, 'testtask', 'cases'),
(1, 1, 'testtask', 'view'),
(1, 1, 'testtask', 'browse'),
(1, 1, 'testtask', 'create'),
(1, 1, 'testtask', 'index'),
(1, 1, 'testcase', 'confirmStoryChange'),
(1, 1, 'testcase', 'export'),
(1, 1, 'testcase', 'delete'),
(1, 1, 'testcase', 'edit'),
(1, 1, 'testcase', 'view'),
(1, 1, 'testcase', 'create'),
(1, 1, 'testcase', 'browse'),
(1, 1, 'testcase', 'index'),
(1, 1, 'bug', 'ajaxGetModuleOwner'),
(1, 1, 'bug', 'ajaxGetUserBugs'),
(1, 1, 'bug', 'customFields'),
(1, 1, 'bug', 'deleteTemplate'),
(1, 1, 'bug', 'saveTemplate'),
(1, 1, 'bug', 'delete'),
(1, 1, 'bug', 'confirmStoryChange'),
(1, 1, 'bug', 'report'),
(1, 1, 'bug', 'close'),
(1, 1, 'bug', 'activate'),
(1, 1, 'bug', 'resolve'),
(1, 1, 'bug', 'edit'),
(1, 1, 'bug', 'view'),
(1, 1, 'bug', 'create'),
(1, 1, 'bug', 'browse'),
(1, 1, 'bug', 'index'),
(1, 1, 'qa', 'index'),
(1, 1, 'build', 'ajaxGetProjectBuilds'),
(1, 1, 'build', 'ajaxGetProductBuilds'),
(1, 1, 'build', 'view'),
(1, 1, 'build', 'delete'),
(1, 1, 'build', 'edit'),
(1, 1, 'build', 'create'),
(1, 1, 'task', 'report'),
(1, 1, 'task', 'ajaxGetProjectTasks'),
(1, 1, 'task', 'ajaxGetUserTasks'),
(1, 1, 'task', 'confirmStoryChange'),
(1, 1, 'task', 'export'),
(1, 1, 'task', 'view'),
(1, 1, 'task', 'delete'),
(1, 1, 'task', 'activate'),
(1, 1, 'task', 'batchClose'),
(1, 1, 'task', 'close'),
(1, 1, 'task', 'cancel'),
(1, 1, 'task', 'finish'),
(1, 1, 'task', 'start'),
(1, 1, 'task', 'edit'),
(1, 1, 'task', 'create'),
(1, 1, 'project', 'ajaxGetProducts'),
(1, 1, 'project', 'unlinkStory'),
(1, 1, 'project', 'linkStory'),
(1, 1, 'project', 'unlinkMember'),
(1, 1, 'project', 'manageMembers'),
(1, 1, 'project', 'manageProducts'),
(1, 1, 'project', 'doc'),
(1, 1, 'project', 'team'),
(1, 1, 'project', 'burnData'),
(1, 1, 'project', 'computeBurn'),
(1, 1, 'project', 'burn'),
(1, 1, 'project', 'bug'),
(1, 1, 'project', 'build'),
(1, 1, 'project', 'story'),
(1, 1, 'project', 'importtask'),
(1, 1, 'project', 'grouptask'),
(1, 1, 'project', 'task'),
(1, 1, 'project', 'delete'),
(1, 1, 'project', 'edit'),
(1, 1, 'project', 'create'),
(1, 1, 'project', 'browse'),
(1, 1, 'project', 'view'),
(1, 1, 'project', 'index'),
(1, 1, 'release', 'view'),
(1, 1, 'release', 'delete'),
(1, 1, 'release', 'edit'),
(1, 1, 'release', 'create'),
(1, 1, 'release', 'browse'),
(1, 1, 'productplan', 'unlinkStory'),
(1, 1, 'productplan', 'linkStory'),
(1, 1, 'productplan', 'view'),
(1, 1, 'productplan', 'delete'),
(1, 1, 'productplan', 'edit'),
(1, 1, 'productplan', 'create'),
(1, 1, 'productplan', 'browse'),
(1, 1, 'story', 'ajaxGetProductStories'),
(1, 1, 'story', 'ajaxGetProjectStories'),
(1, 1, 'story', 'report'),
(1, 1, 'story', 'tasks'),
(1, 1, 'story', 'activate'),
(1, 1, 'story', 'close'),
(1, 1, 'story', 'review'),
(1, 1, 'story', 'change'),
(1, 1, 'story', 'view'),
(1, 1, 'story', 'delete'),
(1, 1, 'story', 'export'),
(1, 1, 'story', 'edit'),
(1, 1, 'story', 'create'),
(1, 1, 'product', 'ajaxGetPlans'),
(1, 1, 'product', 'ajaxGetProjects'),
(1, 1, 'product', 'doc'),
(1, 2, 'search', 'saveQuery'),
(1, 2, 'project', 'team'),
(1, 2, 'task', 'export'),
(1, 2, 'story', 'change'),
(1, 2, 'project', 'burnData'),
(1, 2, 'bug', 'create'),
(1, 2, 'search', 'buildForm'),
(1, 2, 'bug', 'edit'),
(1, 2, 'productplan', 'create'),
(1, 2, 'bug', 'report'),
(1, 2, 'user', 'bug'),
(1, 2, 'bug', 'saveTemplate'),
(1, 2, 'todo', 'edit'),
(1, 2, 'project', 'index'),
(1, 2, 'my', 'project'),
(1, 2, 'productplan', 'delete'),
(1, 2, 'bug', 'browse'),
(1, 2, 'company', 'dynamic'),
(1, 2, 'tree', 'manageChild'),
(1, 2, 'my', 'bug'),
(1, 2, 'my', 'profile'),
(1, 2, 'my', 'editProfile'),
(1, 2, 'my', 'todo'),
(1, 2, 'release', 'view'),
(1, 2, 'story', 'delete'),
(1, 2, 'my', 'index'),
(1, 2, 'user', 'todo'),
(1, 2, 'user', 'view'),
(1, 2, 'todo', 'create'),
(1, 2, 'tree', 'updateOrder'),
(1, 2, 'product', 'view'),
(1, 2, 'tree', 'ajaxGetOptionMenu'),
(1, 2, 'search', 'buildQuery'),
(1, 2, 'bug', 'index'),
(1, 2, 'doc', 'editLib'),
(1, 2, 'doc', 'index'),
(1, 2, 'story', 'edit'),
(1, 2, 'file', 'ajaxUpload'),
(1, 2, 'product', 'delete'),
(1, 2, 'project', 'doc'),
(1, 2, 'product', 'create'),
(1, 2, 'doc', 'view'),
(1, 2, 'user', 'project'),
(1, 2, 'product', 'roadmap'),
(1, 2, 'project', 'build'),
(1, 2, 'product', 'edit'),
(1, 2, 'project', 'bug'),
(1, 2, 'user', 'task'),
(1, 2, 'release', 'create'),
(1, 2, 'story', 'view'),
(1, 2, 'build', 'ajaxGetProductBuilds'),
(1, 2, 'productplan', 'linkStory'),
(1, 2, 'project', 'manageProducts'),
(1, 2, 'story', 'export'),
(1, 2, 'productplan', 'edit'),
(1, 2, 'doc', 'edit'),
(1, 2, 'story', 'report'),
(1, 2, 'productplan', 'view'),
(1, 2, 'build', 'ajaxGetProjectBuilds'),
(1, 2, 'project', 'burn'),
(1, 2, 'story', 'review'),
(1, 2, 'story', 'tasks'),
(1, 2, 'qa', 'index'),
(1, 2, 'productplan', 'browse'),
(1, 2, 'task', 'view'),
(1, 2, 'task', 'edit'),
(1, 2, 'story', 'ajaxGetProjectStories'),
(1, 2, 'task', 'report'),
(1, 2, 'project', 'linkStory'),
(1, 2, 'project', 'ajaxGetProducts'),
(1, 2, 'bug', 'deleteTemplate'),
(1, 2, 'testtask', 'browse'),
(1, 2, 'build', 'create'),
(1, 2, 'doc', 'browse'),
(1, 2, 'testcase', 'browse'),
(1, 2, 'bug', 'customFields'),
(1, 2, 'bug', 'ajaxGetUserBugs'),
(1, 2, 'doc', 'createLib'),
(1, 2, 'doc', 'create'),
(1, 2, 'story', 'activate'),
(1, 2, 'task', 'create'),
(1, 2, 'company', 'browse'),
(1, 2, 'story', 'close'),
(1, 2, 'testtask', 'results'),
(1, 2, 'build', 'view'),
(1, 2, 'task', 'ajaxGetProjectTasks'),
(1, 2, 'my', 'task'),
(1, 2, 'company', 'index'),
(1, 2, 'build', 'delete'),
(1, 2, 'product', 'ajaxGetPlans'),
(1, 2, 'testcase', 'view'),
(1, 2, 'testcase', 'edit'),
(1, 2, 'project', 'story'),
(1, 2, 'task', 'ajaxGetUserTasks'),
(1, 2, 'testcase', 'create'),
(1, 2, 'bug', 'ajaxGetModuleOwner'),
(1, 2, 'build', 'edit'),
(1, 2, 'todo', 'delete'),
(1, 2, 'product', 'index'),
(1, 2, 'my', 'story'),
(1, 2, 'user', 'dynamic'),
(1, 2, 'index', 'index'),
(1, 2, 'my', 'dynamic'),
(1, 2, 'tree', 'browse'),
(1, 2, 'product', 'doc'),
(1, 2, 'project', 'grouptask'),
(1, 2, 'todo', 'import2Today'),
(1, 2, 'productplan', 'unlinkStory'),
(1, 3, 'story', 'view'),
(1, 3, 'story', 'close'),
(1, 3, 'testtask', 'cases'),
(1, 3, 'my', 'task'),
(1, 3, 'bug', 'ajaxGetUserBugs'),
(1, 3, 'project', 'task'),
(1, 3, 'project', 'view'),
(1, 3, 'my', 'todo'),
(1, 3, 'my', 'editProfile'),
(1, 3, 'doc', 'createLib'),
(1, 3, 'doc', 'edit'),
(1, 3, 'testtask', 'index'),
(1, 3, 'todo', 'edit'),
(1, 3, 'testcase', 'index'),
(1, 3, 'user', 'bug'),
(1, 3, 'testtask', 'browse'),
(1, 3, 'task', 'finish'),
(1, 3, 'bug', 'ajaxGetModuleOwner'),
(1, 3, 'task', 'cancel'),
(1, 3, 'doc', 'create'),
(1, 3, 'product', 'doc'),
(1, 3, 'project', 'browse'),
(1, 3, 'user', 'project'),
(1, 3, 'company', 'index'),
(1, 3, 'search', 'buildForm'),
(1, 3, 'task', 'edit'),
(1, 3, 'task', 'create'),
(1, 3, 'user', 'task'),
(1, 3, 'task', 'start'),
(1, 3, 'task', 'report'),
(1, 3, 'user', 'view'),
(1, 3, 'testtask', 'results'),
(1, 3, 'bug', 'view'),
(1, 3, 'project', 'index'),
(1, 3, 'project', 'grouptask'),
(1, 3, 'story', 'review'),
(1, 3, 'release', 'view'),
(1, 3, 'index', 'index'),
(1, 3, 'task', 'confirmStoryChange'),
(1, 3, 'story', 'ajaxGetProductStories'),
(1, 3, 'story', 'report'),
(1, 3, 'company', 'browse'),
(1, 3, 'project', 'build'),
(1, 3, 'story', 'tasks'),
(1, 3, 'story', 'activate'),
(1, 3, 'story', 'ajaxGetProjectStories'),
(1, 3, 'productplan', 'view'),
(1, 3, 'build', 'ajaxGetProjectBuilds'),
(1, 3, 'task', 'ajaxGetUserTasks'),
(1, 3, 'build', 'ajaxGetProductBuilds'),
(1, 3, 'product', 'ajaxGetProjects'),
(1, 3, 'story', 'create'),
(1, 3, 'story', 'export'),
(1, 3, 'my', 'dynamic'),
(1, 3, 'task', 'ajaxGetProjectTasks'),
(1, 3, 'task', 'export'),
(1, 3, 'project', 'burn'),
(1, 3, 'project', 'ajaxGetProducts'),
(1, 3, 'story', 'edit'),
(1, 3, 'testcase', 'view'),
(1, 3, 'release', 'browse'),
(1, 3, 'productplan', 'browse'),
(1, 3, 'project', 'story'),
(1, 3, 'story', 'change'),
(1, 3, 'project', 'team'),
(1, 3, 'user', 'profile'),
(1, 3, 'todo', 'view'),
(1, 3, 'todo', 'create'),
(1, 3, 'build', 'edit'),
(1, 3, 'product', 'ajaxGetPlans'),
(1, 3, 'build', 'view'),
(1, 3, 'my', 'bug'),
(1, 3, 'testtask', 'view'),
(1, 3, 'my', 'project'),
(1, 3, 'my', 'index'),
(1, 3, 'bug', 'create'),
(1, 3, 'company', 'dynamic'),
(1, 3, 'product', 'view'),
(1, 3, 'todo', 'import2Today'),
(1, 3, 'my', 'profile'),
(1, 3, 'todo', 'mark'),
(1, 3, 'product', 'browse'),
(1, 3, 'build', 'create'),
(1, 3, 'product', 'roadmap'),
(1, 3, 'product', 'index'),
(1, 3, 'doc', 'editLib'),
(1, 4, 'project', 'browse'),
(1, 4, 'build', 'edit'),
(1, 4, 'build', 'view'),
(1, 4, 'build', 'ajaxGetProductBuilds'),
(1, 4, 'index', 'index'),
(1, 4, 'product', 'index'),
(1, 4, 'bug', 'close'),
(1, 4, 'story', 'change'),
(1, 4, 'story', 'create'),
(1, 4, 'story', 'ajaxGetProductStories'),
(1, 4, 'bug', 'confirmStoryChange'),
(1, 4, 'product', 'view'),
(1, 4, 'story', 'tasks'),
(1, 4, 'story', 'report'),
(1, 4, 'story', 'close'),
(1, 4, 'story', 'view'),
(1, 4, 'story', 'export'),
(1, 4, 'project', 'doc'),
(1, 4, 'project', 'burn'),
(1, 4, 'story', 'ajaxGetProjectStories'),
(1, 4, 'productplan', 'browse'),
(1, 4, 'tree', 'ajaxGetOptionMenu'),
(1, 4, 'qa', 'index'),
(1, 4, 'release', 'browse'),
(1, 4, 'build', 'ajaxGetProjectBuilds'),
(1, 4, 'build', 'delete'),
(1, 4, 'user', 'profile'),
(1, 4, 'build', 'create'),
(1, 4, 'bug', 'create'),
(1, 4, 'bug', 'index'),
(1, 4, 'doc', 'create'),
(1, 4, 'company', 'dynamic'),
(1, 4, 'release', 'view'),
(1, 4, 'bug', 'browse'),
(1, 4, 'user', 'dynamic'),
(1, 4, 'doc', 'editLib'),
(1, 4, 'bug', 'edit'),
(1, 4, 'testcase', 'index'),
(1, 4, 'testtask', 'runcase'),
(1, 4, 'testtask', 'index'),
(1, 4, 'testtask', 'unlinkcase'),
(1, 4, 'testcase', 'view'),
(1, 4, 'bug', 'ajaxGetModuleOwner'),
(1, 4, 'product', 'ajaxGetProjects'),
(1, 4, 'testtask', 'delete'),
(1, 4, 'testtask', 'results'),
(1, 4, 'testtask', 'edit'),
(1, 4, 'bug', 'ajaxGetUserBugs'),
(1, 4, 'product', 'roadmap'),
(1, 4, 'testtask', 'linkcase'),
(1, 4, 'product', 'doc'),
(1, 4, 'testtask', 'batchAssign'),
(1, 4, 'project', 'build'),
(1, 4, 'bug', 'deleteTemplate'),
(1, 4, 'bug', 'delete'),
(1, 4, 'bug', 'customFields'),
(1, 4, 'tree', 'browse'),
(1, 4, 'task', 'ajaxGetProjectTasks'),
(1, 4, 'tree', 'edit'),
(1, 4, 'company', 'index'),
(1, 4, 'user', 'todo'),
(1, 4, 'my', 'index'),
(1, 4, 'my', 'story'),
(1, 4, 'my', 'profile'),
(1, 4, 'testtask', 'view'),
(1, 4, 'my', 'bug'),
(1, 4, 'my', 'project'),
(1, 4, 'task', 'view'),
(1, 4, 'doc', 'createLib'),
(1, 4, 'project', 'ajaxGetProducts'),
(1, 4, 'my', 'todo'),
(1, 4, 'task', 'create'),
(1, 4, 'doc', 'index'),
(1, 4, 'doc', 'browse'),
(1, 4, 'todo', 'create'),
(1, 4, 'task', 'edit'),
(1, 4, 'bug', 'view'),
(1, 4, 'tree', 'updateOrder'),
(1, 4, 'search', 'buildForm'),
(1, 4, 'task', 'report'),
(1, 4, 'doc', 'edit'),
(1, 4, 'tree', 'manageChild'),
(1, 4, 'company', 'browse'),
(1, 4, 'user', 'task'),
(1, 4, 'user', 'view'),
(1, 4, 'user', 'bug'),
(1, 4, 'testtask', 'create'),
(1, 4, 'testtask', 'browse'),
(1, 4, 'my', 'task'),
(1, 4, 'my', 'editProfile'),
(1, 4, 'todo', 'edit'),
(1, 4, 'my', 'dynamic'),
(1, 4, 'todo', 'mark'),
(1, 4, 'todo', 'delete'),
(1, 4, 'story', 'activate'),
(1, 4, 'bug', 'saveTemplate'),
(1, 4, 'tree', 'delete'),
(1, 4, 'user', 'project'),
(1, 4, 'task', 'ajaxGetUserTasks'),
(1, 4, 'project', 'team'),
(1, 4, 'project', 'task'),
(1, 4, 'bug', 'resolve'),
(1, 4, 'project', 'story'),
(1, 5, 'testtask', 'cases'),
(1, 5, 'project', 'burnData'),
(1, 5, 'productplan', 'linkStory'),
(1, 5, 'testtask', 'browse'),
(1, 5, 'my', 'story'),
(1, 5, 'testcase', 'edit'),
(1, 5, 'my', 'bug'),
(1, 5, 'project', 'index'),
(1, 5, 'my', 'index'),
(1, 5, 'doc', 'editLib'),
(1, 5, 'bug', 'resolve'),
(1, 5, 'company', 'dynamic'),
(1, 5, 'testcase', 'index'),
(1, 5, 'todo', 'edit'),
(1, 5, 'testcase', 'view'),
(1, 5, 'search', 'buildForm'),
(1, 5, 'project', 'bug'),
(1, 5, 'bug', 'ajaxGetModuleOwner'),
(1, 5, 'testtask', 'view'),
(1, 5, 'todo', 'import2Today'),
(1, 5, 'project', 'manageMembers'),
(1, 5, 'user', 'task'),
(1, 5, 'story', 'review'),
(1, 5, 'project', 'create'),
(1, 5, 'company', 'browse'),
(1, 5, 'user', 'bug'),
(1, 5, 'doc', 'edit'),
(1, 5, 'task', 'view'),
(1, 5, 'project', 'linkStory'),
(1, 5, 'user', 'project'),
(1, 5, 'project', 'manageProducts'),
(1, 5, 'build', 'create'),
(1, 5, 'doc', 'view'),
(1, 5, 'my', 'editProfile'),
(1, 5, 'bug', 'view'),
(1, 5, 'doc', 'index'),
(1, 5, 'project', 'browse'),
(1, 5, 'project', 'unlinkMember'),
(1, 5, 'product', 'ajaxGetProjects'),
(1, 5, 'task', 'confirmStoryChange'),
(1, 5, 'story', 'activate'),
(1, 5, 'project', 'edit'),
(1, 5, 'project', 'delete'),
(1, 5, 'story', 'close'),
(1, 5, 'project', 'burn'),
(1, 5, 'product', 'ajaxGetPlans'),
(1, 5, 'task', 'edit'),
(1, 5, 'story', 'tasks'),
(1, 5, 'productplan', 'browse'),
(1, 5, 'story', 'edit'),
(1, 5, 'task', 'ajaxGetProjectTasks'),
(1, 5, 'release', 'browse'),
(1, 5, 'task', 'ajaxGetUserTasks'),
(1, 5, 'project', 'task'),
(1, 5, 'build', 'ajaxGetProjectBuilds'),
(1, 5, 'task', 'finish'),
(1, 5, 'task', 'start'),
(1, 5, 'story', 'ajaxGetProductStories'),
(1, 5, 'project', 'computeBurn'),
(1, 5, 'project', 'team'),
(1, 5, 'release', 'view'),
(1, 5, 'productplan', 'unlinkStory'),
(1, 5, 'story', 'create'),
(1, 5, 'story', 'view'),
(1, 5, 'story', 'export'),
(1, 5, 'project', 'build'),
(1, 5, 'my', 'dynamic'),
(1, 5, 'task', 'report'),
(1, 5, 'task', 'export'),
(1, 5, 'build', 'delete'),
(1, 5, 'project', 'story'),
(1, 5, 'project', 'importtask'),
(1, 5, 'story', 'change'),
(1, 5, 'task', 'create'),
(1, 5, 'testtask', 'index'),
(1, 5, 'project', 'unlinkStory'),
(1, 5, 'productplan', 'view'),
(1, 5, 'story', 'report'),
(1, 5, 'todo', 'delete'),
(1, 5, 'story', 'ajaxGetProjectStories'),
(1, 5, 'user', 'dynamic'),
(1, 5, 'todo', 'mark'),
(1, 5, 'todo', 'create'),
(1, 5, 'build', 'ajaxGetProductBuilds'),
(1, 5, 'task', 'cancel'),
(1, 5, 'build', 'view'),
(1, 5, 'my', 'task'),
(1, 5, 'testcase', 'browse'),
(1, 5, 'my', 'project'),
(1, 5, 'index', 'index'),
(1, 5, 'bug', 'create'),
(1, 5, 'doc', 'create'),
(1, 5, 'user', 'profile'),
(1, 5, 'product', 'index'),
(1, 5, 'my', 'profile'),
(1, 5, 'product', 'browse'),
(1, 5, 'product', 'doc'),
(1, 5, 'build', 'edit'),
(1, 5, 'product', 'view'),
(1, 5, 'product', 'roadmap'),
(1, 5, 'doc', 'createLib'),
(1, 1, 'product', 'roadmap'),
(1, 1, 'product', 'delete'),
(1, 1, 'product', 'edit'),
(1, 2, 'product', 'browse'),
(1, 2, 'testcase', 'index'),
(1, 2, 'story', 'create'),
(1, 2, 'tree', 'edit'),
(1, 3, 'bug', 'resolve'),
(1, 3, 'doc', 'browse'),
(1, 3, 'doc', 'index'),
(1, 4, 'task', 'export'),
(1, 4, 'project', 'burnData'),
(1, 4, 'bug', 'activate'),
(1, 4, 'project', 'bug'),
(1, 5, 'doc', 'browse'),
(1, 5, 'testtask', 'results'),
(1, 1, 'product', 'view'),
(1, 1, 'product', 'create'),
(1, 1, 'product', 'browse'),
(1, 2, 'release', 'browse'),
(1, 2, 'story', 'ajaxGetProductStories'),
(1, 3, 'my', 'story'),
(1, 3, 'testcase', 'browse'),
(1, 4, 'bug', 'report'),
(1, 4, 'project', 'grouptask'),
(1, 5, 'my', 'todo'),
(1, 5, 'bug', 'ajaxGetUserBugs'),
(1, 5, 'bug', 'report'),
(1, 5, 'todo', 'view'),
(1, 1, 'product', 'index'),
(1, 1, 'todo', 'import2Today'),
(1, 1, 'todo', 'mark'),
(1, 1, 'todo', 'delete'),
(1, 1, 'todo', 'view'),
(1, 1, 'todo', 'edit'),
(1, 1, 'todo', 'create'),
(1, 1, 'my', 'editProfile'),
(1, 1, 'my', 'dynamic'),
(1, 1, 'my', 'profile'),
(1, 1, 'my', 'project'),
(1, 1, 'my', 'story'),
(1, 1, 'my', 'testcase'),
(1, 1, 'my', 'testtask'),
(1, 1, 'my', 'bug'),
(1, 1, 'my', 'task'),
(1, 1, 'my', 'todo'),
(1, 2, 'file', 'download'),
(1, 2, 'todo', 'mark'),
(1, 2, 'user', 'profile'),
(1, 2, 'tree', 'delete'),
(1, 2, 'search', 'deleteQuery'),
(1, 2, 'bug', 'close'),
(1, 2, 'todo', 'view'),
(1, 2, 'project', 'browse'),
(1, 2, 'project', 'view'),
(1, 2, 'project', 'unlinkStory'),
(1, 2, 'project', 'task'),
(1, 2, 'bug', 'resolve'),
(1, 2, 'bug', 'activate'),
(1, 2, 'bug', 'view'),
(1, 3, 'todo', 'delete'),
(1, 3, 'bug', 'report'),
(1, 3, 'bug', 'edit'),
(1, 3, 'qa', 'index'),
(1, 3, 'bug', 'browse'),
(1, 3, 'bug', 'index'),
(1, 3, 'bug', 'activate'),
(1, 3, 'project', 'burnData'),
(1, 3, 'task', 'view'),
(1, 3, 'project', 'doc'),
(1, 3, 'project', 'bug'),
(1, 3, 'user', 'dynamic'),
(1, 3, 'user', 'todo'),
(1, 3, 'doc', 'view'),
(1, 4, 'testcase', 'delete'),
(1, 4, 'todo', 'import2Today'),
(1, 4, 'testcase', 'browse'),
(1, 4, 'testcase', 'create'),
(1, 4, 'testcase', 'edit'),
(1, 4, 'product', 'browse'),
(1, 4, 'todo', 'view'),
(1, 4, 'doc', 'view'),
(1, 4, 'project', 'view'),
(1, 4, 'productplan', 'view'),
(1, 4, 'project', 'index'),
(1, 4, 'product', 'ajaxGetPlans'),
(1, 4, 'story', 'review'),
(1, 4, 'story', 'edit'),
(1, 5, 'bug', 'edit'),
(1, 5, 'qa', 'index'),
(1, 5, 'bug', 'browse'),
(1, 5, 'bug', 'index'),
(1, 5, 'bug', 'activate'),
(1, 5, 'project', 'ajaxGetProducts'),
(1, 5, 'task', 'delete'),
(1, 5, 'project', 'doc'),
(1, 5, 'project', 'grouptask'),
(1, 5, 'user', 'todo'),
(1, 5, 'user', 'view'),
(1, 5, 'company', 'index'),
(1, 5, 'bug', 'deleteTemplate'),
(1, 5, 'project', 'view'),
(1, 1, 'my', 'index'),
(1, 1, 'index', 'index'),
(1, 2, 'product', 'ajaxGetProjects'),
(1, 3, 'bug', 'deleteTemplate'),
(1, 3, 'bug', 'saveTemplate'),
(1, 3, 'bug', 'customFields'),
(1, 3, 'bug', 'close'),
(1, 4, 'testcase', 'confirmStoryChange'),
(1, 5, 'bug', 'saveTemplate'),
(1, 5, 'bug', 'customFields'),
(1, 5, 'bug', 'close'),
(1, 5, 'search', 'saveQuery'),
(1, 5, 'search', 'buildQuery'),
(1, 6, 'testtask', 'results'),
(1, 6, 'testcase', 'browse'),
(1, 6, 'testtask', 'index'),
(1, 6, 'bug', 'ajaxGetModuleOwner'),
(1, 6, 'testcase', 'index'),
(1, 6, 'testcase', 'view'),
(1, 6, 'testtask', 'browse'),
(1, 6, 'testtask', 'view'),
(1, 6, 'project', 'view'),
(1, 6, 'project', 'browse'),
(1, 6, 'project', 'task'),
(1, 6, 'project', 'grouptask'),
(1, 6, 'bug', 'ajaxGetUserBugs'),
(1, 6, 'bug', 'report'),
(1, 6, 'project', 'burn'),
(1, 6, 'project', 'bug'),
(1, 6, 'task', 'ajaxGetProjectTasks'),
(1, 6, 'project', 'doc'),
(1, 6, 'bug', 'browse'),
(1, 6, 'task', 'view'),
(1, 6, 'build', 'view'),
(1, 6, 'task', 'ajaxGetUserTasks'),
(1, 6, 'qa', 'index'),
(1, 6, 'bug', 'index'),
(1, 6, 'build', 'ajaxGetProjectBuilds'),
(1, 6, 'project', 'ajaxGetProducts'),
(1, 6, 'build', 'ajaxGetProductBuilds'),
(1, 6, 'bug', 'view'),
(1, 6, 'release', 'browse'),
(1, 6, 'release', 'view'),
(1, 6, 'project', 'index'),
(1, 6, 'user', 'task'),
(1, 6, 'user', 'project'),
(1, 6, 'user', 'bug'),
(1, 6, 'project', 'team'),
(1, 6, 'search', 'buildForm'),
(1, 6, 'search', 'buildQuery'),
(1, 6, 'user', 'dynamic'),
(1, 6, 'user', 'profile'),
(1, 6, 'file', 'download'),
(1, 6, 'file', 'ajaxUpload'),
(1, 6, 'productplan', 'browse'),
(1, 6, 'productplan', 'view'),
(1, 6, 'story', 'ajaxGetProductStories'),
(1, 6, 'story', 'view'),
(1, 6, 'story', 'ajaxGetProjectStories'),
(1, 6, 'product', 'ajaxGetProjects'),
(1, 6, 'story', 'tasks'),
(1, 6, 'product', 'ajaxGetPlans'),
(1, 6, 'company', 'dynamic'),
(1, 6, 'group', 'browse'),
(1, 6, 'company', 'browse'),
(1, 6, 'user', 'view'),
(1, 6, 'user', 'todo'),
(1, 6, 'doc', 'index'),
(1, 6, 'index', 'index'),
(1, 6, 'product', 'index'),
(1, 6, 'product', 'browse'),
(1, 6, 'product', 'doc'),
(1, 6, 'product', 'view'),
(1, 6, 'product', 'roadmap'),
(1, 6, 'project', 'build'),
(1, 6, 'project', 'story'),
(1, 6, 'doc', 'view'),
(1, 6, 'doc', 'browse'),
(1, 6, 'company', 'index'),
(1, 6, 'testtask', 'cases'),
(1, 1, 'search', 'buildForm'),
(1, 1, 'search', 'buildQuery'),
(1, 1, 'search', 'saveQuery'),
(1, 1, 'search', 'deleteQuery'),
(1, 1, 'search', 'select'),
(1, 1, 'admin', 'index'),
(1, 1, 'extension', 'browse'),
(1, 1, 'extension', 'obtain'),
(1, 1, 'extension', 'install'),
(1, 1, 'extension', 'uninstall'),
(1, 1, 'extension', 'activate'),
(1, 1, 'extension', 'deactivate'),
(1, 1, 'extension', 'upload'),
(1, 1, 'extension', 'erase'),
(1, 1, 'api', 'getModel'),
(1, 1, 'file', 'download'),
(1, 1, 'file', 'delete'),
(1, 1, 'file', 'ajaxUpload'),
(1, 1, 'misc', 'ping'),
(1, 1, 'action', 'trash'),
(1, 1, 'action', 'undelete'),
(1, 2, 'release', 'edit'),
(1, 2, 'release', 'delete'),
(1, 2, 'testtask', 'view'),
(1, 2, 'testtask', 'cases'),
(1, 2, 'testtask', 'index'),
(1, 3, 'search', 'buildQuery'),
(1, 3, 'search', 'saveQuery'),
(1, 3, 'search', 'deleteQuery'),
(1, 3, 'file', 'download'),
(1, 3, 'file', 'ajaxUpload'),
(1, 3, 'misc', 'ping'),
(1, 2, 'misc', 'ping'),
(1, 4, 'search', 'buildQuery'),
(1, 4, 'search', 'saveQuery'),
(1, 4, 'search', 'deleteQuery'),
(1, 4, 'file', 'download'),
(1, 4, 'file', 'ajaxUpload'),
(1, 4, 'misc', 'ping'),
(1, 5, 'search', 'deleteQuery'),
(1, 5, 'file', 'download'),
(1, 5, 'file', 'ajaxUpload'),
(1, 5, 'misc', 'ping'),
(1, 5, 'action', 'trash'),
(1, 5, 'action', 'undelete'),
(1, 6, 'misc', 'ping'),
(1, 1, 'bug', 'export'),
(1, 2, 'bug', 'export'),
(1, 3, 'bug', 'export'),
(1, 4, 'bug', 'export'),
(1, 5, 'bug', 'export');
