/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Serializer {
    private static final byte __Quote = 34;
    private static final byte __0 = 48;
    private static final byte __1 = 49;
    private static final byte __Colon = 58;
    private static final byte __Semicolon = 59;
    private static final byte __N = 78;
    private static final byte __U = 85;
    private static final byte __Slash = 92;
    private static final byte __a = 97;
    private static final byte __b = 98;
    private static final byte __d = 100;
    private static final byte __i = 105;
    private static final byte __s = 115;
    private static final byte __LeftB = 123;
    private static final byte __RightB = 125;
    private static final String __NAN = "NAN";
    private static final String __INF = "INF";
    private static final String __NINF = "-INF";
    private static final String charset = "UTF-8";

    public static String serialize(Object obj) {
        return Serializer.serialize(obj, charset);
    }

    public static String serialize(Object obj, String charset) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Serializer.serialize(stream, obj, charset);
        String result = null;
        try {
            result = stream.toString(charset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void serialize(ByteArrayOutputStream stream, Object obj, String charset) {
        if (obj == null) {
            Serializer.writeNull(stream);
        } else if (obj instanceof Boolean) {
            Serializer.writeBoolean(stream, (Boolean)obj != false ? (byte)49 : 48);
        } else if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer) {
            Serializer.writeInteger(stream, Serializer.getAsciiBytes(obj));
        } else if (obj instanceof Long) {
            Serializer.writeDouble(stream, Serializer.getAsciiBytes(obj));
        } else if (obj instanceof Float) {
            Float f = (Float)obj;
            obj = f.isNaN() ? __NAN : (!f.isInfinite() ? obj : (f.floatValue() > 0.0f ? __INF : __NINF));
            Serializer.writeDouble(stream, Serializer.getAsciiBytes(obj));
        } else if (obj instanceof Double) {
            Double d = (Double)obj;
            obj = d.isNaN() ? __NAN : (!d.isInfinite() ? obj : (d > 0.0 ? __INF : __NINF));
            Serializer.writeDouble(stream, Serializer.getAsciiBytes(obj));
        } else if (obj instanceof Character || obj instanceof String) {
            Serializer.writeString(stream, Serializer.getBytes(obj, charset));
        } else if (obj instanceof Map) {
            Serializer.writeMap(stream, (Map)obj, charset);
        } else if (obj instanceof List) {
            Serializer.writeList(stream, (List)obj, charset);
        } else {
            System.out.println("Serializer.serialize: The DataType is invalid");
        }
    }

    private static void writeNull(ByteArrayOutputStream stream) {
        stream.write(78);
        stream.write(59);
    }

    private static void writeBoolean(ByteArrayOutputStream stream, byte b) {
        stream.write(98);
        stream.write(58);
        stream.write(b);
        stream.write(59);
    }

    private static void writeInteger(ByteArrayOutputStream stream, byte[] i) {
        stream.write(105);
        stream.write(58);
        stream.write(i, 0, i.length);
        stream.write(59);
    }

    private static void writeDouble(ByteArrayOutputStream stream, byte[] d) {
        stream.write(100);
        stream.write(58);
        stream.write(d, 0, d.length);
        stream.write(59);
    }

    private static void writeString(ByteArrayOutputStream stream, byte[] s) {
        byte[] slen = Serializer.getAsciiBytes(s.length);
        stream.write(115);
        stream.write(58);
        stream.write(slen, 0, slen.length);
        stream.write(58);
        stream.write(34);
        stream.write(s, 0, s.length);
        stream.write(34);
        stream.write(59);
    }

    private static void writeList(ByteArrayOutputStream stream, List a, String charset) {
        int len = a.size();
        byte[] alen = Serializer.getAsciiBytes(len);
        stream.write(97);
        stream.write(58);
        stream.write(alen, 0, alen.length);
        stream.write(58);
        stream.write(123);
        int i = 0;
        while (i < len) {
            Serializer.writeInteger(stream, Serializer.getAsciiBytes(i));
            Serializer.serialize(stream, a.get(i), charset);
            ++i;
        }
        stream.write(125);
    }

    private static void writeMap(ByteArrayOutputStream stream, Map h, String charset) {
        int len = h.size();
        byte[] hlen = Serializer.getAsciiBytes(len);
        stream.write(97);
        stream.write(58);
        stream.write(hlen, 0, hlen.length);
        stream.write(58);
        stream.write(123);
        for (Object key : h.keySet()) {
            if (key instanceof Byte || key instanceof Short || key instanceof Integer) {
                Serializer.writeInteger(stream, Serializer.getAsciiBytes(key));
            } else if (key instanceof Boolean) {
                Serializer.writeInteger(stream, new byte[]{(Boolean)key != false ? (byte)49 : 48});
            } else {
                Serializer.writeString(stream, Serializer.getBytes(key, charset));
            }
            Serializer.serialize(stream, h.get(key), charset);
        }
        stream.write(125);
    }

    private static byte[] getAsciiBytes(Object obj) {
        try {
            return obj.toString().getBytes("US-ASCII");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static byte[] getBytes(Object obj, String charset) {
        try {
            return obj.toString().getBytes(charset);
        }
        catch (Exception e) {
            return obj.toString().getBytes();
        }
    }

    public static Object unserialize(String ss, int state) {
        return Serializer.unserialize(ss, charset, state);
    }

    public static Object unserialize(String ss, String charset, int state) {
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(ss.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Object result = Serializer.unserialize(stream, charset, state);
        return result;
    }

    private static Object unserialize(ByteArrayInputStream stream, String charset, int state) {
        switch (stream.read()) {
            case 78: {
                return Serializer.readNull(stream);
            }
            case 98: {
                return Serializer.readBoolean(stream);
            }
            case 105: {
                return Serializer.readInteger(stream);
            }
            case 100: {
                return Serializer.readDouble(stream);
            }
            case 115: {
                return Serializer.readString(stream, charset);
            }
            case 85: {
                return Serializer.readUnicodeString(stream);
            }
            case 97: {
                return Serializer.readArray(stream, charset, state);
            }
        }
        System.out.println("Serializer.unserialize: The DataType Is invalid,state=" + state);
        return null;
    }

    private static String readNumber(ByteArrayInputStream stream) {
        StringBuffer sb = new StringBuffer();
        int i = stream.read();
        while (i != 59 && i != 58) {
            sb.append((char)i);
            i = stream.read();
        }
        return sb.toString();
    }

    private static Object readNull(ByteArrayInputStream stream) {
        stream.skip(1L);
        return null;
    }

    private static Boolean readBoolean(ByteArrayInputStream stream) {
        stream.skip(1L);
        boolean b = stream.read() == 49;
        stream.skip(1L);
        return b;
    }

    private static Number readInteger(ByteArrayInputStream stream) {
        stream.skip(1L);
        String i = Serializer.readNumber(stream);
        return Integer.parseInt(i);
    }

    private static Number readDouble(ByteArrayInputStream stream) {
        stream.skip(1L);
        String d = Serializer.readNumber(stream);
        if (d.equals(__NAN)) {
            return new Double(Double.NaN);
        }
        if (d.equals(__INF)) {
            return new Double(Double.POSITIVE_INFINITY);
        }
        if (d.equals(__NINF)) {
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (d.indexOf(46) > 0 || d.indexOf(101) > 0 || d.indexOf(69) > 0) {
            return new Double(d);
        }
        int len = d.length();
        char c = d.charAt(0);
        if (len < 19 || c == '-' && len < 20) {
            return new Long(d);
        }
        if (len > 20 || c != '-' && len > 19) {
            return new Double(d);
        }
        try {
            return new Long(d);
        }
        catch (Exception e) {
            return new Double(d);
        }
    }

    private static String readString(ByteArrayInputStream stream, String charset) {
        stream.skip(1L);
        int len = Integer.parseInt(Serializer.readNumber(stream));
        stream.skip(1L);
        byte[] buf = new byte[len];
        stream.read(buf, 0, len);
        stream.skip(2L);
        try {
            return new String(buf, charset);
        }
        catch (Exception e) {
            return new String(buf);
        }
    }

    private static String readUnicodeString(ByteArrayInputStream stream) {
        stream.skip(1L);
        int len = Integer.parseInt(Serializer.readNumber(stream));
        stream.skip(1L);
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            int c = stream.read();
            if (c == 92) {
                char[] chs = new char[]{(char)stream.read(), (char)stream.read(), (char)stream.read(), (char)stream.read()};
                sb.append((char)Integer.parseInt(new String(chs), 16));
            } else {
                sb.append((char)c);
            }
            ++i;
        }
        stream.skip(2L);
        return sb.toString();
    }

    private static Object readArray(ByteArrayInputStream stream, String charset, int state) {
        stream.skip(1L);
        int n = Integer.parseInt(Serializer.readNumber(stream));
        stream.skip(1L);
        AbstractMap map = null;
        ArrayList<Object> list = null;
        if (state == 0) {
            list = new ArrayList<Object>(n);
            state = -1;
        } else {
            map = state == 1 ? new TreeMap() : new HashMap(n);
        }
        int i = 0;
        while (i < n) {
            Object key;
            switch (stream.read()) {
                case 105: {
                    key = Serializer.readInteger(stream);
                    break;
                }
                case 115: {
                    key = Serializer.readString(stream, charset);
                    break;
                }
                case 85: {
                    key = Serializer.readUnicodeString(stream);
                    break;
                }
                default: {
                    return null;
                }
            }
            Object result = Serializer.unserialize(stream, charset, state);
            if (list != null) {
                if (key instanceof Integer && (Integer)key == i) {
                    list.add(result);
                } else {
                    list = null;
                }
            } else {
                map.put(key, result);
            }
            ++i;
        }
        stream.skip(1L);
        if (list != null) {
            return list;
        }
        return map;
    }
}

