/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.utils;

import cn.jsprun.utils.Common;
import cn.jsprun.utils.Log;
import com.sun.mail.smtp.SMTPTransport;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mail {
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private String host = null;
    private int port = 25;
    private String auth = null;
    private String username = null;
    private String password = null;
    private boolean mailusername = false;
    private Session session = null;
    ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));

    public Mail(Map<String, String> mails) {
        this.host = mails.get("server");
        int tempPort = Common.toDigit(mails.get("port"));
        if (tempPort > 0) {
            this.port = tempPort;
        }
        this.auth = mails.get("auth");
        this.username = mails.get("auth_username");
        this.password = mails.get("auth_password");
        if ("1".equals(mails.get("mailusername"))) {
            this.mailusername = true;
        }
    }

    public Mail(String host, int port, String auth, String username, String password, String mailusername) {
        this.host = host;
        if (port > 0) {
            this.port = port;
        }
        this.auth = auth;
        this.username = username;
        this.password = password;
        if ("1".equals(mailusername)) {
            this.mailusername = true;
        }
    }

    private synchronized void createSession() {
        Properties mailProps = new Properties();
        mailProps.setProperty("mail.transport.protocol", "smtp");
        mailProps.setProperty("mail.smtp.host", this.host);
        mailProps.setProperty("mail.smtp.port", String.valueOf(this.port));
        if ("smtp.gmail.com".equals(this.host)) {
            mailProps.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
            mailProps.setProperty("mail.smtp.socketFactory.fallback", "false");
            mailProps.setProperty("mail.smtp.socketFactory.port", String.valueOf(this.port));
        }
        if ("1".equals(this.auth)) {
            mailProps.put("mail.smtp.auth", "true");
        }
        this.session = Session.getDefaultInstance((Properties)mailProps, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(Mail.this.username, Mail.this.password);
            }
        });
    }

    private MimeMessage createMimeMessage() {
        if (this.session == null) {
            this.createSession();
        }
        return new MimeMessage(this.session);
    }

    public String sendMessage(String from, String toEmail, String subject, String textBody, String htmlBody) {
        String result = null;
        try {
            String fromEmail;
            int index;
            String encoding = MimeUtility.mimeCharset((String)"UTF-8");
            MimeMessage message = this.createMimeMessage();
            String[] toEmails = toEmail.split(",");
            Address[] to = new Address[toEmails.length];
            int i = 0;
            while (i < toEmails.length) {
                String sTo = toEmails[i];
                if (sTo.matches("^.*<.*>$")) {
                    index = sTo.indexOf("<");
                    to[i] = new InternetAddress(sTo.substring(index + 1, sTo.length() - 1), this.mailusername ? sTo.substring(0, index) : "", encoding);
                } else {
                    to[i] = new InternetAddress(sTo, "", encoding);
                }
                ++i;
            }
            String fromName = null;
            if (from.matches("^.*<.*>$")) {
                index = from.indexOf("<");
                if (this.mailusername) {
                    fromName = from.substring(0, index);
                }
                fromEmail = from.substring(index + 1, from.length() - 1);
            } else {
                fromEmail = from;
            }
            InternetAddress fromAddress = new InternetAddress(fromEmail, fromName != null ? fromName : "", encoding);
            message.setHeader("Date", Common.gmdate("EEE, dd MMM yyyy HH:mm:ss Z", (int)(System.currentTimeMillis() / 1000L), "0"));
            message.setHeader("Content-Transfer-Encoding", "8bit");
            message.setRecipients(Message.RecipientType.TO, to);
            message.setFrom((Address)fromAddress);
            message.setSubject(subject, encoding);
            MimeMultipart content = new MimeMultipart("alternative");
            if (textBody != null && htmlBody != null) {
                MimeBodyPart text = new MimeBodyPart();
                text.setText(textBody, encoding);
                text.setDisposition("inline");
                content.addBodyPart((BodyPart)text);
                MimeBodyPart html = new MimeBodyPart();
                html.setContent((Object)htmlBody, "text/html;charset=" + encoding);
                html.setDisposition("inline");
                content.addBodyPart((BodyPart)html);
            } else if (textBody != null) {
                MimeBodyPart text = new MimeBodyPart();
                text.setText(textBody, encoding);
                text.setDisposition("inline");
                content.addBodyPart((BodyPart)text);
            } else if (htmlBody != null) {
                MimeBodyPart html = new MimeBodyPart();
                html.setContent((Object)htmlBody, "text/html;charset=" + encoding);
                html.setDisposition("inline");
                content.addBodyPart((BodyPart)html);
            }
            message.setContent((Multipart)content);
            message.setDisposition("inline");
            this.addToTask(message);
        }
        catch (Exception e) {
            result = e.getMessage();
        }
        return result;
    }

    private void addToTask(MimeMessage message) {
        if (message != null) {
            this.sendMessages((Collection<MimeMessage>)Collections.singletonList(message));
        } else {
            System.out.println("Cannot add null email message to queue.");
        }
    }

    private void sendMessages(Collection<MimeMessage> messages) {
        if (messages.size() == 0) {
            return;
        }
        this.executor.execute(new EmailTask(messages));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmailTask
    implements Runnable {
        private Collection<MimeMessage> messages;

        public EmailTask(Collection<MimeMessage> messages) {
            this.messages = messages;
        }

        @Override
        public void run() {
            try {
                this.sendMessages();
            }
            catch (MessagingException me) {
                int timestamp = (int)(System.currentTimeMillis() / 1000L);
                Log.writelog("errorlog", timestamp, String.valueOf(timestamp) + "\tSMTP\t\t(" + Mail.this.host + ":" + Mail.this.port + ") CONNECT - Unable to connect to the SMTP server");
            }
        }

        public boolean sendMessages() throws MessagingException {
            SMTPTransport transport = null;
            try {
                URLName url = new URLName("smtp", Mail.this.host, Mail.this.port, "", Mail.this.username, Mail.this.password);
                transport = new SMTPTransport(Mail.this.session, url);
                transport.connect(Mail.this.host, Mail.this.port, Mail.this.username, Mail.this.password);
                for (MimeMessage message : this.messages) {
                    transport.sendMessage((Message)message, message.getRecipients(MimeMessage.RecipientType.TO));
                }
                return true;
            }
            finally {
                if (transport != null) {
                    transport.close();
                }
            }
        }
    }
}

