/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.utils;

import cn.jsprun.utils.Common;
import cn.jsprun.utils.ForumInit;
import cn.jsprun.utils.JspRunConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Log {
    public static void writelog(String fileName, int timestamp, String log) {
        Log.writelog(fileName, timestamp, log, false);
    }

    public static void writelog(String fileName, int timestamp, String log, boolean isMoreLine) {
        if (log.length() > 0) {
            Map<String, String> settings = ForumInit.settings;
            String yearmonth = Common.gmdate("yyyyMM", timestamp, settings.get("timeoffset"));
            String logdir = String.valueOf(JspRunConfig.realPath) + "forumdata/logs/";
            String logFileName = String.valueOf(logdir) + yearmonth + "_" + fileName + ".jsp";
            File logFile = new File(logFileName);
            if (logFile.exists() && logFile.length() > 2048000L) {
                File[] files = new File(logdir).listFiles();
                int id = 0;
                int maxid = 0;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String name;
                    File file = fileArray[n2];
                    if (file.isFile() && Common.matches(name = file.getName(), "^" + yearmonth + "_" + fileName + "_(\\d)*\\.jsp$")) {
                        id = Integer.valueOf(name.substring(name.lastIndexOf("_") + 1, name.lastIndexOf(".")));
                        maxid = id > maxid ? id : maxid;
                    }
                    ++n2;
                }
                files = null;
                logFile.renameTo(new File(String.valueOf(logdir) + yearmonth + "_" + fileName + "_" + (maxid + 1) + ".jsp"));
            }
            logFile = null;
            try {
                FileOutputStream out = new FileOutputStream(logFileName, true);
                OutputStreamWriter fwout = new OutputStreamWriter((OutputStream)out, "UTF-8");
                BufferedWriter bw = new BufferedWriter(fwout);
                if (isMoreLine) {
                    bw.write(log);
                } else {
                    bw.write("<?JSP exit;?>\t" + Common.nl2br(log) + "\n");
                }
                bw.close();
                fwout.close();
                ((OutputStream)out).close();
                bw = null;
                fwout = null;
                out = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> readlog(String fileName, int timestamp, String keyword) {
        FileInputStream fr;
        ArrayList<String> list = new ArrayList<String>();
        Map<String, String> settings = ForumInit.settings;
        String yearmonth = Common.gmdate("yyyyMM", timestamp, settings.get("timeoffset"));
        String logdir = String.valueOf(JspRunConfig.realPath) + "forumdata/logs/";
        String logFileName = String.valueOf(logdir) + yearmonth + "_" + fileName + ".jsp";
        File logFile = new File(logFileName);
        File logFile2 = null;
        if (logFile.exists() && logFile.length() < 500000L) {
            File[] files = new File(logdir).listFiles();
            int id = 0;
            int maxid = 0;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                File file = fileArray[n2];
                if (file.isFile() && Common.matches(name = file.getName(), "^" + yearmonth + "_" + fileName + "_(\\d)*\\.jsp$")) {
                    id = Integer.valueOf(name.substring(name.lastIndexOf("_") + 1, name.lastIndexOf(".")));
                    maxid = id > maxid ? id : maxid;
                }
                ++n2;
            }
            files = null;
            if (maxid > 0) {
                logFile2 = new File(String.valueOf(logdir) + yearmonth + "_" + fileName + "_" + maxid + ".jsp");
            } else {
                Calendar calendar = Common.getCalendar(settings.get("timeoffset"));
                int month = calendar.get(2);
                month = month > 0 ? month - 1 : 11;
                calendar.set(2, month);
                int temptime = (int)(calendar.getTimeInMillis() / 1000L);
                String lastyearmonth = Common.gmdate("yyyyMM", temptime, settings.get("timeoffset"));
                logFile2 = new File(String.valueOf(logdir) + lastyearmonth + "_" + fileName + ".jsp");
            }
        }
        if (logFile2 != null && logFile2.exists()) {
            try {
                fr = new FileInputStream(logFile2);
                list.addAll(Log.readLog(fr, keyword));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (logFile.exists()) {
            try {
                fr = new FileInputStream(logFile);
                list.addAll(Log.readLog(fr, keyword));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private static List<String> readLog(FileInputStream filereader, String keyword) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = null;
        InputStreamReader ir = null;
        try {
            try {
                ir = new InputStreamReader((InputStream)filereader, "UTF-8");
                br = new BufferedReader(ir);
                String newline = br.readLine();
                while (newline != null) {
                    if (keyword != null) {
                        String[] str = newline.split("\t");
                        int i = 0;
                        while (i < str.length) {
                            if (str[i].indexOf(keyword) != -1) {
                                list.add(newline);
                                break;
                            }
                            ++i;
                        }
                    } else {
                        list.add(newline);
                    }
                    newline = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                        ir.close();
                        if (filereader != null) {
                            filereader.close();
                        }
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                    ir.close();
                    if (filereader != null) {
                        filereader.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

