/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.utils;

import cn.jsprun.service.DataBaseService;
import cn.jsprun.utils.BeanFactory;
import cn.jsprun.utils.Common;
import cn.jsprun.utils.IPSeeker;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.util.MessageResources;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class Jfreechart
extends HttpServlet {
    private static final long serialVersionUID = -205545450335033053L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MessageResources mr = Common.getMessageResources(request);
        Locale locale = Common.getUserLocale(request);
        String arear = request.getParameter("arears");
        if (arear != null && arear.equals("changjiang")) {
            DefaultPieDataset data = this.getDataSet(arear, mr, locale);
            JFreeChart chart = ChartFactory.createPieChart3D((String)mr.getMessage(locale, "jfreechar_changjiang"), (PieDataset)data, (boolean)true, (boolean)false, (boolean)false);
            try {
                ChartUtilities.writeChartAsJPEG((OutputStream)response.getOutputStream(), (float)1.0f, (JFreeChart)chart, (int)400, (int)300, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (arear != null && arear.equals("huanghe")) {
            DefaultPieDataset data = this.getDataSet(arear, mr, locale);
            JFreeChart chart = ChartFactory.createPieChart3D((String)mr.getMessage(locale, "jfreechar_huanghei"), (PieDataset)data, (boolean)true, (boolean)false, (boolean)false);
            try {
                ChartUtilities.writeChartAsJPEG((OutputStream)response.getOutputStream(), (float)1.0f, (JFreeChart)chart, (int)400, (int)300, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            DefaultPieDataset data = this.getDataSet(arear, mr, locale);
            JFreeChart chart = ChartFactory.createPieChart3D((String)mr.getMessage(locale, "jfreechar_member"), (PieDataset)data, (boolean)true, (boolean)false, (boolean)false);
            try {
                ChartUtilities.writeChartAsJPEG((OutputStream)response.getOutputStream(), (float)1.0f, (JFreeChart)chart, (int)400, (int)300, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void init() throws ServletException {
    }

    private DefaultPieDataset getDataSet(String res, MessageResources mr, Locale locale) {
        DecimalFormat df = new DecimalFormat("0.00");
        DefaultPieDataset dataset = new DefaultPieDataset();
        List<Map<String, String>> memberlist = ((DataBaseService)BeanFactory.getBean("dataBaseService")).executeQuery("select regip from jrun_members", new String[0]);
        IPSeeker seeker = IPSeeker.getInstance();
        if (memberlist != null && memberlist.size() > 0) {
            if (res.equals("changjiang")) {
                String[] north = new String[]{"\u8fbd\u5b81", "\u5409\u6797", "\u6cb3\u5357", "\u6cb3\u5317", "\u9655\u897f", "\u5c71\u897f", "\u9ed1\u9f99\u6c5f", "\u7518\u8083", "\u5185\u8499\u53e4", "\u5317\u4eac\u5e02", "\u5929\u6d25\u5e02", "\u5c71\u4e1c"};
                int northint = 0;
                int southint = 0;
                for (Map<String, String> members : memberlist) {
                    String address = seeker.getAddress(members.get("regip"), mr, locale);
                    boolean flag = false;
                    int j = 0;
                    while (j < north.length) {
                        if (address.indexOf(north[j]) != -1) {
                            ++northint;
                            flag = true;
                        }
                        ++j;
                    }
                    if (flag) continue;
                    ++southint;
                }
                double percentnorth = (double)northint / (double)(northint + southint) * 100.0;
                double percentsouth = (double)southint / (double)(northint + southint) * 100.0;
                dataset.setValue((Comparable)((Object)(String.valueOf(mr.getMessage(locale, "jfreechar_changjiang_north")) + df.format(percentnorth) + "%")), (double)northint);
                dataset.setValue((Comparable)((Object)(String.valueOf(mr.getMessage(locale, "jfreechar_changjiang_south")) + df.format(percentsouth) + "%")), (double)southint);
            } else if (res.equals("huanghe")) {
                dataset.setValue((Comparable)((Object)mr.getMessage(locale, "jfreechar_huanghei_nodata")), 0.0);
            } else {
                String[] north = new String[]{"\u7535\u4fe1", "\u7f51\u901a", "\u94c1\u901a", "\u624b\u673a", "\u8054\u901a", "\u79fb\u52a8", "\u5176\u5b83"};
                int telecom = 0;
                int reticle = 0;
                int tianton = 0;
                int souji = 0;
                int lianton = 0;
                int yidong = 0;
                int other = 0;
                for (Map<String, String> members : memberlist) {
                    String address = seeker.getAddress(members.get("regip"), mr, locale);
                    if (address.indexOf(north[0]) != -1) {
                        ++telecom;
                        continue;
                    }
                    if (address.indexOf(north[1]) != -1) {
                        ++reticle;
                        continue;
                    }
                    if (address.indexOf(north[2]) != -1) {
                        ++tianton;
                        continue;
                    }
                    if (address.indexOf(north[3]) != -1) {
                        ++souji;
                        continue;
                    }
                    if (address.indexOf(north[4]) != -1) {
                        ++lianton;
                        continue;
                    }
                    if (address.indexOf(north[5]) != -1) {
                        ++yidong;
                        continue;
                    }
                    ++other;
                }
                double percenttele = (double)telecom / (double)(telecom + reticle + other + tianton + souji + lianton + yidong) * 100.0;
                double percentreticle = (double)reticle / (double)(telecom + reticle + other + tianton + souji + lianton + yidong) * 100.0;
                double percentother = (double)other / (double)(telecom + reticle + other + tianton + souji + lianton + yidong) * 100.0;
                double percenttianton = (double)tianton / (double)(telecom + reticle + other + tianton + souji + lianton + yidong) * 100.0;
                double percentsouji = (double)souji / (double)(telecom + reticle + other + tianton + souji + lianton + yidong) * 100.0;
                double percentlianton = (double)lianton / (double)(telecom + reticle + other + tianton + souji + lianton + yidong) * 100.0;
                double percentyidong = (double)yidong / (double)(telecom + reticle + other + tianton + souji + lianton + yidong) * 100.0;
                dataset.setValue((Comparable)((Object)(String.valueOf(mr.getMessage(locale, "jfreechar_telecom")) + df.format(percenttele) + "%")), (double)telecom);
                dataset.setValue((Comparable)((Object)(String.valueOf(mr.getMessage(locale, "jfreechar_reticle")) + df.format(percentreticle) + "%")), (double)reticle);
                dataset.setValue((Comparable)((Object)(String.valueOf(mr.getMessage(locale, "jfreechar_iron")) + df.format(percenttianton) + "%")), (double)tianton);
                dataset.setValue((Comparable)((Object)(String.valueOf(mr.getMessage(locale, "jfreechar_combined")) + df.format(percentsouji) + "%")), (double)souji);
                dataset.setValue((Comparable)((Object)(String.valueOf(mr.getMessage(locale, "jfreechar_couplet")) + df.format(percentlianton) + "%")), (double)lianton);
                dataset.setValue((Comparable)((Object)(String.valueOf(mr.getMessage(locale, "jfreechar_move")) + df.format(percentyidong) + "%")), (double)yidong);
                dataset.setValue((Comparable)((Object)(String.valueOf(mr.getMessage(locale, "jfreechar_other")) + df.format(percentother) + "%")), (double)other);
            }
        }
        memberlist = null;
        return dataset;
    }
}

