/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.utils;

import cn.jsprun.utils.IPEntry;
import cn.jsprun.utils.JspRunConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.struts.util.MessageResources;

public class IPSeeker {
    private static final int IP_RECORD_LENGTH = 7;
    private static final byte AREA_FOLLOWED = 1;
    private static final byte NO_AREA = 2;
    private Hashtable ipCache = new Hashtable();
    private RandomAccessFile ipFile;
    private MappedByteBuffer mbb;
    private static IPSeeker instance = null;
    private long ipBegin;
    private long ipEnd;
    private IPLocation loc = new IPLocation();
    private byte[] buf = new byte[100];
    private byte[] b4 = new byte[4];
    private byte[] b3 = new byte[3];

    private IPSeeker() {
        try {
            this.ipFile = new RandomAccessFile(String.valueOf(JspRunConfig.realPath) + "ipdata/ipdata.Dat", "r");
        }
        catch (FileNotFoundException e) {
            System.out.println("IP\u5730\u5740\u4fe1\u606f\u6587\u4ef6\u6ca1\u6709\u627e\u5230\uff0cIP\u663e\u793a\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528");
            this.ipFile = null;
        }
        if (this.ipFile != null) {
            try {
                this.ipBegin = this.readLong4(0L);
                this.ipEnd = this.readLong4(4L);
                if (this.ipBegin == -1L || this.ipEnd == -1L) {
                    this.ipFile.close();
                    this.ipFile = null;
                }
            }
            catch (IOException e) {
                this.ipFile = null;
            }
        }
    }

    public static synchronized IPSeeker getInstance() {
        if (instance == null) {
            instance = new IPSeeker();
        }
        return instance;
    }

    public List getIPEntriesDebug(String s, MessageResources mr, Locale locale) {
        ArrayList<IPEntry> ret = new ArrayList<IPEntry>();
        long endOffset = this.ipEnd + 4L;
        long offset = this.ipBegin + 4L;
        while (offset <= endOffset) {
            long temp = this.readLong3(offset);
            if (temp != -1L) {
                IPLocation loc = this.getIPLocation(temp, mr, locale);
                if (loc.country.indexOf(s) != -1 || loc.area.indexOf(s) != -1) {
                    IPEntry entry = new IPEntry();
                    entry.country = loc.country;
                    entry.area = loc.area;
                    this.readIP(offset - 4L, this.b4);
                    entry.beginIp = this.getIpStringFromBytes(this.b4);
                    this.readIP(temp, this.b4);
                    entry.endIp = this.getIpStringFromBytes(this.b4);
                    ret.add(entry);
                }
            }
            offset += 7L;
        }
        return ret;
    }

    public List getIPEntries(String s, MessageResources mr, Locale locale) {
        ArrayList<IPEntry> ret = new ArrayList<IPEntry>();
        try {
            if (this.mbb == null) {
                FileChannel fc = this.ipFile.getChannel();
                this.mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.ipFile.length());
                this.mbb.order(ByteOrder.LITTLE_ENDIAN);
            }
            int endOffset = (int)this.ipEnd;
            int offset = (int)this.ipBegin + 4;
            while (offset <= endOffset) {
                int temp = this.readInt3(offset);
                if (temp != -1) {
                    IPLocation loc = this.getIPLocation(temp, mr, locale);
                    if (loc.country.indexOf(s) != -1 || loc.area.indexOf(s) != -1) {
                        IPEntry entry = new IPEntry();
                        entry.country = loc.country;
                        entry.area = loc.area;
                        this.readIP(offset - 4, this.b4);
                        entry.beginIp = this.getIpStringFromBytes(this.b4);
                        this.readIP(temp, this.b4);
                        entry.endIp = this.getIpStringFromBytes(this.b4);
                        ret.add(entry);
                    }
                }
                offset += 7;
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return ret;
    }

    private int readInt3(int offset) {
        this.mbb.position(offset);
        return this.mbb.getInt() & 0xFFFFFF;
    }

    private int readInt3() {
        return this.mbb.getInt() & 0xFFFFFF;
    }

    public String getCountry(byte[] ip, MessageResources mr, Locale locale) {
        if (this.ipFile == null) {
            return mr.getMessage(locale, "error_ip_file");
        }
        String ipStr = this.getIpStringFromBytes(ip);
        if (this.ipCache.containsKey(ipStr)) {
            IPLocation loc = (IPLocation)this.ipCache.get(ipStr);
            return loc.country;
        }
        IPLocation loc = this.getIPLocation(ip, mr, locale);
        this.ipCache.put(ipStr, loc.getCopy());
        return loc.country;
    }

    public String getCountry(String ip, MessageResources mr, Locale locale) {
        return this.getCountry(this.getIpByteArrayFromString(ip), mr, locale);
    }

    public String getArea(byte[] ip, MessageResources mr, Locale locale) {
        if (this.ipFile == null) {
            return mr.getMessage(locale, "error_ip_file");
        }
        String ipStr = this.getIpStringFromBytes(ip);
        if (this.ipCache.containsKey(ipStr)) {
            IPLocation loc = (IPLocation)this.ipCache.get(ipStr);
            return loc.area;
        }
        IPLocation loc = this.getIPLocation(ip, mr, locale);
        this.ipCache.put(ipStr, loc.getCopy());
        return loc.area;
    }

    public String getArea(String ip, MessageResources mr, Locale locale) {
        return this.getArea(this.getIpByteArrayFromString(ip), mr, locale);
    }

    private IPLocation getIPLocation(byte[] ip, MessageResources mr, Locale locale) {
        IPLocation info = null;
        long offset = this.locateIP(ip);
        if (offset != -1L) {
            info = this.getIPLocation(offset, mr, locale);
        }
        if (info == null) {
            info = new IPLocation();
            info.country = mr.getMessage(locale, "unbeknown_country");
            info.area = mr.getMessage(locale, "unbeknown_area");
        }
        return info;
    }

    private long readLong4(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            ret |= (long)(this.ipFile.readByte() & 0xFF);
            ret |= (long)(this.ipFile.readByte() << 8 & 0xFF00);
            ret |= (long)(this.ipFile.readByte() << 16 & 0xFF0000);
            return ret |= (long)(this.ipFile.readByte() << 24 & 0xFF000000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3() {
        long ret = 0L;
        try {
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private void readIP(long offset, byte[] ip) {
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(ip);
            byte temp = ip[0];
            ip[0] = ip[3];
            ip[3] = temp;
            temp = ip[1];
            ip[1] = ip[2];
            ip[2] = temp;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private void readIP(int offset, byte[] ip) {
        this.mbb.position(offset);
        this.mbb.get(ip);
        byte temp = ip[0];
        ip[0] = ip[3];
        ip[3] = temp;
        temp = ip[1];
        ip[1] = ip[2];
        ip[2] = temp;
    }

    private int compareIP(byte[] ip, byte[] beginIp) {
        int i = 0;
        while (i < 4) {
            int r = this.compareByte(ip[i], beginIp[i]);
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return 0;
    }

    private int compareByte(byte b1, byte b2) {
        if ((b1 & 0xFF) > (b2 & 0xFF)) {
            return 1;
        }
        if ((b1 ^ b2) == 0) {
            return 0;
        }
        return -1;
    }

    private long locateIP(byte[] ip) {
        long m = 0L;
        this.readIP(this.ipBegin, this.b4);
        int r = this.compareIP(ip, this.b4);
        if (r == 0) {
            return this.ipBegin;
        }
        if (r < 0) {
            return -1L;
        }
        long i = this.ipBegin;
        long j = this.ipEnd;
        while (i < j) {
            m = this.getMiddleOffset(i, j);
            this.readIP(m, this.b4);
            r = this.compareIP(ip, this.b4);
            if (r > 0) {
                i = m;
                continue;
            }
            if (r < 0) {
                if (m == j) {
                    m = j -= 7L;
                    continue;
                }
                j = m;
                continue;
            }
            return this.readLong3(m + 4L);
        }
        m = this.readLong3(m + 4L);
        this.readIP(m, this.b4);
        r = this.compareIP(ip, this.b4);
        if (r <= 0) {
            return m;
        }
        return -1L;
    }

    private long getMiddleOffset(long begin, long end) {
        long records = (end - begin) / 7L;
        if ((records >>= 1) == 0L) {
            records = 1L;
        }
        return begin + records * 7L;
    }

    private IPLocation getIPLocation(long offset, MessageResources mr, Locale locale) {
        try {
            this.ipFile.seek(offset + 4L);
            byte b = this.ipFile.readByte();
            if (b == 1) {
                long countryOffset = this.readLong3();
                this.ipFile.seek(countryOffset);
                b = this.ipFile.readByte();
                if (b == 2) {
                    this.loc.country = this.readString(this.readLong3());
                    this.ipFile.seek(countryOffset + 4L);
                } else {
                    this.loc.country = this.readString(countryOffset);
                }
                this.loc.area = this.readArea(this.ipFile.getFilePointer(), mr, locale);
            } else if (b == 2) {
                this.loc.country = this.readString(this.readLong3());
                this.loc.area = this.readArea(offset + 8L, mr, locale);
            } else {
                this.loc.country = this.readString(this.ipFile.getFilePointer() - 1L);
                this.loc.area = this.readArea(this.ipFile.getFilePointer(), mr, locale);
            }
            return this.loc;
        }
        catch (IOException e) {
            return null;
        }
    }

    private IPLocation getIPLocation(int offset, MessageResources mr, Locale locale) {
        this.mbb.position(offset + 4);
        byte b = this.mbb.get();
        if (b == 1) {
            int countryOffset = this.readInt3();
            this.mbb.position(countryOffset);
            b = this.mbb.get();
            if (b == 2) {
                this.loc.country = this.readString(this.readInt3());
                this.mbb.position(countryOffset + 4);
            } else {
                this.loc.country = this.readString(countryOffset);
            }
            this.loc.area = this.readArea(this.mbb.position(), mr, locale);
        } else if (b == 2) {
            this.loc.country = this.readString(this.readInt3());
            this.loc.area = this.readArea(offset + 8, mr, locale);
        } else {
            this.loc.country = this.readString(this.mbb.position() - 1);
            this.loc.area = this.readArea(this.mbb.position(), mr, locale);
        }
        return this.loc;
    }

    private String readArea(long offset, MessageResources mr, Locale locale) throws IOException {
        this.ipFile.seek(offset);
        byte b = this.ipFile.readByte();
        if (b == 1 || b == 2) {
            long areaOffset = this.readLong3(offset + 1L);
            if (areaOffset == 0L) {
                return mr.getMessage(locale, "unbeknown_area");
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readArea(int offset, MessageResources mr, Locale locale) {
        this.mbb.position(offset);
        byte b = this.mbb.get();
        if (b == 1 || b == 2) {
            int areaOffset = this.readInt3();
            if (areaOffset == 0) {
                return mr.getMessage(locale, "unbeknown_area");
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readString(long offset) {
        try {
            this.ipFile.seek(offset);
            int i = 0;
            byte[] buf = new byte[256];
            while ((buf[i] = this.ipFile.readByte()) != 0) {
                if (++i < buf.length) continue;
                byte[] tmp = new byte[i + 100];
                System.arraycopy(buf, 0, tmp, 0, i);
                buf = tmp;
            }
            if (i != 0) {
                return this.getString(buf, 0, i, "GBK");
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return "";
    }

    private String readString(int offset) {
        try {
            this.mbb.position(offset);
            int i = 0;
            this.buf[i] = this.mbb.get();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.mbb.get();
            }
            if (i != 0) {
                return this.getString(this.buf, 0, i, "GBK");
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        return "";
    }

    public String getAddress(String ip, MessageResources mr, Locale locale) {
        if (ip.matches("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$")) {
            String country = this.getCountry(ip, mr, locale).equals(" CZ88.NET") ? "" : this.getCountry(ip, mr, locale);
            String area = this.getArea(ip, mr, locale).equals(" CZ88.NET") ? "" : this.getArea(ip, mr, locale);
            String address = String.valueOf(country) + " " + area;
            return address.trim();
        }
        return mr.getMessage(locale, "nullity_address");
    }

    private byte[] getIpByteArrayFromString(String ip) {
        byte[] ret = new byte[4];
        StringTokenizer st = new StringTokenizer(ip, ".");
        try {
            ret[0] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
            ret[1] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
            ret[2] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
            ret[3] = (byte)(Integer.parseInt(st.nextToken()) & 0xFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private String getString(byte[] b, int offset, int len, String encoding) {
        try {
            return new String(b, offset, len, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(b, offset, len);
        }
    }

    private String getIpStringFromBytes(byte[] ip) {
        StringBuffer sb = new StringBuffer();
        sb.append(ip[0] & 0xFF);
        sb.append('.');
        sb.append(ip[1] & 0xFF);
        sb.append('.');
        sb.append(ip[2] & 0xFF);
        sb.append('.');
        sb.append(ip[3] & 0xFF);
        return sb.toString();
    }

    private class IPLocation {
        public String country = "";
        public String area = "";

        public IPLocation getCopy() {
            IPLocation ret = new IPLocation();
            ret.country = this.country;
            ret.area = this.area;
            return ret;
        }
    }
}

