/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.utils;

import cn.jsprun.dao.DataBaseDao;
import cn.jsprun.utils.BeanFactory;
import cn.jsprun.utils.Common;
import cn.jsprun.utils.DataParse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ForumInit {
    private static DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
    private static DataParse dataParse = (DataParse)BeanFactory.getBean("dataParse");
    public static Map<String, String> settings = null;

    public static synchronized void initServletContext(ServletContext context) {
        settings = ForumInit.queryForumSetInfo();
        Map msgforward = dataParse.characterParse(settings.get("msgforward"), true);
        context.setAttribute("msgforward", (Object)msgforward);
        context.setAttribute("settings", settings);
    }

    public static void setSettings(ServletContext context, Map<String, String> value) {
        settings = value == null ? ForumInit.queryForumSetInfo() : value;
        context.setAttribute("settings", settings);
    }

    public static Map<String, String> queryForumSetInfo() {
        List<Map<String, String>> pluginhooks;
        List<Map<String, String>> dataList = dataBaseDao.executeQuery("SELECT * FROM jrun_settings", new String[0]);
        if (dataList == null) {
            return null;
        }
        HashMap<String, String> datas = new HashMap<String, String>();
        for (Map<String, String> data : dataList) {
            datas.put(data.get("variable"), data.get("value"));
        }
        datas.put("extcredits_bak", (String)datas.get("extcredits"));
        Map extcredits = dataParse.characterParse((String)datas.get("extcredits"), false);
        if (extcredits != null && extcredits.size() > 0) {
            int creditstrans = Integer.valueOf((String)datas.get("creditstrans"));
            HashMap<Integer, Map> exchcredits = new HashMap<Integer, Map>();
            Set extcreditids = extcredits.keySet();
            boolean allowexchangein = false;
            boolean allowexchangeout = false;
            for (Integer extcreditid : extcreditids) {
                double ratio;
                String avalable;
                Map extcredit = (Map)extcredits.get(extcreditid);
                String string = avalable = extcredit.get("available") == null ? "" : extcredit.get("available").toString();
                if (!"1".equals(avalable)) continue;
                extcredit.remove("available");
                exchcredits.put(extcreditid, extcredit);
                Object obj = extcredit.get("ratio");
                if (obj == null) {
                    obj = 0;
                }
                if (!((ratio = Double.valueOf(obj.toString()).doubleValue()) > 0.0)) continue;
                if ("1".equals(extcredit.get("allowexchangein"))) {
                    allowexchangein = true;
                }
                if (!"1".equals(extcredit.get("allowexchangeout"))) continue;
                allowexchangeout = true;
            }
            datas.put("exchangestatus", allowexchangein && allowexchangeout ? "1" : "0");
            datas.put("transferstatus", exchcredits.get(creditstrans) != null ? "1" : "0");
            datas.put("extcredits", dataParse.combinationChar(exchcredits));
        }
        extcredits = null;
        int jsmenustatus = Integer.valueOf((String)datas.get("jsmenustatus"));
        datas.put("jsmenu_1", String.valueOf(jsmenustatus & 1));
        datas.put("jsmenu_2", String.valueOf(jsmenustatus & 2));
        datas.put("jsmenu_3", String.valueOf(jsmenustatus & 4));
        datas.put("jsmenu_4", String.valueOf(jsmenustatus & 8));
        datas.put("gtimeformat", ((String)datas.get("timeformat")).equals("1") ? "hh:mm a" : "HH:mm");
        datas.put("onlinehold", String.valueOf(Integer.valueOf((String)datas.get("onlinehold")) * 60));
        datas.put("version", "6.0.0");
        datas.put("totalmembers", dataBaseDao.executeQuery("SELECT COUNT(*) count FROM jrun_members", new String[0]).get(0).get("count"));
        int forumcount = Integer.valueOf(dataBaseDao.executeQuery("SELECT COUNT(*) count FROM jrun_forums WHERE status=1 AND threadcaches>0", new String[0]).get(0).get("count"));
        datas.put("cachethreadon", forumcount > 0 ? "1" : "0");
        List<Map<String, String>> lastMember = dataBaseDao.executeQuery("SELECT username FROM jrun_members ORDER BY uid DESC LIMIT 1", new String[0]);
        String username = lastMember != null && lastMember.size() > 0 ? lastMember.get(0).get("username").replace("\\", "\\\\") : "";
        lastMember = null;
        datas.put("lastmember", username);
        List<Map<String, String>> crons = dataBaseDao.executeQuery("SELECT nextrun FROM jrun_crons WHERE available=1 AND nextrun>'0' ORDER BY nextrun LIMIT 1", new String[0]);
        datas.put("cronnextrun", crons != null && crons.size() > 0 ? crons.get(0).get("nextrun") : "0");
        Map google = dataParse.characterParse((String)datas.get("google"), false);
        datas.put("google_status", (String)google.get("status"));
        datas.put("google_searchbox", (String)google.get("searchbox"));
        google = null;
        datas.remove("google");
        Map baidu = dataParse.characterParse((String)datas.get("baidu"), false);
        datas.put("baidu_status", (String)baidu.get("status"));
        datas.put("baidu_searchbox", (String)baidu.get("searchbox"));
        baidu = null;
        datas.remove("baidu");
        List<Map<String, String>> styleList = dataBaseDao.executeQuery("SELECT styleid, name FROM jrun_styles WHERE available='1'", new String[0]);
        if (styleList != null && styleList.size() > 0) {
            HashMap<Integer, String> styles = new HashMap<Integer, String>();
            for (Map<String, String> style : styleList) {
                styles.put(Integer.valueOf(style.get("styleid")), style.get("name"));
            }
            datas.put("forumStyles", styles != null ? dataParse.combinationChar(styles) : "");
        }
        styleList = null;
        Map globaladvs = Common.advertisement("all");
        datas.put("globaladvs", globaladvs.get("all") != null ? dataParse.combinationChar((Map)globaladvs.get("all")) : "");
        datas.put("redirectadvs", globaladvs.get("redirect") != null ? dataParse.combinationChar((Map)globaladvs.get("redirect")) : "");
        globaladvs = null;
        List<Map<String, String>> plugins = dataBaseDao.executeQuery("SELECT available, name, identifier, directory, datatables, modules FROM jrun_plugins where available='1'", new String[0]);
        if (plugins != null && plugins.size() > 0) {
            HashMap<String, Map<Object, Object>> pluginlinks = new HashMap<String, Map<Object, Object>>();
            TreeMap links = new TreeMap();
            TreeMap treeMap = new TreeMap();
            TreeMap jsmenus = new TreeMap();
            for (Map<String, String> plugin : plugins) {
                Map modules = dataParse.characterParse(plugin.get("modules"), false);
                if (modules == null || modules.size() <= 0) continue;
                Set keys = modules.entrySet();
                for (Map.Entry temp : keys) {
                    HashMap<String, String> templink;
                    Map<String, HashMap<String, HashMap<String, String>>> pluginlink;
                    String adminid;
                    String name;
                    Map module = (Map)temp.getValue();
                    int type = Common.toDigit((String)module.get("type"));
                    String identifier = plugin.get("identifier");
                    if (type == 1) {
                        HashMap<String, String> link = new HashMap<String, String>();
                        link.put("adminid", String.valueOf(module.get("adminid")));
                        link.put("url", "<a href=\"" + module.get("url") + "\">" + module.get("menu") + "</a>");
                        links.put(links.size(), link);
                        continue;
                    }
                    if (type == 2) {
                        name = String.valueOf(module.get("name"));
                        adminid = String.valueOf(module.get("adminid"));
                        HashMap<String, String> link = new HashMap<String, String>();
                        link.put("adminid", adminid);
                        link.put("url", "<a href=\"plugin.jsp?identifier=" + identifier + "&module=" + name + "\">" + name + "</a>");
                        links.put(links.size(), link);
                        pluginlink = (HashMap)pluginlinks.get(identifier);
                        if (pluginlink == null) {
                            pluginlink = new HashMap();
                            pluginlinks.put(identifier, pluginlink);
                        }
                        templink = new HashMap<String, String>();
                        templink.put("adminid", adminid);
                        templink.put("directory", String.valueOf(plugin.get("directory")));
                        pluginlink.put(name, templink);
                        continue;
                    }
                    if (type == 4) {
                        HashMap<String, String> include = new HashMap<String, String>();
                        include.put("adminid", String.valueOf(module.get("adminid")));
                        include.put("script", String.valueOf(plugin.get("directory")) + module.get("name"));
                        treeMap.put(treeMap.size(), include);
                        continue;
                    }
                    if (type == 5) {
                        HashMap<String, String> jsmenu = new HashMap<String, String>();
                        jsmenu.put("adminid", String.valueOf(module.get("adminid")));
                        jsmenu.put("url", "<a href=\"" + module.get("url") + "\">" + module.get("menu") + "</a>");
                        jsmenus.put(jsmenus.size(), jsmenu);
                        continue;
                    }
                    if (type != 6) continue;
                    name = String.valueOf(module.get("name"));
                    adminid = String.valueOf(module.get("adminid"));
                    HashMap<String, String> jsmenu = new HashMap<String, String>();
                    jsmenu.put("adminid", String.valueOf(module.get("adminid")));
                    jsmenu.put("url", "<a href=\"plugin.jsp?identifier=" + identifier + "&module=" + name + "\">" + name + "</a>");
                    jsmenus.put(jsmenus.size(), jsmenu);
                    pluginlink = (Map)pluginlinks.get(identifier);
                    if (pluginlink == null) {
                        pluginlink = new HashMap();
                        pluginlinks.put(identifier, pluginlink);
                    }
                    templink = new HashMap();
                    templink.put("adminid", adminid);
                    templink.put("directory", String.valueOf(plugin.get("directory")));
                    pluginlink.put(name, templink);
                }
            }
            HashMap<String, Object> pluginstemp = new HashMap<String, Object>();
            if (links.size() > 0) {
                pluginstemp.put("links", links);
            }
            if (treeMap.size() > 0) {
                pluginstemp.put("includes", treeMap);
            }
            if (jsmenus.size() > 0) {
                pluginstemp.put("jsmenus", jsmenus);
            }
            datas.put("plugins", pluginstemp.size() > 0 ? dataParse.combinationChar(pluginstemp) : "");
            datas.put("pluginlinks", pluginlinks.size() > 0 ? dataParse.combinationChar(pluginlinks) : "");
        }
        if ((pluginhooks = dataBaseDao.executeQuery("SELECT ph.title, ph.code, p.identifier FROM jrun_plugins p LEFT JOIN jrun_pluginhooks ph ON ph.pluginid=p.pluginid AND ph.available='1' WHERE p.available='1' ORDER BY p.identifier", new String[0])) != null && pluginhooks.size() > 0) {
            HashMap<String, String> hooks = new HashMap<String, String>();
            for (Map map : pluginhooks) {
                String title = (String)map.get("title");
                String code = (String)map.get("code");
                if (title == null || code == null) continue;
                hooks.put(String.valueOf((String)map.get("identifier")) + "_" + (String)map.get("title"), (String)map.get("code"));
            }
            datas.put("hooks", hooks.size() > 0 ? dataParse.combinationChar(hooks) : "");
        }
        List<Map<String, String>> forumList = dataBaseDao.executeQuery("SELECT f.fid, f.type, f.name, f.fup, ff.viewperm FROM jrun_forums f LEFT JOIN jrun_forumfields ff ON ff.fid=f.fid WHERE f.status=1 ORDER BY f.type, f.displayorder", new String[0]);
        Common.setForums(forumList);
        datas.put("forums", dataParse.combinationChar(forumList));
        int n = Common.time();
        dataBaseDao.runQuery("DELETE FROM jrun_banned WHERE expiration<'" + n + "'", true, new String[0]);
        List<Map<String, String>> iplist = dataBaseDao.executeQuery("select ip1,ip2,ip3,ip4,expiration from jrun_banned order by expiration", new String[0]);
        StringBuffer buffer = new StringBuffer();
        boolean flag = true;
        for (Map<String, String> ips : iplist) {
            String ip11 = ips.get("ip1");
            String ip12 = ips.get("ip2");
            String ip13 = ips.get("ip3");
            String ip14 = ips.get("ip4");
            ip11 = ip11.equals("-1") ? "\\d+" : ip11;
            ip12 = ip12.equals("-1") ? "\\d+" : ip12;
            ip13 = ip13.equals("-1") ? "\\d+" : ip13;
            ip14 = ip14.equals("-1") ? "\\d+" : ip14;
            buffer.append("|" + ip11 + "\\." + ip12 + "\\." + ip13 + "\\." + ip14);
            if (flag) {
                datas.put("ipban_expiration", ips.get("expiration"));
            }
            flag = false;
        }
        datas.put("ipbanned", buffer.length() > 0 ? buffer.substring(1) : "");
        return datas;
    }
}

