/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.utils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.struts.config.ModuleConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadUtil {
    private Map<String, FileItem> fileField = new TreeMap<String, FileItem>();
    private Map<String, String> formField = new TreeMap<String, String>();
    private Map<String, List<String>> formFields = new TreeMap<String, List<String>>();
    private int memoryBlock;
    private File tempFolder;
    private boolean multipart = false;
    private HttpServletRequest request = null;
    private long maxSize = 0xFA00000L;

    public FileUploadUtil(File tempFolder, int memeoryBlock, ModuleConfig mc) {
        this.tempFolder = tempFolder;
        this.maxSize = this.convertSizeToBytes(mc.getControllerConfig().getMaxFileSize(), this.maxSize);
        this.memoryBlock = (int)this.convertSizeToBytes(mc.getControllerConfig().getMemFileSize(), memeoryBlock);
        if (this.memoryBlock == 262144) {
            this.memoryBlock = memeoryBlock;
        }
    }

    public FileUploadUtil() {
    }

    public void parse(HttpServletRequest request, String charset) {
        block9: {
            this.request = request;
            this.multipart = FileUpload.isMultipartContent((HttpServletRequest)request);
            if (this.multipart) {
                DiskFileItemFactory factory = new DiskFileItemFactory();
                if (this.memoryBlock != 0) {
                    factory.setSizeThreshold(this.memoryBlock);
                } else {
                    this.memoryBlock = factory.getSizeThreshold();
                }
                if (this.tempFolder != null) {
                    factory.setRepository(this.tempFolder);
                } else {
                    this.tempFolder = factory.getRepository();
                }
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                upload.setSizeMax(this.maxSize);
                try {
                    List items = upload.parseRequest(request);
                    for (FileItem item : items) {
                        if (item.isFormField()) {
                            this.processFormField(item, charset);
                            continue;
                        }
                        this.processUploadedFile(item);
                    }
                }
                catch (FileUploadException e) {
                    if (!(e instanceof FileUploadBase.SizeLimitExceededException)) break block9;
                    throw new IllegalStateException("System only support max " + this.maxSize + " File");
                }
            }
        }
    }

    private void processFormField(FileItem item, String charset) {
        try {
            String name = item.getFieldName();
            String value = item.getString(charset);
            String objv = this.formField.get(name);
            if (objv == null) {
                this.formField.put(name, value);
            } else {
                List<String> values = this.formFields.get(name);
                if (values != null) {
                    values.add(value);
                } else {
                    values = new ArrayList<String>();
                    values.add(objv);
                    values.add(value);
                }
                this.formFields.put(name, values);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("the argument \u201ccharset\u201d missing!");
        }
    }

    private void processUploadedFile(FileItem item) {
        String name = item.getFieldName();
        this.fileField.put(name, item);
    }

    public FileItem getFileItem(String name) {
        if (this.multipart) {
            return this.fileField.get(name);
        }
        return null;
    }

    public Map<String, FileItem> getFileItem() {
        if (this.multipart) {
            return this.fileField;
        }
        return null;
    }

    public String getParameter(String name) {
        String value = null;
        if (this.multipart) {
            String obj = this.formField.get(name);
            value = obj != null ? obj : this.request.getParameter(name);
        } else if (this.request != null) {
            value = this.request.getParameter(name);
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] values = null;
        if (this.multipart) {
            List<String> obj = this.formFields.get(name);
            if (obj != null) {
                values = obj.toArray(new String[0]);
            } else {
                String[] stringArray;
                String objv = this.formField.get(name);
                if (objv != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = objv;
                } else {
                    stringArray = this.request.getParameterValues(name);
                }
                values = stringArray;
            }
        } else if (this.request != null) {
            values = this.request.getParameterValues(name);
        }
        return values;
    }

    public static boolean write2file(FileItem item, File file) {
        boolean flag = false;
        try {
            item.write(file);
            flag = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public File getRepository() {
        return this.tempFolder;
    }

    public int getSizeThreshold() {
        return this.memoryBlock;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    private long convertSizeToBytes(String sizeString, long defaultSize) {
        int multiplier = 1;
        if (sizeString.endsWith("K")) {
            multiplier = 1024;
        } else if (sizeString.endsWith("M")) {
            multiplier = 0x100000;
        } else if (sizeString.endsWith("G")) {
            multiplier = 0x40000000;
        }
        if (multiplier != 1) {
            sizeString = sizeString.substring(0, sizeString.length() - 1);
        }
        long size = 0L;
        try {
            size = Long.parseLong(sizeString);
        }
        catch (NumberFormatException nfe) {
            size = defaultSize;
            multiplier = 1;
        }
        return size * (long)multiplier;
    }
}

