/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.utils;

import cn.jsprun.utils.Common;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieUtil {
    public static String getCookie(HttpServletRequest request, String var) {
        return CookieUtil.getCookie(request, var, false, null);
    }

    public static String getCookie(HttpServletRequest request, String var, boolean prefix, Map<String, String> settings) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            if (settings != null) {
                var = String.valueOf(prefix ? settings.get("cookiepre") : "") + var;
            }
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals(var)) {
                    return cookie.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String var, String value, int life) {
        CookieUtil.setCookie(request, response, var, value, life, false, null);
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String var, String value, int life, boolean prefix, Map<String, String> settings) {
        String cookiedomain = null;
        String cookiepath = null;
        if (settings != null) {
            cookiedomain = settings.get("cookiedomain");
            cookiepath = settings.get("cookiepath");
            var = String.valueOf(prefix ? settings.get("cookiepre") : "") + var;
        }
        Cookie cookie = new Cookie(var, value);
        cookie.setMaxAge(life);
        if (cookiedomain != null && !"".equals(cookiedomain)) {
            cookie.setDomain(cookiedomain);
        }
        if (cookiepath != null && !"".equals(cookiepath)) {
            cookie.setPath(cookiepath);
        }
        cookie.setSecure(request.getServerPort() == 443);
        response.addCookie(cookie);
    }

    public static void clearCookies(HttpServletRequest request, HttpServletResponse response, Map<String, String> settings) {
        CookieUtil.setCookie(request, response, "sid", "", 0, true, settings);
        CookieUtil.setCookie(request, response, "auth", "", 0, true, settings);
        CookieUtil.setCookie(request, response, "uid", "", 0, true, settings);
        CookieUtil.setCookie(request, response, "visitedfid", "", 0, true, settings);
        CookieUtil.setCookie(request, response, "onlinedetail", "", 0, false, settings);
        HttpSession session = request.getSession();
        session.removeAttribute("jsprun_sid");
        session.setAttribute("jsprun_uid", (Object)0);
        session.setAttribute("jsprun_userss", (Object)"");
        session.setAttribute("jsprun_pw", (Object)"");
        session.removeAttribute("user");
        Common.setDateformat(session, settings);
        session.setAttribute("jsprun_groupid", (Object)7);
        session.setAttribute("jsprun_adminid", (Object)0);
        session.setAttribute("styleid", (Object)settings.get("styleid"));
        request.setAttribute("refresh", (Object)"true");
    }
}

