/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public final class Config {
    private String charset = "GBK";
    private Properties properties = new Properties();
    private String fileName = null;

    public Config(String fileName) {
        this.fileName = fileName;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            this.properties.load(fis);
            ((InputStream)fis).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getValue(String key) {
        return this.properties.getProperty(key);
    }

    public void setValue(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void saveProperties(String comments) {
        try {
            FileInputStream fis = new FileInputStream(this.fileName);
            InputStreamReader fsr = new InputStreamReader((InputStream)fis, this.charset);
            BufferedReader br = new BufferedReader(fsr);
            ArrayList<String> datas = new ArrayList<String>();
            int index = -1;
            while (br.ready()) {
                ++index;
                datas.add(br.readLine());
            }
            br.close();
            fsr.close();
            fis.close();
            Set<Object> keys = this.properties.keySet();
            for (Object key : keys) {
                boolean isnew = true;
                int i = 0;
                while (i <= index) {
                    if (((String)datas.get(i)).matches("^\\s*" + key + "\\s*\\=.*")) {
                        datas.set(i, key + " = " + this.properties.getProperty(key.toString()).replaceAll("\n", "\\\\n"));
                        isnew = false;
                        break;
                    }
                    ++i;
                }
                if (!isnew) continue;
                datas.add(++index, key + " = " + this.properties.getProperty(key.toString()).replaceAll("\n", "\\\\n"));
            }
            FileOutputStream fos = new FileOutputStream(this.fileName);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, this.charset);
            BufferedWriter bw = new BufferedWriter(osw);
            for (String data : datas) {
                bw.write(data);
                bw.newLine();
            }
            bw.flush();
            osw.flush();
            fos.flush();
            bw.close();
            osw.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

