/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.struts.form;

import cn.jsprun.utils.HibernateUtil;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class PageForm
implements Serializable {
    private static final long serialVersionUID = 7856051824324464936L;
    public static final String TOTALPAGE = "totalpage";
    public static final String TOTALSIZE = "totalsize";
    public static final String CURRENTPAGE = "currentpage";
    public static final String LIST = "showlist";
    private int currentPage = 1;
    private int prePage = 0;
    private int nextPage = 0;
    private List list;
    private int pageSize = 5;
    private int totalPage = 0;
    private int totalSize = 0;
    private String countSQL = "select count(*) from Posts";
    private String sql = "from Posts";

    public PageForm() {
    }

    public PageForm(int currentPage, String countSQL, String sql) {
        this.currentPage = currentPage;
        this.countSQL = countSQL;
        this.sql = sql;
    }

    public PageForm(int currentPage, int pageSize, String countSQL, String sql) {
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.countSQL = countSQL;
        this.sql = sql;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage < 1) {
            currentPage = 1;
        }
        if (currentPage > this.totalPage) {
            currentPage = this.totalPage;
        }
        this.currentPage = currentPage;
    }

    public List getList() {
        return this.list;
    }

    public void setList(List list) {
        this.list = list;
    }

    public int getNextPage() {
        this.getTotalPage();
        return this.currentPage == this.totalPage ? this.currentPage : this.currentPage + 1;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPrePage() {
        return this.currentPage - 1 == 0 ? 1 : this.currentPage - 1;
    }

    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getTotalPage() {
        this.getTotalSize();
        if (this.totalSize > this.pageSize) {
            if (this.totalSize % this.pageSize == 0) {
                this.setTotalPage((int)((double)this.totalSize / (double)this.pageSize));
            } else {
                this.setTotalPage((int)(1.0 + (double)this.totalSize / (double)this.pageSize));
            }
        } else {
            this.totalSize = 1;
            this.setTotalPage(1);
        }
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getTotalSize() {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Object o = session.createQuery(this.countSQL).uniqueResult();
            this.totalSize = (Integer)o;
            tr.commit();
        }
        catch (Exception e) {
            if (tr != null && tr.isActive()) {
                tr.rollback();
            }
            e.printStackTrace();
        }
        this.setTotalSize(this.totalSize);
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public PageForm getPageRecord() {
        int startid = 0;
        if (this.currentPage < 0) {
            startid = 0;
        } else if (this.currentPage > this.getTotalPage()) {
            startid = this.getTotalPage();
            startid = this.pageSize * (startid - 1);
        } else {
            startid = this.pageSize * (this.currentPage - 1);
        }
        this.setCurrentPage(this.currentPage);
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery(this.sql);
            query.setFetchSize(this.pageSize);
            query.setFirstResult(startid);
            query.setMaxResults(this.pageSize);
            this.setList(query.list());
            tr.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public String getCountSQL() {
        return this.countSQL;
    }

    public void setCountSQL(String countSQL) {
        this.countSQL = countSQL;
    }
}

