/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.struts.action;

import cn.jsprun.domain.Members;
import cn.jsprun.struts.action.BaseAction;
import cn.jsprun.utils.Base64;
import cn.jsprun.utils.Cache;
import cn.jsprun.utils.Common;
import cn.jsprun.utils.Config;
import cn.jsprun.utils.ForumInit;
import cn.jsprun.utils.JspRunConfig;
import cn.jsprun.utils.Log;
import cn.jsprun.utils.Md5Token;
import cn.jsprun.utils.ZipUtil;
import cn.jsprun.vo.FieldVO;
import cn.jsprun.vo.TableStatusVO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBaseManageAction
extends BaseAction {
    public ActionForward updateForumCache(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ServletContext context = this.servlet.getServletContext();
        ForumInit.initServletContext(context);
        String resultInfo = Cache.updateCache(new String[0]);
        resultInfo = resultInfo == null ? this.getMessage(request, "a_system_update_cache_succeed", new String[0]) : String.valueOf(this.getMessage(request, "a_system_update_cache_faild", new String[0])) + "<br>" + resultInfo;
        request.setAttribute("message", (Object)resultInfo);
        return mapping.findForward("message");
    }

    public ActionForward toExport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List<String> tableNames = this.dataBaseService.findAllTableNames("jrun_");
        int timestamp = (Integer)request.getAttribute("timestamp");
        String timeoffset = ForumInit.settings.get("timeoffset");
        request.setAttribute("tableNames", tableNames);
        request.setAttribute("randName", (Object)(String.valueOf(Common.gmdate("yyMMdd", timestamp, timeoffset)) + "_" + Common.getRandStr(8, false)));
        return mapping.findForward("toExport");
    }

    public ActionForward exportData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        block51: {
            try {
                String setnames;
                if (!this.submitCheck(request, "exportsubmit", true)) break block51;
                String filename = request.getParameter("filename");
                if (filename.equals("") || filename.matches(".*\\.(exe|jsp|asp|aspx|cgi|fcgi|pl)$")) {
                    request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_export_filename_invalid", new String[0]));
                    request.setAttribute("return", (Object)true);
                    return mapping.findForward("message");
                }
                filename = filename.replaceAll("[/|\\\\|\\.]", "");
                List<Object> tableNames = new ArrayList();
                String type = request.getParameter("type");
                if ("jsprun".equals(type)) {
                    tableNames = this.dataBaseService.findAllTableNames("jrun_");
                } else if ("custom".equals(type)) {
                    String setup = request.getParameter("setup");
                    if (setup == null || !"1".equals(setup)) {
                        Map<String, String> setting = this.dataBaseService.executeQuery("SELECT value FROM jrun_settings WHERE variable='custombackup'", new String[0]).get(0);
                        Map map = this.dataParse.characterParse(setting.get("value"), false);
                        if (map != null && map.size() > 0) {
                            for (Map.Entry e : map.entrySet()) {
                                tableNames.add((String)e.getValue());
                            }
                        }
                    } else {
                        String[] customtables = request.getParameterValues("customtables");
                        String customtablesnew = null;
                        if (customtables != null) {
                            HashMap<Integer, String> map = new HashMap<Integer, String>(customtables.length);
                            int length = customtables.length;
                            int i = 0;
                            while (i < length) {
                                map.put(i, customtables[i]);
                                tableNames.add(customtables[i]);
                                ++i;
                            }
                            customtablesnew = this.dataParse.combinationChar(map);
                        } else {
                            customtablesnew = "";
                        }
                        this.dataBaseService.runQuery("REPLACE INTO jrun_settings (variable, value) VALUES ('custombackup', '" + customtablesnew + "')", true);
                    }
                }
                if (tableNames.size() <= 0) {
                    request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_export_custom_invalid", new String[0]));
                    request.setAttribute("return", (Object)true);
                    return mapping.findForward("message");
                }
                String method = request.getParameter("method");
                long sizelimit = Common.toDigit(request.getParameter("sizelimit"));
                int extendins = Common.toDigit(request.getParameter("extendins"));
                String sqlcompat = request.getParameter("sqlcompat");
                String sqlcharset = request.getParameter("sqlcharset");
                String usehex = request.getParameter("usehex");
                int volume = Common.range(Common.intval(request.getParameter("volume")), 10000, 1);
                int tableid = Common.toDigit(request.getParameter("tableid"));
                int startfrom = Common.toDigit(request.getParameter("startfrom"));
                String realPath = JspRunConfig.realPath;
                int timestamp = (Integer)request.getAttribute("timestamp");
                String encoded = String.valueOf(timestamp) + "," + "6.0.0" + "," + type + "," + method + "," + volume;
                String charset = null;
                String dumpcharset = null;
                switch (sqlcharset.length()) {
                    case 3: {
                        charset = "GBK";
                        dumpcharset = "gbk";
                        break;
                    }
                    case 4: {
                        charset = "UTF-8";
                        dumpcharset = "utf8";
                        break;
                    }
                    default: {
                        charset = "UTF-8";
                        dumpcharset = "UTF-8".replaceAll("-", "");
                    }
                }
                String version = this.dataBaseService.executeQuery("select version() as version", new String[0]).get(0).get("version");
                String string = setnames = sqlcharset.length() > 0 && version.compareTo("4.1") > 0 && (sqlcompat.length() == 0 || sqlcompat.equals("MYSQL41")) ? "SET NAMES '" + dumpcharset + "';\n\n" : "";
                if (version.compareTo("4.1") > 0) {
                    if (sqlcharset.length() > 0) {
                        this.dataBaseService.runQuery("SET NAMES '" + sqlcharset + "';\n\n", true);
                    }
                    if (sqlcompat.equals("MYSQL40")) {
                        this.dataBaseService.runQuery("SET SQL_MODE='MYSQL40'", true);
                    } else if (sqlcompat.equals("MYSQL41")) {
                        this.dataBaseService.runQuery("SET SQL_MODE=''", true);
                    }
                }
                Map<String, String> settings = ForumInit.settings;
                String backupdir = this.createBackupdir(realPath, settings);
                String backupfilename = String.valueOf(backupdir) + "/" + filename;
                if (method.equals("multivol")) {
                    ArrayList<String> excepttables = new ArrayList<String>();
                    excepttables.add("jrun_adminsessions");
                    excepttables.add("jrun_failedlogins");
                    excepttables.add("jrun_pmsearchindex");
                    excepttables.add("jrun_relatedthreads");
                    excepttables.add("jrun_rsscaches");
                    excepttables.add("jrun_searchindex");
                    excepttables.add("jrun_spacecaches");
                    excepttables.add("jrun_sessions");
                    StringBuffer sqldump = new StringBuffer();
                    boolean complete = true;
                    while (complete && tableid < tableNames.size() && (long)(sqldump.length() + 500) < sizelimit * 1000L) {
                        Map map = this.dataBaseService.sqldumptable(excepttables, (String)tableNames.get(tableid), startfrom, sqldump.length() + 500, sizelimit * 1000L, complete, version, extendins, sqlcompat, dumpcharset, sqlcharset, usehex.equals("1"));
                        sqldump.append((StringBuffer)map.get("tabledump"));
                        if (map.get("startfrom") != null) {
                            startfrom = Common.toDigit(map.get("startfrom").toString());
                        }
                        if (map.get("complete") != null) {
                            complete = (Boolean)map.get("complete");
                        }
                        if (complete) {
                            startfrom = 0;
                        }
                        ++tableid;
                    }
                    if (!complete) {
                        --tableid;
                    }
                    String dumpfileName = String.valueOf(backupfilename) + "-" + volume + ".sql";
                    long usezip = Common.range(Common.intval(request.getParameter("usezip")), 2, 0);
                    if (sqldump.length() > 0) {
                        FileOutputStream fos;
                        File dumpfile;
                        block53: {
                            String dateformat = settings.get("dateformat");
                            String timeformat = settings.get("gtimeformat");
                            String timeoffset = settings.get("timeoffset");
                            String time = Common.gmdate(String.valueOf(dateformat) + " " + timeformat + " (z)", timestamp, timeoffset);
                            StringBuffer dump = new StringBuffer();
                            dump.append("# Identify: " + Base64.encode(encoded, charset) + "\n");
                            dump.append("# JspRun! Multi-Volume Data Dump Vol." + volume + "\n");
                            dump.append("# Version: JspRun!_6.0.0_" + charset + "\n");
                            dump.append("# Time: " + time + "\n");
                            dump.append("# Type: " + type + "\n");
                            dump.append("# Table Prefix: jrun_\n");
                            dump.append("# \n");
                            dump.append("# JspRun! Home: http://www.jsprun.com\n");
                            dump.append("# Please visit our website for newest infomation about JspRun!\n");
                            dump.append("# --------------------------------------------------------\n\n\n");
                            dump.append(setnames);
                            dumpfile = new File(String.valueOf(realPath) + dumpfileName);
                            if (!dumpfile.exists()) {
                                try {
                                    dumpfile.createNewFile();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            fos = null;
                            OutputStreamWriter osw = null;
                            BufferedWriter bw = null;
                            try {
                                try {
                                    fos = new FileOutputStream(dumpfile);
                                    osw = new OutputStreamWriter((OutputStream)fos, charset);
                                    bw = new BufferedWriter(osw);
                                    bw.write(dump.toString());
                                    bw.write(sqldump.toString());
                                    bw.flush();
                                    osw.flush();
                                    fos.flush();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    try {
                                        bw.close();
                                        osw.close();
                                        fos.close();
                                    }
                                    catch (IOException e2) {
                                        e2.printStackTrace();
                                    }
                                    break block53;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    bw.close();
                                    osw.close();
                                    fos.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                throw throwable;
                            }
                            try {
                                bw.close();
                                osw.close();
                                fos.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (usezip == 2L) {
                            try {
                                dumpfileName = String.valueOf(backupfilename) + "-" + volume + ".zip";
                                FileOutputStream zfos = new FileOutputStream(String.valueOf(realPath) + dumpfileName);
                                ZipOutputStream zos = new ZipOutputStream(zfos);
                                ZipUtil.zipFile(dumpfile, zos);
                                zos.close();
                                fos.close();
                                dumpfile.delete();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        dumpfile = null;
                        request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_export_multivol_redirect", String.valueOf(volume)));
                        request.setAttribute("url_forward", (Object)(String.valueOf(request.getContextPath()) + "/database.do?action=exportData&exportsubmit=yes&type=" + type + "&saveto=server&filename=" + filename + "&method=" + method + "&sizelimit=" + sizelimit + "&volume=" + ++volume + "&tableid=" + tableid + "&startfrom=" + startfrom + "&extendins=" + extendins + "&sqlcharset=" + sqlcharset + "&sqlcompat=" + sqlcompat + "&usehex=" + usehex + "&usezip=" + usezip + "&formHash=" + Common.formHash(request)));
                        return mapping.findForward("message");
                    }
                    --volume;
                    if (usezip == 1L) {
                        try {
                            String zipfilename = String.valueOf(backupfilename) + ".zip";
                            FileOutputStream fos = new FileOutputStream(String.valueOf(realPath) + zipfilename);
                            ZipOutputStream zos = new ZipOutputStream(fos);
                            int i = 1;
                            while (i <= volume) {
                                File dumpfile = new File(String.valueOf(realPath) + backupfilename + "-" + i + ".sql");
                                ZipUtil.zipFile(dumpfile, zos);
                                dumpfile.delete();
                                ++i;
                            }
                            zos.close();
                            fos.close();
                            String resultInfo = this.getMessage(request, "a_system_database_export_zip_succeed", "<a href=\"" + request.getContextPath() + zipfilename.replaceFirst("\\.", "") + "\">" + zipfilename + "</a>");
                            request.setAttribute("message", (Object)resultInfo);
                            return mapping.findForward("message");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break block51;
                        }
                    }
                    StringBuffer resultInfo = new StringBuffer(this.getMessage(request, "a_system_database_export_multivol_succeed", String.valueOf(volume)));
                    int i = 1;
                    while (i <= volume) {
                        dumpfileName = String.valueOf(backupfilename) + "-" + i + (usezip == 2L ? ".zip" : ".sql");
                        resultInfo.append("<li><a href=\"" + request.getContextPath() + dumpfileName.replaceFirst("\\.", "") + "\">" + dumpfileName + "\n");
                        ++i;
                    }
                    request.setAttribute("message", (Object)resultInfo);
                    return mapping.findForward("message");
                }
                request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_shell_fail", new String[0]));
                request.setAttribute("return", (Object)true);
                return mapping.findForward("message");
            }
            catch (Exception e) {
                request.setAttribute("message", (Object)e.getMessage());
                return mapping.findForward("message");
            }
        }
        return this.toExport(mapping, form, request, response);
    }

    public ActionForward toImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ArrayList dumpfiles;
        String backupdir;
        block21: {
            Map<String, String> settings = ForumInit.settings;
            String dbimport = settings.get("admincp_dbimport");
            if ("0".equals(dbimport)) {
                request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_function_closed", new String[0]));
                return mapping.findForward("message");
            }
            String realPath = JspRunConfig.realPath;
            backupdir = this.createBackupdir(realPath, settings);
            File file = new File(String.valueOf(realPath) + backupdir);
            dumpfiles = new ArrayList();
            File[] files = file.listFiles();
            if (files == null || files.length <= 0) break block21;
            HttpSession session = request.getSession();
            String timeoffset = (String)session.getAttribute("timeoffset");
            String timeformat = (String)session.getAttribute("timeformat");
            String dateformat = (String)session.getAttribute("dateformat");
            SimpleDateFormat sdf_all = Common.getSimpleDateFormat(String.valueOf(dateformat) + " " + timeformat, timeoffset);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block22: {
                    String volume;
                    String method;
                    String type;
                    String jsprunversion;
                    String filename;
                    File dumpfile;
                    block24: {
                        block23: {
                            String content;
                            block20: {
                                dumpfile = fileArray[n2];
                                if (!dumpfile.isFile()) break block22;
                                filename = dumpfile.getName();
                                jsprunversion = "";
                                type = "";
                                method = "";
                                volume = "";
                                if (!filename.matches(".*.sql$")) break block23;
                                content = null;
                                FileReader fr = null;
                                BufferedReader br = null;
                                try {
                                    try {
                                        fr = new FileReader(dumpfile);
                                        br = new BufferedReader(fr);
                                        content = br.readLine();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        try {
                                            br.close();
                                            fr.close();
                                        }
                                        catch (IOException e2) {
                                            e2.printStackTrace();
                                        }
                                        break block20;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        br.close();
                                        fr.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    throw throwable;
                                }
                                try {
                                    br.close();
                                    fr.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            List<String> info = this.getStr(content, "^# Identify:\\s*(\\w+).*");
                            if (info != null && info.size() > 0) {
                                String fileInfo = info.get(0);
                                String[] infos = (fileInfo = Base64.decode(fileInfo.substring(fileInfo.indexOf(":") + 1).trim(), "UTF-8")).split(",");
                                if (infos != null) {
                                    jsprunversion = infos[1];
                                    type = infos[2];
                                    method = infos[3];
                                    volume = infos[4];
                                }
                            } else {
                                method = "shell";
                            }
                            break block24;
                        }
                        if (!filename.matches(".*.zip$")) break block22;
                        type = "zip";
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("filename", filename);
                    map.put("filepath", String.valueOf(backupdir.replace(".", "")) + "/" + filename);
                    map.put("jsprunversion", jsprunversion);
                    map.put("dateline", Common.gmdate(sdf_all, (int)(dumpfile.lastModified() / 1000L)));
                    map.put("type", type);
                    map.put("filesize", Common.sizeFormat(dumpfile.length()));
                    map.put("method", method);
                    map.put("volume", volume);
                    dumpfiles.add(map);
                }
                ++n2;
            }
        }
        request.setAttribute("backupdir", (Object)backupdir);
        request.setAttribute("dumpfiles", dumpfiles);
        request.setAttribute("version", (Object)"6.0.0");
        return mapping.findForward("toImport");
    }

    public ActionForward importData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_file_illegal", new String[0]));
        return mapping.findForward("message");
    }

    public ActionForward importFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        block39: {
            String realPath = JspRunConfig.realPath;
            try {
                if (this.submitCheck(request, "deletesubmit")) {
                    String[] delete = request.getParameterValues("delete");
                    if (delete == null) {
                        request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_file_delete_invalid", new String[0]));
                        request.setAttribute("return", (Object)true);
                        return mapping.findForward("message");
                    }
                    String resultInfo = null;
                    boolean flag = true;
                    String[] stringArray = delete;
                    int n = delete.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filePath = stringArray[n2];
                        File file = new File(String.valueOf(realPath) + filePath);
                        if (file.exists()) {
                            if (!file.delete()) {
                                flag = false;
                                resultInfo = this.getMessage(request, "a_system_database_del_file_invalid", new String[0]);
                                break;
                            }
                        } else {
                            flag = false;
                            resultInfo = this.getMessage(request, "a_system_database_file_no_exist", new String[0]);
                            break;
                        }
                        ++n2;
                    }
                    if (flag) {
                        resultInfo = this.getMessage(request, "a_system_database_file_delete_succeed", new String[0]);
                    }
                    request.setAttribute("message", resultInfo);
                    return mapping.findForward("message");
                }
            }
            catch (Exception e) {
                request.setAttribute("message", (Object)e.getMessage());
                return mapping.findForward("message");
            }
            try {
                StringBuffer sqldump;
                HashMap<String, String> dumpinfo;
                File dumpfile;
                String datafile_server;
                String autoimport;
                block41: {
                    if (!this.submitCheck(request, "importsubmit", true) && !this.submitCheck(request, "confirmed")) break block39;
                    String server = request.getParameter("from");
                    autoimport = request.getParameter("autoimport");
                    String datafile = "";
                    datafile_server = request.getParameter("datafile_server");
                    if ("server".equals(server)) {
                        datafile = String.valueOf(realPath) + datafile_server;
                    }
                    dumpfile = new File(datafile);
                    dumpinfo = new HashMap<String, String>();
                    sqldump = new StringBuffer();
                    if (dumpfile.exists()) {
                        FileInputStream fis = null;
                        InputStreamReader isr = null;
                        BufferedReader br = null;
                        try {
                            try {
                                List<String> info;
                                fis = new FileInputStream(dumpfile);
                                isr = new InputStreamReader((InputStream)fis, "UTF-8");
                                br = new BufferedReader(isr);
                                String content = br.readLine();
                                if (content != null && (info = this.getStr(content, "^# Identify:\\s*(\\w+).*")) != null && info.size() > 0) {
                                    String fileInfo = info.get(0);
                                    String[] infos = (fileInfo = Base64.decode(fileInfo.substring(fileInfo.indexOf(":") + 1).trim(), "UTF-8")).split(",");
                                    if (infos != null) {
                                        dumpinfo.put("method", infos[3]);
                                        dumpinfo.put("volume", infos[4]);
                                    }
                                }
                                while (content != null) {
                                    if (!content.matches("^#.*")) {
                                        sqldump.append(String.valueOf(content) + "\n");
                                    }
                                    content = br.readLine();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                try {
                                    br.close();
                                    isr.close();
                                    fis.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                break block41;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                br.close();
                                isr.close();
                                fis.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            br.close();
                            isr.close();
                            fis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        if (autoimport != null) {
                            request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_multivol_succeed", new String[0]));
                            return mapping.findForward("message");
                        }
                        request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_file_illegal", new String[0]));
                        return mapping.findForward("message");
                    }
                }
                if ("multivol".equals(dumpinfo.get("method"))) {
                    String delunzip;
                    String[] sqls;
                    if (sqldump.length() > 0 && (sqls = sqldump.toString().split(";\n")) != null && sqls.length > 0) {
                        Map<String, String> resultMap = null;
                        Members members = (Members)request.getSession().getAttribute("members");
                        String cMemberName = members == null ? "" : members.getUsername();
                        String errorInfo = null;
                        int timestamp = (Integer)request.getAttribute("timestamp");
                        String[] stringArray = sqls;
                        int n = sqls.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String sql = stringArray[n3];
                            if ((sql = sql.trim()).length() > 0) {
                                resultMap = this.dataBaseService.runQuery(sql);
                                errorInfo = resultMap.get("error");
                                if (resultMap != null && errorInfo != null && !"1062".equals(resultMap.get("errorCode"))) {
                                    Log.writelog("errorlog", timestamp, String.valueOf(timestamp) + "\tMySQL\t" + cMemberName + "\t" + dumpfile + " : " + errorInfo + " - " + Common.cutstr(sql, 120));
                                }
                            }
                            ++n3;
                        }
                    }
                    if ((delunzip = request.getParameter("delunzip")) != null && dumpfile.exists()) {
                        dumpfile.delete();
                    }
                    int index1 = datafile_server.lastIndexOf("-");
                    int index2 = datafile_server.lastIndexOf("/");
                    StringBuffer datafile_next = new StringBuffer(datafile_server);
                    if (index1 > index2) {
                        datafile_next = datafile_next.replace(datafile_next.lastIndexOf("-") + 1, datafile_next.lastIndexOf("."), String.valueOf(Integer.valueOf(datafile_next.substring(datafile_next.lastIndexOf("-") + 1, datafile_next.lastIndexOf("."))) + 1));
                    }
                    if ("1".equals(dumpinfo.get("volume"))) {
                        request.setAttribute("msgtype", (Object)"form");
                        request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_multivol_prompt", new String[0]));
                        request.setAttribute("url_forward", (Object)(String.valueOf(request.getContextPath()) + "/database.do?action=importFile&from=server&datafile_server=" + datafile_next.toString() + "&autoimport=yes&formHash=" + Common.formHash(request) + "&importsubmit=yes" + (request.getParameter("delunzip") != null ? "&delunzip=yes" : "")));
                        return mapping.findForward("message");
                    }
                    if (autoimport != null) {
                        request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_multivol_redirect", (String)dumpinfo.get("volume")));
                        request.setAttribute("url_forward", (Object)(String.valueOf(request.getContextPath()) + "/database.do?action=importFile&from=server&datafile_server=" + datafile_next.toString() + "&autoimport=yes&formHash=" + Common.formHash(request) + "&importsubmit=yes" + (request.getParameter("delunzip") != null ? "&delunzip=yes" : "")));
                        return mapping.findForward("message");
                    }
                    request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_multivol_succeed", new String[0]));
                    return mapping.findForward("message");
                }
                if (!"shell".equals(dumpinfo.get("method"))) {
                    request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_format_illegal", new String[0]));
                    return mapping.findForward("message");
                }
            }
            catch (Exception e) {
                request.setAttribute("message", (Object)e.getMessage());
                return mapping.findForward("message");
            }
        }
        return this.toImport(mapping, form, request, response);
    }

    public ActionForward importZipFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        block22: {
            String realPath = JspRunConfig.realPath;
            String confirmed = request.getParameter("confirmed");
            String importsubmit = request.getParameter("importsubmit");
            if (importsubmit != null || confirmed != null) {
                String autoimport = request.getParameter("autoimport");
                String datafile_server = request.getParameter("datafile_server");
                String path = datafile_server.substring(0, datafile_server.lastIndexOf("/"));
                String zipFileName = String.valueOf(realPath) + datafile_server;
                try {
                    File zipFile = new File(zipFileName);
                    if (zipFile.exists()) {
                        List<String> fileNames = ZipUtil.unZipFile(zipFile);
                        if (fileNames != null && fileNames.size() > 0) {
                            String confirm;
                            File dumpfile = new File(String.valueOf(realPath) + path + "/" + fileNames.get(0));
                            HashMap<String, String> dumpinfo = null;
                            if (dumpfile.exists()) {
                                List<String> info;
                                String content;
                                block21: {
                                    FileReader fr = null;
                                    BufferedReader br = null;
                                    content = null;
                                    try {
                                        try {
                                            fr = new FileReader(dumpfile);
                                            br = new BufferedReader(fr);
                                            content = br.readLine();
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            br.close();
                                            fr.close();
                                            break block21;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        br.close();
                                        fr.close();
                                        throw throwable;
                                    }
                                    br.close();
                                    fr.close();
                                }
                                if (content != null && (info = this.getStr(content, "^# Identify:\\s*(\\w+).*")) != null && info.size() > 0) {
                                    String fileInfo = info.get(0);
                                    String[] infos = (fileInfo = Base64.decode(fileInfo.substring(fileInfo.indexOf(":") + 1).trim(), "UTF-8")).split(",");
                                    if (infos != null) {
                                        dumpinfo = new HashMap<String, String>();
                                        dumpinfo.put("jsprunversion", infos[1]);
                                        dumpinfo.put("type", infos[2]);
                                        dumpinfo.put("method", infos[3]);
                                        dumpinfo.put("volume", infos[4]);
                                    }
                                }
                            }
                            if ((confirm = request.getParameter("confirm")) == null && dumpinfo != null && !((String)dumpinfo.get("jsprunversion")).equals("6.0.0")) {
                                request.setAttribute("msgtype", (Object)"form");
                                request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_confirm", new String[0]));
                                request.setAttribute("url_forward", (Object)(String.valueOf(request.getContextPath()) + "/database.do?action=importZipFile&from=server&datafile_server=" + datafile_server + "&importsubmit=yes&confirm=yes"));
                                return mapping.findForward("message");
                            }
                            String info = "";
                            if (dumpinfo != null) {
                                info = String.valueOf(datafile_server.substring(datafile_server.lastIndexOf("/") + 1)) + "<br/>" + this.getMessage(request, "version", new String[0]) + ": " + (String)dumpinfo.get("jsprunversion") + "<br/>" + this.getMessage(request, "type", new String[0]) + ": " + (((String)dumpinfo.get("type")).equals("jsprun") ? this.getMessage(request, "a_system_database_export_jsprun", new String[0]) : this.getMessage(request, "a_system_database_export_custom", new String[0])) + "<br/>" + this.getMessage(request, "a_system_database_method", new String[0]) + ": " + (((String)dumpinfo.get("method")).equals("multivol") ? this.getMessage(request, "a_system_database_multivol", new String[0]) : this.getMessage(request, "a_system_database_shell", new String[0])) + "<br/><br/>";
                            }
                            int index1 = datafile_server.lastIndexOf("-");
                            int index2 = datafile_server.lastIndexOf("/");
                            StringBuffer datafile_next = new StringBuffer(datafile_server);
                            String volume = null;
                            if (index1 > index2) {
                                volume = datafile_server.substring(datafile_server.lastIndexOf("-") + 1, datafile_server.lastIndexOf("."));
                                datafile_next = datafile_next.replace(datafile_next.lastIndexOf("-") + 1, datafile_next.lastIndexOf("."), String.valueOf(Integer.valueOf(datafile_next.substring(datafile_next.lastIndexOf("-") + 1, datafile_next.lastIndexOf("."))) + 1));
                            }
                            if (!(autoimport != null || volume != null && "1".equals(volume))) {
                                String fileName = String.valueOf(path) + "/" + fileNames.get(0);
                                request.setAttribute("msgtype", (Object)"form");
                                request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_unzip_confirm", info));
                                request.setAttribute("url_forward", (Object)(String.valueOf(request.getContextPath()) + "/database.do?action=importFile&from=server&datafile_server=" + fileName + "&importsubmit=yes&delunzip=yes&formHash=" + Common.formHash(request)));
                                return mapping.findForward("message");
                            }
                            if ("1".equals(volume)) {
                                request.setAttribute("msgtype", (Object)"form");
                                request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_multivol_unzip", info));
                                request.setAttribute("url_forward", (Object)(String.valueOf(request.getContextPath()) + "/database.do?action=importZipFile&datafile_server=" + datafile_next.toString() + "&autoimport=yes&importsubmit=yes&delunzip=yes"));
                                return mapping.findForward("message");
                            }
                            if (autoimport != null) {
                                request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_multivol_unzip_redirect", volume));
                                request.setAttribute("url_forward", (Object)(String.valueOf(request.getContextPath()) + "/database.do?action=importZipFile&datafile_server=" + datafile_next.toString() + "&autoimport=yes&importsubmit=yes&delunzip=yes"));
                                return mapping.findForward("message");
                            }
                            break block22;
                        }
                        request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_file_illegal", new String[0]));
                        return mapping.findForward("message");
                    }
                    if (autoimport != null) {
                        int index1 = datafile_server.lastIndexOf("-");
                        int index2 = datafile_server.lastIndexOf("/");
                        StringBuffer datafile = new StringBuffer(datafile_server);
                        if (index1 > index2) {
                            datafile = datafile.replace(datafile.lastIndexOf("-") + 1, datafile.lastIndexOf("."), "1");
                        }
                        datafile.replace(datafile.lastIndexOf("."), datafile.length(), ".sql");
                        request.setAttribute("msgtype", (Object)"form");
                        request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_multivol_confirm", new String[0]));
                        request.setAttribute("url_forward", (Object)(String.valueOf(request.getContextPath()) + "/database.do?action=importFile&from=server&datafile_server=" + datafile.toString() + "&autoimport=yes&importsubmit=yesimportsubmit=yes&delunzip=yes&formHash=" + Common.formHash(request)));
                        request.setAttribute("cancelurl", (Object)"admincp.jsp?action=import");
                        return mapping.findForward("message");
                    }
                    request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_import_file_illegal", new String[0]));
                    return mapping.findForward("message");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.toImport(mapping, form, request, response);
    }

    private String createBackupdir(String realPath, Map<String, String> settings) {
        String backupdir = null;
        String oldbackupdir = settings.get("backupdir");
        if (oldbackupdir != null) {
            backupdir = "./forumdata/backup_" + oldbackupdir;
        }
        if (backupdir == null || !new File(String.valueOf(realPath) + backupdir).isDirectory()) {
            String randStr = Common.getRandStr(6, false);
            backupdir = "./forumdata/backup_" + randStr;
            try {
                if (new File(String.valueOf(realPath) + backupdir).mkdir()) {
                    this.dataBaseService.runQuery("REPLACE INTO jrun_settings (variable, value) values ('backupdir', '" + randStr + "')");
                    settings.put("backupdir", randStr);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return backupdir;
    }

    public ActionForward runquery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (this.submitCheck(request, "sqlsubmit")) {
                String option = request.getParameter("option");
                String sql = null;
                if (option != null && "simple".equals(option)) {
                    NodeList nl;
                    String queryselect = request.getParameter("queryselect");
                    if (queryselect != null && !"".equals(queryselect) && (nl = this.getSimplequerie()) != null) {
                        int i = 0;
                        while (i < nl.getLength()) {
                            Element element = (Element)nl.item(i);
                            String id = element.getAttribute("id");
                            if (id.equals(queryselect)) {
                                StringBuffer sb = new StringBuffer(element.getAttribute("sql"));
                                sb.replace(sb.indexOf("{"), sb.lastIndexOf("}") + 1, "jrun_");
                                sql = sb.toString();
                            }
                            ++i;
                        }
                    }
                } else {
                    sql = request.getParameter("queries");
                }
                Map<String, String> map = null;
                if (sql != null && !"".equals(sql)) {
                    map = this.dataBaseService.runQuery(sql);
                }
                String num = null;
                num = map != null ? (String)map.get("ok") : "0";
                if (num != null) {
                    request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_run_query_succeed", num));
                } else {
                    request.setAttribute("message", (Object)this.getMessage(request, "a_system_database_run_query_invalid", map.get("error")));
                }
                request.setAttribute("return", (Object)true);
                return mapping.findForward("message");
            }
        }
        catch (Exception e) {
            request.setAttribute("message", (Object)e.getMessage());
            return mapping.findForward("message");
        }
        TreeMap<Integer, TreeMap<Integer, String>> simplequeries = new TreeMap<Integer, TreeMap<Integer, String>>();
        TreeMap<Integer, String> upSimplequeries = new TreeMap<Integer, String>();
        NodeList nl = this.getSimplequerie();
        if (nl != null) {
            int i = 0;
            while (i < nl.getLength()) {
                Element element = (Element)nl.item(i);
                int id = Integer.parseInt(element.getAttribute("id"));
                int uid = Integer.parseInt(element.getAttribute("uid"));
                String comment = element.getAttribute("comment");
                if (uid == 0) {
                    upSimplequeries.put(id, comment);
                } else {
                    TreeMap<Integer, String> map = (TreeMap<Integer, String>)simplequeries.get(uid);
                    if (map == null) {
                        map = new TreeMap<Integer, String>();
                        simplequeries.put(uid, map);
                    }
                    map.put(id, comment);
                }
                ++i;
            }
        }
        request.setAttribute("simplequeries", simplequeries);
        request.setAttribute("upSimplequeries", upSimplequeries);
        return mapping.findForward("toRunquery");
    }

    public ActionForward optimize(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        long totalsize = 0L;
        List<TableStatusVO> tableStatusVOs = null;
        try {
            if (this.submitCheck(request, "optimizesubmit")) {
                String[] optimizetables = request.getParameterValues("optimizetables");
                if (optimizetables != null) {
                    String[] stringArray = optimizetables;
                    int n = optimizetables.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String obj = stringArray[n2];
                        this.dataBaseService.runQuery("OPTIMIZE TABLE " + obj, true);
                        ++n2;
                    }
                }
                tableStatusVOs = this.dataBaseService.findTableStatus("SHOW TABLE STATUS LIKE 'jrun_%';");
                for (TableStatusVO statusVO : tableStatusVOs) {
                    totalsize += statusVO.getData_length() + statusVO.getIndex_length();
                }
                request.setAttribute("type", (Object)"optimize");
                request.setAttribute("tableStatusVOs", tableStatusVOs);
                request.setAttribute("totalsize", (Object)Common.sizeFormat(totalsize));
                return mapping.findForward("toOptimize");
            }
        }
        catch (Exception e) {
            request.setAttribute("message", (Object)e.getMessage());
            return mapping.findForward("message");
        }
        tableStatusVOs = this.dataBaseService.findTableStatus("SHOW TABLE STATUS LIKE 'jrun_%';");
        for (TableStatusVO statusVO : tableStatusVOs) {
            if (statusVO.getData_free() <= 0L) continue;
            totalsize += statusVO.getData_length() + statusVO.getIndex_length();
        }
        request.setAttribute("tableStatusVOs", tableStatusVOs);
        request.setAttribute("totalsize", (Object)Common.sizeFormat(totalsize));
        return mapping.findForward("toOptimize");
    }

    public ActionForward toDbcheck(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List<FieldVO> fieldVOs = this.dataBaseService.findTableFields("jrun_settings");
        if (fieldVOs == null || fieldVOs.size() <= 0) {
            request.setAttribute("info", (Object)"yes");
            request.setAttribute("dbcheck_permissions_invalid", (Object)this.getMessage(request, "a_system_dbcheck_permissions_invalid", new String[0]));
            return mapping.findForward("toDbcheck");
        }
        if (!"yes".equals(request.getParameter("start"))) {
            request.setAttribute("info", (Object)"yes");
            request.setAttribute("dbcheck_checking", (Object)"admincp.jsp?action=moddbcheck&start=yes");
            return mapping.findForward("toDbcheck");
        }
        String realPath = JspRunConfig.realPath;
        File file = new File(String.valueOf(realPath) + "admin/jsprundb.md5");
        if (!file.exists()) {
            request.setAttribute("info", (Object)"yes");
            request.setAttribute("dbcheck_nofound_md5file", (Object)this.getMessage(request, "a_system_dbcheck_nofound_md5file", new String[0]));
            return mapping.findForward("toDbcheck");
        }
        HttpSession session = request.getSession();
        String dbmd5 = null;
        String newdbmd5 = null;
        Map jsprundb = (Map)session.getAttribute("jsprundb");
        if (jsprundb == null) {
            StringBuffer jsprunContent;
            block40: {
                jsprunContent = new StringBuffer();
                FileReader fr = null;
                BufferedReader br = null;
                try {
                    try {
                        fr = new FileReader(file);
                        br = new BufferedReader(fr);
                        do {
                            jsprunContent.append(br.readLine());
                        } while (br.ready());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            br.close();
                            fr.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block40;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                        fr.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    br.close();
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            dbmd5 = jsprunContent.substring(0, 32);
            newdbmd5 = Md5Token.getInstance().getLongToken(String.valueOf(jsprunContent.substring(34).length()));
            jsprundb = this.dataParse.characterParse(jsprunContent.substring(34), false);
            session.setAttribute("dbmd5", (Object)dbmd5);
            session.setAttribute("newdbmd5", (Object)newdbmd5);
            session.setAttribute("jsprundb", (Object)jsprundb);
        }
        if (!(dbmd5 = session.getAttribute("dbmd5").toString()).equals(newdbmd5 = session.getAttribute("newdbmd5").toString())) {
            request.setAttribute("info", (Object)"yes");
            request.setAttribute("dbcheck_modify_md5file", (Object)this.getMessage(request, "a_system_dbcheck_file_invalid", new String[0]));
        }
        Map settingsdata = (Map)jsprundb.get(1);
        jsprundb = (Map)((Map)jsprundb.get(0)).get(0);
        List<Map<String, String>> settings = this.dataBaseService.executeQuery("SELECT variable FROM jrun_settings WHERE SUBSTRING(variable, 1, 9)<>'jswizard_' ORDER BY variable", new String[0]);
        ArrayList<String> settingsdatanew = new ArrayList<String>();
        if (settings != null) {
            for (Map<String, String> setting : settings) {
                settingsdatanew.add(setting.get("variable"));
            }
        }
        StringBuffer settingsdeldata = new StringBuffer();
        if (settingsdata != null) {
            for (Map.Entry e : settingsdata.entrySet()) {
                String variable = (String)e.getValue();
                if (settingsdatanew.contains(variable)) continue;
                settingsdeldata.append("," + variable);
            }
        }
        request.setAttribute("settingsdeldata", settingsdeldata.length() > 0 ? settingsdeldata.substring(1) : null);
        Config config = new Config(String.valueOf(realPath) + "/config.properties");
        String version = config.getValue("version");
        StringBuffer charseterrors = new StringBuffer();
        if (version.compareTo("4.1") > 0) {
            String dbcharset = config.getValue("dbcharset");
            if (dbcharset == null || dbcharset.equals("")) {
                dbcharset = "UTF-8".replaceAll("-", "");
            }
            dbcharset = dbcharset.toUpperCase();
            List<TableStatusVO> tableStatusVOs = this.dataBaseService.findTableStatus("SHOW TABLE STATUS LIKE 'jrun_%';");
            for (TableStatusVO statusVO : tableStatusVOs) {
                String tabledbcharset;
                int index;
                if (statusVO.getCollation() == null || (index = statusVO.getCollation().indexOf("_")) < 0 || dbcharset.equals((tabledbcharset = statusVO.getCollation().substring(0, index)).toUpperCase())) continue;
                charseterrors.append("<span style='float: left; width: 33%'>" + statusVO.getName() + "(" + tabledbcharset + ")</span>");
            }
            request.setAttribute("dbcharset", (Object)dbcharset);
            request.setAttribute("charseterrors", (Object)(charseterrors.length() > 0 ? charseterrors.toString() : null));
        }
        boolean installexists = new File(String.valueOf(realPath) + "install/jsprun.sql").exists();
        List<String> tablenew = this.dataBaseService.findAllTableNames("jrun_");
        StringBuffer missingtables = new StringBuffer();
        TreeMap<String, ArrayList<FieldVO>> addsMap = new TreeMap<String, ArrayList<FieldVO>>();
        TreeMap modifysMap = new TreeMap();
        TreeMap<String, ArrayList<String>> delsMap = new TreeMap<String, ArrayList<String>>();
        if (jsprundb != null) {
            Set key = jsprundb.keySet();
            for (String obj : key) {
                String tableName = "jrun_" + obj;
                if (tablenew.contains(tableName)) {
                    List<FieldVO> fieldsnew = this.dataBaseService.findTableFields(tableName);
                    Map jsprunfields = (Map)jsprundb.get(obj);
                    Set jsprunfieldNames = jsprunfields.keySet();
                    if (jsprunfieldNames != null) {
                        for (String fieldName : jsprunfieldNames) {
                            boolean flag = false;
                            if (fieldsnew != null) {
                                for (FieldVO fieldVO : fieldsnew) {
                                    if (!fieldName.equals(fieldVO.getField())) continue;
                                    flag = true;
                                    break;
                                }
                            }
                            if (flag) continue;
                            ArrayList<String> fieldlists = (ArrayList<String>)delsMap.get(obj);
                            if (fieldlists == null) {
                                fieldlists = new ArrayList<String>();
                            }
                            fieldlists.add(fieldName);
                            delsMap.put(obj, fieldlists);
                        }
                    }
                    if (fieldsnew == null) continue;
                    for (FieldVO fieldVO : fieldsnew) {
                        if (fieldVO.getAllowNull() == null || fieldVO.getAllowNull().equals("")) {
                            fieldVO.setAllowNull("NO");
                        }
                        if (fieldVO.getDefaultValue() == null || fieldVO.getDefaultValue().equals("0") || fieldVO.getDefaultValue().equals("0.00")) {
                            fieldVO.setDefaultValue("");
                        }
                        List<FieldVO> fieldlists = null;
                        if (jsprunfieldNames != null && jsprunfieldNames.contains(fieldVO.getField())) {
                            Map jsprunfield = (Map)jsprunfields.get(fieldVO.getField());
                            if (version.compareTo("4.1") < 0 && tableName == "sessions" && fieldVO.getField() == "sid") {
                                fieldVO.setType(fieldVO.getType().replaceAll(" binary", ""));
                            }
                            if (((String)jsprunfield.get("Type")).equals(fieldVO.getType()) && ((String)jsprunfield.get("Null")).equals(fieldVO.getAllowNull()) && ((String)jsprunfield.get("Extra")).equals(fieldVO.getExtra()) && ((String)jsprunfield.get("Default")).equals(fieldVO.getDefaultValue())) continue;
                            fieldlists = (List)modifysMap.get(obj);
                            if (fieldlists == null) {
                                fieldlists = new ArrayList();
                            }
                            fieldlists.add(fieldVO);
                            modifysMap.put(obj, fieldlists);
                            continue;
                        }
                        fieldlists = (ArrayList<FieldVO>)addsMap.get(obj);
                        if (fieldlists == null) {
                            fieldlists = new ArrayList<FieldVO>();
                        }
                        fieldlists.add(fieldVO);
                        addsMap.put(obj, (ArrayList<FieldVO>)fieldlists);
                    }
                    continue;
                }
                missingtables.append("<span style='float:left;width:33%'>" + (installexists ? "<input name='missingtable' type='checkbox' class='checkbox' value='" + obj + "'>" : "") + tableName + "</span>");
            }
        }
        request.setAttribute("tablepre", (Object)"jrun_");
        request.setAttribute("jsprundb", (Object)jsprundb);
        request.setAttribute("missingtables", (Object)(missingtables.length() > 0 ? missingtables.toString() : null));
        request.setAttribute("addsMap", addsMap.size() > 0 ? addsMap : "");
        session.setAttribute("modifysMap", modifysMap);
        session.setAttribute("delsMap", delsMap);
        request.setAttribute("hasErrorField", (Object)(modifysMap.size() > 0 || delsMap.size() > 0 ? 1 : 0));
        if (charseterrors.length() == 0 && missingtables.length() == 0 && addsMap.size() == 0 && modifysMap.size() == 0 && delsMap.size() == 0 && settingsdeldata.length() == 0) {
            request.setAttribute("info", (Object)"yes");
            request.setAttribute("dbcheck_ok", (Object)this.getMessage(request, "a_system_dbcheck_db_ok", new String[0]));
            return mapping.findForward("toDbcheck");
        }
        return mapping.findForward("toDbcheck");
    }

    public ActionForward dbcheck(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        block34: {
            String[] repair = request.getParameterValues("repair");
            String[] repairtable = request.getParameterValues("repairtable");
            String[] missingtable = request.getParameterValues("missingtable");
            String settingsdel = request.getParameter("setting[del]");
            if (repair == null && repairtable == null && missingtable == null && !"1".equals(settingsdel)) {
                return this.toDbcheck(mapping, form, request, response);
            }
            try {
                int n;
                int n2;
                String[] stringArray;
                if (!this.submitCheck(request, "repairsubmit")) break block34;
                StringBuffer errors = new StringBuffer();
                HttpSession session = request.getSession();
                Map jsprundb = (Map)session.getAttribute("jsprundb");
                Map settingsdata = (Map)jsprundb.get(1);
                jsprundb = (Map)((Map)jsprundb.get(0)).get(0);
                if (repairtable != null) {
                    stringArray = repairtable;
                    n2 = repairtable.length;
                    n = 0;
                    while (n < n2) {
                        List fieldNames;
                        String tableName = stringArray[n];
                        Map modifysMap = (Map)session.getAttribute("modifysMap");
                        Map delsMap = (Map)session.getAttribute("delsMap");
                        List fieldVO = (List)modifysMap.get(tableName);
                        if (fieldVO != null) {
                            for (FieldVO obj : fieldVO) {
                                Map field = (Map)((Map)jsprundb.get(tableName)).get(obj.getField());
                                String error = this.dataBaseService.runQuery("ALTER TABLE jrun_" + tableName + " MODIFY COLUMN " + (String)field.get("Field") + " " + (String)field.get("Type") + " " + (((String)field.get("Null")).equals("NO") ? "NOT NULL" : "") + " " + (String)field.get("Extra") + " " + (((String)field.get("Null")).equals("") && ((String)field.get("Default")).equals("") || this.getStr((String)field.get("Type"), "text").size() == 0 || this.getStr((String)field.get("Extra"), "auto_increment").size() == 0 ? "" : "DEFAULT '" + (String)field.get("Default") + "';")).get("error");
                                if (error == null) continue;
                                errors.append("<br /><br />" + error);
                            }
                        }
                        if ((fieldNames = (List)delsMap.get(tableName)) != null) {
                            for (String fieldName : fieldNames) {
                                Map field = (Map)((Map)jsprundb.get(tableName)).get(fieldName);
                                String error = this.dataBaseService.runQuery("ALTER TABLE jrun_" + tableName + " ADD COLUMN " + (String)field.get("Field") + " " + (String)field.get("Type") + " " + (((String)field.get("Null")).equals("NO") ? "NOT NULL" : "") + " " + (String)field.get("Extra") + " " + (((String)field.get("Null")).equals("") && ((String)field.get("Default")).equals("") || this.getStr((String)field.get("Type"), "text").size() == 0 || this.getStr((String)field.get("Extra"), "auto_increment").size() == 0 ? "" : "DEFAULT '" + (String)field.get("Default") + "';")).get("error");
                                if (error == null) continue;
                                errors.append("<br /><br />" + error);
                            }
                        }
                        ++n;
                    }
                }
                if (repair != null) {
                    stringArray = repair;
                    n2 = repair.length;
                    n = 0;
                    while (n < n2) {
                        String str = stringArray[n];
                        String[] fieldInfo = str.split("\\|");
                        String tableName = fieldInfo[0];
                        String fieldName = fieldInfo[1];
                        String type = fieldInfo[2];
                        Map field = (Map)((Map)jsprundb.get(tableName)).get(fieldName);
                        String error = this.dataBaseService.runQuery("ALTER TABLE jrun_" + tableName + " " + (type.equals("add") ? "ADD COLUMN" : "MODIFY COLUMN") + " " + (String)field.get("Field") + " " + (String)field.get("Type") + " " + (((String)field.get("Null")).equals("NO") ? "NOT NULL" : "") + " " + (String)field.get("Extra") + " " + (((String)field.get("Null")).equals("") && ((String)field.get("Default")).equals("") || this.getStr((String)field.get("Type"), "text").size() == 0 || this.getStr((String)field.get("Extra"), "auto_increment").size() == 0 ? "" : "DEFAULT '" + (String)field.get("Default") + "';")).get("error");
                        if (error != null) {
                            errors.append("<br /><br />" + error);
                        }
                        ++n;
                    }
                }
                if (missingtable != null) {
                    Object br;
                    StringBuffer jsprunContent = (StringBuffer)session.getAttribute("jsprunContent");
                    if (jsprunContent == null) {
                        block36: {
                            String realPath = JspRunConfig.realPath;
                            File file = new File(String.valueOf(realPath) + "./install/jsprun.sql");
                            InputStreamReader fr = null;
                            br = null;
                            try {
                                try {
                                    jsprunContent = new StringBuffer();
                                    fr = new FileReader(file);
                                    br = new BufferedReader(fr);
                                    String line = ((BufferedReader)br).readLine();
                                    while (line != null) {
                                        jsprunContent.append(line);
                                        line = ((BufferedReader)br).readLine();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    try {
                                        ((BufferedReader)br).close();
                                        fr.close();
                                    }
                                    catch (IOException e2) {
                                        e2.printStackTrace();
                                    }
                                    break block36;
                                }
                            }
                            catch (Throwable fieldName) {
                                try {
                                    ((BufferedReader)br).close();
                                    fr.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                throw fieldName;
                            }
                            try {
                                ((BufferedReader)br).close();
                                fr.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        session.setAttribute("jsprunContent", (Object)jsprunContent);
                    }
                    br = missingtable;
                    int fr = missingtable.length;
                    int file = 0;
                    while (file < fr) {
                        String error;
                        String tableName = br[file];
                        List<String> strs = this.getStr(jsprunContent.toString(), "CREATE TABLE jrun_" + tableName + "\\s\\(.+?;");
                        if (strs != null && strs.size() > 0 && (error = this.dataBaseService.runQuery(strs.get(0)).get("error")) != null) {
                            errors.append("<br /><br />" + error);
                        }
                        ++file;
                    }
                }
                if ("1".equals(settingsdel)) {
                    List<Map<String, String>> settings = this.dataBaseService.executeQuery("SELECT variable FROM jrun_settings WHERE SUBSTRING(variable, 1, 9)<>'jswizard_' ORDER BY variable", new String[0]);
                    ArrayList<String> settingsdatanew = new ArrayList<String>();
                    if (settings != null) {
                        for (Map<String, String> setting : settings) {
                            settingsdatanew.add(setting.get("variable"));
                        }
                    }
                    if (settingsdata != null) {
                        for (Map.Entry e : settingsdata.entrySet()) {
                            String error;
                            String variable = ((String)e.getValue()).trim();
                            if (settingsdatanew.contains(variable) || (error = this.dataBaseService.runQuery("insert into jrun_settings (variable, value) values('" + variable + "','')").get("error")) == null) continue;
                            errors.append("<br /><br />" + error);
                        }
                    }
                }
                request.setAttribute("info", (Object)"yes");
                if (errors.length() > 0) {
                    request.setAttribute("dbcheck_repair_error", (Object)errors.toString());
                } else {
                    request.setAttribute("dbcheck_repair_completed", (Object)"admincp.jsp?action=moddbcheck");
                }
                return mapping.findForward("toDbcheck");
            }
            catch (Exception e) {
                request.setAttribute("message", (Object)e.getMessage());
                return mapping.findForward("message");
            }
        }
        return this.toDbcheck(mapping, form, request, response);
    }

    private List<String> getStr(String content, String regex) {
        ArrayList<String> strList = new ArrayList<String>();
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(regex);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
        }
        Perl5Matcher m = new Perl5Matcher();
        if (m.contains(content, pattern)) {
            MatchResult result = m.getMatch();
            int i = 0;
            while (i < result.groups()) {
                strList.add(result.group(i));
                ++i;
            }
        }
        return strList;
    }

    private NodeList getSimplequerie() {
        String simplequerie = String.valueOf(JspRunConfig.realPath) + "admin/page/counter/quickqueries.xml";
        File file = new File(simplequerie);
        NodeList nl = null;
        try {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                nl = document.getElementsByTagName("simplequerie");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return nl;
    }
}

