/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.foreg.service;

import cn.jsprun.dao.DataBaseDao;
import cn.jsprun.domain.Members;
import cn.jsprun.foreg.vo.wap.FooterVO;
import cn.jsprun.foreg.vo.wap.ForumInfo;
import cn.jsprun.foreg.vo.wap.Forums_threadsVO;
import cn.jsprun.foreg.vo.wap.GoToVo;
import cn.jsprun.foreg.vo.wap.HeaderVO;
import cn.jsprun.foreg.vo.wap.HomeVO;
import cn.jsprun.foreg.vo.wap.LoginVO;
import cn.jsprun.foreg.vo.wap.MessageVO;
import cn.jsprun.foreg.vo.wap.MyCollectionVO;
import cn.jsprun.foreg.vo.wap.MyPhoneVO;
import cn.jsprun.foreg.vo.wap.MyVO;
import cn.jsprun.foreg.vo.wap.NewReplyVO;
import cn.jsprun.foreg.vo.wap.NewThreadVO;
import cn.jsprun.foreg.vo.wap.PmListVO;
import cn.jsprun.foreg.vo.wap.PmSendVO;
import cn.jsprun.foreg.vo.wap.PmVO;
import cn.jsprun.foreg.vo.wap.PmViewVO;
import cn.jsprun.foreg.vo.wap.RegisterVO;
import cn.jsprun.foreg.vo.wap.SearchResultVO;
import cn.jsprun.foreg.vo.wap.SearchVO;
import cn.jsprun.foreg.vo.wap.StatsVO;
import cn.jsprun.foreg.vo.wap.ThreadInfo;
import cn.jsprun.foreg.vo.wap.ThreadVO;
import cn.jsprun.utils.BeanFactory;
import cn.jsprun.utils.Common;
import cn.jsprun.utils.DataParse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WapService {
    private static final String tablePre = "jrun_";

    public boolean validateWap(HttpServletRequest request, HttpServletResponse response, Map<String, String> settingMap, Members memberInSession, String formhashInSession, String sid, MessageResources mr, Locale locale) {
        String url;
        String user_agent = request.getHeader("user-agent");
        if (user_agent != null && user_agent.toLowerCase().matches(".*(mozilla|m3gate|winwap|openwave).*")) {
            String boardUrl = (String)request.getSession().getAttribute("boardurl");
            try {
                response.sendRedirect(String.valueOf(boardUrl) + "index.jsp");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        String action = request.getParameter("action");
        String string = action = action == null ? "home" : action;
        if (action.equals("goto") && (url = request.getParameter("url")) != null && !url.equals("")) {
            try {
                response.sendRedirect(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        if (settingMap.get("wapstatus").equals("0")) {
            this.forwardToMessage(request, response, settingMap, mr.getMessage(locale, "wap_disabled"), null, settingMap.get("bbname"), memberInSession, action, formhashInSession, sid);
            return false;
        }
        if (!settingMap.get("bbclosed").equals("0")) {
            this.forwardToMessage(request, response, settingMap, mr.getMessage(locale, "board_closed_wap"), null, settingMap.get("bbname"), memberInSession, action, formhashInSession, sid);
            return false;
        }
        if (!(action.equals("home") || action.equals("login") || action.equals("register") || action.equals("search") || action.equals("stats") || action.equals("my") || action.equals("myphone") || action.equals("goto") || action.equals("forum") || action.equals("thread") || action.equals("post") || action.equals("pm"))) {
            this.forwardToMessage(request, response, settingMap, mr.getMessage(locale, "undefined_action"), null, settingMap.get("bbname"), memberInSession, action, formhashInSession, sid);
            return false;
        }
        return true;
    }

    public HomeVO getHomeVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String allowsearch, String formhash, String sid) {
        List<Map<String, String>> forumInfoMapList;
        HomeVO homeVO = new HomeVO();
        this.setHeaderVO(homeVO.getHeaderVO(), settingMap.get("bbname"));
        this.setFooterVO(request, settingMap, homeVO.getFooterVO(), currentMember, "home", formhash, sid);
        homeVO.setIsLogin(currentMember != null);
        homeVO.setSid(sid);
        homeVO.setBbname(settingMap.get("bbname"));
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        String sql = null;
        if (currentMember != null) {
            byte accessmasks;
            if (allowsearch != null && !allowsearch.equals("") && !allowsearch.equals("0")) {
                homeVO.setAllowsearch(true);
                int timestamp = (Integer)request.getAttribute("timestamp");
                int lastvisit = currentMember.getLastvisit();
                int newthreads = Math.round((float)(timestamp - lastvisit + 600) / 1000.0f) * 1000;
                homeVO.setNewthreads(newthreads);
            }
            if ((accessmasks = currentMember.getAccessmasks().byteValue()) > 0) {
                sql = "SELECT f.fid, f.name, ff.viewperm, a.allowview FROM jrun_forums f LEFT JOIN jrun_forumfields ff ON ff.fid=f.fid LEFT JOIN jrun_access a ON a.uid='" + currentMember.getUid() + "' AND a.fid=f.fid " + "WHERE f.status=1 AND f.type='forum' ORDER BY f.displayorder,f.fid";
            }
        }
        if (sql == null) {
            sql = "SELECT f.fid, f.name, ff.viewperm FROM jrun_forums f LEFT JOIN jrun_forumfields ff USING(fid) WHERE f.status=1 AND f.type='forum' ORDER BY f.displayorder,f.fid";
        }
        if ((forumInfoMapList = dataBaseDao.executeQuery(sql, new String[0])) != null) {
            List<HomeVO.Forum> forumList = homeVO.getForumList();
            int groupid = currentMember != null ? (int)currentMember.getGroupid().shortValue() : 7;
            int sign = 1;
            for (Map<String, String> forumInfoMap : forumInfoMapList) {
                String viewperm;
                if (forumInfoMap == null || !(viewperm = forumInfoMap.get("viewperm")).equals("") && ("\t" + viewperm + "\t").indexOf("\t" + groupid + "\t") < 0) continue;
                HomeVO.Forum forum = homeVO.getForum();
                forum.setFid(forumInfoMap.get("fid"));
                forum.setName(Common.strip_tags(Common.htmlspecialchars(forumInfoMap.get("name"))));
                forumList.add(forum);
                if (sign++ == 10) break;
            }
            homeVO.setExistMoreForum(sign > 10);
        }
        int onlinenum = Integer.parseInt(dataBaseDao.executeQuery("SELECT COUNT(*) as count FROM jrun_sessions", new String[0]).get(0).get("count"));
        int guestCount = Integer.parseInt(dataBaseDao.executeQuery("SELECT COUNT(*) as count FROM jrun_sessions WHERE uid = 0", new String[0]).get(0).get("count"));
        int memberCount = onlinenum - guestCount;
        homeVO.setGuestCount(guestCount);
        homeVO.setMemberCount(memberCount);
        return homeVO;
    }

    public LoginVO getLoginVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid, boolean failedAnswer, String username, String loginauth) {
        LoginVO loginVO = new LoginVO();
        loginVO.setSid(sid);
        loginVO.setFailedAnswer(failedAnswer);
        loginVO.setUsername(username);
        loginVO.setLoginauth(loginauth);
        this.setHeaderVO(loginVO.getHeaderVO(), settingMap.get("bbname"));
        this.setFooterVO(request, settingMap, loginVO.getFooterVO(), currentMember, "login", formhash, sid);
        return loginVO;
    }

    public boolean loginCheck(String onlineIp, int timestamp) {
        Map<String, String> flMap;
        int lastupdate;
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        List<Map<String, String>> flMapList = dataBaseDao.executeQuery("SELECT count, lastupdate FROM jrun_failedlogins WHERE ip=?", onlineIp);
        int count = 0;
        count = flMapList != null && flMapList.size() > 0 ? (timestamp - (lastupdate = Integer.parseInt((flMap = flMapList.get(0)).get("lastupdate"))) > 900 ? 4 : Math.max(0, Integer.parseInt(flMap.get("count")))) : 4;
        if (count == 4) {
            dataBaseDao.execute("REPLACE INTO jrun_failedlogins (ip, count, lastupdate) VALUES (?, '1', '" + timestamp + "')", onlineIp);
            dataBaseDao.executeDelete("DELETE FROM jrun_failedlogins WHERE lastupdate<" + (timestamp - 901), new String[0]);
        }
        return count != 0;
    }

    public void forwardToMessage(HttpServletRequest request, HttpServletResponse response, Map<String, String> settingMap, String message, Map<String, String> forwardMap, String headerVO_title, Members currentMembers, String action, String formhash, String sid) {
        MessageVO messageVO = new MessageVO();
        this.setMessageVO(request, response, settingMap, messageVO, message, forwardMap, headerVO_title, currentMembers, action, formhash, sid);
        request.setAttribute("valueObject", (Object)messageVO);
        RequestDispatcher dispatcher = request.getRequestDispatcher("/wap/include/message.jsp");
        try {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RegisterVO getRegisterVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid) {
        RegisterVO registerVO = new RegisterVO();
        this.setHeaderVO(registerVO.getHeaderVO(), settingMap.get("bbname"));
        this.setFooterVO(request, settingMap, registerVO.getFooterVO(), currentMember, "register", formhash, sid);
        return registerVO;
    }

    public Forums_threadsVO getPartOfF(HttpServletRequest request, HttpServletResponse response, String pageString, Map<String, String> settingMap, Members currentMember, int jsprun_uid, short groupid, String formhash, String sid, MessageResources mr, Locale locale, String timeoffset) {
        byte accessmasks;
        String sql;
        List<Map<String, String>> forumMapList;
        Forums_threadsVO forums_threadsVO = new Forums_threadsVO();
        this.setHeaderVO(forums_threadsVO.getHeaderVO(), settingMap.get("bbname"));
        this.setFooterVO(request, settingMap, forums_threadsVO.getFooterVO(), currentMember, "forum", formhash, sid);
        forums_threadsVO.setShowForum(true);
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        int page = 1;
        if (pageString != null && !pageString.equals("")) {
            try {
                page = Math.max(1, Integer.parseInt(pageString));
            }
            catch (NumberFormatException exception) {
                exception.printStackTrace();
            }
        }
        int waptpp = Integer.parseInt(settingMap.get("waptpp"));
        int start_limit = (page - 1) * waptpp;
        String query = "SELECT COUNT(*) AS ct FROM jrun_forums WHERE status=1 AND type='forum'";
        int forumcount = 0;
        List<Map<String, String>> resultTemp = dataBaseDao.executeQuery(query, new String[0]);
        if (resultTemp != null && resultTemp.size() > 0) {
            forumcount = Integer.parseInt(resultTemp.get(0).get("ct"));
        }
        if ((forumMapList = dataBaseDao.executeQuery(sql = (accessmasks = currentMember != null ? currentMember.getAccessmasks() : (byte)0) > 0 ? "SELECT f.fid, f.name, f.lastpost, ff.viewperm, ff.moderators, ff.icon, a.allowview FROM jrun_forums f LEFT JOIN jrun_forumfields ff ON ff.fid=f.fid LEFT JOIN jrun_access a ON a.uid='" + jsprun_uid + "' AND a.fid=f.fid " + "WHERE f.status=1 AND f.type='forum' ORDER BY f.displayorder,f.fid LIMIT " + start_limit + ", " + waptpp : "SELECT f.fid, f.name, f.lastpost, ff.viewperm, ff.moderators, ff.icon FROM jrun_forums f LEFT JOIN jrun_forumfields ff USING(fid) WHERE f.status=1 AND f.type='forum' ORDER BY f.displayorder,f.fid LIMIT " + start_limit + ", " + waptpp, new String[0])) != null) {
            List<ForumInfo> forumList = forums_threadsVO.getForumList();
            String hideprivate = settingMap.get("hideprivate");
            int lastvisit = currentMember != null ? currentMember.getLastvisit() : 0;
            String extgroupid = currentMember != null ? currentMember.getExtgroupids() : null;
            TreeMap<String, Map<String, String>> lastposts = new TreeMap<String, Map<String, String>>();
            String timeformat = settingMap.get("timeformat");
            timeformat = timeformat.equals("1") ? "hh:mm a" : "HH:mm";
            String dateformat = settingMap.get("dateformat");
            SimpleDateFormat sdf_all = Common.getSimpleDateFormat(String.valueOf(dateformat) + " " + timeformat, timeoffset);
            for (Map<String, String> forumMap : forumMapList) {
                String viewperm = forumMap.get("viewperm");
                if (!Common.forum(forumMap, hideprivate, groupid, lastvisit, extgroupid, lastposts, sdf_all) || !viewperm.equals("") && !("\t" + viewperm.trim() + "\t").contains("\t" + groupid + "\t")) continue;
                ForumInfo forumInfo = forums_threadsVO.getForumInfo();
                forumInfo.setFid(forumMap.get("fid"));
                forumInfo.setName(Common.strip_tags(Common.htmlspecialchars(forumMap.get("name"))));
                forumList.add(forumInfo);
            }
        }
        forums_threadsVO.setMultipage(this.wapmulti(forumcount, waptpp, page, response.encodeURL("index.jsp?action=forum"), mr, locale));
        return forums_threadsVO;
    }

    public Forums_threadsVO getPartOfT(HttpServletRequest request, HttpServletResponse response, String pageString, String dow, short fid, short groupid, Map<String, String> settingMap, Map<String, Map<String, String>> forums, Map<String, String> groupCache, Members currentMember, String formhash, String sid, MessageResources mr, Locale locale) {
        int start_limit;
        Forums_threadsVO forums_threadsVO = new Forums_threadsVO();
        this.setHeaderVO(forums_threadsVO.getHeaderVO(), settingMap.get("bbname"));
        this.setFooterVO(request, settingMap, forums_threadsVO.getFooterVO(), currentMember, "forum", formhash, sid);
        List<ThreadInfo> threadList = forums_threadsVO.getThreadList();
        Map<String, String> forum = forums.get(String.valueOf(fid));
        forums_threadsVO.setForumName(forum.get("name"));
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        int waptpp = Integer.parseInt(settingMap.get("waptpp"));
        int page = 1;
        if (pageString != null && !pageString.equals("")) {
            try {
                page = Math.max(1, Integer.parseInt(pageString));
            }
            catch (NumberFormatException exception) {
                exception.printStackTrace();
            }
        }
        int number = start_limit = (page - 1) * waptpp;
        dow = dow == null || dow.equals("") || dow.equals("0") ? "" : "digest";
        String filteradd = dow.equals("digest") ? "AND digest>'0'" : "";
        int threadcount = 0;
        List<Map<String, String>> tempResult = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct FROM jrun_threads WHERE fid='" + fid + "' " + filteradd + " AND displayorder>='0'", new String[0]);
        if (tempResult != null && tempResult.size() > 0) {
            threadcount = Integer.parseInt(tempResult.get(0).get("ct"));
        }
        String thread_prefix = "";
        List<Map<String, String>> threadMapList = dataBaseDao.executeQuery("SELECT * FROM jrun_threads WHERE fid='" + fid + "' " + filteradd + " AND displayorder>='0' " + "ORDER BY displayorder DESC, lastpost DESC LIMIT " + start_limit + ", " + waptpp, new String[0]);
        if (threadMapList != null && threadMapList.size() > 0) {
            for (Map<String, String> thread : threadMapList) {
                thread_prefix = Integer.parseInt(thread.get("displayorder")) > 0 ? mr.getMessage(locale, "forum_thread_sticky") : "";
                thread_prefix = String.valueOf(thread_prefix) + (Integer.parseInt(thread.get("digest")) > 0 ? mr.getMessage(locale, "forum_thread_digest") : "");
                ThreadInfo threadInfo = forums_threadsVO.getThreadInfo();
                threadInfo.setAuthor(thread.get("author"));
                threadInfo.setNumber(String.valueOf(++number));
                threadInfo.setPrefix(thread_prefix);
                threadInfo.setReplies(thread.get("replies"));
                String subject = thread.get("subject");
                threadInfo.setSubject(Common.strip_tags(subject.length() > 30 ? Common.htmlspecialchars(subject.substring(0, 30)) : Common.htmlspecialchars(subject)));
                threadInfo.setTid(thread.get("tid"));
                threadInfo.setViews(thread.get("views"));
                threadList.add(threadInfo);
            }
        }
        forums_threadsVO.setMultipage(this.wapmulti(threadcount, waptpp, page, response.encodeURL("index.jsp?action=forum&amp;fid=" + fid + "&amp;sid=" + sid), mr, locale));
        StringBuffer subfrums = new StringBuffer();
        if (!dow.equals("digest")) {
            String fidString = String.valueOf(fid);
            for (Map.Entry<String, Map<String, String>> entry : forums.entrySet()) {
                String subFid = entry.getKey();
                Map<String, String> subforum = entry.getValue();
                if (!subforum.get("type").equals("sub") || !subforum.get("fup").equals(fidString) || !subforum.get("viewperm").equals("") && !("\t" + subforum.get("viewperm").trim() + "\t").contains("\t" + groupid + "\t")) continue;
                subfrums.append("<a href=\"" + response.encodeURL("index.jsp") + "?action=forum&amp;fid=" + subFid + "\">" + Common.strip_tags(subforum.get("name")) + "</a><br />");
            }
        }
        forums_threadsVO.setForumId(String.valueOf(fid));
        forums_threadsVO.setSubfrums(subfrums.toString());
        String allowsearch = groupCache.get("allowsearch");
        forums_threadsVO.setAllowsearch(allowsearch != null && !allowsearch.equals("") && !allowsearch.equals("0"));
        return forums_threadsVO;
    }

    public ThreadVO getThreadVO(HttpServletRequest request, HttpServletResponse response, Members currentMember, Map<String, String> thread, Map<String, String> settingMap, String formhash, String sid, String dow, String pageString, int offset, String pid, int start, Map<String, String> userGroupCache, String timeoffset, MessageResources mr, Locale locale) {
        String allowreply;
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        ThreadVO threadVO = new ThreadVO();
        this.setHeaderVO(threadVO.getHeaderVO(), settingMap.get("bbname"));
        this.setFooterVO(request, settingMap, threadVO.getFooterVO(), currentMember, "thread", formhash, sid);
        String wapdateformat = settingMap.get("wapdateformat");
        String timeformat = settingMap.get("timeformat");
        timeformat = timeformat.equals("1") ? "hh:mm a" : "HH:mm";
        int wapmps = Integer.parseInt(settingMap.get("wapmps"));
        String tid = thread.get("tid");
        threadVO.setTid(tid);
        threadVO.setSubject(Common.htmlspecialchars(Common.strip_tags(thread.get("subject"))));
        String threadposts = "";
        if (dow.equals("")) {
            threadVO.setViewThread(true);
            threadVO.setAuthorid(thread.get("authorid"));
            threadVO.setAuthor(Common.strip_tags(thread.get("author")));
            SimpleDateFormat simpleDateFormat = Common.getSimpleDateFormat(String.valueOf(wapdateformat) + " " + timeformat, timeoffset);
            threadVO.setDateline(Common.gmdate(simpleDateFormat, Integer.parseInt(thread.get("dateline"))));
            int page = 1;
            if (pageString != null && !pageString.equals("")) {
                try {
                    page = Math.max(1, Integer.parseInt(pageString));
                }
                catch (NumberFormatException exception) {
                    exception.printStackTrace();
                }
            }
            int wapppp = Integer.parseInt(settingMap.get("wapppp"));
            int start_limit = (page - 1) * wapppp;
            int number = start_limit++;
            int end_limit = 0;
            end_limit = page < 2 ? wapppp + 1 : wapppp;
            List<Map<String, String>> postsMapList = dataBaseDao.executeQuery("SELECT * FROM jrun_posts WHERE tid='" + tid + "' AND invisible='0' " + "ORDER BY dateline LIMIT " + start_limit + ", " + end_limit, new String[0]);
            int offset_last = 0;
            int offset_next = 0;
            boolean breaked = false;
            ArrayList<Map<String, String>> postlist = new ArrayList<Map<String, String>>();
            String fid = null;
            for (Map<String, String> postsMap : postsMapList) {
                postsMap.put("message", this.wapcode(postsMap.get("message"), mr, locale));
                if (postsMap.get("first").equals("1")) {
                    if (offset > 0) {
                        offset_last = offset - wapmps;
                        postsMap.put("message", this.substr(postsMap.get("message"), offset));
                    } else {
                        offset = 0;
                    }
                    int mLen = 0;
                    String string = postsMap.get("message");
                    try {
                        mLen = string.getBytes("GBK").length;
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    if (mLen > wapmps) {
                        postsMap.put("message", this.wapcutstr(string, wapmps));
                        offset_next = offset + wapmps;
                        breaked = true;
                    } else {
                        breaked = false;
                    }
                    if (postsMap.get("anonymous").equals("1")) {
                        postsMap.put("author", mr.getMessage(locale, "anonymous"));
                    }
                    threadposts = String.valueOf(threadposts) + postsMap.get("message").trim();
                    fid = postsMap.get("fid");
                    continue;
                }
                postlist.add(postsMap);
            }
            threadVO.setThreadposts(Common.strip_tags(threadposts).replaceAll("\r|\n", "<br />"));
            threadVO.setExistNextPage(breaked);
            threadVO.setExistLastPage(offset != 0);
            threadVO.setFid(fid);
            threadVO.setOffset_next(offset_next);
            threadVO.setOffset_last(offset_last);
            List<ThreadVO.PostsInfo> postsList = threadVO.getPostsList();
            int waptlength = 30;
            if (postlist.size() > 0) {
                String replies = thread.get("replies");
                threadVO.setReplies(replies);
                for (Map map : postlist) {
                    ThreadVO.PostsInfo postsInfo = threadVO.getPostsInfoInstance();
                    postsInfo.setAuthor(((String)map.get("anonymous")).equals("1") ? mr.getMessage(locale, "anonymous") : (String)map.get("author"));
                    postsInfo.setDateline(Common.gmdate(simpleDateFormat, Integer.parseInt((String)map.get("dateline"))));
                    postsInfo.setMessage(Common.strip_tags(this.wapcutstr((String)map.get("message"), waptlength)));
                    postsInfo.setNumber(++number);
                    postsInfo.setPid((String)map.get("pid"));
                    postsList.add(postsInfo);
                }
                threadVO.setWapmulti(this.wapmulti(Integer.parseInt(replies), wapppp, page, response.encodeURL("index.jsp?action=thread&amp;tid=" + tid), mr, locale));
            }
        } else {
            List<Map<String, String>> postMapList = dataBaseDao.executeQuery("SELECT * FROM jrun_posts WHERE pid=? AND invisible='0'", pid);
            boolean breaked = false;
            if (postMapList != null && postMapList.size() > 0) {
                Map<String, String> postMap = postMapList.get(0);
                if (offset > 0) {
                    postMap.put("message", this.substr(postMap.get("message"), offset));
                }
                int postMessgeLen = 0;
                try {
                    postMessgeLen = postMap.get("message").getBytes("GBK").length;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (postMessgeLen - wapmps > 0) {
                    postMap.put("message", this.wapcutstr(postMap.get("message"), wapmps));
                    breaked = true;
                }
                if (postMap.get("anonymous").equals("1")) {
                    postMap.put("author", mr.getMessage(locale, "anonymous"));
                }
                postMap.put("message", this.wapcode(postMap.get("message"), mr, locale));
                ThreadVO.PostsInfo postsInfo = threadVO.getPostsInfo();
                postsInfo.setPid(postMap.get("pid"));
                postsInfo.setAnonymous(postMap.get("anonymous").equals("1"));
                postsInfo.setAuthor(Common.strip_tags(postMap.get("author")));
                postsInfo.setAuthorid(postMap.get("authorid"));
                postsInfo.setMessage(Common.strip_tags(postMap.get("message").trim()).replaceAll("\n|\r", "<br />"));
                threadVO.setExistNextPage(breaked);
                threadVO.setExistLastPage(offset != 0);
                threadVO.setOffset_next(offset + wapmps);
                threadVO.setOffset_last(offset - wapmps);
            }
        }
        threadVO.setAllowreply(!(allowreply = userGroupCache.get("allowreply")).equals(""));
        threadVO.setFid(thread.get("fid"));
        threadVO.setTid(thread.get("tid"));
        threadVO.setSid(sid);
        threadVO.setFormhash(formhash);
        return threadVO;
    }

    public GoToVo getGoToVo(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid) {
        GoToVo goToVo = new GoToVo();
        this.setHeaderVO(goToVo.getHeaderVO(), settingMap.get("bbname"));
        this.setFooterVO(request, settingMap, goToVo.getFooterVO(), currentMember, "goto", formhash, sid);
        return goToVo;
    }

    public NewThreadVO getNewThreadVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid, String fid, String threadtypesString, DataParse dataParse) {
        NewThreadVO newThreadVO = new NewThreadVO();
        this.setFooterVO(request, settingMap, newThreadVO.getFooterVO(), currentMember, "post", formhash, sid);
        this.setHeaderVO(newThreadVO.getHeaderVO(), settingMap.get("bbname"));
        Map threadtypesMap = dataParse.characterParse(threadtypesString, false);
        Object tempRequired = threadtypesMap.get("required");
        if (tempRequired != null && !tempRequired.toString().equals("") && !tempRequired.toString().equals("0")) {
            newThreadVO.setThreadtypes(threadtypesMap);
        }
        newThreadVO.setFid(fid);
        newThreadVO.setFormhash(formhash);
        return newThreadVO;
    }

    public NewReplyVO getNewReplyVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid, String fid, String tid) {
        NewReplyVO newReplyVO = new NewReplyVO();
        this.setFooterVO(request, settingMap, newReplyVO.getFooterVO(), currentMember, "post", formhash, sid);
        this.setHeaderVO(newReplyVO.getHeaderVO(), settingMap.get("bbname"));
        newReplyVO.setFid(fid);
        newReplyVO.setFormhash(formhash);
        newReplyVO.setTid(tid);
        newReplyVO.setSid(sid);
        return newReplyVO;
    }

    public MyVO getMyVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid, Map<String, String> memberMap, int uid, int jsprun_uid, String username, MessageResources mr, Locale locale) {
        String bio;
        String location;
        MyVO myVO = new MyVO();
        myVO.setUid(String.valueOf(uid));
        myVO.setUsername(username);
        this.setFooterVO(request, settingMap, myVO.getFooterVO(), currentMember, "my", formhash, sid);
        this.setHeaderVO(myVO.getHeaderVO(), settingMap.get("bbname"));
        String gender = memberMap.get("gender");
        if (gender.equals("1")) {
            myVO.setGender(mr.getMessage(locale, "a_member_edit_gender_male"));
        } else if (gender.equals("2")) {
            myVO.setGender(mr.getMessage(locale, "a_member_edit_gender_female"));
        } else {
            myVO.setGender(mr.getMessage(locale, "a_member_edit_gender_secret"));
        }
        String bday = memberMap.get("bday");
        if (bday != null && !bday.equals("") && !bday.equals("0000-00-00")) {
            myVO.setBirthday(bday);
        }
        if ((location = memberMap.get("location")) != null && !location.equals("")) {
            myVO.setLocation(location);
        }
        if ((bio = memberMap.get("bio")) != null && !bio.equals("")) {
            myVO.setBio(bio);
        }
        myVO.setSameMember(uid == jsprun_uid);
        return myVO;
    }

    public MyCollectionVO getMyCollectionVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid, int jsprun_uid) {
        MyCollectionVO myCollectionVO = new MyCollectionVO();
        this.setFooterVO(request, settingMap, myCollectionVO.getFooterVO(), currentMember, "my", formhash, sid);
        this.setHeaderVO(myCollectionVO.getHeaderVO(), settingMap.get("bbname"));
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        List<Map<String, String>> mythreadList = dataBaseDao.executeQuery("SELECT m.*, t.subject FROM jrun_mythreads m, jrun_threads t WHERE m.uid = '" + jsprun_uid + "' AND m.tid = t.tid ORDER BY m.dateline DESC LIMIT 0, 3", new String[0]);
        if (mythreadList != null) {
            for (Map<String, String> tempMap : mythreadList) {
                tempMap.put("subject", Common.cutstr(tempMap.get("subject"), 15, null));
            }
        }
        myCollectionVO.setMythreadList(mythreadList);
        List<Map<String, String>> mypostList = dataBaseDao.executeQuery("SELECT m.*, t.subject FROM jrun_myposts m, jrun_threads t WHERE m.uid = '" + jsprun_uid + "' AND m.tid = t.tid ORDER BY m.dateline DESC LIMIT 0, 3", new String[0]);
        if (mypostList != null) {
            for (Map<String, String> tempMap : mypostList) {
                tempMap.put("subject", Common.cutstr(tempMap.get("subject"), 15, null));
            }
        }
        myCollectionVO.setMypostList(mypostList);
        List<Map<String, String>> favthreadList = dataBaseDao.executeQuery("SELECT t.tid, t.subject FROM jrun_favorites fav, jrun_threads t WHERE fav.tid=t.tid AND t.displayorder>='0' AND fav.uid='" + jsprun_uid + "' ORDER BY t.lastpost DESC LIMIT 0, 3", new String[0]);
        if (favthreadList != null) {
            for (Map<String, String> tempMap : favthreadList) {
                tempMap.put("subject", Common.cutstr(tempMap.get("subject"), 24, null));
            }
        }
        myCollectionVO.setFavthreadList(favthreadList);
        List<Map<String, String>> favforumList = dataBaseDao.executeQuery("SELECT f.fid, f.name FROM jrun_favorites fav, jrun_forums f WHERE fav.uid='" + jsprun_uid + "' AND fav.fid=f.fid ORDER BY f.displayorder DESC LIMIT 0, 3", new String[0]);
        myCollectionVO.setFavforumList(favforumList);
        return myCollectionVO;
    }

    public MyPhoneVO getMyPhoneVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid) {
        MyPhoneVO myPhoneVO = new MyPhoneVO();
        this.setFooterVO(request, settingMap, myPhoneVO.getFooterVO(), currentMember, "myphone", formhash, sid);
        this.setHeaderVO(myPhoneVO.getHeaderVO(), settingMap.get("bbname"));
        String user_agent = request.getHeader("user-agent");
        user_agent = user_agent != null ? user_agent.toLowerCase() : "";
        myPhoneVO.setServerInfo(user_agent);
        HashMap<String, String> otherInfoMap = new HashMap<String, String>();
        Enumeration headerInfo = request.getHeaderNames();
        while (headerInfo.hasMoreElements()) {
            String tempName = (String)headerInfo.nextElement();
            otherInfoMap.put(tempName, request.getHeader(tempName));
        }
        myPhoneVO.setOtherInfoMap(otherInfoMap);
        return myPhoneVO;
    }

    public SearchVO getSearchVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid) {
        SearchVO searchVO = new SearchVO();
        this.setHeaderVO(searchVO.getHeaderVO(), settingMap.get("bbname"));
        this.setFooterVO(request, settingMap, searchVO.getFooterVO(), currentMember, "search", formhash, sid);
        searchVO.setSid(sid);
        return searchVO;
    }

    public SearchResultVO getSearchResultVO(HttpServletRequest request, HttpServletResponse response, Map<String, String> settingMap, Members currentMember, String formhash, String sid, Map<String, String> index, int waptpp, int start_limit, int page, int searchnum, String searchid, MessageResources mr, Locale locale) {
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        SearchResultVO searchResultVO = new SearchResultVO();
        this.setHeaderVO(searchResultVO.getHeaderVO(), settingMap.get("bbname"));
        this.setFooterVO(request, settingMap, searchResultVO.getFooterVO(), currentMember, "search", formhash, sid);
        List<Map<String, String>> threadMapList = dataBaseDao.executeQuery("SELECT * FROM jrun_threads WHERE tid IN (" + index.get("tids") + ") AND displayorder>='0' ORDER BY dateline DESC LIMIT " + start_limit + ", " + waptpp, new String[0]);
        List<ThreadInfo> threadInfoList = searchResultVO.getThreadInfoList();
        int number = start_limit;
        if (threadMapList != null && threadMapList.size() > 0) {
            for (Map<String, String> thread : threadMapList) {
                ThreadInfo threadInfo = searchResultVO.geThreadInfo();
                threadInfo.setTid(thread.get("tid"));
                threadInfo.setSubject(Common.cutstr(thread.get("subject"), 24, null));
                threadInfo.setNumber(String.valueOf(++number));
                threadInfo.setViews(thread.get("views"));
                threadInfo.setReplies(thread.get("replies"));
                threadInfoList.add(threadInfo);
            }
        }
        searchResultVO.setMultipage(this.wapmulti(searchnum, waptpp, page, response.encodeURL("index.jsp?action=search&amp;searchid=" + searchid + "&amp;do=submit&amp;sid=" + sid), mr, locale));
        return searchResultVO;
    }

    public StatsVO getStatsVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid) {
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        StatsVO statsVO = new StatsVO();
        this.setFooterVO(request, settingMap, statsVO.getFooterVO(), currentMember, "stats", formhash, sid);
        this.setHeaderVO(statsVO.getHeaderVO(), settingMap.get("bbname"));
        String totalmembers = settingMap.get("totalmembers");
        statsVO.setMembers(totalmembers);
        List<Map<String, String>> tempMapList = dataBaseDao.executeQuery("SELECT SUM(threads) AS threads, SUM(posts) AS posts FROM jrun_forums WHERE status=1", new String[0]);
        if (tempMapList != null && tempMapList.size() > 0) {
            Map<String, String> tempMap = tempMapList.get(0);
            statsVO.setPosts(tempMap.get("posts"));
            statsVO.setThreads(tempMap.get("threads"));
        } else {
            statsVO.setPosts("0");
            statsVO.setThreads("0");
        }
        return statsVO;
    }

    public PmVO getPmVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid, int jsprun_uid) {
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        PmVO pmVO = new PmVO();
        this.setFooterVO(request, settingMap, pmVO.getFooterVO(), currentMember, "pm", formhash, sid);
        this.setHeaderVO(pmVO.getHeaderVO(), settingMap.get("bbname"));
        List<Map<String, String>> tempMapList = dataBaseDao.executeQuery("SELECT COUNT(*) AS num, new FROM jrun_pms WHERE msgtoid='" + jsprun_uid + "' AND folder='inbox' GROUP BY new='0'", new String[0]);
        int num_unread = 0;
        int num_read = 0;
        if (tempMapList != null && tempMapList.size() > 0) {
            for (Map<String, String> tempMap : tempMapList) {
                if (tempMap.get("new").equals("0")) {
                    num_read = Integer.parseInt(tempMap.get("num"));
                    continue;
                }
                num_unread = Integer.parseInt(tempMap.get("num"));
            }
        }
        pmVO.setNum_all(String.valueOf(num_unread + num_read));
        pmVO.setNum_unread(String.valueOf(num_unread));
        return pmVO;
    }

    public PmListVO getPmListVO(HttpServletRequest request, HttpServletResponse response, Map<String, String> settingMap, Members currentMember, String formhash, String sid, int jsprun_uid, String unreadFR, String pageString, String dow, MessageResources mr, Locale locale, String timeoffset) {
        int start_limit;
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        PmListVO pmListVO = new PmListVO();
        this.setFooterVO(request, settingMap, pmListVO.getFooterVO(), currentMember, "pm", formhash, sid);
        this.setHeaderVO(pmListVO.getHeaderVO(), settingMap.get("bbname"));
        int waptpp = Integer.parseInt(settingMap.get("waptpp"));
        String unreadadd = unreadFR == null ? "" : "AND new>'0'";
        String pageadd = unreadFR == null ? "" : "&amp;unread=yes";
        int page = pageString == null || pageString.equals("") ? 0 : Integer.parseInt(pageString);
        page = Math.max(1, page);
        int number = start_limit = (page - 1) * waptpp;
        int totalpms = 0;
        List<Map<String, String>> pmsMapList = dataBaseDao.executeQuery("SELECT COUNT(*) AS cnt FROM jrun_pms WHERE msgtoid='" + jsprun_uid + "' AND folder='inbox' " + unreadadd, new String[0]);
        if (pmsMapList == null || pmsMapList.size() == 0) {
            return pmListVO;
        }
        totalpms = Integer.parseInt(pmsMapList.get(0).get("cnt"));
        pmsMapList = dataBaseDao.executeQuery("SELECT pmid, new, msgfrom, subject, dateline FROM jrun_pms WHERE msgtoid='" + jsprun_uid + "' AND folder='inbox' " + unreadadd + " " + "ORDER BY dateline DESC " + "LIMIT " + start_limit + ", " + waptpp, new String[0]);
        if (pmsMapList != null && pmsMapList.size() > 0) {
            List<PmListVO.PmInfo> pmInfoList = pmListVO.getPmInfoList();
            String wapdateformat = settingMap.get("wapdateformat");
            String timeformat = settingMap.get("timeformat");
            timeformat = timeformat.equals("1") ? "hh:mm a" : "HH:mm";
            SimpleDateFormat simpleDateFormat = Common.getSimpleDateFormat(String.valueOf(wapdateformat) + " " + timeformat, timeoffset);
            for (Map<String, String> tempMap : pmsMapList) {
                PmListVO.PmInfo pmInfo = pmListVO.getPmInfo();
                pmInfo.setPmid(tempMap.get("pmid"));
                pmInfo.setNumber(++number);
                pmInfo.setUnread(unreadFR == null && !tempMap.get("new").equals("0"));
                pmInfo.setSubject(Common.cutstr(tempMap.get("subject"), 30, null));
                pmInfo.setMsgfrom(tempMap.get("msgfrom"));
                pmInfo.setDateline(simpleDateFormat.format(Long.parseLong(tempMap.get("dateline")) * 1000L));
                pmInfoList.add(pmInfo);
            }
        }
        String indexEncode = response.encodeURL("index.jsp");
        String wapmulti = this.wapmulti(totalpms, waptpp, page, String.valueOf(indexEncode) + "?action=pm&amp;do=" + dow + pageadd, mr, locale);
        pmListVO.setWapmulti(wapmulti);
        return pmListVO;
    }

    public PmViewVO getPmViewVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid, String pmid, int jsprun_uid, String timeoffset) {
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        PmViewVO pmViewVO = new PmViewVO();
        this.setFooterVO(request, settingMap, pmViewVO.getFooterVO(), currentMember, "pm", formhash, sid);
        this.setHeaderVO(pmViewVO.getHeaderVO(), settingMap.get("bbname"));
        List<Map<String, String>> pmsMapList = dataBaseDao.executeQuery("SELECT * FROM jrun_pms WHERE pmid=? AND msgtoid='" + jsprun_uid + "' AND folder='inbox'", pmid);
        if (pmsMapList == null || pmsMapList.size() == 0) {
            return pmViewVO;
        }
        pmViewVO.setExistPm(true);
        String wapdateformat = settingMap.get("wapdateformat");
        String timeformat = settingMap.get("timeformat");
        timeformat = timeformat.equals("1") ? "hh:mm a" : "HH:mm";
        Map<String, String> pm = pmsMapList.get(0);
        pmViewVO.setSubject(pm.get("subject"));
        pmViewVO.setMsgfrom(pm.get("msgfrom"));
        pmViewVO.setMessage(Common.nl2br(Common.htmlspecialchars(pm.get("message"))));
        pmViewVO.setDateline(Common.gmdate(String.valueOf(wapdateformat) + " " + timeformat, Integer.parseInt(pm.get("dateline")), timeoffset));
        pmViewVO.setPmid(pmid);
        dataBaseDao.execute("UPDATE jrun_pms SET new='0' WHERE pmid=?", pmid);
        return pmViewVO;
    }

    public PmSendVO getPmSendVO(HttpServletRequest request, Map<String, String> settingMap, Members currentMember, String formhash, String sid, String pmid, int jsprun_uid) {
        List<Map<String, String>> tempMapList;
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        PmSendVO pmSendVO = new PmSendVO();
        this.setFooterVO(request, settingMap, pmSendVO.getFooterVO(), currentMember, "pm", formhash, sid);
        this.setHeaderVO(pmSendVO.getHeaderVO(), settingMap.get("bbname"));
        pmSendVO.setSid(sid);
        pmSendVO.setFormhash(formhash);
        if (pmid != null && (tempMapList = dataBaseDao.executeQuery("SELECT msgfrom, subject FROM jrun_pms WHERE pmid=? AND msgtoid='" + jsprun_uid + "' AND folder='inbox'", pmid)) != null && tempMapList.size() > 0) {
            Map<String, String> tempMap = tempMapList.get(0);
            pmSendVO.setMsgfrom(tempMap.get("msgfrom"));
            pmSendVO.setSubject(tempMap.get("subject"));
        }
        return pmSendVO;
    }

    private String wapmulti(int num, int perpage, int curpage, String mpurl, MessageResources mr, Locale locale) {
        String multipage = "";
        mpurl = String.valueOf(mpurl) + (mpurl.contains("?") ? "&amp;" : "?");
        if (num > perpage) {
            int page = 3;
            int offset = 2;
            int from = 0;
            int to = 0;
            int realpages = (int)Math.ceil((double)num * 1.0 / (double)perpage);
            int pages = realpages;
            if (page > pages) {
                from = 1;
                to = pages;
            } else {
                from = curpage - offset;
                to = from + page - 1;
                if (from < 1) {
                    to = curpage + 1 - from;
                    if (to - (from = 1) < page) {
                        to = page;
                    }
                } else if (to > pages) {
                    from = pages - page + 1;
                    to = pages;
                }
            }
            multipage = String.valueOf(curpage - offset > 1 && pages > page ? "<a href=\"" + mpurl + "page=1\">" + mr.getMessage(locale, "home") + "</a>" : "") + (curpage > 1 ? " <a href=\"" + mpurl + "page=" + (curpage - 1) + "\">" + mr.getMessage(locale, "last_page") + "</a>" : "");
            int i = from;
            while (i <= to) {
                multipage = String.valueOf(multipage) + (i == curpage ? " " + i : " <a href=\"" + mpurl + "page=" + i + "\">" + i + "</a>");
                ++i;
            }
            multipage = String.valueOf(multipage) + (curpage < pages ? " <a href=\"" + mpurl + "page=" + (curpage + 1) + "\">" + mr.getMessage(locale, "next_page") + "</a>" : "") + (to < pages ? " <a href=\"" + mpurl + "page=" + pages + "\">" + mr.getMessage(locale, "end_page") + "</a>" : "");
            multipage = String.valueOf(multipage) + (realpages > page ? "<br />" + curpage + "/" + realpages + mr.getMessage(locale, "page") + "<input type=\"text\" name=\"page\" size=\"2\" emptyok=\"true\" /> " + "<anchor title=\"submit\">" + mr.getMessage(locale, "turn_page") + "<go method=\"post\" href=\"" + mpurl + "\">" + "<postfield name=\"page\" value=\"$(page)\" />" + "</go></anchor>" : "");
        }
        return multipage;
    }

    private void setHeaderVO(HeaderVO headerVO, String title) {
        headerVO.setTitle(title);
    }

    private void setFooterVO(HttpServletRequest request, Map<String, String> settingMap, FooterVO footerVO, Members currentMember, String action, String formhash, String sid) {
        HttpSession session = request.getSession();
        int timestamp = (Integer)request.getAttribute("timestamp");
        String timeoffset = (String)session.getAttribute("timeoffset");
        boolean isLogin = currentMember != null;
        String userName = isLogin ? currentMember.getUsername() : "";
        boolean isNotHome = action != null && !action.equals("home");
        String wapdateformat = settingMap.get("wapdateformat");
        String timeformat = settingMap.get("timeformat");
        timeformat = timeformat.equals("1") ? "hh:mm a" : "HH:mm";
        String time = Common.gmdate(String.valueOf(wapdateformat) + " " + timeformat, timestamp, timeoffset);
        footerVO.setSid(sid);
        footerVO.setFormhash(formhash);
        footerVO.setIsLogin(isLogin);
        footerVO.setIsNotHome(isNotHome);
        footerVO.setTime(time);
        footerVO.setUserName(userName);
        Common.updatesession(request, settingMap);
    }

    private void setMessageVO(HttpServletRequest request, HttpServletResponse response, Map<String, String> settingMap, MessageVO messageVO, String message, Map<String, String> forwardMap, String headerVO_title, Members currentMember, String action, String footerVO_formhash, String sid) {
        HeaderVO headerVO = messageVO.getHeaderVO();
        FooterVO footerVO = messageVO.getFooterVO();
        messageVO.setMessage(message);
        if (forwardMap != null) {
            messageVO.setForward(true);
            messageVO.setForwardLink(response.encodeURL(forwardMap.get("link")));
            messageVO.setForwardTitle(forwardMap.get("title"));
        }
        this.setHeaderVO(headerVO, headerVO_title);
        this.setFooterVO(request, settingMap, footerVO, currentMember, action, footerVO_formhash, sid);
    }

    private String wapcode(String targetString, MessageResources mr, Locale locale) {
        targetString = targetString.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
        String regex = "\\[hide\\](.+?)\\[\\/hide\\]";
        targetString = targetString.replaceAll(regex, mr.getMessage(locale, "post_hide_reply_hidden_wap"));
        int i = 0;
        while (i < 5) {
            targetString = targetString.replaceAll("\\[(\\w+)[^\\]]*?\\](.*?)\\[\\/\\\\1\\]", "\\2");
            ++i;
        }
        return targetString;
    }

    private String wapcutstr(String targetString, int length) {
        int tarLen = 0;
        try {
            tarLen = targetString.getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (tarLen > length) {
            int targetLen = targetString.length();
            int temp = 0;
            StringBuffer strcut = new StringBuffer();
            int i = 0;
            while (i < targetLen) {
                if (temp >= length) break;
                ++temp;
                char tempC = targetString.charAt(i);
                strcut.append(tempC);
                if (tempC < '\u0000' || tempC > '\u007f') {
                    ++temp;
                }
                ++i;
            }
            return String.valueOf(strcut.toString()) + " ..";
        }
        return targetString;
    }

    /*
     * Unable to fully structure code
     */
    private String substr(String targetString, int offset) {
        block5: {
            countDown = offset < 0;
            stringLen = targetString.length();
            sign = 0;
            i = 0;
            if (!countDown) ** GOTO lbl23
            i = stringLen - 1;
            while (i >= 0) {
                if (sign > offset) {
                    --sign;
                    temp = targetString.charAt(i);
                    if (temp < '\u0000' || temp > '\u007f') {
                        --sign;
                    }
                    --i;
                    continue;
                }
                break block5;
            }
            break block5;
            while (sign < offset) {
                ++sign;
                temp = targetString.charAt(i);
                if (temp < '\u0000' || temp > '\u007f') {
                    ++sign;
                }
                ++i;
lbl23:
                // 2 sources

                if (i < stringLen) continue;
            }
        }
        return targetString.substring(i);
    }
}

