/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.foreg.service;

import cn.jsprun.dao.DataBaseDao;
import cn.jsprun.dao.StatsDao;
import cn.jsprun.dao.StatvarsDao;
import cn.jsprun.domain.Stats;
import cn.jsprun.domain.StatsId;
import cn.jsprun.domain.Statvars;
import cn.jsprun.domain.StatvarsId;
import cn.jsprun.foreg.vo.statistic.CompositorInfo;
import cn.jsprun.foreg.vo.statistic.PageInfo;
import cn.jsprun.foreg.vo.statistic.PageInfoWithImage;
import cn.jsprun.foreg.vo.statistic.Stats_CompositorVO;
import cn.jsprun.foreg.vo.statistic.Stats_agentVO;
import cn.jsprun.foreg.vo.statistic.Stats_creditComposidorVO;
import cn.jsprun.foreg.vo.statistic.Stats_forumsrankVO;
import cn.jsprun.foreg.vo.statistic.Stats_mainVO;
import cn.jsprun.foreg.vo.statistic.Stats_manageStatisticVO;
import cn.jsprun.foreg.vo.statistic.Stats_manageTeamVO;
import cn.jsprun.foreg.vo.statistic.Stats_navbarVO;
import cn.jsprun.foreg.vo.statistic.Stats_onlineCompositorVO;
import cn.jsprun.foreg.vo.statistic.Stats_postsLogVO;
import cn.jsprun.foreg.vo.statistic.Stats_tradeCompositorVO;
import cn.jsprun.foreg.vo.statistic.Stats_viewsVO;
import cn.jsprun.foreg.vo.statistic.SubPostlog;
import cn.jsprun.utils.BeanFactory;
import cn.jsprun.utils.Common;
import cn.jsprun.utils.DataParse;
import cn.jsprun.utils.ForumInit;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatvarsService {
    private static final String tableprefix = "jrun_";
    private static DecimalFormat df = new DecimalFormat("0.00");

    public boolean allowAccess(Map<String, String> groupMap) {
        String allowviewstatString = groupMap.get("allowviewstats");
        if (allowviewstatString != null) {
            Byte allowviewstats = Byte.valueOf(allowviewstatString);
            return allowviewstats == 1;
        }
        return true;
    }

    public boolean checkUserid(String uid) {
        List<Map<String, String>> tempML = ((DataBaseDao)BeanFactory.getBean("dataBaseDao")).executeQuery("SELECT username FROM jrun_members WHERE uid=? AND adminid>'0'", uid);
        return tempML != null && tempML.size() > 0;
    }

    public Stats_mainVO getFinalStats_mainVO(int timestamp, String timeoffsetSession, MessageResources mr, Locale locale) {
        Map<String, String> tm;
        Map<String, String> settingsMap = ForumInit.settings;
        String tempS = settingsMap.get("statstatus");
        boolean statstatus = tempS != null && !"".equals(tempS) && !"0".equals(tempS);
        tempS = settingsMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !"".equals(tempS) && !"0".equals(tempS);
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        Map<String, String> statvars = this.getFinalMap("main", dataBaseDao);
        tempS = statvars.get("lastupdate");
        int lastupdate = tempS == null ? 0 : Integer.parseInt(tempS);
        Double statscachelife = Double.valueOf(settingsMap.get("statscachelife"));
        statscachelife = statscachelife * 60.0;
        ArrayList<String> newstatvars = new ArrayList<String>();
        if ((double)(timestamp - lastupdate) > statscachelife) {
            statvars.clear();
            statvars.put("lastupdate", String.valueOf(timestamp));
            newstatvars.add("'main', 'lastupdate', '" + timestamp + "'");
        }
        Stats_mainVO stats_mainVO = new Stats_mainVO();
        tempS = statvars.get("forums");
        if (tempS != null) {
            stats_mainVO.setFormsCount(tempS);
        } else {
            tempS = this.getForumCount(dataBaseDao);
            stats_mainVO.setFormsCount(tempS);
            newstatvars.add("'main', 'forums', '" + tempS + "'");
        }
        tempS = statvars.get("threads");
        if (tempS != null) {
            stats_mainVO.setThreadNum(tempS);
        } else {
            tempS = this.getThreadCount(dataBaseDao);
            stats_mainVO.setThreadNum(tempS);
            newstatvars.add("'main', 'threads', '" + tempS + "'");
        }
        tempS = statvars.get("runtime");
        String tempS2 = statvars.get("posts");
        if (tempS != null && tempS2 != null) {
            stats_mainVO.setRuntime(tempS);
            stats_mainVO.setPostsNum(tempS2);
        } else {
            tm = this.getRunTimeAdPost(dataBaseDao);
            tempS = tm.get("rt");
            tempS2 = tm.get("ct");
            stats_mainVO.setRuntime(tempS);
            stats_mainVO.setPostsNum(tempS2);
            newstatvars.add("'main', 'runtime', '" + tempS + "'");
            newstatvars.add("'main', 'posts', '" + tempS2 + "'");
        }
        tempS = statvars.get("members");
        if (tempS != null) {
            stats_mainVO.setMembersNum(tempS);
        } else {
            tempS = this.getMemberCount(dataBaseDao);
            stats_mainVO.setMembersNum(tempS);
            newstatvars.add("'main', 'members', '" + tempS + "'");
        }
        tempS = statvars.get("postsaddtoday");
        if (tempS != null) {
            stats_mainVO.setAddPostsInLast24(tempS);
        } else {
            tempS = this.getAddPostsInLast24(dataBaseDao, timestamp);
            stats_mainVO.setAddPostsInLast24(tempS);
            newstatvars.add("'main', 'postsaddtoday', '" + tempS + "'");
        }
        tempS = statvars.get("membersaddtoday");
        if (tempS != null) {
            stats_mainVO.setAddMemberInLast24(tempS);
        } else {
            tempS = this.getAddMemberInLast24(dataBaseDao, timestamp);
            stats_mainVO.setAddMemberInLast24(tempS);
            newstatvars.add("'main', 'membersaddtoday', '" + tempS + "'");
        }
        tempS = statvars.get("admins");
        if (tempS != null) {
            stats_mainVO.setMemberOfManageNum(tempS);
        } else {
            tempS = this.getAdminNum(dataBaseDao);
            stats_mainVO.setMemberOfManageNum(tempS);
            newstatvars.add("'main', 'admins', '" + tempS + "'");
        }
        tempS = statvars.get("memnonpost");
        if (tempS != null) {
            stats_mainVO.setMembersOfNoPostsNum(tempS);
        } else {
            tempS = this.getNonPost(dataBaseDao);
            stats_mainVO.setMembersOfNoPostsNum(tempS);
            newstatvars.add("'main', 'memnonpost', '" + tempS + "'");
        }
        tempS = statvars.get("hotforum");
        if (tempS != null) {
            Map beanModuleInfo = ((DataParse)BeanFactory.getBean("dataParse")).characterParse(tempS, false);
            stats_mainVO.setBestModule((String)beanModuleInfo.get("name"));
            stats_mainVO.setBestModuleID((String)beanModuleInfo.get("fid"));
            stats_mainVO.setBestModuleThreadNum((String)beanModuleInfo.get("threads"));
            stats_mainVO.setBestModulePostsNum((String)beanModuleInfo.get("posts"));
        } else {
            tm = this.getHotforumInfo(dataBaseDao);
            stats_mainVO.setBestModule(tm.get("name"));
            stats_mainVO.setBestModuleID(tm.get("fid"));
            stats_mainVO.setBestModuleThreadNum(tm.get("threads"));
            stats_mainVO.setBestModulePostsNum(tm.get("posts"));
            newstatvars.add("'main', 'hotforum', '" + ((DataParse)BeanFactory.getBean("dataParse")).combinationChar(tm) + "'");
        }
        tempS = statvars.get("bestmem");
        tempS2 = statvars.get("bestmemposts");
        if (tempS != null && tempS2 != null) {
            stats_mainVO.setBestMem(tempS);
            stats_mainVO.setBestMemPosts(tempS2);
        } else {
            tm = this.getBestMenInfo(dataBaseDao, timestamp);
            tempS = tm.get("author");
            tempS2 = tm.get("posts");
            stats_mainVO.setBestMem(tempS);
            stats_mainVO.setBestMemPosts(tempS2);
            newstatvars.add("'main', 'bestmem', '" + tempS + "'");
            newstatvars.add("'main', 'bestmemposts', '" + tempS2 + "'");
        }
        stats_mainVO.setNewMemberName(settingsMap.get("lastmember"));
        stats_mainVO.setShowFluxSurvey(statstatus);
        String timeoffsetSetting = settingsMap.get("timeoffset");
        SimpleDateFormat formatToDate = Common.getSimpleDateFormat("yyyyMM", timeoffsetSetting);
        SimpleDateFormat formatToString = Common.getSimpleDateFormat("yyyy " + mr.getMessage(locale, "year_stats") + " MM " + mr.getMessage(locale, "month_stats"), timeoffsetSetting);
        StatsDao statsDao = (StatsDao)BeanFactory.getBean("statsDao");
        if (statstatus) {
            Map<String, Stats> mapTemp = statsDao.workForFluxStatistic();
            Stats statsMonth = mapTemp.get("month");
            String accessMaxMonth = null;
            String accessMaxMonthNum = null;
            if (statsMonth != null) {
                accessMaxMonth = statsMonth.getId().getVariable();
                Date date = null;
                try {
                    date = formatToDate.parse(accessMaxMonth);
                    accessMaxMonth = formatToString.format(date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                date = null;
                accessMaxMonthNum = statsMonth.getCount().toString();
            }
            stats_mainVO.setAllPageFlux(mapTemp.get("hits").getCount().toString());
            stats_mainVO.setMemberOfAccess(mapTemp.get("members").getCount().toString());
            stats_mainVO.setVisitorOfAccess(mapTemp.get("guests").getCount().toString());
            stats_mainVO.setAccessMaxNum(accessMaxMonth);
            stats_mainVO.setAllPageFluxOfMonth(accessMaxMonthNum);
            String maxHour = mapTemp.get("hour").getId().getVariable();
            stats_mainVO.setAccessTime(String.valueOf(maxHour) + " - " + (Integer.parseInt(maxHour) + 1));
            stats_mainVO.setAccessTimeAllFlux(mapTemp.get("hour").getCount().toString());
            List<Stats> statsList = statsDao.getStatsByType("month");
            statsDao = null;
            formatToString.applyPattern("yyyy - MM ");
            String monthTemp = null;
            PageInfo pageInfo = null;
            float tempf = 0.0f;
            float hits = mapTemp.get("hits").getCount().intValue();
            List<PageInfo> pageInfoList = stats_mainVO.getMonthFlux();
            if (statsList != null) {
                float maxPercent = 0.0f;
                try {
                    for (Stats tempStats : statsList) {
                        pageInfo = new PageInfo();
                        tempf = (float)tempStats.getCount().intValue() / hits * 100.0f;
                        maxPercent = tempf > maxPercent ? tempf : maxPercent;
                        monthTemp = formatToString.format(formatToDate.parse(tempStats.getId().getVariable()));
                        pageInfo.setNum(tempStats.getCount().toString());
                        pageInfo.setNumPercent(this.number_format(mapTemp.get("hits").getCount().intValue(), tempStats.getCount().intValue()));
                        pageInfo.setInformation(monthTemp);
                        pageInfoList.add(pageInfo);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                for (PageInfo pageInfo2 : pageInfoList) {
                    this.setPageInfoMaxLengh(maxPercent, pageInfo2);
                }
            }
        } else {
            StatsId statsId = new StatsId();
            statsId.setType("total");
            statsId.setVariable("hits");
            Stats stats = statsDao.getStatsById(statsId);
            statsDao = null;
            statsId = null;
            stats_mainVO.setAllPageFlux(stats.getCount().toString());
            this.setSubPostlog(stats_mainVO.getSubPostLog(), newstatvars, dataBaseDao, timestamp);
        }
        this.updateNewStatvars(newstatvars, dataBaseDao);
        String lastupdateString = statvars.get("lastupdate");
        statvars = null;
        int lastUpdate = lastupdateString != null ? Integer.parseInt(lastupdateString) : 0;
        int nextUpdate = lastUpdate + statscachelife.intValue();
        SimpleDateFormat dateFormat = Common.getSimpleDateFormat("yyyy-MM-dd HH:mm", timeoffsetSession);
        stats_mainVO.setLastTime(Common.gmdate(dateFormat, lastUpdate));
        stats_mainVO.setNextTime(Common.gmdate(dateFormat, nextUpdate));
        this.setNavbarVO(stats_mainVO.getNavbar(), statstatus, modworkstatus, "stats");
        return stats_mainVO;
    }

    public Stats_forumsrankVO getForumCompositor(int timestamp, String timeoffsetSession) {
        int lastupdate;
        Map<String, String> settingMap = ForumInit.settings;
        Double statscachelife = Double.valueOf(settingMap.get("statscachelife"));
        statscachelife = statscachelife * 60.0;
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("0") && !tempS.equals("");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        ArrayList<String> newstatvars = new ArrayList<String>();
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        Map<String, String> statvars = this.getFinalMap("forumsrank", dataBaseDao);
        tempS = statvars.get("lastupdate");
        int n = lastupdate = tempS == null ? 0 : Integer.parseInt(tempS);
        if ((double)(timestamp - lastupdate) > statscachelife) {
            statvars.clear();
            statvars.put("lastupdate", String.valueOf(timestamp));
            newstatvars.add("'forumsrank', 'lastupdate', '" + timestamp + "'");
        }
        DataParse dataParse = (DataParse)BeanFactory.getBean("dataParse");
        HashMap<Integer, Map<String, String>> threads = null;
        HashMap<Integer, Map<String, String>> posts = null;
        HashMap<Integer, Map<String, String>> thismonth = null;
        HashMap<Integer, Map<String, String>> today = null;
        List<Map<String, String>> tempML = null;
        int tempI = 0;
        tempS = statvars.get("threads");
        if (tempS != null) {
            threads = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT fid, name, threads FROM jrun_forums WHERE status=1 AND type<>'group' ORDER BY threads DESC LIMIT 0, 20", new String[0]);
            if (tempML != null) {
                threads = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    threads.put(tempI, tempM);
                    ++tempI;
                }
            }
            statvars.put("forums", String.valueOf(tempI));
            newstatvars.add("'forumsrank', 'threads', '" + dataParse.combinationChar(threads) + "'");
            newstatvars.add("'forumsrank', 'forums', '" + tempI + "'");
        }
        tempS = statvars.get("forums");
        if (tempS == null || tempS.equals("") || tempS.equals("0")) {
            statvars.put("forums", "20");
        }
        if ((tempS = statvars.get("posts")) != null) {
            posts = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT fid, name, posts FROM jrun_forums WHERE status=1 AND type<>'group' ORDER BY posts DESC LIMIT 0, " + statvars.get("forums"), new String[0]);
            if (tempML != null) {
                tempI = 0;
                posts = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    posts.put(tempI, tempM);
                    ++tempI;
                }
            }
            newstatvars.add("'forumsrank', 'posts', '" + dataParse.combinationChar(posts) + "'");
        }
        tempS = statvars.get("thismonth");
        if (tempS != null) {
            thismonth = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT DISTINCT(p.fid) AS fid, f.name, COUNT(pid) AS posts FROM jrun_posts p LEFT JOIN jrun_forums f USING (fid) WHERE dateline>='" + (timestamp - 2592000) + "' AND invisible='0' AND f.status='1' AND authorid>'0' " + "GROUP BY p.fid ORDER BY posts DESC LIMIT 0, " + statvars.get("forums"), new String[0]);
            if (tempML != null) {
                tempI = 0;
                thismonth = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    thismonth.put(tempI, tempM);
                    ++tempI;
                }
            }
            newstatvars.add("'forumsrank', 'thismonth', '" + dataParse.combinationChar(thismonth) + "'");
        }
        tempS = statvars.get("today");
        if (tempS != null) {
            today = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT DISTINCT(p.fid) AS fid, f.name, COUNT(pid) AS posts FROM jrun_posts p LEFT JOIN jrun_forums f USING (fid) WHERE dateline>='" + (timestamp - 86400) + "' AND invisible='0' AND f.status='1' AND authorid>'0' " + "GROUP BY p.fid ORDER BY posts DESC LIMIT 0, " + statvars.get("forums"), new String[0]);
            if (tempML != null) {
                tempI = 0;
                today = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    today.put(tempI, tempM);
                    ++tempI;
                }
            }
            newstatvars.add("'forumsrank', 'today', '" + dataParse.combinationChar(today) + "'");
        }
        Stats_forumsrankVO stats_forumsrankVO = new Stats_forumsrankVO();
        stats_forumsrankVO.setForumCompositorMapList(threads, posts, (Map<Integer, Map<String, String>>)thismonth, (Map<Integer, Map<String, String>>)today);
        tempI = Integer.parseInt(statvars.get("lastupdate"));
        SimpleDateFormat dateFormat = Common.getSimpleDateFormat("yyyy-MM-dd HH:mm", timeoffsetSession);
        stats_forumsrankVO.setLastTime(Common.gmdate(dateFormat, tempI));
        stats_forumsrankVO.setNextTime(Common.gmdate(dateFormat, tempI + statscachelife.intValue()));
        this.setNavbarVO(stats_forumsrankVO.getNavbar(), statstatus, modworkstatus, "forumsrank");
        this.updateNewStatvars(newstatvars, dataBaseDao);
        return stats_forumsrankVO;
    }

    /*
     * WARNING - void declaration
     */
    public Stats_viewsVO getFinalStats_viewsVO() {
        void var21_24;
        Map<String, String> settingMap = ForumInit.settings;
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        List<Map<String, String>> totalResultML = dataBaseDao.executeQuery("SELECT st.count FROM jrun_stats AS st WHERE st.type='total' AND st.variable='hits'", new String[0]);
        float total_count = 0.0f;
        if (totalResultML.size() > 0) {
            total_count = Float.parseFloat(totalResultML.get(0).get("count"));
        }
        List<Map<String, String>> tempML = dataBaseDao.executeQuery("SELECT * FROM jrun_stats AS st WHERE st.type='week' OR st.type='hour'", new String[0]);
        dataBaseDao = null;
        ArrayList<Map<String, String>> weekResultML = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> hourResultML = new ArrayList<Map<String, String>>();
        if (tempML != null) {
            for (Map<String, String> tempM : tempML) {
                if (tempM == null) continue;
                if ("hour".equals(tempM.get("type"))) {
                    hourResultML.add(tempM);
                    continue;
                }
                weekResultML.add(tempM);
            }
        }
        tempML = null;
        Stats_viewsVO stats_viewsVO = new Stats_viewsVO();
        List<PageInfo> pageInfo_week = stats_viewsVO.getPageInfoWeekList();
        String[] weekTime = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        String[] hourTime = new String[]{"0 AM", "1 AM", "2 AM", "3 AM", "4 AM", "5 AM", "6 AM", "7 AM", "8 AM", "9 AM", "10 AM", "11 AM", "12 AM", "1 PM", "2 PM", "3 PM", "4 PM", "5 PM", "6 PM", "7 PM", "8 PM", "9 PM", "10 PM", "11 PM"};
        Map mapTemp2 = null;
        float maxPercent_week = 0.0f;
        int foreachSize = weekResultML.size();
        PageInfo pageInfo = null;
        int i = 0;
        while (i < foreachSize) {
            if (i == 0) {
                float tempD = 0.0f;
                for (Map map : weekResultML) {
                    tempD = Float.parseFloat((String)map.get("count"));
                    float f = maxPercent_week = tempD > maxPercent_week ? tempD : maxPercent_week;
                }
                maxPercent_week = Float.valueOf(this.number_format(total_count, maxPercent_week)).floatValue();
            }
            mapTemp2 = (Map)weekResultML.get(i);
            pageInfo = new PageInfo();
            pageInfo.setNum((String)mapTemp2.get("count"));
            pageInfo.setNumPercent(this.number_format(total_count, Float.parseFloat((String)mapTemp2.get("count"))));
            pageInfo.setInformation(weekTime[Integer.parseInt((String)mapTemp2.get("variable"))]);
            this.setPageInfoMaxLengh(maxPercent_week, pageInfo);
            pageInfo_week.add(pageInfo);
            ++i;
        }
        pageInfo_week = null;
        weekResultML = null;
        List<PageInfo> pageInfo_hour = stats_viewsVO.getPageInfoHourList();
        float maxPercent_hour = 0.0f;
        foreachSize = hourResultML.size();
        boolean bl = false;
        while (var21_24 < foreachSize) {
            if (var21_24 == false) {
                float tempD = 0.0f;
                for (Map map : hourResultML) {
                    tempD = Float.parseFloat((String)map.get("count"));
                    float f = maxPercent_hour = tempD > maxPercent_hour ? tempD : maxPercent_hour;
                }
                maxPercent_hour = Float.valueOf(this.number_format(total_count, maxPercent_hour)).floatValue();
            }
            mapTemp2 = (Map)hourResultML.get((int)var21_24);
            pageInfo = new PageInfo();
            pageInfo.setNum((String)mapTemp2.get("count"));
            pageInfo.setNumPercent(this.number_format(total_count, Float.parseFloat((String)mapTemp2.get("count"))));
            pageInfo.setInformation(hourTime[Integer.parseInt((String)mapTemp2.get("variable"))]);
            this.setPageInfoMaxLengh(maxPercent_hour, pageInfo);
            pageInfo_hour.add(pageInfo);
            ++var21_24;
        }
        mapTemp2 = null;
        pageInfo_hour = null;
        hourResultML = null;
        pageInfo = null;
        this.setNavbarVO(stats_viewsVO.getNavbar(), statstatus, modworkstatus, "views");
        return stats_viewsVO;
    }

    public Stats_agentVO getFinalStats_agentVO() {
        Map<String, String> settingMap = ForumInit.settings;
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        List<Map<String, String>> tempML = dataBaseDao.executeQuery("SELECT * FROM jrun_stats AS st WHERE st.type='os' OR st.type='browser'", new String[0]);
        dataBaseDao = null;
        ArrayList<Map<String, String>> osResultML = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> browserResultML = new ArrayList<Map<String, String>>();
        if (tempML != null) {
            for (Map<String, String> tempM : tempML) {
                if (tempM == null) continue;
                if ("os".equals(tempM.get("type"))) {
                    osResultML.add(tempM);
                    continue;
                }
                browserResultML.add(tempM);
            }
        }
        tempML = null;
        Stats_agentVO stats_agentVO = new Stats_agentVO();
        List<PageInfoWithImage> operatingSystemList = stats_agentVO.getOperatingSystemList();
        PageInfoWithImage pageInfoWithImage = null;
        Map tempMap = null;
        float numPercent_system = 0.0f;
        float maxPercent = 0.0f;
        float tempD = 0.0f;
        int i = 0;
        while (i < osResultML.size()) {
            if (i == 0) {
                for (Map map : osResultML) {
                    tempD = Float.parseFloat((String)map.get("count"));
                    numPercent_system += tempD;
                    float f = maxPercent = tempD > maxPercent ? tempD : maxPercent;
                }
                maxPercent = Float.parseFloat(this.number_format(numPercent_system, maxPercent));
            }
            pageInfoWithImage = new PageInfoWithImage();
            tempMap = (Map)osResultML.get(i);
            pageInfoWithImage.setInformation((String)tempMap.get("variable"));
            pageInfoWithImage.setNum((String)tempMap.get("count"));
            pageInfoWithImage.setNumPercent(this.number_format(numPercent_system, Float.parseFloat((String)tempMap.get("count"))));
            this.setPageInfoMaxLengh(maxPercent, pageInfoWithImage);
            operatingSystemList.add(pageInfoWithImage);
            ++i;
        }
        operatingSystemList = null;
        List<PageInfoWithImage> browserList = stats_agentVO.getBrowserList();
        float f = 0.0f;
        float maxPercent_browser = 0.0f;
        int i2 = 0;
        while (i2 < browserResultML.size()) {
            if (i2 == 0) {
                for (Map map : browserResultML) {
                    tempD = Float.parseFloat((String)map.get("count"));
                    f += tempD;
                    float f2 = maxPercent_browser = tempD > maxPercent_browser ? tempD : maxPercent_browser;
                }
                maxPercent_browser = Float.parseFloat(this.number_format(f, maxPercent_browser));
            }
            pageInfoWithImage = new PageInfoWithImage();
            tempMap = (Map)browserResultML.get(i2);
            pageInfoWithImage.setInformation((String)tempMap.get("variable"));
            pageInfoWithImage.setNum((String)tempMap.get("count"));
            pageInfoWithImage.setNumPercent(this.number_format(f, Float.parseFloat((String)tempMap.get("count"))));
            this.setPageInfoMaxLengh(maxPercent_browser, pageInfoWithImage);
            browserList.add(pageInfoWithImage);
            ++i2;
        }
        pageInfoWithImage = null;
        tempMap = null;
        browserList = null;
        this.setNavbarVO(stats_agentVO.getNavbar(), statstatus, modworkstatus, "agent");
        return stats_agentVO;
    }

    public Stats_postsLogVO getFinalStats_postsLogVO(int timestamp) {
        Map<String, String> settingMap = ForumInit.settings;
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        Stats_postsLogVO stats_postsLogVO = new Stats_postsLogVO();
        this.setNavbarVO(stats_postsLogVO.getNavbar(), statstatus, modworkstatus, "posts");
        ArrayList<String> newstatvars = new ArrayList<String>();
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        this.setSubPostlog(stats_postsLogVO.getSubPostLog(), newstatvars, dataBaseDao, timestamp);
        this.updateNewStatvars(newstatvars, dataBaseDao);
        return stats_postsLogVO;
    }

    public Stats_CompositorVO getFinalStats_threadCompositorVO() {
        Map<String, String> settingMap = ForumInit.settings;
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        List<Map<String, String>> list_views = dataBaseDao.executeQuery("SELECT views, tid, subject FROM jrun_threads WHERE displayorder>='0' ORDER BY views DESC LIMIT 0, 20", new String[0]);
        List<Map<String, String>> list_replies = dataBaseDao.executeQuery("SELECT replies, tid, subject FROM jrun_threads WHERE displayorder>='0' ORDER BY replies DESC LIMIT 0, 20", new String[0]);
        dataBaseDao = null;
        Stats_CompositorVO stats_threadCompositorVO = new Stats_CompositorVO();
        List<Map<String, CompositorInfo>> threadCompositorMapList = stats_threadCompositorVO.getCompositorMapList();
        CompositorInfo threadInfo_views = null;
        HashMap<String, CompositorInfo> mapTemp_result = null;
        Map<String, String> tempMap_views = null;
        Map<String, String> tempMap_replies = null;
        CompositorInfo threadInfo_replies = null;
        int i = 0;
        while (i < list_views.size()) {
            mapTemp_result = new HashMap<String, CompositorInfo>();
            tempMap_views = list_views.get(i);
            threadInfo_views = new CompositorInfo();
            threadInfo_views.setCompositorSign(tempMap_views.get("tid"));
            threadInfo_views.setCompositorName(Common.cutstr(tempMap_views.get("subject"), 45));
            threadInfo_views.setCompositorNum(tempMap_views.get("views"));
            mapTemp_result.put("views", threadInfo_views);
            tempMap_replies = list_replies.get(i);
            threadInfo_replies = new CompositorInfo();
            threadInfo_replies.setCompositorSign(tempMap_replies.get("tid"));
            threadInfo_replies.setCompositorName(Common.cutstr(tempMap_replies.get("subject"), 50));
            threadInfo_replies.setCompositorNum(tempMap_replies.get("replies"));
            mapTemp_result.put("replies", threadInfo_replies);
            threadCompositorMapList.add(mapTemp_result);
            ++i;
        }
        threadInfo_views = null;
        mapTemp_result = null;
        tempMap_views = null;
        tempMap_replies = null;
        threadInfo_replies = null;
        threadCompositorMapList = null;
        this.setNavbarVO(stats_threadCompositorVO.getNavbar(), statstatus, modworkstatus, "threadsrank");
        return stats_threadCompositorVO;
    }

    public Stats_CompositorVO getFinalStats_postsCompositorVO(int timestamp) {
        Map<String, String> settingMap = ForumInit.settings;
        Double statscachelife = Double.valueOf(settingMap.get("statscachelife"));
        statscachelife = statscachelife * 60.0;
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("0") && !tempS.equals("");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        Map<String, String> statvars = this.getFinalMap("postsrank", dataBaseDao);
        tempS = statvars.get("lastupdate");
        int lastupdate = tempS == null ? 0 : Integer.parseInt(tempS);
        ArrayList<String> newstatvars = new ArrayList<String>();
        if ((double)(timestamp - lastupdate) > statscachelife) {
            statvars.clear();
            statvars.put("lastupdate", String.valueOf(timestamp));
            newstatvars.add("'postsrank', 'lastupdate', '" + timestamp + "'");
        }
        HashMap<Integer, Map<String, String>> posts = null;
        HashMap<Integer, Map<String, String>> digestposts = null;
        HashMap<Integer, Map<String, String>> thismonth = null;
        HashMap<Integer, Map<String, String>> today = null;
        DataParse dataParse = (DataParse)BeanFactory.getBean("dataParse");
        List<Map<String, String>> tempML = null;
        int tempI = 0;
        tempS = statvars.get("posts");
        if (tempS != null) {
            posts = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT username, uid, posts FROM jrun_members ORDER BY posts DESC LIMIT 0, 20", new String[0]);
            if (tempML != null) {
                posts = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    posts.put(tempI++, tempM);
                }
            }
            newstatvars.add("'postsrank', 'posts', '" + dataParse.combinationChar(posts) + "'");
        }
        tempI = 0;
        tempS = statvars.get("digestposts");
        if (tempS != null) {
            digestposts = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT username, uid, digestposts FROM jrun_members ORDER BY digestposts DESC LIMIT 0, 20", new String[0]);
            if (tempML != null) {
                digestposts = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    digestposts.put(tempI++, tempM);
                }
            }
            newstatvars.add("'postsrank', 'digestposts', '" + dataParse.combinationChar(digestposts) + "'");
        }
        tempI = 0;
        tempS = statvars.get("thismonth");
        if (tempS != null) {
            thismonth = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT DISTINCT(author) AS username, COUNT(pid) AS posts FROM jrun_posts WHERE dateline>='" + (timestamp - 2592000) + "' AND invisible='0' AND authorid>'0' " + "GROUP BY author ORDER BY posts DESC LIMIT 0, 20", new String[0]);
            if (tempML != null) {
                thismonth = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    thismonth.put(tempI++, tempM);
                }
            }
            newstatvars.add("'postsrank', 'thismonth', '" + dataParse.combinationChar(thismonth) + "'");
        }
        tempI = 0;
        tempS = statvars.get("today");
        if (tempS != null) {
            today = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT DISTINCT(author) AS username, COUNT(pid) AS posts FROM jrun_posts WHERE dateline >='" + (timestamp - 86400) + "' AND invisible='0' AND authorid>'0' " + "GROUP BY author ORDER BY posts DESC LIMIT 0, 20", new String[0]);
            if (tempML != null) {
                today = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    today.put(tempI++, tempM);
                }
            }
            newstatvars.add("'postsrank', 'today', '" + dataParse.combinationChar(today) + "'");
        }
        Stats_CompositorVO stats_CompositorVO = new Stats_CompositorVO();
        List<Map<String, CompositorInfo>> compositorMapList = stats_CompositorVO.getCompositorMapList();
        HashMap<String, CompositorInfo> mapResult = null;
        Map stringMapTemp_posts = null;
        Map stringMapTemp_digestposts = null;
        Map stringMapTemp_thismonth = null;
        Map stringMapTemp_today = null;
        CompositorInfo compositorInfo = null;
        int i = 0;
        while (i < posts.size()) {
            mapResult = new HashMap<String, CompositorInfo>();
            stringMapTemp_posts = (Map)posts.get(i);
            compositorInfo = new CompositorInfo();
            compositorInfo.setCompositorName((String)stringMapTemp_posts.get("username"));
            compositorInfo.setCompositorNum((String)stringMapTemp_posts.get("posts"));
            compositorInfo.setCompositorSign((String)stringMapTemp_posts.get("uid"));
            mapResult.put("allPosts", compositorInfo);
            stringMapTemp_digestposts = (Map)digestposts.get(i);
            if (stringMapTemp_digestposts != null) {
                compositorInfo = new CompositorInfo();
                compositorInfo.setCompositorName((String)stringMapTemp_digestposts.get("username"));
                compositorInfo.setCompositorNum((String)stringMapTemp_digestposts.get("digestposts"));
                compositorInfo.setCompositorSign((String)stringMapTemp_digestposts.get("uid"));
                mapResult.put("prime", compositorInfo);
            }
            if ((stringMapTemp_thismonth = (Map)thismonth.get(i)) != null) {
                compositorInfo = new CompositorInfo();
                compositorInfo.setCompositorName((String)stringMapTemp_thismonth.get("username"));
                compositorInfo.setCompositorNum((String)stringMapTemp_thismonth.get("posts"));
                mapResult.put("dayOf30", compositorInfo);
            }
            if ((stringMapTemp_today = (Map)today.get(i)) != null) {
                compositorInfo = new CompositorInfo();
                compositorInfo.setCompositorName((String)stringMapTemp_today.get("username"));
                compositorInfo.setCompositorNum((String)stringMapTemp_today.get("posts"));
                mapResult.put("hourOf24", compositorInfo);
            }
            compositorMapList.add(mapResult);
            ++i;
        }
        mapResult = null;
        stringMapTemp_posts = null;
        stringMapTemp_digestposts = null;
        stringMapTemp_thismonth = null;
        stringMapTemp_today = null;
        compositorInfo = null;
        compositorMapList = null;
        this.setNavbarVO(stats_CompositorVO.getNavbar(), statstatus, modworkstatus, "postsrank");
        this.updateNewStatvars(newstatvars, dataBaseDao);
        return stats_CompositorVO;
    }

    public Stats_creditComposidorVO getFinalStats_creditCompositorVO(int timestamp, MessageResources mr, Locale locale) {
        Map<String, String> settingMap = ForumInit.settings;
        Double statscachelife = Double.valueOf(settingMap.get("statscachelife"));
        statscachelife = statscachelife * 60.0;
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("0") && !tempS.equals("");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        Map<String, String> statvars = this.getFinalMap("creditsrank", dataBaseDao);
        tempS = statvars.get("lastupdate");
        int lastupdate = tempS == null ? 0 : Integer.parseInt(tempS);
        ArrayList<String> newstatvars = new ArrayList<String>();
        if ((double)(timestamp - lastupdate) > statscachelife) {
            statvars.clear();
            statvars.put("lastupdate", String.valueOf(timestamp));
            newstatvars.add("'creditsrank', 'lastupdate', '" + timestamp + "'");
        }
        HashMap<Integer, Map<String, String>> credits = null;
        Map extendedcredits = null;
        List<Map<String, String>> tempML = null;
        int tempI = 0;
        DataParse dataParse = (DataParse)BeanFactory.getBean("dataParse");
        tempS = statvars.get("credits");
        if (tempS != null) {
            credits = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT username, uid, credits FROM jrun_members ORDER BY credits DESC LIMIT 0, 20", new String[0]);
            if (tempML != null) {
                credits = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    credits.put(tempI++, tempM);
                }
            }
            newstatvars.add("'creditsrank', 'credits', '" + dataParse.combinationChar(credits) + "'");
        }
        Map extcredits = dataParse.characterParse(settingMap.get("extcredits"), false);
        tempS = statvars.get("extendedcredits");
        if (tempS != null) {
            extendedcredits = dataParse.characterParse(tempS, false);
        } else {
            extendedcredits = new HashMap();
            int id = 0;
            HashMap<Integer, Map<String, String>> tempM2 = null;
            for (Map.Entry entry : extcredits.entrySet()) {
                id = (Integer)entry.getKey();
                tempI = 0;
                tempM2 = new HashMap<Integer, Map<String, String>>();
                tempML = dataBaseDao.executeQuery("SELECT username, uid, extcredits" + id + " AS credits FROM " + tableprefix + "members ORDER BY extcredits" + id + " DESC LIMIT 0, 20", new String[0]);
                if (tempML != null) {
                    for (Map<String, String> tempM : tempML) {
                        tempM2.put(tempI++, tempM);
                    }
                }
                extendedcredits.put(id, tempM2);
            }
            newstatvars.add("'creditsrank', 'extendedcredits', '" + dataParse.combinationChar(extendedcredits) + "'");
        }
        Stats_creditComposidorVO stats_creditComposidorVO = new Stats_creditComposidorVO();
        List<String> creditNameTopList = stats_creditComposidorVO.getCreditNameTopList();
        creditNameTopList.add(mr.getMessage(locale, "credits"));
        List<String> creditNameDownList = stats_creditComposidorVO.getCreditNameDownList();
        ArrayList<Integer> integerTempListTop = new ArrayList<Integer>();
        HashMap<Integer, String> tempMapDown = new HashMap<Integer, String>();
        Integer extcreditsCount = extcredits.size();
        Integer nowExtcreditsCount = 0;
        for (Map.Entry extcreditsEntry : extcredits.entrySet()) {
            Integer key = (Integer)extcreditsEntry.getKey();
            Map map = (Map)extcreditsEntry.getValue();
            nowExtcreditsCount = nowExtcreditsCount + 1;
            if (extcreditsCount < 5) {
                integerTempListTop.add(key);
                creditNameTopList.add((String)map.get("title"));
                continue;
            }
            if (extcreditsCount == 5) {
                if (nowExtcreditsCount < 3) {
                    integerTempListTop.add(key);
                    creditNameTopList.add((String)map.get("title"));
                    continue;
                }
                tempMapDown.put(key, (String)map.get("title"));
                creditNameDownList.add((String)map.get("title"));
                continue;
            }
            if (extcreditsCount > 5 && extcreditsCount < 8) {
                if (nowExtcreditsCount < 4) {
                    integerTempListTop.add(key);
                    creditNameTopList.add((String)map.get("title"));
                    continue;
                }
                tempMapDown.put(key, (String)map.get("title"));
                creditNameDownList.add((String)map.get("title"));
                continue;
            }
            if (nowExtcreditsCount < 5) {
                integerTempListTop.add(key);
                creditNameTopList.add((String)map.get("title"));
                continue;
            }
            tempMapDown.put(key, (String)map.get("title"));
            creditNameDownList.add((String)map.get("title"));
        }
        List<Stats_creditComposidorVO.LineObject> lineObjectTopList = stats_creditComposidorVO.getLineObjectTopList();
        List<Map<String, Map<String, String>>> downMapList = stats_creditComposidorVO.getDownMapList();
        int i = 0;
        while (i < credits.size()) {
            Map mapTempInI = (Map)credits.get(i);
            Stats_creditComposidorVO.LineObject lineObject = new Stats_creditComposidorVO.LineObject();
            List<Stats_creditComposidorVO.LineObject.CreditInfo> creditInfoList = lineObject.getCreditInfoList();
            Stats_creditComposidorVO.LineObject.CreditInfo creditInfo_credits = new Stats_creditComposidorVO.LineObject.CreditInfo();
            creditInfo_credits.setCreditNum((String)mapTempInI.get("credits"));
            creditInfo_credits.setUsername((String)mapTempInI.get("username"));
            creditInfoList.add(creditInfo_credits);
            int j = 0;
            while (j < integerTempListTop.size()) {
                Map extendedcreditsMapIn = (Map)extendedcredits.get(integerTempListTop.get(j));
                Stats_creditComposidorVO.LineObject.CreditInfo creditInfo_extendedcredits = new Stats_creditComposidorVO.LineObject.CreditInfo();
                Map extendedcreditsMapIn2 = (Map)extendedcreditsMapIn.get(i);
                creditInfo_extendedcredits.setCreditNum((String)extendedcreditsMapIn2.get("credits"));
                creditInfo_extendedcredits.setUsername((String)extendedcreditsMapIn2.get("username"));
                creditInfoList.add(creditInfo_extendedcredits);
                ++j;
            }
            lineObjectTopList.add(lineObject);
            HashMap mapTemp = new HashMap();
            for (Map.Entry e : tempMapDown.entrySet()) {
                Integer mapKeyInteger = (Integer)e.getKey();
                Map extendedcreditsMapIn = (Map)extendedcredits.get(mapKeyInteger);
                Map extendedcreditsMapIn2 = (Map)extendedcreditsMapIn.get(i);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("username", (String)extendedcreditsMapIn2.get("username"));
                resultMap.put("creditNum", (String)extendedcreditsMapIn2.get("credits"));
                mapTemp.put((String)e.getValue(), resultMap);
            }
            downMapList.add(mapTemp);
            ++i;
        }
        this.setNavbarVO(stats_creditComposidorVO.getNavbar(), statstatus, modworkstatus, "creditsrank");
        this.updateNewStatvars(newstatvars, dataBaseDao);
        return stats_creditComposidorVO;
    }

    public Stats_onlineCompositorVO getFinalStats_onlineCompositorVO(int timestamp, String timeoffsetSession) {
        int lastupdate;
        Map<String, String> settingMap = ForumInit.settings;
        Double statscachelife = Double.valueOf(settingMap.get("statscachelife"));
        statscachelife = statscachelife * 60.0;
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("0") && !tempS.equals("");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        ArrayList<String> newstatvars = new ArrayList<String>();
        Map<String, String> statvars = this.getFinalMap("onlines", dataBaseDao);
        tempS = statvars.get("lastupdate");
        int n = lastupdate = tempS == null ? 0 : Integer.parseInt(tempS);
        if ((double)(timestamp - lastupdate) > statscachelife) {
            statvars.clear();
            statvars.put("lastupdate", String.valueOf(timestamp));
            newstatvars.add("'onlines', 'lastupdate', '" + timestamp + "'");
        }
        DataParse dataParse = (DataParse)BeanFactory.getBean("dataParse");
        Stats_onlineCompositorVO stats_onlineCompositorVO = new Stats_onlineCompositorVO();
        List<Map<String, Map<String, String>>> compositorMapList = stats_onlineCompositorVO.getCompositorMapList();
        Map<Integer, Map<String, String>> total = null;
        Map<Integer, Map<String, String>> thismonth = null;
        List<Map<String, String>> tempML = null;
        tempS = statvars.get("total");
        int tempI = 0;
        if (tempS != null) {
            total = dataParse.characterParse(tempS, false);
        } else {
            total = new HashMap();
            tempML = dataBaseDao.executeQuery("SELECT o.uid, m.username, o.total AS time FROM jrun_onlinetime o LEFT JOIN jrun_members m USING (uid) ORDER BY o.total DESC LIMIT 20", new String[0]);
            if (tempML != null) {
                for (Map<String, String> tempM : tempML) {
                    tempM.put("time", String.valueOf((double)Math.round(Double.parseDouble(tempM.get("time")) / 60.0 * 100.0) / 100.0));
                    total.put(tempI++, tempM);
                }
            }
            newstatvars.add("'onlines', 'total', '" + dataParse.combinationChar(total) + "'");
        }
        tempS = statvars.get("thismonth");
        tempI = 0;
        if (tempS != null) {
            thismonth = dataParse.characterParse(tempS, false);
        } else {
            thismonth = new HashMap();
            Calendar calendar = Common.getCalendar(settingMap.get("timeoffset"));
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.set(5, 1);
            tempML = dataBaseDao.executeQuery("SELECT o.uid, m.username, o.thismonth AS time FROM jrun_onlinetime o, jrun_members m WHERE o.uid=m.uid AND m.lastactivity>='" + calendar.getTimeInMillis() / 1000L + "' " + "ORDER BY o.thismonth DESC LIMIT 20", new String[0]);
            if (tempML != null) {
                for (Map<String, String> tempM : tempML) {
                    tempM.put("time", String.valueOf((double)Math.round(Double.parseDouble(tempM.get("time")) / 60.0 * 100.0) / 100.0));
                    thismonth.put(tempI++, tempM);
                }
            }
            newstatvars.add("'onlines', 'thismonth', '" + dataParse.combinationChar(thismonth) + "'");
        }
        HashMap resultMap = null;
        Map totalMapTemp = null;
        HashMap<String, String> totalResultMap = null;
        Map thismonthMapTemp = null;
        HashMap<String, String> thismonthResultMap = null;
        if (total != null) {
            tempI = total.size();
            int i = 0;
            while (i < tempI) {
                resultMap = new HashMap();
                totalMapTemp = (Map)total.get(i);
                totalResultMap = new HashMap<String, String>();
                totalResultMap.put("username", (String)totalMapTemp.get("username"));
                totalResultMap.put("uid", (String)totalMapTemp.get("uid"));
                totalResultMap.put("onlineTime", (String)totalMapTemp.get("time"));
                resultMap.put("total", totalResultMap);
                if (thismonth != null && (thismonthMapTemp = (Map)thismonth.get(i)) != null) {
                    thismonthResultMap = new HashMap<String, String>();
                    thismonthResultMap.put("username", (String)thismonthMapTemp.get("username"));
                    thismonthResultMap.put("uid", (String)thismonthMapTemp.get("uid"));
                    thismonthResultMap.put("onlineTime", ((String)thismonthMapTemp.get("time")).toString());
                    resultMap.put("thisMonth", thismonthResultMap);
                }
                compositorMapList.add(resultMap);
                ++i;
            }
        }
        compositorMapList = null;
        resultMap = null;
        totalMapTemp = null;
        totalResultMap = null;
        thismonthMapTemp = null;
        thismonthResultMap = null;
        SimpleDateFormat dateFormat = Common.getSimpleDateFormat("yyyy-MM-dd HH:mm", timeoffsetSession);
        tempI = Integer.parseInt(statvars.get("lastupdate"));
        stats_onlineCompositorVO.setLastTime(Common.gmdate(dateFormat, tempI));
        stats_onlineCompositorVO.setNextTime(Common.gmdate(dateFormat, tempI + statscachelife.intValue()));
        this.setNavbarVO(stats_onlineCompositorVO.getNavbar(), statstatus, modworkstatus, "onlinetime");
        this.updateNewStatvars(newstatvars, dataBaseDao);
        return stats_onlineCompositorVO;
    }

    /*
     * WARNING - void declaration
     */
    public Stats_manageTeamVO getFinalStats_manageTeamVO(int timestamp, String timeoffsetSession, MessageResources mr, Locale locale) {
        int lastupdate;
        Map<String, String> settingMap = ForumInit.settings;
        Double statscachelife = Double.valueOf(settingMap.get("statscachelife"));
        statscachelife = statscachelife * 60.0;
        boolean oltimespan = Double.valueOf(settingMap.get("oltimespan")) > 0.0;
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("0") && !tempS.equals("");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        ArrayList<String> newstatvars = new ArrayList<String>();
        DataParse dataParse = (DataParse)BeanFactory.getBean("dataParse");
        SimpleDateFormat dateFormat = Common.getSimpleDateFormat("", settingMap.get("timeoffset"));
        Map<String, String> statvars = this.getFinalMap("team", dataBaseDao);
        tempS = statvars.get("lastupdate");
        int n = lastupdate = tempS == null ? 0 : Integer.parseInt(tempS);
        if ((double)(timestamp - lastupdate) > statscachelife) {
            statvars.clear();
            statvars.put("lastupdate", String.valueOf(timestamp));
            newstatvars.add("'team', 'lastupdate', '" + timestamp + "'");
        }
        Map forums = null;
        Map<Integer, HashMap<Integer, String>> moderators = null;
        Map<Integer, Object> members = null;
        HashMap<Integer, Map<Object, Object>> categories = null;
        HashMap<Integer, String> admins = null;
        double avgoffdays = 0.0;
        double avgthismonthposts = 0.0;
        double avgtotalol = 0.0;
        double avgthismonthol = 0.0;
        double avgmodactions = 0.0;
        Map<String, HashMap<String, Map<String, HashMap<String, Map<String, Map<String, Double>>>>>> team = null;
        tempS = statvars.get("team");
        int tempI = 0;
        if (tempS != null) {
            team = dataParse.characterParse(tempS, false);
            forums = (Map)team.get("forums");
            categories = (HashMap<Integer, Map<Object, Object>>)team.get("categories");
            admins = (HashMap<Integer, String>)team.get("admins");
            moderators = (Map)team.get("moderators");
            members = (Map)team.get("members");
            avgoffdays = Float.parseFloat(String.valueOf(team.get("avgoffdays")));
            avgthismonthposts = Float.parseFloat(String.valueOf(team.get("avgthismonthposts")));
            avgtotalol = Float.parseFloat(String.valueOf(team.get("avgtotalol")));
            avgthismonthol = Float.parseFloat(String.valueOf(team.get("avgthismonthol")));
            avgmodactions = Float.parseFloat(String.valueOf(team.get("avgmodactions")));
        } else {
            team = new HashMap();
            forums = new HashMap();
            moderators = new HashMap();
            members = new HashMap();
            categories = new HashMap<Integer, Map<Object, Object>>();
            HashMap<Integer, Integer> fuptemp = new HashMap<Integer, Integer>();
            Map<String, String> tempM_SS = new HashMap<String, String>();
            tempM_SS.put("fid", "0");
            tempM_SS.put("fup", "0");
            tempM_SS.put("type", "group");
            tempM_SS.put("name", settingMap.get("bbname"));
            categories.put(0, tempM_SS);
            TreeMap<String, String> uids = new TreeMap<String, String>();
            List<Map<String, String>> tempML = dataBaseDao.executeQuery("SELECT fid, uid FROM jrun_moderators WHERE inherited='0' ORDER BY displayorder", new String[0]);
            if (tempML != null) {
                HashMap<Integer, String> tempM_IS = null;
                for (Map<String, String> moderator : tempML) {
                    tempS = moderator.get("uid");
                    tempM_IS = (HashMap<Integer, String>)moderators.get(Integer.parseInt(moderator.get("fid")));
                    if (tempM_IS == null) {
                        tempM_IS = new HashMap<Integer, String>();
                        moderators.put(Integer.parseInt(moderator.get("fid")), tempM_IS);
                    }
                    tempM_IS.put(tempM_IS.size(), tempS);
                    uids.put(tempS, tempS);
                }
            }
            String oltimeadd1 = "";
            String oltimeadd2 = "";
            if (oltimespan) {
                oltimeadd1 = ", o.thismonth AS thismonthol, o.total AS totalol";
                oltimeadd2 = "LEFT JOIN jrun_onlinetime o ON o.uid=m.uid";
            }
            int totaloffdays = 0;
            int totalol = 0;
            int totalthismonthol = 0;
            tempML = dataBaseDao.executeQuery("SELECT m.uid, m.username, m.adminid, m.lastactivity, m.credits, m.posts " + oltimeadd1 + " " + "FROM " + tableprefix + "members m " + oltimeadd2 + " " + "WHERE m.uid IN (" + Common.sImplode(uids) + ") OR m.adminid IN (1, 2) ORDER BY m.adminid", new String[0]);
            admins = new HashMap<Integer, String>();
            if (tempML != null) {
                dateFormat.applyPattern("yyyyM");
                tempI = 0;
                int offdays = 0;
                double tempD = 0.0;
                for (Map<String, String> member : tempML) {
                    tempS = member.get("adminid");
                    if ("1".equals(tempS) || "2".equals(tempS)) {
                        admins.put(tempI++, member.get("uid"));
                    }
                    offdays = (timestamp - Integer.parseInt(member.get("lastactivity"))) / 86400;
                    member.put("offdays", String.valueOf(offdays));
                    totaloffdays += offdays;
                    if (oltimespan) {
                        tempS = (String)member.get("totalol");
                        if (tempS == null) {
                            tempS = "0";
                        }
                        tempD = (double)Math.round(Double.parseDouble(tempS) / 60.0 * 100.0) / 100.0;
                        member.put("totalol", String.valueOf(tempD));
                        totalol = (int)((double)totalol + tempD);
                        if (dateFormat.format(Long.parseLong((String)member.get("lastactivity")) * 1000L).equals(dateFormat.format((long)timestamp * 1000L))) {
                            tempS = (String)member.get("thismonthol");
                            if (tempS == null) {
                                tempS = "0";
                            }
                            tempD = (double)Math.round(Double.parseDouble(tempS) * 100.0 / 60.0) / 100.0;
                            tempS = String.valueOf(tempD);
                        } else {
                            tempD = 0.0;
                            tempS = "0";
                        }
                        member.put("thismonthol", tempS);
                        totalthismonthol = (int)((double)totalthismonthol + tempD);
                    }
                    tempS = (String)member.get("uid");
                    members.put(Integer.valueOf(tempS), member);
                    uids.put(tempS, tempS);
                }
            }
            int totalthismonthposts = 0;
            tempML = dataBaseDao.executeQuery("SELECT authorid, COUNT(*) AS posts FROM jrun_posts WHERE dateline>=" + (timestamp - 2592000) + " AND authorid IN (" + Common.sImplode(uids) + ") AND invisible='0' GROUP BY authorid", new String[0]);
            if (tempML != null) {
                for (Map<String, String> post : tempML) {
                    tempS = post.get("posts");
                    tempM_SS = (Map)members.get(Integer.parseInt(post.get("authorid")));
                    if (tempM_SS != null) {
                        tempM_SS.put("thismonthposts", tempS);
                    }
                    totalthismonthposts += Integer.parseInt(tempS);
                }
            }
            int totalmodactions = 0;
            if (modworkstatus) {
                dateFormat.applyPattern("yyyy-MM-01");
                tempS = dateFormat.format((long)timestamp * 1000L);
                tempML = dataBaseDao.executeQuery("SELECT uid, SUM(count) AS actioncount FROM jrun_modworks WHERE dateline>='" + tempS + "' GROUP BY uid", new String[0]);
                if (tempML != null) {
                    for (Map map : tempML) {
                        tempS = (String)map.get("actioncount");
                        tempM_SS = (Map)members.get(Integer.valueOf((String)map.get("uid")));
                        if (tempM_SS != null) {
                            tempM_SS.put("modactions", tempS);
                        }
                        totalmodactions += Integer.parseInt(tempS);
                    }
                }
            }
            if ((tempML = dataBaseDao.executeQuery("SELECT fid, fup, type, name, inheritedmod FROM jrun_forums WHERE status=1 ORDER BY type, displayorder", new String[0])) != null) {
                Object var45_54 = null;
                Map tempM_IS = null;
                int temp_fid = 0;
                int temp_fup = 0;
                for (Map<String, String> forum : tempML) {
                    temp_fid = Integer.valueOf(forum.get("fid"));
                    temp_fup = Integer.valueOf(forum.get("fup"));
                    tempM_IS = (Map)moderators.get(temp_fid);
                    if (tempM_IS == null) {
                        forum.put("moderators", "0");
                    } else {
                        forum.put("moderators", String.valueOf(tempM_IS.size()));
                    }
                    tempS = forum.get("type");
                    if ("group".equals(tempS)) {
                        void var45_58;
                        categories.put(temp_fid, forum);
                        Map map = (Map)forums.get(temp_fid);
                        if (map == null) {
                            HashMap hashMap = new HashMap();
                            forums.put(temp_fid, hashMap);
                        }
                        var45_58.put(temp_fid, forum);
                        tempI = temp_fid;
                    } else if ("forum".equals(tempS)) {
                        void var45_61;
                        Map map = (Map)forums.get(temp_fup);
                        if (map == null) {
                            HashMap hashMap = new HashMap();
                            forums.put(temp_fup, hashMap);
                        }
                        var45_61.put(temp_fid, forum);
                        fuptemp.put(temp_fid, temp_fup);
                        tempI = temp_fup;
                    } else if ("sub".equals(tempS)) {
                        void var45_64;
                        Map map = (Map)forums.get(fuptemp.get(temp_fup));
                        if (map == null) {
                            HashMap hashMap = new HashMap();
                            forums.put((Integer)fuptemp.get(temp_fup), hashMap);
                        }
                        var45_64.put(temp_fid, forum);
                        tempI = (Integer)fuptemp.get(temp_fup);
                    }
                    if (moderators.get(temp_fid) == null || (tempM_SS = (Map)categories.get(tempI)) == null) continue;
                    tempM_SS.put("moderating", "1");
                }
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Map.Entry tempEntry : categories.entrySet()) {
                tempM_SS = (Map)tempEntry.getValue();
                if (tempM_SS.get("moderating") != null) continue;
                arrayList.add((Integer)tempEntry.getKey());
            }
            for (Integer fid : arrayList) {
                categories.remove(fid);
            }
            tempI = members.size();
            avgoffdays = (double)totaloffdays / (double)tempI;
            avgthismonthposts = (double)totalthismonthposts / (double)tempI;
            avgtotalol = (double)totalol / (double)tempI;
            avgthismonthol = (double)totalthismonthol / (double)tempI;
            avgmodactions = (double)totalmodactions / (double)tempI;
            team.put("categories", categories);
            team.put("forums", (HashMap<String, Map<String, HashMap<String, Map<String, Map<String, Double>>>>>)forums);
            team.put("admins", admins);
            team.put("moderators", (HashMap<String, Map<String, HashMap<String, Map<String, Map<String, Double>>>>>)moderators);
            team.put("members", (HashMap<String, Map<String, HashMap<String, Map<String, Map<String, Double>>>>>)members);
            team.put("avgoffdays", (HashMap<String, Map<String, HashMap<String, Map<String, Map<String, Double>>>>>)avgoffdays);
            team.put("avgthismonthposts", (HashMap<String, Map<String, HashMap<String, Map<String, Map<String, Double>>>>>)avgthismonthposts);
            team.put("avgtotalol", (HashMap<String, Map<String, HashMap<String, Map<String, Map<String, Double>>>>>)avgtotalol);
            team.put("avgthismonthol", (HashMap<String, Map<String, HashMap<String, Map<String, Map<String, Double>>>>>)avgthismonthol);
            team.put("avgmodactions", (HashMap<String, Map<String, HashMap<String, Map<String, Map<String, Double>>>>>)avgmodactions);
            newstatvars.add("'team', 'team', '" + dataParse.combinationChar(team) + "'");
        }
        Stats_manageTeamVO stats_manageTeamVO = new Stats_manageTeamVO();
        List<Stats_manageTeamVO.ForumTableGroup> forumTableGroupList = stats_manageTeamVO.getForumTableGroupList();
        boolean beingAdmin = false;
        List<Map<String, Object>> manageTeamMapList = stats_manageTeamVO.getManageTeamMapList();
        dateFormat.applyPattern("dd/MM/yyyy HH:mm");
        double avgthismonthposts_2 = avgthismonthposts / 2.0;
        double avgthismonthol_2 = avgthismonthol / 2.0;
        double avgtotalol_2 = avgtotalol / 2.0;
        double avgmodactions_2 = avgmodactions / 2.0;
        Map member2 = null;
        String lastactivity = null;
        String adminid = null;
        HashMap<String, Object> finalMap_members = null;
        HashMap<String, String> usernameMap = null;
        HashMap<String, String> map_thisMonthManage = null;
        for (Map.Entry tempM : members.entrySet()) {
            member2 = (Map)tempM.getValue();
            tempS = (String)member2.get("lastactivity");
            tempS = tempS == null ? "0" : tempS;
            lastactivity = Common.gmdate(dateFormat, Integer.parseInt(tempS));
            adminid = (String)member2.get("adminid");
            finalMap_members = new HashMap<String, Object>();
            usernameMap = new HashMap<String, String>();
            usernameMap.put("uid", (String)member2.get("uid"));
            usernameMap.put("username", (String)member2.get("username"));
            finalMap_members.put(mr.getMessage(locale, "username"), usernameMap);
            finalMap_members.put(mr.getMessage(locale, "lastvisit"), lastactivity);
            tempS = (String)member2.get("offdays");
            tempS = tempS == null ? "0" : tempS;
            finalMap_members.put(mr.getMessage(locale, "stats_team_offdays"), (double)Integer.valueOf(tempS).intValue() > avgoffdays ? "<b><i>" + tempS + "</i></b>" : tempS);
            finalMap_members.put(mr.getMessage(locale, "credits"), member2.get("credits"));
            finalMap_members.put(mr.getMessage(locale, "a_setting_posts"), member2.get("posts"));
            tempS = (String)member2.get("thismonthposts");
            tempS = tempS == null ? "0" : tempS;
            finalMap_members.put(mr.getMessage(locale, "stats_posts_thismonth"), (double)Integer.valueOf(tempS).intValue() < avgthismonthposts_2 ? "<b><i>" + tempS + "</i></b>" : tempS);
            if (modworkstatus) {
                map_thisMonthManage = new HashMap<String, String>();
                map_thisMonthManage.put("uid", (String)member2.get("uid"));
                tempS = (String)member2.get("modactions");
                tempS = tempS == null ? "0" : tempS;
                map_thisMonthManage.put("thisMonthManage", tempS);
                finalMap_members.put(mr.getMessage(locale, "stats_modworks_thismonth"), map_thisMonthManage);
            }
            if (oltimespan) {
                tempS = (String)member2.get("totalol");
                tempS = tempS == null ? "0" : tempS;
                finalMap_members.put(mr.getMessage(locale, "onlinetime_total"), Double.parseDouble(tempS) < avgtotalol_2 ? "<b><i>" + tempS + "</i></b>" : tempS);
                tempS = (String)member2.get("thismonthol");
                tempS = tempS == null ? "0" : tempS;
                finalMap_members.put(mr.getMessage(locale, "onlinetime_thismonth"), Double.parseDouble(tempS) < avgthismonthol_2 ? "<b><i>" + tempS + "</i></b>" : tempS);
            }
            if (adminid.equals("1")) {
                beingAdmin = true;
                finalMap_members.put(mr.getMessage(locale, "admin_status"), mr.getMessage(locale, "admin"));
                manageTeamMapList.add(finalMap_members);
                continue;
            }
            if (!adminid.equals("2")) continue;
            finalMap_members.put(mr.getMessage(locale, "admin_status"), mr.getMessage(locale, "usergroups_system_2"));
            manageTeamMapList.add(finalMap_members);
        }
        manageTeamMapList = null;
        finalMap_members = null;
        usernameMap = null;
        map_thisMonthManage = null;
        Stats_manageTeamVO.ForumTableGroup forumTableGroup = null;
        Integer fid = null;
        Map mapTemp_categories = null;
        Map mapTemp_forumTemp = null;
        Map mapTemp_moderators = null;
        Map mapIn_forum = null;
        List<Stats_manageTeamVO.ForumTableGroup.Forum> forumList = null;
        tempI = 0;
        Stats_manageTeamVO.ForumTableGroup.Forum forum = null;
        for (Map.Entry tempEntry : categories.entrySet()) {
            forumTableGroup = new Stats_manageTeamVO.ForumTableGroup();
            mapTemp_categories = (Map)tempEntry.getValue();
            fid = Integer.valueOf((String)mapTemp_categories.get("fid"));
            mapTemp_forumTemp = (Map)forums.get(fid);
            for (Map.Entry tempEntry2 : mapTemp_forumTemp.entrySet()) {
                for (Map.Entry tempEntry3 : moderators.entrySet()) {
                    if (((Integer)tempEntry2.getKey()).intValue() != ((Integer)tempEntry3.getKey()).intValue()) continue;
                    mapTemp_moderators = (Map)tempEntry3.getValue();
                    mapIn_forum = (Map)tempEntry2.getValue();
                    forumTableGroup.setGroupName((String)mapTemp_categories.get("name"));
                    forumTableGroup.setGroupId("" + fid);
                    forumList = forumTableGroup.getForumList();
                    tempI = mapTemp_moderators.size();
                    int i = 0;
                    while (i < tempI) {
                        forum = new Stats_manageTeamVO.ForumTableGroup.Forum();
                        forum.setShowOnline(oltimespan);
                        if (mapTemp_moderators.get(i) != null && (member2 = (Map)members.get(Integer.valueOf((String)mapTemp_moderators.get(i)))) != null) {
                            adminid = (String)member2.get("adminid");
                            lastactivity = Common.gmdate(dateFormat, Integer.parseInt((String)member2.get("lastactivity")));
                            forum.setSelectFroumName(i == 0);
                            forum.setFroumName((String)mapIn_forum.get("name"));
                            if (((String)mapIn_forum.get("type")).equals("group")) {
                                forum.setUri("index.jsp?gid=" + fid);
                            } else {
                                forum.setUri("forumdisplay.jsp?fid=" + (String)mapIn_forum.get("fid"));
                            }
                            tempS = (String)member2.get("username");
                            if (Integer.valueOf((String)mapIn_forum.get("inheritedmod")) > 0) {
                                tempS = "<b>" + tempS + "</b>";
                            }
                            forum.setUid((String)member2.get("uid"));
                            forum.setUsername(tempS);
                            forum.setLastAccessTime(lastactivity);
                            tempS = (String)member2.get("offdays");
                            tempS = tempS == null ? "0" : tempS;
                            forum.setOffDays((double)Integer.valueOf(tempS).intValue() > avgoffdays ? "<b><i>" + tempS + "</i></b>" : tempS);
                            forum.setCredits((String)member2.get("credits"));
                            forum.setPosts((String)member2.get("posts"));
                            tempS = (String)member2.get("thismonthposts");
                            tempS = tempS == null ? "0" : tempS;
                            forum.setThisMonthPosts((double)Integer.valueOf(tempS).intValue() < avgthismonthposts_2 ? "<b><i>" + tempS + "</i></b>" : tempS);
                            if (modworkstatus) {
                                tempS = (String)member2.get("modactions");
                                tempS = tempS == null ? "0" : tempS;
                                forum.setThisMonthManage((double)Integer.parseInt(tempS) < avgmodactions_2 ? "<b><i>" + tempS + "</i></b>" : tempS);
                            } else {
                                forum.setThisMonthManage("N/A");
                            }
                            if (oltimespan) {
                                tempS = (String)member2.get("totalol");
                                tempS = tempS == null ? "0" : tempS;
                                forum.setAllTimeOnline(Double.parseDouble(tempS) < avgtotalol_2 ? "<b><i>" + tempS + "</i></b>" : tempS);
                                tempS = (String)member2.get("thismonthol");
                                tempS = tempS == null ? "0" : tempS;
                                forum.setThisMonthTimeOnline(Double.parseDouble(tempS) < avgthismonthol_2 ? "<b><i>" + tempS + "</i></b>" : tempS);
                            }
                            if (adminid.equals("1")) {
                                beingAdmin = true;
                                forum.setManagerName(mr.getMessage(locale, "admin"));
                            } else if (adminid.equals("2")) {
                                forum.setManagerName(mr.getMessage(locale, "usergroups_system_2"));
                            } else if (adminid.equals("3")) {
                                forum.setManagerName(mr.getMessage(locale, "usergroups_system_3"));
                            }
                            forum.setRowspan((String)mapIn_forum.get("moderators"));
                            forumList.add(forum);
                        }
                        ++i;
                    }
                }
            }
            forumTableGroupList.add(forumTableGroup);
        }
        forumTableGroup = null;
        fid = null;
        mapTemp_categories = null;
        mapTemp_forumTemp = null;
        mapTemp_moderators = null;
        mapIn_forum = null;
        forumList = null;
        forum = null;
        tempS = null;
        member2 = null;
        lastactivity = null;
        adminid = null;
        String[] adminTableTitleArray = null;
        if (beingAdmin) {
            adminTableTitleArray = modworkstatus && oltimespan ? new String[]{mr.getMessage(locale, "username"), mr.getMessage(locale, "admin_status"), mr.getMessage(locale, "lastvisit"), mr.getMessage(locale, "stats_team_offdays"), mr.getMessage(locale, "credits"), mr.getMessage(locale, "a_setting_posts"), mr.getMessage(locale, "stats_posts_thismonth"), mr.getMessage(locale, "stats_modworks_thismonth"), mr.getMessage(locale, "onlinetime_total"), mr.getMessage(locale, "onlinetime_thismonth")} : (modworkstatus && !oltimespan ? new String[]{mr.getMessage(locale, "username"), mr.getMessage(locale, "admin_status"), mr.getMessage(locale, "lastvisit"), mr.getMessage(locale, "stats_team_offdays"), mr.getMessage(locale, "credits"), mr.getMessage(locale, "a_setting_posts"), mr.getMessage(locale, "stats_posts_thismonth"), mr.getMessage(locale, "stats_modworks_thismonth")} : (!modworkstatus && oltimespan ? new String[]{mr.getMessage(locale, "username"), mr.getMessage(locale, "admin_status"), mr.getMessage(locale, "lastvisit"), mr.getMessage(locale, "stats_team_offdays"), mr.getMessage(locale, "credits"), mr.getMessage(locale, "a_setting_posts"), mr.getMessage(locale, "stats_posts_thismonth"), mr.getMessage(locale, "onlinetime_total"), mr.getMessage(locale, "onlinetime_thismonth")} : new String[]{mr.getMessage(locale, "username"), mr.getMessage(locale, "admin_status"), mr.getMessage(locale, "lastvisit"), mr.getMessage(locale, "stats_team_offdays"), mr.getMessage(locale, "credits"), mr.getMessage(locale, "a_setting_posts"), mr.getMessage(locale, "stats_posts_thismonth")}));
        }
        List<String> adminTableTitleList = stats_manageTeamVO.getAdminTableTitleList();
        if (adminTableTitleArray != null) {
            int i = 0;
            while (i < adminTableTitleArray.length) {
                adminTableTitleList.add(adminTableTitleArray[i]);
                ++i;
            }
        }
        adminTableTitleList = null;
        adminTableTitleArray = null;
        String[] forumTableTitleArray = null;
        forumTableTitleArray = oltimespan ? new String[]{mr.getMessage(locale, "forum_name"), mr.getMessage(locale, "username"), mr.getMessage(locale, "admin_status"), mr.getMessage(locale, "lastvisit"), mr.getMessage(locale, "stats_team_offdays"), mr.getMessage(locale, "credits"), mr.getMessage(locale, "a_setting_posts"), mr.getMessage(locale, "stats_posts_thismonth"), mr.getMessage(locale, "stats_modworks_thismonth"), mr.getMessage(locale, "onlinetime_total"), mr.getMessage(locale, "onlinetime_thismonth")} : new String[]{mr.getMessage(locale, "forum_name"), mr.getMessage(locale, "username"), mr.getMessage(locale, "admin_status"), mr.getMessage(locale, "lastvisit"), mr.getMessage(locale, "stats_team_offdays"), mr.getMessage(locale, "credits"), mr.getMessage(locale, "a_setting_posts"), mr.getMessage(locale, "stats_posts_thismonth"), mr.getMessage(locale, "stats_modworks_thismonth")};
        List<String> forumTableTitleList = stats_manageTeamVO.getForumTableTitleList();
        int i = 0;
        while (i < forumTableTitleArray.length) {
            forumTableTitleList.add(forumTableTitleArray[i]);
            ++i;
        }
        forumTableTitleList = null;
        forumTableTitleArray = null;
        SimpleDateFormat simpleDateFormat = Common.getSimpleDateFormat("yyyy-MM-dd HH:mm", timeoffsetSession);
        tempI = Integer.parseInt(statvars.get("lastupdate"));
        stats_manageTeamVO.setLastTime(Common.gmdate(simpleDateFormat, tempI));
        stats_manageTeamVO.setNextTime(Common.gmdate(simpleDateFormat, tempI + statscachelife.intValue()));
        this.setNavbarVO(stats_manageTeamVO.getNavbar(), statstatus, modworkstatus, "team");
        this.updateNewStatvars(newstatvars, dataBaseDao);
        return stats_manageTeamVO;
    }

    public Stats_tradeCompositorVO getFinalStats_tradeCompositorVO(int timestamp, String timeoffsetSession) {
        int lastupdate;
        Map<String, String> settingMap = ForumInit.settings;
        Double statscachelife = Double.valueOf(settingMap.get("statscachelife"));
        statscachelife = statscachelife * 60.0;
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("0") && !tempS.equals("");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        ArrayList<String> newstatvars = new ArrayList<String>();
        DataParse dataParse = (DataParse)BeanFactory.getBean("dataParse");
        Map<String, String> statvars = this.getFinalMap("trade", dataBaseDao);
        tempS = statvars.get("lastupdate");
        int n = lastupdate = tempS == null ? 0 : Integer.parseInt(tempS);
        if ((double)(timestamp - lastupdate) > statscachelife) {
            statvars.clear();
            statvars.put("lastupdate", String.valueOf(timestamp));
            newstatvars.add("'trade', 'lastupdate', '" + timestamp + "'");
        }
        HashMap<Integer, Map<String, String>> tradesums = null;
        List<Map<String, String>> tempML = null;
        tempS = statvars.get("tradesums");
        int tempI = 0;
        if (tempS != null) {
            tradesums = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT subject, tid, pid, seller, sellerid, sum(tradesum) as tradesum FROM jrun_trades WHERE tradesum>0 GROUP BY sellerid ORDER BY tradesum DESC LIMIT 10", new String[0]);
            if (tempML != null) {
                tradesums = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    tradesums.put(tempI++, tempM);
                }
            }
            newstatvars.add("'trade', 'tradesums', '" + dataParse.combinationChar(tradesums) + "'");
        }
        HashMap<Integer, Map<String, String>> totalitems = null;
        tempS = statvars.get("totalitems");
        tempI = 0;
        if (tempS != null) {
            totalitems = dataParse.characterParse(tempS, false);
        } else {
            tempML = dataBaseDao.executeQuery("SELECT subject, tid, pid, seller, sellerid, sum(totalitems) as totalitems FROM jrun_trades WHERE totalitems>0 GROUP BY sellerid ORDER BY totalitems DESC LIMIT 10", new String[0]);
            if (tempML != null) {
                totalitems = new HashMap<Integer, Map<String, String>>();
                for (Map<String, String> tempM : tempML) {
                    totalitems.put(tempI++, tempM);
                }
            }
            newstatvars.add("'trade', 'totalitems', '" + dataParse.combinationChar(totalitems) + "'");
        }
        Stats_tradeCompositorVO stats_tradeCompositorVO = new Stats_tradeCompositorVO();
        stats_tradeCompositorVO.setTotalitems(totalitems);
        stats_tradeCompositorVO.setTradesums(tradesums);
        tempI = Integer.parseInt(statvars.get("lastupdate"));
        SimpleDateFormat dateFormatUpdateTime = Common.getSimpleDateFormat("yyyy-MM-dd HH:mm", timeoffsetSession);
        stats_tradeCompositorVO.setLastUpdate(Common.gmdate(dateFormatUpdateTime, tempI));
        stats_tradeCompositorVO.setNextUpdate(Common.gmdate(dateFormatUpdateTime, tempI + statscachelife.intValue()));
        this.setNavbarVO(stats_tradeCompositorVO.getNavbar(), statstatus, modworkstatus, "trade");
        this.updateNewStatvars(newstatvars, dataBaseDao);
        return stats_tradeCompositorVO;
    }

    public Stats_manageStatisticVO getFinalStats_manageStatisticVO(String beforeIR, String uidFromRequest, MessageResources mr, Locale locale) {
        Map<Object, Object> tempMap;
        Map<String, Map<String, String>> columnOfNumberMapMap;
        Iterator<Stats_manageStatisticVO.ContentInfo> contentInfo;
        Map<String, String> settingMap = ForumInit.settings;
        if (uidFromRequest == null) {
            uidFromRequest = "";
        }
        StatvarsDao statvarsDao = (StatvarsDao)BeanFactory.getBean("statvarsDao");
        DataBaseDao dataBaseDao = (DataBaseDao)BeanFactory.getBean("dataBaseDao");
        int maxmodworksmonthsInteger = Integer.parseInt(settingMap.get("maxmodworksmonths"));
        Stats_manageStatisticVO stats_manageStatisticVO = new Stats_manageStatisticVO();
        stats_manageStatisticVO.setShowUsername(uidFromRequest.equals(""));
        int before = 0;
        if (beforeIR != null && !beforeIR.equals("")) {
            before = Integer.valueOf(beforeIR);
        }
        before = before > 0 && before <= maxmodworksmonthsInteger ? before : 0;
        HashMap<String, String> mergeActions = new HashMap<String, String>();
        mergeActions.put("OPN", "CLS");
        mergeActions.put("ECL", "CLS");
        mergeActions.put("UEC", "CLS");
        mergeActions.put("EOP", "CLS");
        mergeActions.put("UEO", "CLS");
        mergeActions.put("UDG", "DIG");
        mergeActions.put("EDI", "DIG");
        mergeActions.put("UED", "DIG");
        mergeActions.put("UST", "STK");
        mergeActions.put("EST", "STK");
        mergeActions.put("UES", "STK");
        mergeActions.put("DLP", "DEL");
        mergeActions.put("PRN", "DEL");
        mergeActions.put("UDL", "DEL");
        mergeActions.put("UHL", "HLT");
        mergeActions.put("EHL", "HLT");
        mergeActions.put("UEH", "HLT");
        mergeActions.put("SPL", "MRG");
        mergeActions.put("ABL", "EDT");
        mergeActions.put("RBL", "EDT");
        List<Stats_manageStatisticVO.TimeInfo> timeInfoList = stats_manageStatisticVO.getTimeInfoList();
        int finalMonth = 0;
        int finalYear = 0;
        String startTime = "";
        String endTime = "";
        Integer dayCount = 0;
        String thismonth = null;
        Calendar calendar = Common.getCalendar(settingMap.get("timeoffset"));
        int nowDateInteger = (int)(calendar.getTimeInMillis() / 1000L);
        int nowMonth = calendar.get(2) + 1;
        int nowYear = calendar.get(1);
        int nowDay = calendar.get(5);
        int i = 0;
        while (i <= maxmodworksmonthsInteger) {
            if (i != 0) {
                calendar.add(2, -1);
            }
            finalMonth = calendar.get(2) + 1;
            finalYear = calendar.get(1);
            String yearAndMonth = finalMonth < 10 ? String.valueOf(finalYear) + "-0" + finalMonth : String.valueOf(finalYear) + "-" + finalMonth;
            Stats_manageStatisticVO.TimeInfo timeInfo = new Stats_manageStatisticVO.TimeInfo();
            timeInfo.setBefore(String.valueOf(i));
            timeInfo.setTime(yearAndMonth);
            timeInfo.setNowTime(i == before);
            timeInfo.setUid(uidFromRequest);
            timeInfoList.add(timeInfo);
            if (i == before) {
                Integer endMonth = finalMonth + 1;
                Integer endYear = null;
                if (endMonth > 12) {
                    endMonth = 1;
                    endYear = finalYear + 1;
                } else {
                    endYear = finalYear;
                }
                startTime = String.valueOf(yearAndMonth) + "-01";
                endTime = endMonth < 10 ? endYear + "-0" + endMonth + "-01" : endYear + "-" + endMonth + "-01";
                dayCount = before == 0 ? Integer.valueOf(nowDay) : Integer.valueOf(calendar.getActualMaximum(5));
                thismonth = yearAndMonth;
            }
            ++i;
        }
        timeInfoList = null;
        int expireMonth = nowMonth - maxmodworksmonthsInteger;
        int expireYear = 0;
        if (expireMonth <= 0) {
            expireYear = nowYear - (1 - expireMonth / 12);
            expireMonth = expireMonth % 12 + 12;
        } else {
            expireYear = nowYear;
        }
        String expireTime = String.valueOf(expireYear) + (expireMonth < 10 ? "-0" : "-") + expireMonth;
        boolean bool_needToUpdate = false;
        String variable = before == 0 ? "thismonth" : startTime;
        List<Stats_manageStatisticVO.ContentInfo> contentInfoList = stats_manageStatisticVO.getContentInfoList();
        if (uidFromRequest.equals("")) {
            Map<String, Integer> halfFinal_level1;
            Map<String, String> finalMap = new HashMap();
            List<Map<String, String>> list_statvars = dataBaseDao.executeQuery("SELECT type, variable, value FROM jrun_statvars WHERE type='modworks' AND variable='" + variable + "'", new String[0]);
            if (list_statvars.size() > 0) {
                Map<String, String> resultMap_statvars = list_statvars.get(0);
                String value_statvars = resultMap_statvars.get("value");
                Map valueMap_statvars = ((DataParse)BeanFactory.getBean("dataParse")).characterParse(value_statvars, false);
                String thisMonthInValueMap = valueMap_statvars.get("thismonth") == null ? "" : (String)valueMap_statvars.get("thismonth");
                Integer lastUpdateInValueMap = valueMap_statvars.get("lastupdate") == null ? 0 : (Integer)valueMap_statvars.get("lastupdate");
                if (before == 0 && (double)(nowDateInteger - lastUpdateInValueMap) > Double.parseDouble(settingMap.get("statscachelife")) * 60.0 || !thisMonthInValueMap.equals(startTime)) {
                    bool_needToUpdate = true;
                } else {
                    finalMap = valueMap_statvars;
                }
            } else {
                bool_needToUpdate = true;
            }
            if (bool_needToUpdate) {
                StringBuffer uids = new StringBuffer("0");
                Integer totalmodactions = 0;
                Integer avgmodactioncount = 0;
                List<Map<String, String>> list_members = dataBaseDao.executeQuery("SELECT uid, username, adminid FROM jrun_members WHERE adminid IN (1, 2, 3) ORDER BY adminid, uid", new String[0]);
                halfFinal_level1 = null;
                int i2 = 0;
                while (i2 < list_members.size()) {
                    halfFinal_level1 = new HashMap();
                    Map<String, String> resultMap_members = list_members.get(i2);
                    String uid = resultMap_members.get("uid");
                    String username = resultMap_members.get("username");
                    halfFinal_level1.put("uid", (Integer)((Object)uid));
                    halfFinal_level1.put("username", (Integer)((Object)username));
                    halfFinal_level1.put("adminid", (Integer)((Object)resultMap_members.get("adminid")));
                    finalMap.put((String)((Object)Integer.valueOf(resultMap_members.get("uid"))), (String)((Object)halfFinal_level1));
                    uids.append(", " + resultMap_members.get("uid"));
                    ++i2;
                }
                List<Map<String, String>> list_modwords = dataBaseDao.executeQuery("SELECT uid, modaction, SUM(count) AS count, SUM(posts) AS posts FROM jrun_modworks WHERE uid IN (" + uids + ") AND dateline>='" + startTime + "' AND dateline<'" + endTime + "' GROUP BY uid, modaction", new String[0]);
                int i3 = 0;
                while (i3 < list_modwords.size()) {
                    Map<String, String> resultMap_modwords = list_modwords.get(i3);
                    halfFinal_level1 = (Map)finalMap.get(Integer.valueOf(resultMap_modwords.get("uid")));
                    if (halfFinal_level1 != null) {
                        Integer lastTotal = halfFinal_level1.get("total") == null ? 0 : (Integer)halfFinal_level1.get("total");
                        Integer nowTotal = Integer.valueOf(resultMap_modwords.get("count"));
                        Integer thisUserTotal = lastTotal + nowTotal;
                        totalmodactions = totalmodactions + nowTotal;
                        String modactionFromDB = resultMap_modwords.get("modaction");
                        if (mergeActions.get(modactionFromDB) != null) {
                            resultMap_modwords.put("modaction", (String)mergeActions.get(modactionFromDB));
                        }
                        if (thisUserTotal != 0) {
                            halfFinal_level1.put("total", thisUserTotal);
                        }
                        HashMap<String, Integer> halfFinal_level2 = (HashMap<String, Integer>)halfFinal_level1.get(resultMap_modwords.get("modaction"));
                        Integer halfFinal_level2_lastCount = 0;
                        Integer halfFinal_level2_lastPosts = 0;
                        Integer halfFinal_level2_nowCount = nowTotal;
                        Integer halfFinal_level2_nowPosts = Integer.valueOf(resultMap_modwords.get("posts"));
                        if (halfFinal_level2 == null) {
                            halfFinal_level2 = new HashMap<String, Integer>();
                        } else {
                            halfFinal_level2_lastCount = (Integer)halfFinal_level2.get("count");
                            halfFinal_level2_lastPosts = (Integer)halfFinal_level2.get("posts");
                        }
                        Integer halfFinal_level2_resultCount = halfFinal_level2_lastCount + halfFinal_level2_nowCount;
                        Integer halfFinal_level2_resultPosts = halfFinal_level2_lastPosts + halfFinal_level2_nowPosts;
                        if (halfFinal_level2_resultCount != 0 || halfFinal_level2_resultPosts != 0) {
                            halfFinal_level2.put("count", halfFinal_level2_resultCount);
                            halfFinal_level2.put("posts", halfFinal_level2_resultPosts);
                        }
                        if (halfFinal_level2.size() > 0) {
                            halfFinal_level1.put(resultMap_modwords.get("modaction"), (Integer)((Object)halfFinal_level2));
                        }
                    }
                    ++i3;
                }
                avgmodactioncount = Math.round((float)totalmodactions.intValue() / (float)finalMap.size());
                Iterator iterator_finalMapKey = finalMap.keySet().iterator();
                int i4 = 0;
                while (i4 < list_members.size()) {
                    Map<String, String> resultMap_members = list_members.get(i4);
                    Integer nowUid = Integer.valueOf(resultMap_members.get("uid"));
                    halfFinal_level1.put("totalactions", (halfFinal_level1 = (Map)finalMap.get(nowUid)).get("totalactions") == null ? 0 : (Integer)halfFinal_level1.get("totalactions"));
                    Integer temp = halfFinal_level1.get("total") == null ? 0 : (Integer)halfFinal_level1.get("total");
                    String username = (String)halfFinal_level1.get("username");
                    halfFinal_level1.put("username", (Integer)((Object)(temp < avgmodactioncount / 2 ? "<b><i>" + username + "</i></b>" : username)));
                    ++i4;
                }
                halfFinal_level1 = null;
                Statvars statvars = new Statvars();
                StatvarsId statvarsId = new StatvarsId();
                ArrayList<Statvars> listTemp = new ArrayList<Statvars>();
                statvarsId.setType("modworks");
                statvarsId.setVariable(variable);
                statvars.setId(statvarsId);
                statvarsId = null;
                if (before == 0) {
                    finalMap.put("thismonth", startTime);
                    finalMap.put("lastupdate", (String)((Object)Integer.valueOf(nowDateInteger)));
                } else {
                    String sql_delete1 = "DELETE FROM jrun_statvars WHERE type='modworks' AND variable<'" + expireTime + "'";
                    String sql_delete2 = "DELETE FROM jrun_modworks WHERE dateline<'" + expireTime + "-01" + "'";
                    dataBaseDao.executeDelete(sql_delete1, new String[0]);
                    dataBaseDao.executeDelete(sql_delete2, new String[0]);
                }
                statvars.setValue(((DataParse)BeanFactory.getBean("dataParse")).combinationChar(finalMap));
                listTemp.add(statvars);
                statvars = null;
                statvarsDao.updateStatvarsForMain(listTemp);
            }
            Iterator iterator_finalMap = finalMap.keySet().iterator();
            Object key = null;
            while (iterator_finalMap.hasNext()) {
                key = iterator_finalMap.next();
                if (key instanceof String) continue;
                contentInfo = new Stats_manageStatisticVO.ContentInfo();
                columnOfNumberMapMap = ((Stats_manageStatisticVO.ContentInfo)((Object)contentInfo)).getColumnOfNumberMapMap();
                ((Stats_manageStatisticVO.ContentInfo)((Object)contentInfo)).setBefore(String.valueOf(before));
                halfFinal_level1 = (Map)finalMap.get(key);
                for (Object key_halfFinal_level1 : halfFinal_level1.keySet()) {
                    if (!(key_halfFinal_level1 instanceof String)) continue;
                    String finalKey = (String)key_halfFinal_level1;
                    if (finalKey.equals("uid")) {
                        ((Stats_manageStatisticVO.ContentInfo)((Object)contentInfo)).setUid((String)halfFinal_level1.get("uid"));
                        continue;
                    }
                    if (finalKey.equals("username")) {
                        ((Stats_manageStatisticVO.ContentInfo)((Object)contentInfo)).setUsername((String)halfFinal_level1.get("username"));
                        continue;
                    }
                    if (finalKey.equals("adminid") || finalKey.equals("total") || finalKey.equals("totalactions")) continue;
                    Map level2Map = (Map)halfFinal_level1.get(finalKey);
                    tempMap = new HashMap<String, String>();
                    tempMap.put("number", level2Map.get("count").toString());
                    tempMap.put("title", String.valueOf(mr.getMessage(locale, "post2")) + level2Map.get("posts").toString());
                    columnOfNumberMapMap.put(finalKey, tempMap);
                }
                contentInfoList.add((Stats_manageStatisticVO.ContentInfo)((Object)contentInfo));
            }
            key = null;
        } else {
            stats_manageStatisticVO.setShowThisMonthManageStatistic(true);
            List<Map<String, String>> list_modwords = dataBaseDao.executeQuery("SELECT uid, modaction, dateline, count, posts FROM jrun_modworks WHERE uid=? AND dateline>='" + startTime + "' AND dateline<'" + endTime + "'", uidFromRequest);
            Map<String, Map<String, String>> columnOfAllNumberMap = stats_manageStatisticVO.getColumnOfAllNumberMap();
            int i5 = 0;
            while (i5 < dayCount) {
                String timeOfDay = String.valueOf(thismonth) + (i5 + 1 < 10 ? "-0" + (i5 + 1) : "-" + (i5 + 1));
                contentInfo = new Stats_manageStatisticVO.ContentInfo();
                columnOfNumberMapMap = ((Stats_manageStatisticVO.ContentInfo)((Object)contentInfo)).getColumnOfNumberMapMap();
                ((Stats_manageStatisticVO.ContentInfo)((Object)contentInfo)).setTimeOfDay(timeOfDay);
                String count = null;
                String posts = null;
                String actionType = null;
                for (Map<String, String> resultMap : list_modwords) {
                    if (!resultMap.get("dateline").equals(timeOfDay)) continue;
                    count = resultMap.get("count");
                    posts = resultMap.get("posts");
                    actionType = resultMap.get("modaction");
                    if (mergeActions.get(actionType) != null) {
                        actionType = (String)mergeActions.get(actionType);
                    }
                    if ((tempMap = columnOfNumberMapMap.get(actionType)) == null) {
                        tempMap = new HashMap();
                        tempMap.put("number", count);
                        tempMap.put("title", String.valueOf(mr.getMessage(locale, "post2")) + posts);
                        columnOfNumberMapMap.put(actionType, tempMap);
                    } else {
                        String lastCount = (String)tempMap.get("number");
                        tempMap.put("number", String.valueOf(Integer.valueOf(count) + Integer.valueOf(lastCount)));
                        String lastPostString = (String)tempMap.get("title");
                        Integer lastPostInteger = Integer.valueOf(lastPostString.substring(3));
                        tempMap.put("title", String.valueOf(mr.getMessage(locale, "post2")) + (lastPostInteger + Integer.valueOf(posts)));
                    }
                    Map<String, String> mapTemp = columnOfAllNumberMap.get(actionType);
                    if (mapTemp == null) {
                        mapTemp = new HashMap<String, String>();
                        mapTemp.put("allNumber", count);
                        mapTemp.put("titleAllPost", String.valueOf(mr.getMessage(locale, "post2")) + posts);
                        columnOfAllNumberMap.put(actionType, mapTemp);
                        continue;
                    }
                    String lastCount = mapTemp.get("allNumber");
                    mapTemp.put("allNumber", String.valueOf(Integer.valueOf(count) + Integer.valueOf(lastCount)));
                    String lastPostString = mapTemp.get("titleAllPost");
                    Long lastPostInteger = Long.valueOf(lastPostString.substring(3, lastPostString.length()));
                    mapTemp.put("titleAllPost", String.valueOf(mr.getMessage(locale, "post2")) + (lastPostInteger + (long)Integer.valueOf(posts).intValue()));
                }
                contentInfoList.add((Stats_manageStatisticVO.ContentInfo)((Object)contentInfo));
                ++i5;
            }
        }
        ArrayList<String> modactioncode = new ArrayList<String>();
        modactioncode.add("EDT");
        modactioncode.add("DEL");
        modactioncode.add("DLP");
        modactioncode.add("PRN");
        modactioncode.add("UDL");
        modactioncode.add("DIG");
        modactioncode.add("UDG");
        modactioncode.add("EDI");
        modactioncode.add("UED");
        modactioncode.add("CLS");
        modactioncode.add("OPN");
        modactioncode.add("ECL");
        modactioncode.add("UEC");
        modactioncode.add("EOP");
        modactioncode.add("UEO");
        modactioncode.add("STK");
        modactioncode.add("UST");
        modactioncode.add("EST");
        modactioncode.add("UES");
        modactioncode.add("SPL");
        modactioncode.add("MRG");
        modactioncode.add("HLT");
        modactioncode.add("UHL");
        modactioncode.add("EHL");
        modactioncode.add("UEH");
        modactioncode.add("BMP");
        modactioncode.add("DWN");
        modactioncode.add("MOV");
        modactioncode.add("CPY");
        modactioncode.add("TYP");
        modactioncode.add("RFD");
        modactioncode.add("MOD");
        modactioncode.add("ABL");
        modactioncode.add("RBL");
        modactioncode.add("RMR");
        modactioncode.add("BNP");
        modactioncode.add("UBN");
        modactioncode.add("REC");
        modactioncode.add("URE");
        List<String> titleInfoList = stats_manageStatisticVO.getTitleInfoList();
        Map<String, String> titleInfoMap = stats_manageStatisticVO.getTitleInfoMap();
        for (String modactioncodeString : modactioncode) {
            if (mergeActions.get(modactioncodeString) != null) continue;
            titleInfoList.add(modactioncodeString);
            titleInfoMap.put(modactioncodeString, mr.getMessage(locale, modactioncodeString));
        }
        for (Stats_manageStatisticVO.ContentInfo contentInfo2 : contentInfoList) {
            columnOfNumberMapMap = contentInfo2.getColumnOfNumberMapMap();
            for (String titleInfo : titleInfoList) {
                if (columnOfNumberMapMap.get(titleInfo) != null) continue;
                HashMap<String, String> tempMap2 = new HashMap<String, String>();
                tempMap2.put("number", "0");
                tempMap2.put("title", "");
                columnOfNumberMapMap.put(titleInfo, tempMap2);
            }
        }
        contentInfoList = null;
        String tdWidth = String.valueOf(Math.round(90 / titleInfoList.size())) + "%";
        stats_manageStatisticVO.setTdWidth(tdWidth);
        String tempS = settingMap.get("statstatus");
        boolean statstatus = tempS != null && !tempS.equals("0") && !tempS.equals("");
        tempS = settingMap.get("modworkstatus");
        boolean modworkstatus = tempS != null && !tempS.equals("") && !tempS.equals("0");
        this.setNavbarVO(stats_manageStatisticVO.getNavbar(), statstatus, modworkstatus, "modworks");
        statvarsDao = null;
        dataBaseDao = null;
        return stats_manageStatisticVO;
    }

    private void setNavbarVO(Stats_navbarVO stats_navbarVO, boolean statstatus, boolean modworkstatus, String type) {
        stats_navbarVO.setStatistic(statstatus);
        stats_navbarVO.setModworkstatus(modworkstatus);
        stats_navbarVO.setType(type);
    }

    private Map<String, String> getFinalMap(String type, DataBaseDao dataBaseDao) {
        List<Map<String, String>> resultML = dataBaseDao.executeQuery("SELECT sta.variable, sta.value FROM jrun_statvars AS sta WHERE sta.type='" + type + "'", new String[0]);
        HashMap<String, String> statvars = new HashMap<String, String>();
        for (Map<String, String> statvarsMap : resultML) {
            statvars.put(statvarsMap.get("variable"), statvarsMap.get("value"));
        }
        return statvars;
    }

    private Map<String, String> getRunTimeAdPost(DataBaseDao dataBaseDao) {
        List<Map<String, String>> rml = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct, (MAX(dateline)-MIN(dateline))/86400 AS rt FROM jrun_posts", new String[0]);
        if (rml != null && rml.size() > 0) {
            Map<String, String> tempM = rml.get(0);
            if (tempM.get("ct") == null) {
                tempM.put("ct", "0");
            }
            if (tempM.get("rt") == null) {
                tempM.put("rt", "0");
            }
            return tempM;
        }
        HashMap<String, String> tm = new HashMap<String, String>();
        tm.put("ct", "0");
        tm.put("rt", "0");
        return tm;
    }

    private String getForumCount(DataBaseDao dataBaseDao) {
        List<Map<String, String>> rml = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct FROM jrun_forums WHERE type IN ('forum', 'sub') AND status=1", new String[0]);
        if (rml != null && rml.size() > 0) {
            return rml.get(0).get("ct");
        }
        return "0";
    }

    private String getThreadCount(DataBaseDao dataBaseDao) {
        List<Map<String, String>> rml = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct FROM jrun_threads WHERE displayorder>='0'", new String[0]);
        if (rml != null && rml.size() > 0) {
            return rml.get(0).get("ct");
        }
        return "0";
    }

    private String getMemberCount(DataBaseDao dataBaseDao) {
        List<Map<String, String>> rml = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct FROM jrun_members", new String[0]);
        if (rml != null && rml.size() > 0) {
            return rml.get(0).get("ct");
        }
        return "0";
    }

    private String getAddPostsInLast24(DataBaseDao dataBaseDao, int timestamp) {
        List<Map<String, String>> rml = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct FROM jrun_posts WHERE dateline>='" + (timestamp - 86400) + "' AND invisible='0'", new String[0]);
        if (rml != null && rml.size() > 0) {
            return rml.get(0).get("ct");
        }
        return "0";
    }

    private String getAddMemberInLast24(DataBaseDao dataBaseDao, int timestamp) {
        List<Map<String, String>> rml = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct FROM jrun_members WHERE regdate>='" + (timestamp - 86400) + "'", new String[0]);
        if (rml != null && rml.size() > 0) {
            return rml.get(0).get("ct");
        }
        return "0";
    }

    private String getAdminNum(DataBaseDao dataBaseDao) {
        List<Map<String, String>> rml = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct FROM jrun_members WHERE adminid>'0'", new String[0]);
        if (rml != null && rml.size() > 0) {
            return rml.get(0).get("ct");
        }
        return "0";
    }

    private String getNonPost(DataBaseDao dataBaseDao) {
        List<Map<String, String>> rml = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct FROM jrun_members WHERE posts='0'", new String[0]);
        if (rml != null && rml.size() > 0) {
            return rml.get(0).get("ct");
        }
        return "0";
    }

    private Map<String, String> getHotforumInfo(DataBaseDao dataBaseDao) {
        List<Map<String, String>> rml = dataBaseDao.executeQuery("SELECT posts, threads, fid, name FROM jrun_forums WHERE status=1 ORDER BY posts DESC LIMIT 1", new String[0]);
        if (rml != null && rml.size() > 0) {
            return rml.get(0);
        }
        HashMap<String, String> tm = new HashMap<String, String>();
        tm.put("name", "");
        tm.put("posts", "0");
        tm.put("threads", "0");
        tm.put("fid", "0");
        return tm;
    }

    private Map<String, String> getBestMenInfo(DataBaseDao dataBaseDao, int timestamp) {
        List<Map<String, String>> rml = dataBaseDao.executeQuery("SELECT author, COUNT(*) AS posts FROM jrun_posts WHERE dateline>='" + (timestamp - 86400) + "' AND invisible='0' AND authorid>'0' GROUP BY author ORDER BY posts DESC LIMIT 1", new String[0]);
        if (rml != null && rml.size() > 0) {
            Map<String, String> rm = rml.get(0);
            String author = rm.get("author");
            rm.put("author", "<a href=\"space.jsp?username=" + Common.encode(author) + "\"><strong>" + author + "</strong></a>");
            return rml.get(0);
        }
        HashMap<String, String> tm = new HashMap<String, String>();
        tm.put("author", "None");
        tm.put("posts", "0");
        return tm;
    }

    private String number_format(float total, float num) {
        return df.format(total > 0.0f ? num / total * 100.0f : 0.0f);
    }

    private void setSubPostlog(SubPostlog subPostlog, List<String> newstatvars, DataBaseDao dataBaseDao, int timestamp) {
        String timeoffsetSetting = ForumInit.settings.get("timeoffset");
        SimpleDateFormat dateFormat = Common.getSimpleDateFormat("yyyyMMdd", timeoffsetSetting);
        int maxmonthposts = 0;
        int maxdayposts = 0;
        TreeMap<String, String> stats_monthposts = new TreeMap<String, String>();
        TreeMap<String, String> stats_dayposts = new TreeMap<String, String>();
        stats_dayposts.put("starttime", Common.gmdate(dateFormat, timestamp - 2592000));
        dataBaseDao.execute("DELETE FROM jrun_statvars WHERE type='dayposts' AND variable<'" + (String)stats_dayposts.get("starttime") + "'", new String[0]);
        List<PageInfo> ereryMonthPost = subPostlog.getEreryMonthPost();
        List<PageInfo> ereryDayPost = subPostlog.getEreryDayPost();
        PageInfo pageInfo = null;
        float tempAllMF = 0.0f;
        float tempAllDF = 0.0f;
        String tempS = null;
        List<Map<String, String>> tempMapList = dataBaseDao.executeQuery("SELECT * FROM jrun_statvars WHERE type='monthposts' OR type='dayposts' ORDER BY variable", new String[0]);
        if (tempMapList != null) {
            for (Map<String, String> variable : tempMapList) {
                if ("monthposts".equals(variable.get("type"))) {
                    tempS = variable.get("variable");
                    stats_monthposts.put(variable.get("variable"), variable.get("value"));
                    if ("starttime".equals(tempS)) continue;
                    pageInfo = new PageInfo();
                    if (tempS.length() == 6) {
                        tempS = String.valueOf(tempS.substring(0, 4)) + " - " + tempS.substring(4);
                    }
                    pageInfo.setInformation(tempS);
                    tempS = variable.get("value");
                    tempS = tempS != null && !tempS.equals("") ? tempS : "0";
                    pageInfo.setNum(tempS);
                    tempAllMF += (float)Integer.parseInt(tempS);
                    ereryMonthPost.add(pageInfo);
                    continue;
                }
                tempS = variable.get("value");
                tempS = tempS != null && !tempS.equals("") ? tempS : "0";
                tempAllDF += (float)Integer.parseInt(tempS);
                pageInfo = new PageInfo();
                pageInfo.setNum(tempS);
                tempS = variable.get("variable");
                if (tempS.length() == 8) {
                    tempS = String.valueOf(tempS.substring(0, 4)) + " - " + tempS.substring(4, 6) + " - " + tempS.substring(6);
                }
                pageInfo.setInformation(tempS);
                ereryDayPost.add(pageInfo);
                stats_dayposts.put(variable.get("variable"), variable.get("value"));
            }
        }
        dateFormat.applyPattern("yyyy-MM-01");
        if (stats_monthposts.get("starttime") == null) {
            tempMapList = dataBaseDao.executeQuery("SELECT MIN(dateline) AS mdl FROM jrun_posts", new String[0]);
            String starttime = "0";
            if (tempMapList != null && tempMapList.size() > 0 && (starttime = tempMapList.get(0).get("mdl")) == null) {
                starttime = "0";
            }
            if (starttime.equals("0") || starttime.equals("")) {
                stats_monthposts.put("starttime", Common.gmdate(dateFormat, timestamp));
            } else {
                stats_monthposts.put("starttime", Common.gmdate(dateFormat, Integer.parseInt(starttime)));
            }
            newstatvars.add("'monthposts', 'starttime', '" + (String)stats_monthposts.get("starttime") + "'");
        }
        dateFormat.applyPattern("yyyy-MM-dd");
        int dateline = 0;
        try {
            dateline = (int)(dateFormat.parse((String)stats_monthposts.get("starttime")).getTime() / 1000L);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        dateFormat.applyPattern("yyyyMM");
        Calendar calendar = Common.getCalendar(timeoffsetSetting);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(5, 1);
        long nowMonthFirstDay = calendar.getTimeInMillis() / 1000L;
        calendar.setTimeInMillis((long)dateline * 1000L);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(5, 1);
        String month = null;
        int tempI = 0;
        while ((long)dateline < nowMonthFirstDay) {
            month = Common.gmdate(dateFormat, dateline);
            if (stats_monthposts.get(month) == null && (tempMapList = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct FROM jrun_posts WHERE dateline > " + dateline + " AND dateline<= " + (dateline + 2592000) + " AND invisible='0'", new String[0])) != null && tempMapList.size() > 0) {
                tempS = tempMapList.get(0).get("ct");
                tempS = tempS != null && !tempS.equals("") ? tempS : "0";
                tempAllMF += (float)Integer.parseInt(tempS);
                pageInfo = new PageInfo();
                pageInfo.setNum(tempS);
                tempS = month;
                if (tempS.length() == 6) {
                    tempS = String.valueOf(tempS.substring(0, 4)) + " - " + tempS.substring(4);
                }
                pageInfo.setInformation(tempS);
                ereryMonthPost.add(pageInfo);
                stats_monthposts.put(month, tempMapList.get(0).get("ct"));
                newstatvars.add("'monthposts', '" + month + "', '" + (String)stats_monthposts.get(month) + "'");
            }
            if ((tempI = Integer.parseInt((String)stats_monthposts.get(month))) > maxmonthposts) {
                maxmonthposts = tempI;
            }
            calendar.add(2, 1);
            dateline = (int)(calendar.getTimeInMillis() / 1000L);
        }
        calendar.setTimeInMillis((long)(timestamp - 2592000) * 1000L);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        dateline = (int)(calendar.getTimeInMillis() / 1000L);
        calendar.setTimeInMillis((long)timestamp * 1000L);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        int nowDayTime = (int)(calendar.getTimeInMillis() / 1000L);
        String day = null;
        dateFormat.applyPattern("yyyyMMdd");
        while (dateline < nowDayTime) {
            day = Common.gmdate(dateFormat, dateline);
            if (stats_dayposts.get(day) == null && (tempMapList = dataBaseDao.executeQuery("SELECT COUNT(*) AS ct FROM jrun_posts WHERE dateline > " + dateline + " AND dateline<=" + (dateline + 86400) + " AND invisible='0'", new String[0])) != null && tempMapList.size() > 0) {
                tempS = tempMapList.get(0).get("ct");
                tempS = tempS != null && !tempS.equals("") ? tempS : "0";
                tempAllDF += (float)Integer.parseInt(tempS);
                pageInfo = new PageInfo();
                pageInfo.setNum(tempS);
                tempS = day;
                if (tempS.length() == 8) {
                    tempS = String.valueOf(tempS.substring(0, 4)) + " - " + tempS.substring(4, 6) + " - " + tempS.substring(6);
                }
                pageInfo.setInformation(tempS);
                ereryDayPost.add(pageInfo);
                stats_dayposts.put(day, tempMapList.get(0).get("ct"));
                newstatvars.add("'dayposts', '" + day + "', '" + (String)stats_dayposts.get(day) + "'");
            }
            if ((tempI = Integer.parseInt((String)stats_dayposts.get(day))) > maxdayposts) {
                maxdayposts = tempI;
            }
            dateline += 86400;
        }
        float maxPercent = (float)maxmonthposts / tempAllMF * 100.0f;
        for (PageInfo pageInfo_ : ereryMonthPost) {
            pageInfo_.setNumPercent(this.number_format(tempAllMF, Float.parseFloat(pageInfo_.getNum())));
            this.setPageInfoMaxLengh(maxPercent, pageInfo_);
        }
        maxPercent = (float)maxdayposts / tempAllDF * 100.0f;
        for (PageInfo pageInfo_ : ereryDayPost) {
            pageInfo_.setNumPercent(this.number_format(tempAllDF, Float.parseFloat(pageInfo_.getNum())));
            this.setPageInfoMaxLengh(maxPercent, pageInfo_);
        }
    }

    private void setPageInfoMaxLengh(float maxPercent, PageInfo pageInfo) {
        pageInfo.setMaxLengh((int)(37000.0f / maxPercent));
    }

    private void updateNewStatvars(List<String> newstatvars, DataBaseDao dataBaseDao) {
        StringBuffer newdata = new StringBuffer();
        if (newstatvars != null && newstatvars.size() > 0) {
            for (String tempS : newstatvars) {
                newdata.append(String.valueOf(tempS) + "),(");
            }
            dataBaseDao.execute("REPLACE INTO jrun_statvars (type, variable, value) VALUES (" + newdata.substring(0, newdata.length() - 3) + ")", new String[0]);
        }
    }
}

