/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.filter;

import cn.jsprun.domain.Members;
import cn.jsprun.service.DataBaseService;
import cn.jsprun.service.MemberService;
import cn.jsprun.utils.BeanFactory;
import cn.jsprun.utils.Cache;
import cn.jsprun.utils.Common;
import cn.jsprun.utils.CookieUtil;
import cn.jsprun.utils.DataParse;
import cn.jsprun.utils.ForumInit;
import cn.jsprun.utils.HibernateUtil;
import cn.jsprun.utils.JspRunConfig;
import cn.jsprun.utils.Md5Token;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;

public class OnlineFilter
implements Filter {
    private DataParse dataParse = (DataParse)BeanFactory.getBean("dataParse");

    public void init(FilterConfig fc) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean promotion;
        Map creditspolicys;
        int attackevasive;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        request.setAttribute("starttime", (Object)System.currentTimeMillis());
        int timestamp = Common.time();
        request.setAttribute("timestamp", (Object)timestamp);
        String accessPath = request.getRequestURI();
        if (accessPath.endsWith("install.jsp")) {
            if (accessPath.endsWith("install/install.jsp")) {
                response.sendRedirect("../install.jsp");
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            return;
        }
        int index = accessPath.lastIndexOf("/");
        if (index != -1) {
            accessPath = accessPath.substring(index + 1);
        }
        if (accessPath.startsWith("forum-")) {
            accessPath = "forumdisplay.jsp";
        } else if (accessPath.startsWith("thread-")) {
            accessPath = "viewthread.jsp";
        }
        request.setAttribute("CURSCRIPT", (Object)accessPath);
        if (HibernateUtil.getSessionFactory() == null) {
            request.setAttribute("errorinfo", (Object)HibernateUtil.getMessage());
            request.getRequestDispatcher("/errors/error_sql.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Map<String, String> settings = ForumInit.settings;
        if (settings == null) {
            this.initForum(request.getSession().getServletContext());
            settings = ForumInit.settings;
            File file = new File(String.valueOf(JspRunConfig.realPath) + "./forumdata/cache/cache_index.jsp");
            if (!file.isFile()) {
                Cache.updateCache(new String[0]);
            }
        }
        if ((attackevasive = Common.toDigit(settings.get("attackevasive"))) > 0 && this.security(request, response, timestamp, attackevasive)) {
            return;
        }
        if ("1".equals(settings.get("nocacheheaders"))) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "private, post-check=0, pre-check=0, max-age=0");
            response.setDateHeader("Expires", 0L);
        }
        HttpSession httpSession = request.getSession();
        Map languages = this.dataParse.characterParse(settings.get("languages"), true);
        request.setAttribute("languages", (Object)languages);
        Locale locale = (Locale)httpSession.getAttribute("org.apache.struts.action.LOCALE");
        if (locale == null) {
            String lang = null;
            for (Map.Entry e : languages.entrySet()) {
                Map language = (Map)e.getValue();
                if ((Integer)language.get("default") <= 0 || (Integer)language.get("available") <= 0) continue;
                lang = (String)language.get("language");
                break;
            }
            if (lang != null) {
                String[] langs = lang.split("_");
                Locale newLocal = null;
                newLocal = langs.length > 1 ? new Locale(langs[0], langs[1]) : new Locale(langs[0]);
                httpSession.setAttribute("org.apache.struts.action.LOCALE", (Object)newLocal);
            }
        }
        if (httpSession.getAttribute("timeoffset") == null) {
            Common.setDateformat(httpSession, settings);
        }
        if (request.getParameter("styleid") != null && !"admincp.jsp".equals(accessPath)) {
            httpSession.setAttribute("styleid", (Object)request.getParameter("styleid"));
        }
        if (httpSession.getAttribute("boardurl") == null) {
            String port = request.getServerPort() == 80 ? "" : ":" + request.getServerPort();
            httpSession.setAttribute("boardurl", (Object)(String.valueOf(request.getScheme().concat("://").concat(request.getServerName())) + port).concat(request.getContextPath()).concat("/"));
        }
        String jsprun_sid = (String)httpSession.getAttribute("jsprun_sid");
        Integer jsprun_uid = (Integer)httpSession.getAttribute("jsprun_uid");
        String sid = CookieUtil.getCookie(request, "sid", true, settings);
        if (sid == null && jsprun_sid == null || sid != null && sid.equals("")) {
            sid = Common.getRandStr(6, false);
            CookieUtil.setCookie(request, response, "sid", sid, 604800, true, settings);
            httpSession.setAttribute("jsprun_sid", (Object)sid);
        } else if (sid == null && jsprun_sid != null || sid != null && jsprun_sid != null && !jsprun_sid.equals(sid)) {
            sid = jsprun_sid;
            CookieUtil.setCookie(request, response, "sid", jsprun_sid, 604800, true, settings);
        } else if (sid != null && jsprun_sid == null) {
            httpSession.setAttribute("jsprun_sid", (Object)sid);
        }
        if (jsprun_uid == null) {
            jsprun_uid = 0;
            String jsprun_userss = null;
            short groupid = 7;
            byte adminid = 0;
            String uid = CookieUtil.getCookie(request, "uid", true, settings);
            if (uid != null) {
                String validateAuth;
                MemberService memberService = (MemberService)BeanFactory.getBean("memberService");
                Members member = memberService.findMemberById(Common.toDigit(uid));
                if (member != null && (validateAuth = Md5Token.getInstance().getLongToken(String.valueOf(member.getPassword()) + "\t" + member.getSecques() + "\t" + member.getUid())).equals(CookieUtil.getCookie(request, "auth", true, settings))) {
                    jsprun_uid = member.getUid();
                    jsprun_userss = member.getUsername();
                    groupid = member.getGroupid();
                    adminid = member.getAdminid();
                    httpSession.setAttribute("user", (Object)member);
                    Common.setDateformat(httpSession, settings);
                    httpSession.setAttribute("jsprun_pw", (Object)member.getPassword());
                    if (member.getStyleid() > 0) {
                        httpSession.setAttribute("styleid", (Object)member.getStyleid().toString());
                    }
                }
            } else {
                CookieUtil.setCookie(request, response, "uid", String.valueOf(jsprun_uid), 604800, true, settings);
            }
            httpSession.setAttribute("jsprun_uid", (Object)jsprun_uid);
            httpSession.setAttribute("jsprun_userss", (Object)(jsprun_userss != null ? jsprun_userss : ""));
            httpSession.setAttribute("jsprun_groupid", (Object)groupid);
            httpSession.setAttribute("jsprun_adminid", (Object)adminid);
            httpSession.setAttribute("formhash", (Object)Common.getRandStr(8, false));
        }
        Common.sessionExists(request, response, sid, jsprun_uid, settings);
        Common.calcGroup(httpSession, request, response, settings);
        if (Common.allowAccessBbs(request, response, httpSession, settings, accessPath)) {
            return;
        }
        Common.setFtpValue(settings.get("ftp"), settings.get("authkey"));
        String statstatus = settings.get("statstatus");
        if (statstatus != null && statstatus.equals("1") && request.getParameter("inajax") == null) {
            Common.stats(request);
        }
        if (!Common.empty((creditspolicys = this.dataParse.characterParse(settings.get("creditspolicy"), false)).get("promotion_visit")) || !Common.empty(creditspolicys.get("promotion_register"))) {
            request.setAttribute("promotion", (Object)true);
        }
        String fromuid = request.getParameter("fromuid");
        String fromuser = request.getParameter("fromuser");
        if (!(Common.empty(fromuid) && Common.empty(fromuser) || !(promotion = ((Boolean)request.getAttribute("promotion")).booleanValue()))) {
            String jsprun_userss = httpSession.getAttribute("jsprun_userss") != null ? (String)httpSession.getAttribute("jsprun_userss") : "";
            Common.promotion(request, response, settings, fromuid, fromuser, jsprun_uid, jsprun_userss, creditspolicys);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    private synchronized void initForum(ServletContext context) {
        if (ForumInit.settings == null) {
            ForumInit.initServletContext(context);
        }
    }

    private boolean security(HttpServletRequest request, HttpServletResponse response, int timestamp, int attackevasive) {
        boolean attackevasive1 = (attackevasive & 1) > 0;
        boolean attackevasive2 = (attackevasive & 2) > 0;
        boolean attackevasive4 = (attackevasive & 4) > 0;
        boolean attackevasive8 = (attackevasive & 8) > 0;
        int lastrequest = 0;
        if (attackevasive1 || attackevasive4) {
            lastrequest = Common.toDigit(CookieUtil.getCookie(request, "lastrequest"));
            CookieUtil.setCookie(request, response, "lastrequest", String.valueOf(timestamp), timestamp + 816400);
        }
        if (attackevasive1 && timestamp - lastrequest < 1) {
            this.securitymessage(request, response, "attachsave_1_subject", "attachsave_1_message", true, false);
            return true;
        }
        if (attackevasive2 && (request.getHeader("x-forwarded-for") != null || request.getHeader("via") != null)) {
            this.securitymessage(request, response, "attachsave_2_subject", "attachsave_2_message", false, false);
            return true;
        }
        if (attackevasive4 && (lastrequest == 0 || timestamp - lastrequest > 60)) {
            this.securitymessage(request, response, "attachsave_4_subject", "attachsave_4_message", true, false);
            return true;
        }
        if (attackevasive8) {
            String[] secqcodes;
            String questionanswer = null;
            String questiontime = null;
            String secqcode = CookieUtil.getCookie(request, "secqcode");
            if (secqcode != null && (secqcodes = secqcode.split(",")) != null && secqcodes.length >= 2) {
                questionanswer = secqcodes[0];
                questiontime = secqcodes[1];
            }
            String attackevasive_answer = CookieUtil.getCookie(request, "attackevasive_answer");
            if (questionanswer == null || questiontime == null || !questionanswer.equals(attackevasive_answer)) {
                String secqsubmit = request.getParameter("secqsubmit");
                String answer = request.getParameter("answer");
                if (secqsubmit == null || secqsubmit != null && !Md5Token.getInstance().getLongToken(answer).equals(attackevasive_answer)) {
                    CookieUtil.setCookie(request, response, "secqcode", "," + timestamp, timestamp + 816400);
                    String attackevasive_question = this.updatesecqaa(request, response);
                    if (attackevasive_question != null) {
                        this.securitymessage(request, response, this.updatesecqaa(request, response), "<input type='text' name='answer' size='8' maxlength='150' /><input class='button' type='submit' name='secqsubmit' value=' Submit ' />", false, true);
                        return true;
                    }
                } else {
                    CookieUtil.setCookie(request, response, "secqcode", String.valueOf(attackevasive_answer) + "," + timestamp, timestamp + 816400);
                }
            }
        }
        return false;
    }

    private void securitymessage(HttpServletRequest request, HttpServletResponse response, String subject, String message, boolean reload, boolean form) {
        MessageResources mr = Common.getMessageResources(request);
        Locale locale = Common.getUserLocale(request);
        HashMap<String, String> scuritylang = new HashMap<String, String>();
        scuritylang.put("attachsave_1_subject", mr.getMessage(locale, "attachsave_1_subject"));
        scuritylang.put("attachsave_1_message", mr.getMessage(locale, "attachsave_1_message"));
        scuritylang.put("attachsave_2_subject", mr.getMessage(locale, "attachsave_2_subject"));
        scuritylang.put("attachsave_2_message", mr.getMessage(locale, "attachsave_2_message"));
        scuritylang.put("attachsave_4_subject", mr.getMessage(locale, "attachsave_4_subject"));
        scuritylang.put("attachsave_4_message", mr.getMessage(locale, "attachsave_4_message"));
        try {
            Common.setResponseHeader(response);
            boolean inajax = false;
            subject = scuritylang.get(subject) != null ? (String)scuritylang.get(subject) : subject;
            PrintWriter out = response.getWriter();
            if (!inajax) {
                out.write("<html>");
                out.write("<head>");
                out.write("<title>" + subject + "</title>");
                out.write("</head>");
                out.write("<body bgcolor='#FFFFFF'>");
                if (reload) {
                    out.write("<script language='JavaScript'>");
                    out.write("function reload() {");
                    out.write("\tdocument.location.reload();");
                    out.write("}");
                    out.write("setTimeout('reload()', 1001);");
                    out.write("</script>");
                }
                if (form) {
                    out.write("<form action='" + request.getRequestURI() + "' method='POST' target='_top'>");
                }
                out.write("<table cellpadding='0' cellspacing='0' border='0' width='700' align='center' height='85%'>");
                out.write("  <tr align='center' valign='middle'>");
                out.write("    <td>");
                out.write("    <table cellpadding='10' cellspacing='0' border='0' width='80%' align='center' style='font-family: Verdana, Tahoma; color: #666666; font-size: 11px'>");
                out.write("    <tr>");
                out.write("      <td valign='middle' align='center' bgcolor='#EBEBEB'>");
                out.write("     \t<br /><br /> <b style='font-size: 16px'>" + subject + "</b> <br /><br />");
                out.write(scuritylang.get(message) != null ? (String)scuritylang.get(message) : message);
                out.write("        <br /><br />");
                out.write("      </td>");
                out.write("    </tr>");
                out.write("    </table>");
                out.write("    </td>");
                out.write("  </tr>");
                out.write("</table>");
                if (form) {
                    out.write("</form>");
                }
                out.write("</body>");
                out.write("</html>");
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String updatesecqaa(HttpServletRequest request, HttpServletResponse response) {
        List<Map<String, String>> itempools = ((DataBaseService)BeanFactory.getBean("dataBaseService")).executeQuery("SELECT question,answer FROM jrun_itempool ORDER BY rand() LIMIT 1", new String[0]);
        String attackevasive_question = null;
        if (itempools != null && itempools.size() > 0) {
            attackevasive_question = itempools.get(0).get("question");
            CookieUtil.setCookie(request, response, "attackevasive_answer", Md5Token.getInstance().getLongToken(itempools.get(0).get("answer")), 31536000);
        }
        return attackevasive_question;
    }
}

